program OwnDemo;

{ by Scott Stephenson, CIS 70564,677 , 7 July 94
  This simple demo shows a few possibilities for owner draw controls.

  All you have to do to include these controls in your application is:

     1. Declare a pointer variable in your window object.
     2. Initialize the owner draw control in your Init method.
     3. In some cases, perform a setup call in your SetupWindow method.
     4. Include an owner draw button in your dialog resource.

  The following controls are included:

     1. An owner draw clock.
}


{$R OWNDRAW.RES}



uses drawtime, { an owner draw clock }
     slidebox, { an owner draw slider control }
     polarBox, { an owner draw polar coordinates input control }
     colorbtn, { an owner draw pushbutton }
     WinTypes,
     WinProcs,
     Strings,
     OWindows,
     ODialogs;

const
  AppName: PChar = 'OWNDRAW';


type

POwner = ^TOwner;
TOwner = object(TDlgWindow)
  PStatus     : pcolorButton;
  PTime       : pTimeBox;   { this is a clock }
  PSlide      : pSlideBox;  { this is a slider }
  pPolar      : pPolarBox;  { this is a polar coordinates box }
  function    GetClassName : PChar; virtual;
  procedure   WMControlColor(var Msg: TMessage); virtual wm_First + wm_CtlColor;
  procedure   statuspushed(var Msg: TMessage); virtual id_First + 103;
  constructor init(AParent: PWindowsObject; ATitle: pchar);
  procedure   Setupwindow; virtual;
  end;

var mainWindow: pOwner;

type
  TOwnApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

var

{ Application instance }

  OwnApp: TOwnApp;

procedure towner.statuspushed(var Msg: TMessage);
begin
pstatus^.setup('You pushed me!',rgb(255,0,255),normal);
end;

constructor tOwner.init(AParent: PWindowsObject; ATitle:pchar);
begin
tdialog.init(AParent,ATitle);
New(Ptime  ,     InitResource(@Self, 101));
New(PSlide ,     InitResource(@Self, 102));
New(PStatus,     InitResource(@Self, 103));
New(PPolar,      InitResource(@Self, 104));
end;

procedure  tOwner.Setupwindow;
var value: tpoint;
begin
tdialog.setupwindow;
ptime^.setup;
pstatus^.setup('Push me...',rgb(0,255,0),normal);
pslide^.setup(-50,50,1,10,5,'SFC TEMP C',rgb(192,192,192));
pslide^.setpos(5);
value.x:= 0;
value.y:= 0;
PPolar^.setup(30,value,rgb(192,192,192));
end;

function TOwner.GetClassName: PChar;
begin
  GetClassName := AppName;
end;

procedure TOwner.WMControlColor(var Msg: TMessage);
begin
  case Msg.LParamHi of
    ctlColor_Static:
      begin
        SetTextColor(Msg.WParam, rgb(0,0,0));
        SetBkMode(Msg.WParam, transparent);
        Msg.Result := GetStockObject(ltgray_Brush);
      end;
    ctlcolor_Dlg:
      begin
        SetBkMode(Msg.WParam, Transparent);
        Msg.Result :=  GetStockObject(ltgray_Brush);
      end;
  else
    DefWndProc(Msg);
  end;
end;



procedure TOwnApp.InitMainWindow;
begin
 MainWindow := New(POwner, Init(nil,'MAIN'));
end;


begin
OwnApp.Init(AppName);
OwnApp.Run;
OwnApp.Done;
end.
