program Mem32Test;

(* Demonstrate the working of TMEM32 objects. Jochen Magnus 10/94 *)

uses
   winCrt,winProcs,strings,winMem32,mem32bit;

var
   mem,mem2       :  PMem32;
   path        :  array[0..79] of char;
   s           :  string;
   res,len,i   :  word;


procedure Failed(err:word);
begin
   write(#7'Program failed because: ');
   case err of
      wm32_Invalid_Func          {1} :    writeln('Invalid Function reference');
      wm32_Invalid_Flags         {2} :    writeln('Invalid Flags');
      wm32_Invalid_Arg           {3} :    writeln('Invalid Argument(s)');
      wm32_Insufficient_Sels  {4} : writeln('Insufficient Selectors');
      wm32_Insufficient_Mem   {5} : writeln('Insufficient Memory');

      $FFFE                       : writeln('Source object is NIL');
      $FFFF                       : writeln('TObject.Init failed');

      255                         : writeln('Can''t get Windows Directory');
      else                          writeln('#',err);
   end;
   HALT(err);
end;


begin
   new(mem,Init($18000,$40000,res));                  { allocate a TMem32 instance (98K) }
   if mem=NIL then Failed(res);
   writeln(mem^.TellSize,' bytes allocated');

   res:=mem^.MemFill(0,-1,0);
   writeln('Fill memory with ''0'': ',res=0);
   if res<>0 then Failed(res);

   if GetWindowsDirectory(path,sizeof(path))=0 then Failed(255);
   if path[strLen(path)]<>'\' then strCat(path,'\');
   strCat(path,'README.WRI');
   res:=mem^.ReadFromFile(path,0,0,-1);               { read the whole file  }
   if res<>0 then Failed(res);                        { #1 if file not found }
   writeln('Now ',mem^.TellSize,' bytes allocated');  { automatic realloction happened }

   i:=0;
   repeat                                             { shows the first part of the   }
      len:=255;                                       { file README.WRI if availiable }
      mem^.GetData(i*255,s[1],len); s[0]:=char(len);
      write(s);
      inc(i);
   until (i=10) or (len<255) or (keypressed and (readKey=#27));
   writeln(#13#10);

   new(mem2,Copy(mem,res));                           { Copy constructor, create a }
   if mem2=NIL then Failed(res);                      { 'twin' of mem }

   write('Press <RET>'); readLn;
   i:=0;
   repeat
      len:=255;
      mem2^.GetData(i*255,s[1],len); s[0]:=char(len);
      write(s);
      inc(i);
   until (i=10) or (len<255) or (keypressed and (readKey=#27));
   writeln(#13#10);

   dispose(mem2,Done);                                 { Release the memory }
   dispose(mem,Done);
   writeln('Objects disposed. Done.');
end.
