
{$R-,S+,O-,A-,E-,N-,D-,L-,V-}
{$M 32768,2048,4096} {Turbo 3 default stack and heap}

Program JP_Demo3;

{-----------------------------------------------------------------------------}
{    SAMPLE PROGRAM to show how to write a door which reads the ExitInfo.BBS  }
{    file using JPDoor 4.1                                                    }
{                                                                             }
{            NOTE: You MUST un-comment the following line in TRAPEXIT.PAS     }
{                  to compile this door because it DOES read EXITINFO.BBS     }
{                  If ExitConverted then DoConvert;                           }
{                                                                             }
{                         Copyright 1993, Motor City Software                 }
{-----------------------------------------------------------------------------}

USES
  Crt,
  Dos,
  JPGlobal,
  JPDoor41,
  ExitCvt;

Var
  X             : Integer;
  Temp,
  ExitPath      : String[80];
  FlagToChange  : String[2];
  ExitFile      : File Of ExitInfoRecord;
  TxtDir        : String[80];

Procedure Terminate(HaltCode:byte) ;
{ This is an example procedure to handle the halt codes passed by
  TrapExit.  See the TrapExit.Pas file for more information on
  the codes returned and how they are passed to this procedure.
}
Begin
  Case HaltCode Of              { Do Any Cleaning Up here.  TrapExit will     }
    0,                          { Describe the error on the screen as well as }
    7 : Begin                   { Logging it to disk.                         }
          ClearScreen ;
          sDisplay(0,11,0,'Returning to ') ;
          Display(0,7,0,FormatStr(SystemName)) ;
          Crlf ;
        End ;
  End ;
End;

{$I TRAPEXIT}                   { Include the TrapExit.Pas file               }

Procedure UpDateExitInfo;       { This is an example of how to update the     }
Begin                           { ExitInfo.BBS with current user info         }
  Assign(ExitFile,ExitInfoBBSName);
  Reset(ExitFile);
  Write(ExitFile,ExitInfo);
  Close(ExitFile);
End;



Procedure Change_Voice_Phone;
Var
  Temp : String[12];
  NumSet : CharSet;
  IsOK : Boolean;
Begin
  IsOK := False;
  Temp := Exitinfo.UserInfo.VoicePhone;
  ClearScreen;
  Repeat
    CrLf;
    Temp := Exitinfo.UserInfo.VoicePhone;
    SetColor(0,11,0);
    Display(0,11,0,'Current Voice Phone Number : '+Temp);
    sDisplay(0,10,0,'Please Enter Your VOICE Phone Number : ');
    SetColor(0,13,0);
    ExitInfo.UserInfo.VoicePhone := GetPhone(0);
    CrLf;
    sDisplay(0,10,0,'Voice Phone Number Entered : ');
    Display(0,15,0,Exitinfo.Userinfo.VoicePhone);
    CrLf;
    If Ask_YN('Is This Correct? [Y/N] : ',13) = 'N' then
    Begin
      IsOK := False;
      ExitInfo.UserInfo.VoicePhone := Temp;
    End Else IsOK := True;
  Until IsOk;
  UpDateExitInfo;
End;



PROCEDURE GetThisNode(Counter : BYTE) ;
VAR
  Temp    : String[60];
  ErrCode : Integer;
BEGIN
  Temp := PARAMSTR(Counter) ;
  Delete(Temp,1,2);
  ThisNode := Temp;
  If Length(ThisNode) = 1 then ThisNode := '0' + ThisNode;
  MultiNode := TRUE ;
END;




Procedure GetParams;
Var
  Counter   : Byte;
Begin
  For Counter := 1 to ParamCount do
  Begin
    Temp := ChangeCase(ParamStr(Counter));
    If Temp[1] = '/' then
    Begin
      Case Temp[2] of
        'N' : GetThisNode(Counter);  { Update ThisNode variable with node #   }
        'D' : JP_Debug := True;      { See Note at end of program             }
        'S' : ShowWindow := True;    { Show the exploding window at startup   }
      End;
    End;
  End;
End;




BEGIN   { MAIN }

  ShowWindow := False;          { Do Not Show The Exploding Window At Startup }
  ThisNode := '001';            { Default to Node 1 on single node systems    }

  JPLogName := 'DEMO3';          { See note following program code             }

  ProductName := 'JP_Demo3';    { Name Of Door, used on StatusLine            }

  DoorExit := TrapExit ;        { Assign ExitProcedure For The Door. TrapExit }
                                { handles all the error logging, etc.         }

  ForceNode := True;            { Always Read Dorinfo1.Def rather than        }
                                { Dorinfo2.Def                                }

  DoConvert;                    { See Notes Following Main Program Code       }

  GetDorInfo(ThisNode,'') ;     { Read In the Exitinfo.BBS from the current   }
                                { directory. It is ASSUMED that this will be  }
                                { an RA 2.01 type ExitInfo.Bbs, so if your    }
                                { door 'might' be run on one of the versions  }
                                { mentioned in DoConvert, then make sure you  }
                                { Call DoConvert BEFORE this.                 }


  If Not Local Then             { This Simple ensures that a fossil driver IS }
  Begin                         { Loaded. If Not, it exits back to the BBS    }
    If Not SetFossil Then       { A Fossil Driver is NOT needed in Local Mode }
    Begin
      WriteLn(#7,'Fossil not installed');
      Halt(0);
    End Else WriteLn('Fossil Active');
  End;


  SetColor(0,15,0) ;            { Initialize the Screen Colors                }

  FossilHot := TRUE ;           { If True, then the fossil driver will NOT be }
                                { de-initialized when the door exits. By      }
                                { default, FossilHot := False                 }

  StatusLineOn := TRUE ;        { Show the two line status bar at the bottom  }
                                { of the screen. This defaults to False.      }

  Show_Status ;                 { Update the status bar at the bottom of the  }
                                { screen                                      }

  ClearScreen;                  { Quite Obvious... Use this, not ClrScr as    }
                                { this will also clear the remote users screen}

  Display(0,15,0,'JPDoor Demonstration Program');
  Display(0,15,0,'Copyright (C) Motor City Software 1990,1991,1992,1993');
  Display(0,15,0,'All Rights Reserved');
  Delay(2000);

                                { Gotta have a title screen!                  }


  Change_Voice_Phone;           { Call your code                              }

  HALT(0) ;                     { Normal Exit From Door                       }

END.



(*****************************************************************************)
(*                                                                           *)
(*        JPDoor V4.1 - Demonstration Door 3 - Uses ExitInfo.BBS             *)
(*                                                                           *)
(*****************************************************************************)

    JPDoor V4.1 is compatable with

                          RemoteAccess 1.10
                          RemoteAccess 1.11
                          RemoteAccess 2.00
                          RemoteAccess 2.01
                            SuperBBS 1.17
                            QuickBBS 2.75
                            QuickBBS 2.76
                            QuickBBS 2.80



  DOCONVERT
  ---------

  Procedure DoConvert;   Located in ExitCvt.Tpu

  This is the module which will Read Other BBS Drop Files and create a
  standard RemoteAccess V2.01  ExitInfo.BBS. This procedure is pretty
  smart. It will look in the directory pointed to by ExitInfoPath variable.
  If this is Null, which is the default, then it looks in the current
  directory. If you wish, you may set this to point to another directory
  before you call DoConvert.  DoConvert will check the SIZE of the
  exitinfo.bbs, and match it against QBBS V2.75, 2.76, RA 1.1x, and RA 2.00
  If it is already an RA 2.01 exitinfo.bbs then nothing is done. If it is
  found to be another type, it renames the exitinfo.bbs to exitinfo.###
  where ### is the version - 275 - 276 - 110. It then converts creates a
  RA 2.00 exitinfo.bbs using the information from the original file.  You
  MUST make sure DoConvert is called when your door exits. This can be
  guaranteed by putting another DoConvert in the Trapexit.pas file.
  When it runs for the second time, it reads in the ExitInfo.### file,
  and updates it with data from the RA 2.01 ExitInfo.Bbs. DoConvert must be
  run BEFORE GetDorinfo, and one of the LAST things in your door. YOU can
  find out what the BBS is by checking the following booleans :

       RA200   If true, then no changes were made
               and the BBS is in fact RA V2.01
       RA110   This is either RA 1.10 or RA 1.11
               There are no changes you need
               to worry about between those 2
       QBBS275 BBS is QBBS V2.75
       QBBS276 BBS is QBBS 2.76
       QBBS280 BBS is QBBS 2.80
       SUPER117 BBS is SuperBBS 1.17

  You can still use JPDoor with almost any BBS Package, but it has very
  specific support for the above Versions.


  LOG FILES
  ---------

  A Couple Notes about JPDoor and log files. There are a couple new
  variables used internally by JPDoor.

      JPLogName : String[5];
      ThisNode  : String[2];   Forced 3 digits - eg. 001
      JPLogExt  : String[3];

  TRAPEXIT.PAS will create, or use a log file using the name
    JPLogName + ThisNode + '.ERR'

  The File is laid out as follows:

---Cut Here---
Error Log Generated by MineField On Node 01
 
 ! 02-25-93  19:11:29   Error : 5 @ 0000:0BC5
 ! 02-25-93  19:11:29   DOS ERROR : File access denied

 ! 02-25-93  20:20:11   Cannot Find Dorinfo1.Def

 ! 02-26-93  12:39:20   Time Limit Exceeded
---Cut Here---


The first line uses the ProductName variable and ThisNode.
  'Error Log Generated by ' + ProductName + ' On Node ' + ThisNode

The ! Signifies it was written by the TrapExit Procedure.

If there is a RunTime Error then the description of that error is shown
on the second line.

The Common part to EVERY line is as follows:
  '   ' + DateStr + '  ' + TimeStr + '   '

You may also use this log file for your own use if you follow the above
guidelines. This can be usefull for informing the Sysop of problems.


There is also a Boolean Variable in JPDoor that will force JPDoor to write
a rather unreadable log file of its own activities internally. This is mainly
there for our own use, to track bugs in JPDoor. If you suspect something in
JPDoor is not working correctly, then you may set JP_Debug := True in your
program, or by typing the following at the DOS prompt BEFORE you run the
door.
  SET JP_DEBUG=ON

  To turn it off again,

  SET JP_DEBUG=

The file created by this is defined as 'DEBUG'+ThisNode+'.JPD'

As I said, the log file generated won't make much sense to you, but if you
can supply this when reporting bugs, it would be most helpful for us to
help sove any problems you may have.
The above program will check for a /D commandline parameter, and if found,
turn debug logging on.

When debugging your own programs, you may use this log file yourself.
Do this by :
  JP_Log('This is a test');

If JP_Debug := False then nothing is done. This can be very usefull if you
are trying to track problems in your doors.  NOTE, with the extra overhead
of writing to the log your door will run much more slowly.



