
{$R-,S+,O-,A-,E-,N-,D-,L-,V-}
{$M 32768,2048,4096} {Turbo 3 default stack and heap}

Program JP_Demo1;

{-----------------------------------------------------------------------------}
{            DEMO 1 - Basic Door structure which traps HALT Codes             }
{                                                                             }
{            NOTE: You MUST comment out the following line in TRAPEXIT.PAS    }
{                  to compile this door because it does NOT read EXITINFO.BBS }
{                  If ExitConverted then DoConvert;                           }
{                                                                             }
{                         Copyright 1994, McSoft Corporation                  }
{-----------------------------------------------------------------------------}

USES
  Crt,
  Dos,
  JPGlobal,
  JPDoor41;


PROCEDURE Terminate(HaltCode : BYTE) ;
BEGIN
  Delay(2000);
  ClearScreen;
  TextColor(14);
  writeln;
  Write(ProductName,' - Terminate - ');
  CASE HaltCode OF
     0 : WRITELN('Normal termination') ; {normal terminate - no action}
     1 : BEGIN
            WRITELN('Carrier lost') ;
            {do what you want if carrier was dropped.}
         END ;
     2 : BEGIN
            WRITELN('Time limit exceeded') ;
            { do what you want if the caller's time limit was exceeded }
         END ;
     3 : BEGIN
            WRITELN('User inactivity timeout') ;
            { do what you would want done if user was inactive }
         END ;
     4 : BEGIN
            If DoorSys then Writeln('Door.Sys file not found')
              Else WRITELN('Dorinfo1.Def file not found') ;
            { not good - do what you would want done in this situation}
         END ;
     5 : BEGIN
            WRITELN('Exitinfo.Bbs file not found') ;
            { not good - do what you would want done in this situation}
         END ;
     6 : BEGIN
            WRITELN('Directory read/change error') ;
            { this is a nasty.  You should close files and HALT(0) }
         END ;
     7 : BEGIN
            WRITELN('Character Transmit Timeout');
            { the local modem is unable to transmit any more characters }
         END;
     8 : WRITELN('RAXIT Semaphore forced Exit');
     9 : ; { Reserved For future Use }
     10: Begin
           { Return From hangUp Procedure - Clean up and exit }
           Halt(0);
         End;
     11: ; { Reserved for future Use by JPDoor }
     12: ; { Reserved for future Use by JPDoor }
     13: ; { Reserved for future Use by JPDoor }
     14: ; { Reserved for future Use by JPDoor }
     15: ; { Reserved for future Use by JPDoor }
     16: ; { Reserved for future Use by JPDoor }
     17: ; { Reserved for future Use by JPDoor }
     18: ; { Reserved for future Use by JPDoor }
     19: ; { Reserved for future Use by JPDoor }
     20: ; { Reserved for future Use by JPDoor }
  END ;
END ;

{$I TRAPEXIT}                   { Include the TrapExit.Pas file               }




Procedure YourDoorCode;
Begin
  Display(0,15,0,'JPDoor Demonstration Program');
  Display(0,15,0,'Copyright (C) McSoft Corp 1990,1991,1992,1993,1994');
  Display(0,15,0,'All Rights Reserved');
  CrLf;
  CrLf;
  More('Hit Any Key To Return To '+SystemName,14);
  { Display title on screen (local and Remote) then exit back to bbs }
End;



BEGIN   { MAIN }

  ShowWindow := False;          { Do Not Show The Exploding Window At Startup }

  ThisNode := '001';            { Default to Node 1 on single node systems    }

  ProductName := 'JP_Demo1';    { Name Of Door, used on StatusLine            }

  DoorExit := TrapExit ;        { Assign ExitProcedure For The Door. TrapExit }
                                { handles all the error logging, etc.         }

  CkExitInfo := False;          { We do not want to read ExitInfo.bbs }

  GetDorInfo(ThisNode,'') ;     { Read In the Dorinfo1.def from the current   }
                                { directory.                                  }


  If Not Local Then             { This Simply ensures that a fossil driver IS }
  Begin                         { Loaded. If Not, it exits back to the BBS    }
    If Not SetFossil Then       { A Fossil Driver is NOT needed in Local Mode }
    Begin
      WriteLn(#7,'Fossil not installed');
      Halt(0);
    End Else WriteLn('Fossil Active');
  End;

  SetColor(0,15,0) ;            { Initialize the Screen Colors                }

  StatusLineOn := TRUE ;        { Show the two line status bar at the bottom  }
                                { of the screen. This defaults to False.      }

  Show_Status ;                 { Update the status bar at the bottom of the  }
                                { screen                                      }

  ClearScreen;                  { Quite Obvious... Use this, not ClrScr as    }
                                { this will also clear the remote users screen}

  YourDoorCode;                 { Call your door code }

  StatusLineOn := False;
  Show_Status;

  HALT(0) ;                     { Normal Exit From Door                       }

END.



