program main;
uses fgmain, fgmisc, fgpr;

var
  pixel_runs : array[0..19999] of byte;
  old_mode   : integer;
  new_mode   : integer;
  stream     : file;
  file_size, run_count : integer;

begin
  new_mode := fg_bestmode(320,200,1);
  if (new_mode < 0) or (new_mode = 12) then
  begin
    write('This program requires a 320 ');
    writeln('x 200 color graphics mode.');
    exit;
  end;
  old_mode := fg_getmode;
  fg_setmode(new_mode);

  assign(stream,'coral.spr');
  reset(stream,1);
  file_size := filesize(stream);
  blockread(stream,pixel_runs,file_size);
  close(stream);

  run_count := file_size div 2;
  fg_move(0,199);
  fg_display(pixel_runs,run_count,320);
  fg_waitkey;

  assign(stream,'coral.ppr');
  reset(stream,1);
  file_size := filesize(stream);
  blockread(stream,pixel_runs,file_size);
  close(stream);

  run_count := file_size div 3 * 2;
  fg_erase;
  fg_displayp(pixel_runs,run_count,320);
  fg_waitkey;

  fg_setmode(old_mode);
  fg_reset;
end.
