/*-------------------------------------------------------------------
                            testcase.cpp

A program to test type 1 source code generated by Dialog Design.  Open
project, TEST.PRJ, copy this file to TEST.CPP and then insert the XXX.SRC
file generated by Dialog Design at the line of asterisks.  Define TV1 or
TV2 depending on which Turbo Vision version you're using.  Choose
Compile\Make (F9) to form the test program TEST.EXE.

In case of difficulty, check Options|Directories to make sure the directory
paths are correct for your system.

--------------------------------------------------------------------*/

#define Uses_TEventQueue
#define Uses_TEvent
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TView
#define Uses_TWindow
#define Uses_TFrame
#define Uses_TScroller
#define Uses_TScrollBar
#define Uses_TDialog
#define Uses_TButton
#define Uses_TSItem
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_TLabel
#define Uses_TInputLine
#define Uses_TCollection
#define Uses_THistory
#define Uses_THistoryWindow
#define Uses_TListBox
#define Uses_TStringCollection
#define Uses_TMemo

#ifdef TV2
#  define Uses_TMultiCheckBoxes  
#  define Uses_TRangeValidator
#  define Uses_TFilterValidator
#  define Uses_TStringLookupValidator
#  define Uses_TPXPictureValidator
#endif

#define Uses_TColoredText
#define Uses_TInputLong

#if defined (TV2)
#  include <tvision\tv.h>
#elif defined (TV1)
#  include <tv.h>
#else
#  error TV1 or TV2 must be defined
#endif


#include "tcolortx.h"
#include "tinplong.h"

const cmTry = 150;

class TMyApp : public TApplication
{
public:
    TMyApp();
    static TStatusLine *initStatusLine(TRect r);
    virtual void handleEvent(TEvent& event);
};

TMyApp::TMyApp() :
    TProgInit( TMyApp::initStatusLine,
	       TMyApp::initMenuBar,
	       TMyApp::initDeskTop
	     )
{
}

TStatusLine *TMyApp::initStatusLine( TRect r )
{
    r.a.y = r.b.y - 1;     // move top to 1 line above bottom
    return new TStatusLine( r,
      *new TStatusDef(0, 0xFFFF) +
      *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
      *new TStatusItem("~F9~ Try dialog", kbF9, cmTry)
    );
}

//******Insert makeDialog here*****

dataRec a;

void TMyApp::handleEvent(TEvent& event)
{
    TApplication::handleEvent(event);
    if( event.what == evCommand && event.message.command == cmTry )
	{
	 TDialog* dialog = makeDialog();
	 if (validView(dialog))
	   {
	   dialog->setData(&a);
	   if (deskTop->execView(dialog) != cmCancel)
	      dialog->getData(&a);
	   destroy(dialog);
	   }
	 clearEvent(event);
	}
}

int main()
{
    TMyApp myApp;
    myApp.run();
    return 0;
}


