(*
 *      Windows/Network Interface
 *      (c) Copyright G.Swindell 1993.
 *
 *      Standard WINNET Driver Header File, spec version 1.00
 *)

(*

  This library is incomplete.

  The original WINNET.H file used was written such that functions were only parameterised,
  and not given variable names. You could use arbitary names and guess their function
  I suppose.

*)

(*
 *      SPOOLING - CONTROLLING JOBS
 *)

Unit WINNET;
Interface
Uses
  WinTypes, WinProcs, Strings;

const
 WNJ_NULL_JOBID  = 0;

(*
Function WNetOpenJob(LPSTR,LPSTR,WORD,LPINT} : WORD;
Function WNetCloseJob(WORD,LPINT,LPSTR) : WORD;
Function WNetWriteJob(HANDLE,LPSTR,LPINT) : WORD;
Function WNetAbortJob(WORD,LPSTR) : WORD;
Function WNetHoldJob(LPSTR,WORD) : WORD;
Function WNetReleaseJob(LPSTR,WORD) : WORD;
Function WNetCancelJob(LPSTR,WORD) : WORD;
Function WNetSetJobCopies(LPSTR,WORD,WORD) : WORD;
*)

(*
 *      SPOOLING - QUEUE AND JOB INFO
 *)

Type
  PQUEUESTRUCT = ^TQUEUESTRUCT;
  TQUEUESTRUCT = Record
    pqName,
    pqComment,
    pqStatus,
    pqJobcount,
    pqPrinters  : WORD;
  end;

Const
  WNPRQ_ACTIVE   = $0;
  WNPRQ_PAUSE    = $1;
  WNPRQ_ERROR    = $2;
  WNPRQ_PENDING  = $3;
  WNPRQ_PROBLEM  = $4;

Type
  PJOBSTRUCT = ^TJOBSTRUCT;
  TJOBSTRUCT = Record
    pjId,
    pjUsername,
    pjParms,
    pjPosition,
    pjStatus,
    pjSubmitted : Word;
    pjSize : LongInt;
    pjCopies,
    pjComment : Word;
  end;

Const
  WNPRJ_QSTATUS         = $0007;
  WNPRJ_QS_QUEUED       = $0000;
  WNPRJ_QS_PAUSED       = $0001;
  WNPRJ_QS_SPOOLING     = $0002;
  WNPRJ_QS_PRINTING     = $0003;
  WNPRJ_DEVSTATUS       = $0FF8;
  WNPRJ_DS_COMPLETE     = $0008;
  WNPRJ_DS_INTERV       = $0010;
  WNPRJ_DS_ERROR        = $0020;
  WNPRJ_DS_DESTOFFLINE  = $0040;
  WNPRJ_DS_DESTPAUSED   = $0080;
  WNPRJ_DS_NOTIFY       = $0100;
  WNPRJ_DS_DESTNOPAPER  = $0200;
  WNPRJ_DS_DESTFORMCHG  = $0400;
  WNPRJ_DS_DESTCRTCHG   = $0800;
  WNPRJ_DS_DESTPENCHG   = $1000;

  SP_QUEUECHANGED       = $0500;


(*
Function WNetWatchQueue(HWND,LPSTR,LPSTR,WORD) : Word;
Function WNetUnwatchQueue(LPSTR) : Word;
Function WNetLockQueueData(LPSTR,LPSTR,LPQUEUESTRUCT FAR ) : Word;
Function WNetUnlockQueueData(LPSTR) : Word;
*)


(*
 *      CONNECTIONS
 *)

Function WNetAddConnection(lpszNetPath, lpszPassword, lpszLocalName : PChar) : Word;
Function WNetCancelConnection(lpszName : PChar; tForce : BOOL) : Word;
Function WNetGetConnection(lpszLocalName, lpszRemoteName : PChar; var cbRemoteName : Word) : Word;
Function WNetRestoreConnection(hwndOwner : HWND; lpszDevice : PChar) : Word;

(*
 *      CAPABILITIES
 *)

Const
  WNNC_SPEC_VERSION             = $0001;

  WNNC_NET_TYPE                 = $0002;
  WNNC_NET_NONE                 = $0000;
  WNNC_NET_MSNet                = $0100;
  WNNC_NET_LanMan               = $0200;
  WNNC_NET_NetWare              = $0300;
  WNNC_NET_Vines                = $0400;
  WNNC_NET_10NET                = $0500;
  WNNC_NET_Locus                = $0600;
  WNNC_NET_Sun_PC_NFS           = $0700;
  WNNC_NET_LANstep              = $0800;
  WNNC_NET_9TILES               = $0900;
  WNNC_NET_LANtastic            = $0A00;
  WNNC_NET_AS400                = $0B00;
  WNNC_NET_FTP_NFS              = $0C00;
  WNNC_NET_PATHWORKS            = $0D00;
  WNNC_NET_MultiNet             = $8000;
  WNNC_SUBNET_NONE              = $0000;
  WNNC_SUBNET_MSNet             = $0001;
  WNNC_SUBNET_LanMan            = $0002;
  WNNC_SUBNET_WinWorkgroups     = $0004;
  WNNC_SUBNET_NetWare           = $0008;
  WNNC_SUBNET_Vines             = $0010;
  WNNC_SUBNET_Other             = $0080;
  WNNC_DRIVER_VERSION           = $0003;

  WNNC_USER                     = $0004;
  WNNC_USR_GetUser              = $0001;

  WNNC_CONNECTION               = $0006;
  WNNC_CON_AddConnection        = $0001;
  WNNC_CON_CancelConnection     = $0002;
  WNNC_CON_GetConnections       = $0004;
  WNNC_CON_AutoConnect          = $0008;
  WNNC_CON_BrowseDialog         = $0010;
  WNNC_CON_RestoreConnection    = $0020;
  WNNC_PRINTING                 = $0007;
  WNNC_PRT_OpenJob              = $0002;
  WNNC_PRT_CloseJob             = $0004;
  WNNC_PRT_HoldJob              = $0010;
  WNNC_PRT_ReleaseJob           = $0020;
  WNNC_PRT_CancelJob            = $0040;
  WNNC_PRT_SetJobCopies         = $0080;
  WNNC_PRT_WatchQueue           = $0100;
  WNNC_PRT_UnwatchQueue         = $0200;
  WNNC_PRT_LockQueueData        = $0400;
  WNNC_PRT_UnlockQueueData      = $0800;
  WNNC_PRT_ChangeMsg            = $1000;
  WNNC_PRT_AbortJob             = $2000;
  WNNC_PRT_NoArbitraryLock      = $4000;
  WNNC_PRT_WriteJob             = $8000;

  WNNC_DIALOG                   = $0008;
  WNNC_DLG_DeviceMode           = $0001;
  WNNC_DLG_BrowseDialog         = $0002;
  WNNC_DLG_ConnectDialog        = $0004;
  WNNC_DLG_DisconnectDialog     = $0008;
  WNNC_DLG_ViewQueueDialog      = $0010;
  WNNC_DLG_PropertyDialog       = $0020;
  WNNC_DLG_ConnectionDialog     = $0040;
  WNNC_DLG_PrinterConnectDialog = $0080;
  WNNC_DLG_SharesDialog         = $0100;
  WNNC_DLG_ShareAsDialog        = $0200;
  WNNC_ADMIN                    = $0009;
  WNNC_ADM_GetDirectoryType     = $0001;
  WNNC_ADM_DirectoryNotify      = $0002;
  WNNC_ADM_LongNames            = $0004;
  WNNC_ADM_SetDefaultDrive      = $0008;

  WNNC_ERROR                    = $000A;
  WNNC_ERR_GetError             = $0001;
  WNNC_ERR_GetErrorText         = $0002;

Function WNetGetCaps(nIndex : Word) : WORD;

(*
 *      OTHER
 *)

Function WNetGetUser(szUser : PChar; var nBufferSize : Word) : Word;

(*
 *      BROWSE DIALOG
 *)

Const
  WNBD_CONN_UNKNOWN     =  $0;
  WNBD_CONN_DISKTREE    =  $1;
  WNBD_CONN_PRINTQ      =  $3;
  WNBD_MAX_LENGTH       =  $80;    { path length, includes the NULL}

  WNTYPE_DRIVE          =  1;
  WNTYPE_FILE           =  2;
  WNTYPE_PRINTER        =  3;
  WNTYPE_COMM           =  4;

  WNPS_FILE             =  0;
  WNPS_DIR              =  1;
  WNPS_MULT             =  2;

Function WNetDeviceMode(hwndOwner : HWND) : Word;
Function WNetBrowseDialog(hwndOwner : HWND; nType : WORD; szPath : PChar) : Word;
Function WNetConnectDialog(hwndOwner : HWND; iType : Word) : Word;
Function WNetDisconnectDialog(hwndOwner : HWND; iType : WORD) : Word;
Function WNetConnectionDialog(hwndOwner : HWND; iType : WORD) : Word;
Function WNetViewQueueDialog(hwndOwner : HWND; lpszName : PChar) : Word;
Function WNetPropertyDialog(hwndParent : hWnd; iButton, nPropSel : Word;
			    lpszName : PChar; nType : Word) : Word;
Function WNetGetPropertyText(iButton : Word; nPropSel : Word; lpszName : PChar;
			     lpszButtonName : PChar; cbButtonName, nType : Word) : Word;

(*
	 The following APIs are not exported from USER.EXE.  They must be
	 loaded from the active network driver like this:

      var
	 hinstNetDriver : tHandle;
	 lpDialogAPI : WNETSERVERBROWSEDIALOG ;
      begin
	 hinstNetDriver := WNetGetCaps($FFFF);
	 if (hinstNetDriver <> 0) then
	 lpDialogAPI  := GetProcAddress(hinstNetDriver, ORD_WNETSERVERBROWSEDIALOG);
         if (lpDialogAPI <> NULL) then
		 // currently installed network doesn't support this API
           lpDialogAPI(hwndParent, lpszSectionName, lpszBuffer, cbBuffer, 0L);
      end;
*)

Const
  WNETSHAREASDIALOG : Function(hwndParent : HWND; iType : Word; lpszPath : PChar) : Word = NIL;
  WNETSTOPSHAREDIALOG : Function(hwndParent : Hwnd; iType : Word; lpszPath : PChar) : Word = NIL;
  WNETSETDEFAULTDRIVE : Function(idriveDefault : Word) : Word = NIL;
  WNETGETSHARECOUNT : Function(iType : Word) : Word = NIL;
  WNETGETSHARENAME : Function(lpszPath, lpszBuf : PChar; cbBuf : Word) : Word = NIL;
  WNETSERVERBROWSEDIALOG : Function(hwndParent : hWnd;
			            lpszSectionName,
			            lpszBuffer : PChar;
				    cbBuffer : Word;
                                    dlFlags : LongInt) : Word = NIL;
  WNETGETSHAREPATH : Function(lpszName, lpszBuf : PChar; cbBuf : Word) : Word = NIL;
  WNETGETLASTCONNECTION : Function(iType : Word; var lpwConnIndex : Word) : Word = NIL;
  WNETEXITCONFIRM : Function(hwndOwner : hWnd; iExitType : Word) : Word = NIL;
  AUTOLOGON : Function(hwndOwner : hWnd; lpszReserved : PChar;	fPrompt : BOOL;
                        var lpfLoggedOn : BOOL) : Word = NIL;
  LOGOFF : Function(hwndOwner : hWnd; lpszReserved : PChar) : BOOL = NIL;
  CHANGEPASSWORD : Procedure(hwndOwner : hWnd) = NIL;
  CHANGECACHEPASSWORD : Procedure(hwndOwner : hWnd) = NIL;
  CONNECTDIALOG : Function(hwndParent : hWnd; iType : Word) : Word = NIL;
  CONNECTIONDIALOG : Function(hwndParent : hWnd; iType : Word) : Word = NIL;

Type
  PPASSWORD_CACHE_ENTRY = ^TPASSWORD_CACHE_ENTRY;
  TPASSWORD_CACHE_ENTRY = Record
    cbEntry,
    cbResource,
    cbPassword : Word;
    iEntry,
    nType : Byte;
    abResource : Array[0..1] of Byte;    (* resource name, cbResource bytes long *)
                                         (* password follows immediately after *)
  end;

Const
  WNETCACHEPASSWORD : Function(pbResource : PChar; cbResource : Word;
			       pbPassword : PChar; cbPassword : Word;
			       nType : Byte) : Word = NIL;

  WNETGETCACHEDPASSWORD : Function(pbResource : PChar; cbResource : Word;
				   pbPassword : PChar; var pcbPassword : Word;
				   nType : Byte) : Word = NIL;

  WNETREMOVECACHEDPASSWORD : Function(pbResource : PChar;
				      cbResource : Word; nType : Byte) : Word = NIL;

(*
	 Typedef for the callback routine passed to WNetEnumCachedPasswords.
	 It will be called once for each entry that matches the criteria
	 requested.  It should return TRUE if it wants the enumeration to
	 continue, FALSE to stop.
*)
  CACHECALLBACK : Function(pce : PPASSWORD_CACHE_ENTRY) : BOOL = NIL;


  WNETENUMCACHEDPASSWORDS : Function(pbPrefix : PChar; cbPrefix : Word;
				     nType : Byte; pfnCallback : tFarProc) : Word = NIL;

(*
 * Ordinals in the network driver for APIs not exported by USER.
 *)

Const
  ORD_I_AUTOLOGON               = 530;
  ORD_I_CHANGEPASSWORD          = 531;
  ORD_I_LOGOFF                  = 532;
  ORD_I_CONNECTIONDIALOG        = 533;
  ORD_I_CHANGECACHEPASSWORD     = 534;
  ORD_I_CONNECTDIALOG           = 535;
  ORD_WNETSHARESDIALOG          = 140;
  ORD_WNETSHAREASDIALOG         = 141;
  ORD_WNETSTOPSHAREDIALOG       = 142;
  ORD_WNETSETDEFAULTDRIVE       = 143;
  ORD_WNETGETSHARECOUNT         = 144;
  ORD_WNETGETSHARENAME          = 145;
  ORD_WNETSERVERBROWSEDIALOG    = 146;
  ORD_WNETGETSHAREPATH          = 147;
  ORD_WNETGETLASTCONNECTION     = 148;
  ORD_WNETEXITCONFIRM           = 149;
  ORD_WNETCACHEPASSWORD         = 150;
  ORD_WNETGETCACHEDPASSWORD     = 151;
  ORD_WNETREMOVECACHEDPASSWORD  = 152;
  ORD_WNETENUMCACHEDPASSWORDS   = 153;

(*
 *   the following nType values are only for the purposes of enumerating
 *   entries from the cache.  note that PCE_ALL is reserved and should not
 *   be the nType value for any entry.
*)

  PCE_DOMAIN  = $01;  (* entry is for a domain *)
  PCE_SERVER  = $02;  (* entry is for a server *)
  PCE_UNC     = $03;  (* entry is for a server/share combo *)

  PCE_NOTMRU  = $80;  (* bit set if entry is exempt from MRU aging *)
  PCE_ALL     = $ff;  (* retrieve all entries *)


(*
 * Defines for iExitType on WNetExitConfirm
*)
  EXIT_CONFIRM  = 0;
  EXIT_EXITING  = 1;
  EXIT_CANCELED = 2;

(*
 *      ADMIN
 *)

  WNDT_NORMAL  = 0;
  WNDT_NETWORK = 1;

  WNDN_MKDIR = 1;
  WNDN_RMDIR = 2;
  WNDN_MVDIR = 3;

Function WNetGetDirectoryType(lpName : PChar; var lpType : Integer) : Word;
Function WNetDirectoryNotify(hwndOwner : HWND; lpDir : PChar; wOper : WORD) : Word;

(*
 *      ERRORS
*)

Function WNetGetError(var nError : Word) : Word;
Function WNetGetErrorText(nError : WORD; lpBuffer : PChar; var nBufferSize : Word) : Word;

(*
 *      STATUS CODES
*)

(* General *)
Const
  WN_SUCCESS                     = $0000;
  WN_NOT_SUPPORTED               = $0001;
  WN_NET_ERROR                   = $0002;
  WN_MORE_DATA                   = $0003;
  WN_BAD_POINTER                 = $0004;
  WN_BAD_VALUE                   = $0005;
  WN_BAD_PASSWORD                = $0006;
  WN_ACCESS_DENIED               = $0007;
  WN_FUNCTION_BUSY               = $0008;
  WN_WINDOWS_ERROR               = $0009;
  WN_BAD_USER                    = $000A;
  WN_OUT_OF_MEMORY               = $000B;
  WN_CANCEL                      = $000C;
  WN_CONTINUE                    = $000D;

(* Connection *)

  WN_NOT_CONNECTED               = $0030;
  WN_OPEN_FILES                  = $0031;
  WN_BAD_NETNAME                 = $0032;
  WN_BAD_LOCALNAME               = $0033;
  WN_ALREADY_CONNECTED           = $0034;
  WN_DEVICE_ERROR                = $0035;
  WN_CONNECTION_CLOSED           = $0036;

(* Printing *)

  WN_BAD_JOBID                   = $0040;
  WN_JOB_NOT_FOUND               = $0041;
  WN_JOB_NOT_HELD                = $0042;
  WN_BAD_QUEUE                   = $0043;
  WN_BAD_FILE_HANDLE             = $0044;
  WN_CANT_SET_COPIES             = $0045;
  WN_ALREADY_LOCKED              = $0046;

  WN_NO_ERROR                    = $0050;

(* stuff in user, not driver, for shell apps ;Internal *)
Function WNetErrorText(nError : WORD; lpszText : PChar; cbText : WORD) : Word;

(* this is the data structure returned from LFNFindFirst and
 * LFNFindNext.  The last field, achName, is variable length.  The size
 * of the name in that field is given by cchName, plus 1 for the zero
 * terminator.
 *)

Type
  PFILEFINDBUF2 = ^TFILEFINDBUF2;
  TFILEFINDBUF2 = Record
    fdateCreation,
    ftimeCreation,
    fdateLastAccess,
    ftimeLastAccess,
    fdateLastWrite,
    ftimeLastWrite : Word;
    cbFile,
    cbFileAlloc : LongInt;
    attr : Word;
    cbList : LongInt;
    cchName : Byte;
    achName : Array[0..1] of Byte;
  end;

Const
  QUERYPROC : Function : BOOL = NIL;

(* Functions in Winnet.h but not exported by anything obvious
   and not documented.
Function LFNFindFirst(LPSTR,WORD,LPINT,LPINT,WORD,PFILEFINDBUF2) : Word;
Function LFNFindNext(HANDLE,LPINT,WORD,PFILEFINDBUF2) : Word;
Function LFNFindClose(HANDLE) : Word;
Function LFNGetAttribute(LPSTR,LPINT) : Word;
Function LFNSetAttribute(LPSTR,WORD) : Word;
Function LFNCopy(LPSTR,LPSTR,PQUERYPROC) : Word;
Function LFNMove(LPSTR,LPSTR) : Word;
Function LFNDelete(LPSTR) : Word;
Function LFNMKDir(LPSTR) : Word;
Function LFNRMDir(LPSTR) : Word;
Function LFNGetVolumeLabel(WORD,LPSTR) : Word;
Function LFNSetVolumeLabel(WORD,LPSTR) : Word;
Function LFNParse(LPSTR,LPSTR,LPSTR) : Word;
Function LFNVolumeType(WORD,LPINT) : Word;
*)

(* return values from LFNParse
 *)

Const
  FILE_83_CI         =     0;
  FILE_83_CS         =     1;
  FILE_LONG          =     2;

(* volumes types from LFNVolumeType
 *)
  VOLUME_STANDARD    =     0;
  VOLUME_LONGNAMES   =     1;

{ will add others later, == DOS int 21h error codes.}

{ this error code causes a call to WNetGetError, WNetGetErrorText}
{ to get the error text.}
  ERROR_NETWORKSPECIFIC  = $FFFF;

Implementation
Function WNetAddConnection; external 'USER' index 517;
Function WNetCancelConnection; external 'USER' index 518;
Function WNetGetConnection; external 'USER' index 512;
Function WNetRestoreConnection; external 'USER' index 523;

Function WNetGetCaps; external 'USER' index 513;
Function WNetGetUser; external 'USER' index 516;

Function WNetDeviceMode; external 'USER' index 514;
Function WNetBrowseDialog; external 'USER' index 515;
Function WNetConnectDialog; external 'USER' index 525;
Function WNetDisconnectDialog; external 'USER' index 526;
Function WNetConnectionDialog; external 'USER' index 527;
Function WNetViewQueueDialog; external 'USER' index 528;
Function WNetPropertyDialog; external 'USER' index 529;
Function WNetGetPropertyText; external 'USER' index 532;

Function WNetGetDirectoryType; external 'USER' index 530;
Function WNetDirectoryNotify; external 'USER' index 531;

Function WNetGetError; external 'USER' index 519;
Function WNetGetErrorText; external 'USER' index 520;

Function WNetErrorText; external 'USER' index 499;
end.