(*****************************************************************************\
*                                                                             *
* nddeapi.pas - Network DDE share manipulation and control functions          *
*                                                                             *
*               Version 1.0                                                   *
*                                                                             *
*               (c) Copyright G.T. Swindell 1993                              *
\*****************************************************************************)

Unit NDDEAPI;
{$F+}
Interface
Uses
  WinTypes, WinProcs;

Const
  CnLen = 15;
  UnCLen = CnLen + 2;

  { API error codes }

  NDDE_NO_ERROR                = 0 ;
  NDDE_ACCESS_DENIED           = 1 ;
  NDDE_BUF_TOO_SMALL           = 2 ;
  NDDE_ERROR_MORE_DATA         = 3 ;
  NDDE_INVALID_SERVER          = 4 ;
  NDDE_INVALID_SHARE           = 5 ;
  NDDE_INVALID_PARAMETER       = 6 ;
  NDDE_INVALID_LEVEL           = 7 ;
  NDDE_INVALID_PASSWORD        = 8 ;
  NDDE_INVALID_ITEMNAME        = 9 ;
  NDDE_INVALID_TOPIC           = 10;
  NDDE_INTERNAL_ERROR          = 11;
  NDDE_OUT_OF_MEMORY           = 12;
  NDDE_INVALID_APPNAME         = 13;
  NDDE_NOT_IMPLEMENTED         = 14;
  NDDE_SHARE_ALREADY_EXIST     = 15;
  NDDE_SHARE_NOT_EXIST         = 16;
  NDDE_INVALID_FILENAME        = 17;
  NDDE_NOT_RUNNING             = 18;
  NDDE_INVALID_WINDOW          = 19;
  NDDE_INVALID_SESSION         = 20;

{ string size constants }
  MAX_NDDESHARENAME     = 64 ;
  MAX_PASSWORD          = 15 ;
  MAX_USERNAME          = 15 ;
  MAX_DOMAINNAME        = 15 ;
  MAX_APPNAME           = 255;
  MAX_TOPICNAME         = 255;
  MAX_ITEMNAME          = 255;

{ permission mask bits }
  NDDEACCESS_REQUEST      : LongInt = $00000001;
  NDDEACCESS_ADVISE       : LongInt = $00000002;
  NDDEACCESS_POKE         : LongInt = $00000004;
  NDDEACCESS_EXECUTE      : LongInt = $00000008;
  NDDEACCESS_START_APP    : LongInt = $00000010;

  NDDEACCESS_ALL              : LongInt =   $0000001F;
  NDDEACCESS_EXCLUDEEXECUTE   : LongInt =   $00000017;
  NDDEACCESS_EXCLUDESTARTAPP  : LongInt =   $0000000F;

{ connectFlags bits for ndde service affix }
  NDDEF_NOPASSWORDPROMPT  = $0001;
  NDDEF_NOCACHELOOKUP     = $0002;
  NDDEF_STRIP_NDDE        = $0004;

Type
{ NDDESHAREITEMINFO - contains information about item security }
  PNDDEShareItemInfo = ^TNDDEShareItemInfo;
  TNDDEShareItemInfo = Record
    lpszItem : PChar;
    dwPermission : LongInt;
  end;

  PNDDEShareInfo = ^TNDDEShareInfo;
  TNDDEShareInfo = Record
    szShareName : Array[0..MAX_NDDESHARENAME] of Char;
    lpszTargetApp,
    lpszTargetTopic : PChar;
    lpbPassWord1 : PByte;
    cbPassWord1 : LongInt;
    dwPermissions1 : LongInt;
    lpbPassWord2 : PByte;
    cbPassWord2 : LongInt;
    dwPermissions2 : LongInt;
    lpszItem : PChar;
    cAddItems : LongInt;
    lpNDDEShareItemInfo : PNDDEShareItemInfo;
  end;

const
{* ddesess_Status defines *}
  NDDESESS_CONNECTING_WAIT_NET_INI = 1;
  NDDESESS_CONNECTING_WAIT_OTHR_ND = 2;
  NDDESESS_CONNECTED               = 3;
  NDDESESS_DISCONNECTING           = 4;

Type
 (* NDDESESSINFO - contains information about a NDDE session *)

  PNDDESessInfo = ^TNDDESessInfo;
  TNDDESessInfo = Record
    szClientName : Array[0..UnClen] of Char;
    Status : Integer;
    UniqueID : LongInt;
  end;

const
 (* ddeconn_Status defines *)

  NDDECONN_WAIT_LOCAL_INIT_ACK = 1;
  NDDECONN_WAIT_NET_INIT_ACK   = 2;
  NDDECONN_OK                  = 3;
  NDDECONN_TERMINATING         = 4;
  NDDECONN_WAIT_USER_PASSWORD  = 5;

Type
  (* NDDECONNINFO - contains information about a NDDE conversation *)

  PNDDEConnInfo = ^TDDEConnInfo;
  TDDEConnInfo = Record
    lpszShareName : PChar;
    Status : Integer;
    Pad : Integer;
  end;


{Share Management}

Function NDdeShareAdd
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    uLevel : Integer;                   {Info level: must be 2}
    lpNDdeShareInfo : PNDDESHAREINFO;   {Pointer to the share info}
    cbShareInfo : LongInt               {Sizeof lpNDdeShareInfo}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeShareDel
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    lpszShareName : PChar;              {Name of share to delete}
    uReserved : Word                    {Reserved}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeShareEnum
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    uLevel : Word;                      {0 for doubly-null terminated list}
    lpNames : PChar;                    {Pointer to buffer to receive the}
                                        {    doubly-null term list of shares}
    cbNames : LongInt;                  {Size of the lpNames buffer}
    lpnEntriesRead : PLongInt;          {Number of names returned}
    lpcbTotalAvailable : PWord          {Number of bytes available}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeShareGetInfo
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    lpszShareName : PChar;              {Name of share}
    uLevel : Word;                      {Info level: must be 2}
    lpNDdeShareInfo : PNDDESHAREINFO;   {Structure to receive the info}
    cbShareInfo : LongInt;              {Size of lpNDdeShareInfo}
    lpcbTotalAvailable : PLongInt;      {Number of bytes available}
    lpnItems : PWord                    {Receives gets number of added items}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeShareSetInfo
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    lpszShareName : PChar;              {Name of share}
    uLevel : Word;                      {Info level must be 2}
    lpNDdeShareInfo : PNDDESHAREINFO;   {Points to structure with info}
    cbShareInfo : LongInt;              {Size of lpNDdeShareInfo}
    sParmNum : Word                     {Parameter index: must be 0}
    ) : Word;                           {Returns NDDE_* error code.}



{Session and Connection Management}

Function NDdeSessionEnum
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    uLevel : Word;                      {Info level:  must be 1}
    lpNDdeSessInfo : PNDDESESSINFO;     {Pointer to structure to get info}
    cbSessInfo : LongInt;               {Size of lpNDdeSessInfo}
    lpcbTotalAvailable : PLongInt;      {Received number of bytes filled}
    lpnItems : PLongInt                 {Received number of names}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeConnectionEnum
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    lpszClientName : PChar;             {Name of client to enum shares from;}
                                        {if NULL, enumerate from all}
    UniqueID : LongInt;                 {Used to distinguish same-name clients}
    uLevel : Word;                      {Info level:  must be 1}
    lpNDdeConnInfo : PNDDECONNINFO;     {Pointer to receive connection info}
                                        {which is a doubly-null terminated}
                                        {list of name strings.}
    cbConnInfo : LongInt;               {Size of lpNDdeConnInfo}
    lpcbTotalAvailable : PLongInt;      {Receives number of bytes filled}
    lpnItems : PLongInt                 {Receives number of items returned}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeSessionClose
    (
    lpszServer : PChar;                 {Server to execute on: must be NULL}
    lpszClientName : PChar;             {Client to close}
    UniqueID : LongInt                  {To identify same-named clients}
    ) : Word;                           {Returns NDDE_* error code.}

{Information Retrieval}

Function NDdeGetClientInfo
    (
    hWndClient : hWnd;                  {Your window, or the guy you talk to?}
    lpszClientNode : PChar;             {Buffer to receive the client name}
    cchClientNode : LongInt;            {Size of lpszClientNode}
    lpszClientApp : PChar;              {Buffer to receive the app name}
    cchClientApp : LongInt              {Size of lpszClientApp}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeGetNodeName
    (
    lpszNodeName : PChar;               {Buffer in which to store the name}
    cchNodeName : LongInt               {Length of the lpszNodeName buffer}
    ) : Word;                           {Returns NDDE_* error code.}


Function NDdeGetErrorString
    (
    uErrorCode : Word;                  {Error code to get string for}
    lpszError : PChar;                  {Buffer to hold error string}
    cchError : LongInt                  {Length of lpszError}
    ) : Word;                           {Returns NDDE_* error code.}

{Utilities}
Function NDdeGetWindow : hWnd;

{Name validation APIs}
Function NDdeIsValidShareName(pszShare : PChar) : BOOL;
Function NDdeIsValidPassword(pszPassword : PChar) : BOOL;
Function NDdeIsValidTopic(pszTopic : PChar) : BOOL;

Implementation

Function NDdeShareAdd; external 'NDDEAPI' Index 100;
Function NDdeShareDel; external 'NDDEAPI' Index 101;
Function NDdeShareEnum; external 'NDDEAPI' Index 102;
Function NDdeShareGetInfo; external 'NDDEAPI' Index 103;
Function NDdeShareSetInfo; external 'NDDEAPI' Index 104;
Function NDdeSessionEnum; external 'NDDEAPI' Index 112;
Function NDdeConnectionEnum; external 'NDDEAPI' Index 108;
Function NDdeSessionClose; external 'NDDEAPI' Index 113;
Function NDdeGetClientInfo; external 'NDDEAPI' Index 105;
Function NDdeGetNodeName; external 'NDDEAPI' Index 106;
Function NDdeGetErrorString; external 'NDDEAPI' Index 107;
Function NDdeGetWindow; external 'NDDEAPI' Index 114;
Function NDdeIsValidShareName; external 'NDDEAPI' Index 109;
Function NDdeIsValidPassword; external 'NDDEAPI' Index 110;
Function NDdeIsValidTopic; external 'NDDEAPI' Index 111;

end.
