{************************************************}
{                                                }
{   Turbo Pascal 6.0                             }
{   Demo program FmtDemo.pas for unit FmtLine,   }
{   TVGUID16.pas Demo program from the TV Guide  }
{                                                }
{************************************************}

{$X+}

program ValidateFormatDemo;

uses Objects, Drivers, Views,      {std. TV units}
Menus, Dialogs, App, Msgbox,       { ditto       }
FmtLine;                  {modified Formline unit}

const
  cmNewDialog = 101;

var
  Value: real;
type                          {declare the type of data record to use in box}
  DataRec                   = RECORD
   Field1                    : string [ 30 ] ; {NameFormatline}
   Field2                    : real          ; {MoneyFormatline}
   Field3                    : string [ 14 ] ; {PhoneFormatline}
   Field4                    : string [ 10 ] ; {ZipFormatline}
   Field5                    : real          ; {RealFormatline}
   Field6                    : integer       ; {IntegerFormatline}
   Field7                    : real          ; {LatlongFormatline}
   Field8                    : real          ; {TimeFormatline}
  END ;


  TMyApp = object(TApplication)
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure NewDialog;
  end;

  PDemoDialog = ^TDemoDialog;
  TDemoDialog = object(TDialog)
  end;

var
  DemoDialogData: DataRec;  {declare name of data record variable in box }
                            {you need a name since you could have two    }
                            {instances of the box, each with its own data}

{ TMyApp }
procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmNewDialog: NewDialog;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil)),
    NewSubMenu('~D~ialog', hcNoContext, NewMenu(
      NewItem('~V~alidate', 'F2', kbF2, cmNewDialog, hcNoContext,
      nil)),
    nil))
  )));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~F10~ Menu', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F2~ Dialog', kbF2, cmNewDialog,
      NewStatusKey('            <<Input Validator>>   SA Midwinter',
                                kbNoKey, cmError,
      nil)))),
    nil)
  ));
end;

   {Dialog box built with Shazam 2, Turbo Vision  }
   {code generator by Jonathan J. Stein, 76576,470} 

procedure TMyApp.NewDialog;

var
   Dlg                       : PDemoDialog ;
   R                         : TRect ; 
   Control                   : PInputline;
   Labl, Histry,
   Button, Bruce             : PView ;
   C                         : word;

begin
   R.Assign ( 3 , 1 , 54 , 20 ) ; 
  Dlg := New(PDemoDialog, Init(R, 'tFormatLine Descendants'));
  with Dlg^ do
  begin
   R.Assign ( 12 , 2 , 37 , 3 ) ; 
   Control                   := New ( PNameFormatLine , Init ( R , 30 ) ) ;
   Control^.HelpCtx          := hcNoContext ;
   Dlg^.Insert ( Control ) ; 
   {the Dlg^ is redundant since we have a 'With Dlg^ do' }
   R.Assign ( 7 , 2 , 12 , 3 ) ;
   Labl                      := New ( PLabel , Init ( R , '~N~ame' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 4 , 32 , 5 ) ; 
   Control                   := New ( PMoneyFormatLine , Init ( R , 30 ) ) ;
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 6 , 4 , 12 , 5 ) ;
   Labl                      := New ( PLabel , Init ( R , '~M~oney' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 6 , 29 , 7 ) ;
   Control                   := New ( PPhoneFormatLine , Init ( R , 14 ) ) ;
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 6 , 6 , 12 , 7 ) ;
   Labl                      := New ( PLabel , Init ( R , '~P~hone' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 8 , 22 , 9 ) ; 
   Control                   := New ( PZipFormatLine , Init ( R , 10 ) ) ;
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 1 , 8 , 12 , 9 ) ; 
   Labl                      := New ( PLabel , Init ( R , '~Z~ip/Postal' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 10 , 27 , 11 ) ; 
   Control                   := New ( PRealFormatLine , Init ( R , 15 ) ) ;
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 7 , 10 , 12 , 11 ) ;
   Labl                      := New ( PLabel , Init ( R , '~R~eal' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 12 , 19 , 13 ) ;
   Control                   := New ( PIntegerFormatLine , Init ( R , 15 ) ) ;
   Control^.HelpCtx          := hcNOCONTEXT ; 
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 4 , 12 , 12 , 13 ) ; 
   Labl                      := New ( PLabel , Init ( R , '~I~nteger' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 14 , 27 , 15 ) ;
   Control                   := New ( PLongFormatLine , Init ( R , 15 ) ) ;
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 2 , 14 , 12 , 15 ) ;
   Labl                      := New ( PLabel , Init ( R , '~L~ongitude' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 12 , 16 , 25 , 17 ) ; 
   Control                   := New ( PTimeFormatLine , Init ( R , 15 ) ) ;
   Dlg^.Insert ( Control ) ; 
   R.Assign ( 7 , 16 , 12 , 17 ) ; 
   Labl                      := New ( PLabel , Init ( R , '~T~ime' , Control ) ) ;
   Dlg^.Insert ( Labl ) ;

   R.Assign ( 38 , 11 , 46 , 13 ) ; 
   Button                    := New ( PButton , Init ( R , '~O~k' , cmOK , bfDefault ) ) ;
   Dlg^.Insert ( Button  ) ; 
   R.Assign ( 37 , 14 , 47 , 16 ) ;
   Button                    := New ( PButton , Init ( R , 'Cancel' , cmCancel , bfNormal ) ) ;
   Dlg^.Insert ( Button  ) ; 

   R.Assign ( 9 , 18 , 17 , 19 ) ; 
   Bruce                     := New ( PStaticText , Init ( R , 'TAB-next' ) ) ;
   Dlg^.Insert ( Bruce   ) ;
   R.Assign ( 24 , 18 , 37 , 19 ) ; 
   Bruce                     := New ( PStaticText , Init ( R , 'ShiftTAB-prev' ) ) ;
   Dlg^.Insert ( Bruce   ) ; 

end; {end of With Dlg^ do}

  Dlg^.SetData(DemoDialogData);
  C := DeskTop^.ExecView(Dlg);
  if C <> cmCancel then Dlg^.GetData(DemoDialogData);

  {in a real app, you would insert here methods for using the data}
  {you have collected, for example the following nonsense:        }

    With DemoDialogData do
    begin
      Value:= Field2 {money} * Field8 {time} / Field7 {longitude};
      if Value > 100 then
         Messagebox(#3'I''m rich, I''m rich!!',
                    nil, mfInformation+mfOkButton)
      else
         Messagebox(#3'Oh well, back to work...',
                    nil, mfInformation+mfOkButton);
    end;

  Dispose(Dlg, Done);
end;

var
  MyApp: TMyApp;

begin  {initialise data record}
  with DemoDialogData do
  begin
   Field1 := 'Brian Mulroney' {string [ 30 ] } ; {NameFormatline}
   Field2 := 276543.21        {real          } ; {MoneyFormatline}
   Field3 := '(403) 230-7769' {string [ 14 ] } ; {PhoneFormatline}
   Field4 := 'T2M 1S4'        {string [ 10 ] } ; {ZipFormatline}
   Field5 := 123.456789       {real          } ; {RealFormatline}
   Field6 := 16384            {integer       } ; {IntegerFormatline}
   Field7 := -121.3456        {real          } ; {LatlongFormatline}
   Field8 := 17.3377          {real          } ; {TimeFormatline}
  end;
  MyApp.Init;
  MessageBox(#3'Validated Input Line Tester'#13
             +#3'released into the public domain by'#13
             +#3'Stewart Midwinter 74670,1306',
             nil,mfInformation+mfOkButton);
  MyApp.Run;
  MyApp.Done;
end.
