/* Rexx program to install WUZ */
/* (c) Copyright 1993 Scott Maxwell. */

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

arg where tempdir

  Say "Welcome to Workplace UnZip!"'0a'x

  Say "WUZ is a series of REXX functions to give you access to archive"
  Say "files (including .ARC, .ARJ, .LZH, .TAR, .Z, .ZIP and .ZOO) from"
  Say "the Workplace Shell or the command line."'0a'x

top:
if where = '' | tempdir = '' then do
  where = ''
  path = Value('PATH',,'OS2ENVIRONMENT')

  Say "WUZ must be installed in a directory on your PATH:"'0a'x
  i = 1
  found = 0
  dir. = ''
  do forever
    parse var path dir.i ';' path
    if Right(dir.i,1) \= '\' then
      dir.i = dir.i'\'
    if SubStr(dir.i,2,1) = ':' then do
      if Length(CharIn(dir.i'wuz.cmd',1,1)) = 1 then do
        found=i
	Call CharOut dir.i'wuz.cmd'
      end
      i=i+1
    end
    if path='' then leave
  end

  if found > 0 then do
    Say '0a'x"WUZ seems to be installed in" dir.found
    Call CharOut ,"Do you wish to uninstall WUZ? "
    parse upper pull ans
    if Left(ans,1)='Y' then do
      say "Erasing:	wuz.cmd"
      say "		wuz.ico"
      say "		post-wuz.cmd"
      say "		zipstrip.cmd"
      say "		open-dir.cmd"
      say "		kill-dir.cmd from" dir.found
      Call SysFileDelete dir.found'wuz.cmd'
      Call SysFileDelete dir.found'wuz.ico'
      Call SysFileDelete dir.found'post-wuz.cmd'
      Call SysFileDelete dir.found'zipstrip.cmd'
      Call SysFileDelete dir.found'open-dir.cmd'
      Call SysFileDelete dir.found'kill-dir.cmd'
      Call SysDestroyObject '<WorkplaceUnZip>'
      exit(1)
    end      
    Call CharOut ,"Do you wish to install over the old copy? "
    parse upper pull ans
    if Left(ans,1)='Y' then
      where = dir.found
  end
  if where = '' then do
    i = i-1
    dir.0 = i
    tr = Trunc((i+1)/2)
    do i=1 to tr
      i2 = i+tr
      build  = '('i')' dir.i
      if dir.i2 \= '' then
        build2 = '('i2')' dir.i2
      else
        build2 = ''
      say insert(build,build2,,40)
    end
    Call CharOut ,'0a'x"Enter the number of your selection: "
    parse pull ans
    if ans > 0 & ans <= dir.0 then
      where = dir.ans
    else do
      say "Invalid number.  Aborting"
      exit(0)
    end
  end
  tempdir = '\'
  hold = directory()
end
else do
  hold = directory()
  where2 = directory(where)
  if where2 = '\' then do
    say "Unknown directory:" where
    where = ''
    Call Directory hold
    Signal top
  end
  where = where2
  tempdir = directory(tempdir)
end

do while tempdir = '\'
  Call CharOut ,"Where should I create temporary directories? "
  parse pull tempdir
  if tempdir='' then do
    Say "Aborting install"
    exit(0)
  end
  call Directory hold
  temp = tempdir
  tempdir = directory(tempdir)
  if tempdir = '\' then do
    Call CharOut ,temp "does not exist.  Should I create it? "
    parse upper pull ans
    if Left(ans,1) = 'Y' then do
      if SysMkDir(temp) then
        say "Can't create" temp
      else
        tempdir = temp
    end
  end
end

call Directory hold

if where \= '.' then do
  from = directory()
  to = directory(where)
  if to = '\' then do
    say where': directory not found'
    exit(1)
  end
  say '0a'x"Copying:	wuz.cmd"
  say "		wuz.ico"
  say "		post-wuz.cmd"
  say "		zipstrip.cmd"
  say "		open-dir.cmd"
  say "		kill-dir.cmd to "to

  Drive = Left(tempdir,2)
  Call SysFileDelete 'wuz.cmd'
  Call LineOut 'wuz.cmd',linein(from'wuz.cmd')
  Call LineOut 'wuz.cmd',linein(from'wuz.cmd')
  Call LineOut 'wuz.cmd',linein(from'wuz.cmd')
  Call LineIn from'wuz.cmd'
  Call LineIn from'wuz.cmd'
  Call LineOut 'wuz.cmd',"Drive    = '"Drive"'"
  Call LineOut 'wuz.cmd',"DestPath = '"tempdir"'"
  do while lines(from'wuz.cmd') > 0
    Call LineOut 'wuz.cmd',LineIn(from'wuz.cmd')
  end
  '@copy' from'wuz.ico > nul'
  '@copy' from'post-wuz.cmd > nul'
  '@copy' from'zipstrip.cmd > nul'
  '@copy' from'open-dir.cmd > nul'
  '@copy' from'kill-dir.cmd > nul'
  Call Directory from
end
else
  to = directory()

Call SysDestroyObject '<WorkplaceUnZip>'
Call SysCreateObject "WPProgram", "WPS Unzip", "<WP_DESKTOP>",,
	"OBJECTID=<WorkplaceUnZip>;PROGTYPE=PM;EXENAME="to"wuz.cmd;ASSOCFILTER=*.arc,*.arj,*.lzh,*.tar,*.z,*.zip,*.zoo"

Say '0a'x"Workplace UnZip has been successfully installed."
Say "Try it out and see if you like it.  If you do, I would appreciate"
Say "a small cash donation ($10 maybe) or at least a note telling me"
Say "what you think.  My Usenet address is scott.maxwell@channel1.com."
Say "Any money should go to:  Pat Maxwell"
Say "                         1587 E. Modesto Ave."
Say "                         Camarillo, CA 93010 U.S.A."'0a'x

Say "You may also rerun Inst-WUZ.Cmd to uninstall."
Say "For more information about Workplace UnZip, read README.WUZ."
exit(0)

Directory: procedure
  arg Name
  if Length(Name) > 3 then
    if Right(Name,1) = '\' then
      Name = Left(Name,LENGTH(Name)-1)
  n = 'DIRECTORY'(Name)
  if Right(n,1) \= '\' then
    n = n'\'
  return n
