/** Demo.cmd **/
/******************************************/
/*                                        */
/* Command line syntax:                   */
/*                                        */
/* demo db_path user_password user_name   */
/*                                        */
/*                                        */
/******************************************/
ARG db_path user_pw user_name
'@echo off'
'@cls'
Say 'RexxVIM General Demonstration Program'
Say

/* Unload functions upon error */
SIGNAL ON ERROR NAME done

/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(db_path)) = 0 then do
   Say 'Enter Postoffice Directory:'
   PARSE PULL db_path .
   Say
   Say 'Enter User Name:'
   PARSE PULL user_name
   Say 'Enter Password:'
   PARSE PULL user_pw
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
Say
Say '|-Call To Routine ---------------RC--|'
Say '  RxVIMInitialize:              ' rc
if (rc > 0) then call vimerr


/* Retrieve the default session info if present */
rc = RxVIMGetDefaultSessionInfo('def_path', 'def_user')
Say '  RxVIMGetDefaultSessionInfo    ' rc
if (rc > 0) then call vimerr
Say '      Default Path:' def_path
Say '      Default Name:' def_user
Say


/* Query the maximum subject line length and maximum */
/* text length                                       */
rc = RxVIMQueryCapability('VIMSEL_MAX_SUBJECT_LEN','Query')
Say '  RxVIMQueryCapability          ' rc
if (rc > 0) then call vimerr
Say '      Max Subject Length:' query
rc = RxVIMQueryCapability('VIMSEL_MAX_TEXT_LEN','Query')
if (rc > 0) then call vimerr
Say '         Max Text Length:' query
Say


/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession(db_path,user_name,user_pw,Session)
Say '  RxVIMOpenSession:             ' rc
if (rc > 0) then call vimerr


/* Retieve the name and type of active session */
rc = RxVIMGetEntityName(Session,'Entity')
Say '  RxVIMGetEntityName            ' rc
if (rc > 0) then call vimerr
Say '      Type:' entity.Type
Say '      Name:' entity.Name
Say


/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
Say '  RxVIMCloseSession:            ' rc
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
Say '  RxVIMTerminate:               ' rc
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

rc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information -----------------|'
Say '  Error Text:' status.1
Say
Say '  Ext Status:' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
