/**********************************************************************
 *
 * Personal Inventory Gatherer/2 installation program.
 *
 * Vesion 1.0
 * August 8, 1994
 *
 * Copyright (C) 1994 by 
 * James E Johnson Jr.
 * All Rights Reserved.
 *
 **********************************************************************/


"@ECHO OFF"

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs
call RxFuncAdd "SysCls", "RexxUtil", "SysCls"

arg FullPathName

if FullPathName = "" then
  do
    call SysCls
    say ""
    say "Usage:"
    say " "
    say "  INSTALL FullPathName"
    say ""
    say "  FullPathname is a combination of both the drive letter and directory path,"
    say "  if the directory does not exist it will be created."
    say ""
    say ""
    say "  Example:"
    say ""
    say "  INSTALL c:\apps\pig                   -- will install PIG/2 in c:\apps\pig"
  end
else
  do
    call SysCls
    say "Installing Personal Inventory Gatherer/2 in "FullPathName"."
    rc = SysFileTree( FullPathName, "dirs", "D")
    if (dirs.0 = 0) then
      do
        rc = SysMkDir(FullPathName)
        if (rc \= 0) then
          do
            say "Couldn't create directory "FullPathName"."
          exit
        end
      end
    copy pig.exe     FullPathName ">NUL"
    copy pig.hlp     FullPathName ">NUL"
    copy pig.doc     FullPathName ">NUL"
    copy install.cmd FullPathName ">NUL"
    rc = SysFileTree( "pig.key", "files", "F")
    if (files.0 \= 0) then
      do
        copy pig.key FullPathName ">NUL"
      end
    CR = D2C(13)
    rc = SysCreateObject("WPProgram", "Personal"CR" Inventory"CR" Gatherer/2", "<WP_DESKTOP>", "PROGTYPE=PM;EXENAME="FullPathname"\pig.exe", "REPLACE")
    say "Installation complete."
  end

