/* REXX */
/*=========================================================================*/
/* In the unfortunate situation that a forum message base gets hosed,      */
/* this REXX will rebuild a new forum index file from all of the the       */
/* messages existing in the forum directory.                               */
/*                                                                         */
/* Upon completion of this REXX, there will be a file called xxxx.CAP      */
/* present in the affected forum directory. The next time you run          */
/* ODN.EXE with the forum ACTIVE, this xxxx.CAP file will be processed     */
/* just as if it had just been captured during a call to delphi.           */
/* Therefore all messages in that forum will show up as being unread.      */
/*                                                                         */
/* Please back up the forum directory prior to running this REXX.          */
/*=========================================================================*/
CRLF=D2C(13)||D2C(10)
If RxFuncQuery('SysLoadFuncs') <> 0 Then
Do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
End
If RxFuncQuery('rexxlibregister') <> 0 Then
Do
  call rxfuncadd 'rexxlibregister', 'rexxlib', 'rexxlibregister'
  call rexxlibregister
End
ForIdx="FORUMS.IDX"
If \ DosIsFile(ForIdx) Then Do; Say "No FORUMS.IDX present."; Exit; End
RC=FileRead(ForIdx,"Line.")

Top:
"@CLS"
Cnt=Line.0 - 1
Do Z=1 to Cnt
  Say Right(" "Z,2)"  "Left(Line.Z,4)"  "SubStr(Line.Z,5,39)
End
Say right(" "Cnt+1,2)"  Exit"
Say ""
RC=Charout(,"Please Enter the number beside the forum you want to rebuild: ")
Pull Num
If DataType(Num) \= "NUM" | Num <1 | Num>Cnt+1 Then Signal Top
If Num=Cnt+1 Then Exit
Say ""
Say "The "Strip(SubStr(Line.Num,5,39))" will be rebuilt."
Say ""
RC=Charout(,"Enter 1 to continue or 2 to Abort: "); Pull Resp
If Resp \=1 Then Signal Top
MyDir=Left(Line.Num,4)
CapFile=MyDir".CAP"
FullName=Directory()"\"MyDir
If \ DosIsDir(FullName) Then
Do
  Say FullName" does not exist. Aborting."
  Exit
End

"@CD "MyDir
L.0=1; L.1="Dummy"; RC=FileWrite(CapFile,"L.")
RC=SysFileTree("*.DB","Matches.")
Do Z=1 to Matches.0
  Emf=Strip(SubStr(Matches.Z,38,255))
  Say "Working on "Emf
  RC=FileRead(Emf,"Line.")
  If Line.4 \= "" Then Line.3=Line.3||CRLF
  Do Y=1 to Line.0
    If Left(Line.Y,3)="-*-" Then
    Do
      Line.Y=Line.Y||CRLF
      Y1=Y+3; Y2=Y1+1
      If Line.Y2 \= "" Then Line.Y1=Line.Y1||CRLF
    End
  End
  RC=FileWrite(CapFile,"Line.","A")
End
"@Erase "MyDir"SUB.IDX"
Say ""
Say "Deleting .DB files. Please wait..."
"@Del *.DB"
