/* ANNOUNCE.CMD - REXX program to generate a File Announcement
with MPBeta for new files. Version 1.31

ver 1.1:  Found an error and in the process of cleaning it up, sped up the
program's execution! Moved the file_desc stuff inside the loop.

ver 1.2:  Added format description routines, most borrowed from Craig
Morrison (Thanks!)

ver 1.21: Added two lines to add back the space between upload counters:
from ( 0) back to (  0). It was stripped out in formatting.

ver 1.3: New MPM_FileAreaSort() and MPM_SaveFilesBBS() functions
incorporated. Thanks, Craig!!

ver 1.31: change in the way I call the areas. Attempt to clean up the code

  - 18 December, 1994 by Elliott Goodman, 1:102/1319 - 805-264-0200
*/

/* check whether RxFuncs are loaded. If not, load them. */       
                                                                 
if RxFuncQuery('SysLoadFuncs') then                              
do                                                               
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs                                        
end                                                              

/* Just to let the user know what's going on.... */

say 'Searching thru file areas for new files to announce.'
say 'Please wait....';
say ' ';


/* create a tracking file */
report = 'd:\lora\file\mpbeta\1anounce.txt'

/* delete old tracking file, if present */
call SysFileDelete(report)

m_txt = 'Report of ANNOUNCE.CMD activity'
call lineout report, m_txt
m_txt = date('U')
call lineout report, m_txt
m_txt = ''
call lineout report, m_txt

/* get today's date, create an index from it */
day_index = SPECIFIED_DATE_IN_DAYS( DATE('U') )                        

/* set some defaults */

nfile.0 = 0
files.0 = 0				/* will increment */
file_index = 0

lmargin = 16         /* how far from the left margin the ED Marker should be */
llength = 45                 /* this is how long each line segment should be */
EDMarker = '>'        /* Set EDMarker to your extended description character */
                                                                               
spaces = SubStr(Copies(' ', 80), 1, lmargin)||EDMarker||' '                    

/* set up the array elements of FILES which will be used by
MPM_AnnounceFiles() at the end of all this processing.
See TANN.CMD included with MPBeta for details.   */

files.msgpath = 'D:\LORA\MSG\USERS'
files.msgtype = 'SQUISH'
files.msgflag = 'CRASH'
files.to = 'ALL'
files.toaddr = '1:102/1316.0'
files.header = 'New files online at Miles Enterprises BBS'
files.from = 'Elliott Goodman'
files.fromaddr = '1:102/1319.0'
files.footer = '- Elliott'

/* your origin info */
files.origin = 'Miles Enterprises * 805-264-0200 *'

/* my first 99 areas are on the CD so I start with 99 (and increment it
immediately.) This saves time since the CD is slow. */
mpmarea = 99

rc = MPM_QueryAreaList('arealist')         
do impm = mpmarea to arealist.0                     

   mpmarea = MPM_QueryArea(mpmarea)	/* look at next area */
   if mpmarea = 'ERROR' then do
      leave				/* this will bail us out */
      end				/* if an error occurs */

/* get drive/subdir of next file area */
   area_path = MPM_QueryAreaInfo(mpmarea, '1')

/* notify user of our progress */
   say area_path ;

/* use SysFileTree here to check for new files */
   call SysFileTree area_path, stuff, 'F'

/* reset before each file area */
   found_new = 0
   nfile.0 = 0

/* assume at least one file in the file area */
   do i = 1 to stuff.0		/* cycle thru files in one area */

/* get info on each file in the area */
   parse var stuff.i,
         file_date,
         file_time,
         file_size,
         file_attr,
         file_name

/* remove trailing space */
   file_name = strip( file_name )

/* remove drive/subdir info from filename */
   parse var file_name (area_path) file_name

/* convert to caps, just in case */
   file_name = translate( file_name )

/* get extention. We don't want to announce FILES.BBS or FILES.BAK! */
   parse var file_name junk '.' extn

   if extn = 'BAK' then do
      iterate
      end

   if extn = 'BBS' then do
      iterate
      end

/* test if next file is dated today, hence NEW */
   file_test = SPECIFIED_DATE_IN_DAYS( file_date )
   if file_test = day_index then do

/* here's where the ver. 1.1 code makes it's major changes. Store the
files that are new and do them all at once for each area */
      found_new = 1
      nfile.0 = nfile.0 + 1
      t_index = nfile.0
      nfile.t_index = file_name
      end /* if file_test = day_index */

   end /* do i = 1 to stuff.0 */

/* now, if we found one or more new files in this area... */
   if found_new = 1 then do

/* we have to open the files.bbs file so we can get the
description */
      retval = MPM_OpenArea(mpmarea)

/* this just gives the system time to open the file */
      Call SysSleep 3

/* ....cycle thru the new files for this area */
      do k = 1 to nfile.0

/* continue storing elements in FILES */
         file_index = file_index + 1
         files.0 = files.0 + 1
         files.file_index.path = area_path
         files.file_index.file = nfile.k

         text = MPM_QueryFileInfo(mpmarea, nfile.k, '3')

/* just in case no description was Tic'd... */
         if text = 'ERROR' then do
            text = '   No Description!'
            end

/* here's where we format the file description!   */

/* Translate all CRs, LFs and Extended Description Markers into spaces */
         ntext = Translate(text, '   ', x2c('0d')||x2c('0a')||EDMarker)                 
         
         text = GetOneLine(llength, ntext)                    
         ntext = Space(DelWord(ntext, 1, Words(text)), 1)     
         Do While Length(ntext) \= 0                          
            wText = GetOneLine(llength, ntext)               
            text = text||x2c('0d')||x2c('0a')||spaces||wText 
            ntext = Space(DelWord(ntext, 1, Words(wText)), 1)
            End

/* the following two lines replace the extra space between
parentesis that was removed: (  0) */
         text = overlay(' ',text,1,1)
         text = '('||text            

         retval = MPM_SetFileInfo(mpmarea, nfile.k, '2', text)

         text = Space(Translate(text, ' ', '>'), 1)
         files.file_index.desc = text
         end /* do k to nfile.0 */

/* New Sort Function!!! New Save files.bbs function! */

   retval = MPM_FileAreaSort(mpmarea, 'Name', 'Asc', 'All') 
   retval = MPM_SaveFilesBBS(mpmarea)                       

/* close the files.bbs file to avoid problems */
      retval = MPM_CloseArea(mpmarea)
      end /* if  found = 1 */

   end /* do impm */

/* if no new files: exit */
if files.0 = 0 then do
   m_txt = 'No new files found'
   call lineout report, m_txt
   exit
   end

/* there are new files. Save the info so we can play
with the descriptions when we wake up <g> */

m_txt = 'List of New Files'
call lineout report, m_txt
m_txt = ' '
call lineout report, m_txt

do j = 1 to files.0
   m_txt = 'File Path = ' files.j.path
   call lineout report, m_txt
   m_txt = 'File Name = ' files.j.file
   call lineout report, m_txt
   m_txt = 'File Description = ' files.j.desc
   call lineout report, m_txt
   m_txt = ' '
   call lineout report, m_txt
   end  

/* actually make the announcement */
retval = MPM_AnnounceFiles('files')

m_txt = files.0 'new files announced!'
call lineout report, m_txt

/* close the report file */
call lineout report

/* and we're done */
exit

/*------------------------------------------------*/                 
/* Convert calendar date to consistent date index                  */
/*------------------------------------------------*/                 
SPECIFIED_DATE_IN_DAYS:                                              
   Procedure                                                         
                                                                     
parse arg,                                                           
   mm '/',                                                           
   dd '/',                                                           
   yy                                                                
                                                                     
days_by_month = '31 28 31 30 31 30 31 31 30 31 30 31'                
current_number_of_days = (yy * 365) + dd                             
do m = 1 while m < mm                                                
   current_number_of_days = current_number_of_days +,                
      WORD( days_by_month, m )                                       
end                                                                  
return current_number_of_days                                        

/*   This subroutine and all format description routines written by
      Craig Morrison, author of MaxFilePM.
    GetOneLine takes a variable length string and returns a blank delimited   
    string that is a substring of inText and is no longer than llen           
    characters.                                                               
                                                                              
    A single word that is longer than llen is simply truncated at llen when it
    would be the only word in a line segment and not wrappable. Its cheesy and
    cheap, but hey, it works.. ;-)                                            
*/                                                                            

GetOneLine:                                        
                                                   
    Parse Arg llen, inText                         
                                                   
    cText = ''                                     
    Do While Length(cText' 'Word(inText, 1)) < llen
        cText = cText' 'Word(inText, 1)            
        inText = DelWord(inText, 1, 1)             
        If inText = '' Then Leave                  
    End                                            
                                                   
    if cText = '' Then Do                          
        cText = Left(inText, llen)                 
    End                                            
                                                   
Return Space(cText, 1)                             
