/*
	life.c
	sample saver module C source file version 1.1
	(C) 1994 Michael Harris
*/

/* changes since version 1.0 are marked with "!!!!!" */
/* some typecasts (PSZ) were added to avoid compiler warnings. they are */
/* not marked as changes */

#define INCL_DOS
#define INCL_DOSERRORS	/* !!!!! this line added since version 1.0 */
#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <process.h>	/* !!!!! this line added since version 1.0 */
#include <time.h>

#include "life.h"


/* ===== preprocessor definitions */

#define MODULEVERSION		0x00010001	/* !!!!! changed */
#define STACKSIZE		32000
#define SAVER_NAME_MAXLEN	32
#define FUNCTION_CONFIGURE	1
#define FUNCTION_STARTSAVER	2
#define FUNCTION_STOPSAVER	3
#define FUNCTION_QUERYNAME	4
#define FUNCTION_QUERYENABLED	5
#define FUNCTION_SETENABLED	6


/* ===== prototypes */

/* !!!!! some of the prototypes changed since version 1.0 */
/* !!!!! following line added since version 1.0 */
void	EXPENTRY SAVER_PROC(int function, HAB _hab, HWND hwndOwner, char *appname, void *buffer);
static	MRESULT EXPENTRY SaverWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
static	MRESULT	EXPENTRY ConfigureDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
#if defined(__IBMC__)
static	void	_Optlink draw_thread(void *args);
static	void	_Optlink priority_thread(void *args);
#elif defined(__BORLANDC__)
static	void	_USERENTRY draw_thread(void *args);
static	void	_USERENTRY priority_thread(void *args);
#else
static	void	draw_thread(void *args);
static	void	priority_thread(void *args);
#endif
static	void	load_configuration_data(void);


/* ===== global data */

static	LONG	screenSizeX = 0;		/* screen size x */
static	LONG	screenSizeY = 0;		/* screen size y */
static	HWND	hwndSaver = NULLHANDLE;		/* saver window handle */
static	HMODULE	hmodDLL = NULLHANDLE;		/* saver module dll handle */
static	char	*application_name;		/* name of ScreenSaver app */
static	TID	tidDraw;			/* drawing-thread ID */
static	HPS	hps;				/* presentation space handle */
static	HAB	hab;				/* anchor block handle */
static	BOOL	low_priority = TRUE;		/* low-priority flag */
static	BOOL	configuration_data_loaded = FALSE; /* config data loaded flag */
static	volatile BOOL stop_draw_thread;		/* stop flag */
static	char	modulename[SAVER_NAME_MAXLEN+1]; /* module name buffer */

static	struct	_configuration_data {
	ULONG	version;
	BOOL	enabled;

        int cell_size;
        int init_density;
        int max_age;
        int color;
        int form;
        int lonely;
        int crowd;
        int birth;

} configuration_data;

#define NUM_FORMS	2
CHAR szForms[NUM_FORMS][9] =		/* Text for configuration dialog */
    {
        "Outline",
        "Solid"
    };

#define NUM_COLORS	15
CHAR szColors[NUM_COLORS][14] =
    {
      "Random",
      "Blue",
      "Red",
      "Light Violet",
      "Light Green",
      "Light Cyan",
      "Yellow",
      "White",
      "Dark Gray",
      "Dark Blue",
      "Dark Red",
      "Violet",
      "Green",
      "Dark Cyan",
      "Dark Yellow"
    };


/* ===== code */

/*
	SAVER_PROC
	This is the entry point into the saver module that is called by
	the ScreenSaver program.
	There should be no reason to alter the code.
	Depending on the requested function, the following tasks
	are performed:
	* call the configuration dialog of the saver module
	* copy the name of the saver module into the supplied buffer
	* tell if the saver module is enabled
	* set the "enabled" state of the saver module
	* start the saver
	* stop the saver
	Note that before any processing is done, module configuration data is
	loaded from the INI-files.
*/
/* !!!!! the function declaration changed since version 1.0 (EXPENTRY added) */
void	EXPENTRY SAVER_PROC(int function, HAB _hab, HWND hwndOwner, char *appname, void *buffer)
{
/* !!!!! the next 4 lines were added since version 1.0 */
#if defined(__BORLANDC__)
	extern ULONG _os2hmod;
	hmodDLL = _os2hmod;
#endif
	hab = _hab;
	application_name = appname;
	/* load all configuration data from INI-file */
	load_configuration_data();
	switch(function){
	case FUNCTION_CONFIGURE:
		/* call the configuration dialog */
		WinDlgBox(HWND_DESKTOP, hwndOwner, ConfigureDlgProc,
		  hmodDLL, IDD_CONFIGURE, application_name);
		return;
	case FUNCTION_STARTSAVER:
		/* start the saver */
		/* get "low priority" state from supplied buffer (BOOL *) */
		low_priority = *((BOOL *)buffer);
		/* random seed */
		srand(WinGetCurrentTime(hab));
		/* query size of screen */
		screenSizeX = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
		screenSizeY = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
		/* register window class for the saver window */
		WinRegisterClass(hab, (PSZ)modulename,
		  (PFNWP)SaverWindowProc, 0, 0);
		/* create the saver window */
		hwndSaver = WinCreateWindow(HWND_DESKTOP, (PSZ)modulename,
		  (PSZ)NULL, WS_VISIBLE, 0, 0, screenSizeX, screenSizeY,
		  HWND_DESKTOP, HWND_TOP, 0, NULL, NULL);
		return;
	case FUNCTION_STOPSAVER:
		/* stop the saver */
		if(hwndSaver != NULLHANDLE){
			/* move saver window to front */
			WinSetWindowPos(hwndSaver, HWND_TOP,
			  0, 0, 0, 0, SWP_ZORDER);
			/* destroy saver window */
			WinDestroyWindow(hwndSaver);
			hwndSaver = NULLHANDLE;
		}
		return;
	case FUNCTION_QUERYNAME:
		/* copy module name to supplied buffer (CHAR *) */
		strcpy(buffer, modulename);
		return;
	case FUNCTION_QUERYENABLED:
		/* copy "enabled" state to supplied buffer (BOOL *) */
		*((BOOL *)buffer) = configuration_data.enabled;
		return;
	case FUNCTION_SETENABLED:
		/* get new "enabled" state from supplied buffer (BOOL *) */
		configuration_data.enabled = *((BOOL *)buffer);
		PrfWriteProfileData(HINI_USER, (PSZ)application_name, (PSZ)modulename, (PSZ)&configuration_data, sizeof(configuration_data));
		return;
	}

	/* illegal function request */
	WinAlarm(HWND_DESKTOP, WA_ERROR);
	return;
}

/* !!!!! the #if and #endif below were added since version 1.0 */
#if !defined(__BORLANDC__)
/*
	_DLL_InitTerm
	This procedure is called at DLL initialization and termination.
	There should be no reason to alter the code.
*/
ULONG	_DLL_InitTerm(HMODULE hmod, ULONG flag)
{
	switch(flag){
	case 0:	/* initializing DLL */
		hmodDLL = hmod;
		return 1;
	case 1: /* terminating DLL */
		return 1;
	default:
		/* return error */
		return 0;
	}
}
#endif

/*
	ConfigureDlgProc
	This is the dialog procedure for the module configuration dialog.
	The dialog contains a check box for enabling/disabling the module
	and two push buttons ("OK" and "Cancel") to close/cancel the dialog.
	This is enough for simple saver modules, but can easily be expanded
	for more saver modules that need more settings.
*/
MRESULT	EXPENTRY ConfigureDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	char	buf[sizeof(modulename)+20];
	static	HWND	hwndEnabled;
        int i;

        static        HWND        hwndCellSize;
        static        HWND        hwndInitDensity;
        static        HWND        hwndMaxAge;
        static        HWND        hwndColor;
        static        HWND        hwndForm;
        static        HWND        hwndLonely;
        static        HWND        hwndCrowd;
        static        HWND        hwndBirth;


	switch(msg){
	case WM_INITDLG:
		/* set titlebar of the dialog window */
		/* to "MODULENAME configuration" */
		strcpy(buf, modulename);
		strcat(buf, " configuration");
		WinSetWindowText(hwnd, (PSZ)buf);

		/* get window handles of the dialog controls */
		/* and set initial state of the controls */
		hwndEnabled = WinWindowFromID(hwnd, IDC_ENABLED);
		WinSendMsg(hwndEnabled, BM_SETCHECK,
		  MPFROMSHORT(configuration_data.enabled), MPVOID);

                hwndCellSize = WinWindowFromID(hwnd, IDC_CELLSIZE);
                WinSendMsg(hwndCellSize, SPBM_SETLIMITS, (MPARAM)CONFIGMAXSIZE, (MPARAM)1);
                WinSendMsg(hwndCellSize, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.cell_size), MPVOID);

                hwndInitDensity = WinWindowFromID(hwnd, IDC_DENSITY);
                WinSendMsg(hwndInitDensity, SPBM_SETLIMITS, (MPARAM)CONFIGMAXDENSITY, (MPARAM)1);
                WinSendMsg(hwndInitDensity, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.init_density), MPVOID);

                hwndMaxAge = WinWindowFromID(hwnd, IDC_MAXAGE);
                WinSendMsg(hwndMaxAge, SPBM_SETLIMITS, (MPARAM)CONFIGMAXAGE, (MPARAM)0);
                WinSendMsg(hwndMaxAge, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.max_age), MPVOID);

                hwndBirth = WinWindowFromID(hwnd, IDC_BIRTH);
                WinSendMsg(hwndBirth, SPBM_SETLIMITS, (MPARAM)CONFIGMAXBIRTH, (MPARAM)0);
                WinSendMsg(hwndBirth, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.birth), MPVOID);

                hwndCrowd = WinWindowFromID(hwnd, IDC_CROWD);
                WinSendMsg(hwndCrowd, SPBM_SETLIMITS, (MPARAM)CONFIGMAXCROWD, (MPARAM)0);
                WinSendMsg(hwndCrowd, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.crowd), MPVOID);

                hwndLonely = WinWindowFromID(hwnd, IDC_LONELY);
                WinSendMsg(hwndLonely, SPBM_SETLIMITS, (MPARAM)CONFIGMAXLONELY, (MPARAM)0);
                WinSendMsg(hwndLonely, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.lonely), MPVOID);

                hwndColor = WinWindowFromID(hwnd, IDC_COLOR);
		for (i=0;i< NUM_COLORS;i++) {
		    (void)WinInsertLboxItem(hwndColor, LIT_END, szColors[i]);
		}
		WinSendMsg(hwndColor,LM_SELECTITEM,MPFROMSHORT(configuration_data.color),MPFROMSHORT(TRUE) );

		hwndForm = WinWindowFromID(hwnd, IDC_FORM);
		for (i=0;i< NUM_FORMS;i++) {
		    (void)WinInsertLboxItem(hwndForm, LIT_END, szForms[i]);
		}
		WinSendMsg(hwndForm,LM_SELECTITEM,MPFROMSHORT(configuration_data.form),MPFROMSHORT(TRUE) );



		/* return FALSE since we did not change the focus */
		return (MRESULT)FALSE;


	case WM_COMMAND:
		switch(SHORT1FROMMP(mp1)){
		case IDC_OK:
			/* OK button was pressed. query the control settings */
			configuration_data.enabled = SHORT1FROMMR(WinSendMsg(hwndEnabled, BM_QUERYCHECK, MPVOID, MPVOID));

			configuration_data.color = WinQueryLboxSelectedItem(hwndColor);
			configuration_data.form = WinQueryLboxSelectedItem(hwndForm);

                        WinSendMsg(hwndCellSize, SPBM_QUERYVALUE, MPFROMP(&configuration_data.cell_size), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                        WinSendMsg(hwndInitDensity, SPBM_QUERYVALUE, MPFROMP(&configuration_data.init_density), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                        WinSendMsg(hwndMaxAge, SPBM_QUERYVALUE, MPFROMP(&configuration_data.max_age), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                        WinSendMsg(hwndLonely, SPBM_QUERYVALUE, MPFROMP(&configuration_data.lonely), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                        WinSendMsg(hwndBirth, SPBM_QUERYVALUE, MPFROMP(&configuration_data.birth), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                        WinSendMsg(hwndCrowd, SPBM_QUERYVALUE, MPFROMP(&configuration_data.crowd), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
                        WinSendMsg(hwndForm, SPBM_QUERYVALUE, MPFROMP(&configuration_data.form), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
			WinSendMsg(hwndColor, SPBM_QUERYVALUE, MPFROMP(&configuration_data.color), MPFROM2SHORT(0, SPBQ_DONOTUPDATE));
			

			/* write all configuration data to INI-file */
			PrfWriteProfileData(HINI_USER, (PSZ)application_name, (PSZ)modulename, (PSZ)&configuration_data, sizeof(configuration_data));
			/* end dialog */
			WinDismissDlg(hwnd, TRUE);
			return (MRESULT)0;
		case IDC_CANCEL:
			/* dialog was cancelled; end it */
			WinDismissDlg(hwnd, FALSE);
			return (MRESULT)0;

			/* Added this command. Resets initial configuration */
		case IDC_SETDEFAULTS :
                        configuration_data.version = MODULEVERSION;
                        configuration_data.enabled = TRUE;

			configuration_data.color = CONFIGDEFAULTCOLOR;
			configuration_data.form = CONFIGDEFAULTFORM;
			configuration_data.birth = CONFIGDEFAULTBIRTH;
			configuration_data.lonely = CONFIGDEFAULTLONELY;
			configuration_data.crowd = CONFIGDEFAULTCROWD;
			configuration_data.cell_size = CONFIGDEFAULTSIZE;
			configuration_data.init_density = CONFIGDEFAULTDENSITY;
			configuration_data.max_age = CONFIGDEFAULTAGE;
			configuration_data.color = CONFIGDEFAULTCOLOR;

			WinSendMsg(hwndCellSize, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.cell_size), MPVOID);
			WinSendMsg(hwndInitDensity, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.init_density), MPVOID);
			WinSendMsg(hwndMaxAge, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.max_age), MPVOID);
			WinSendMsg(hwndBirth, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.birth), MPVOID);
			WinSendMsg(hwndCrowd, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.crowd), MPVOID);
			WinSendMsg(hwndLonely, SPBM_SETCURRENTVALUE, MPFROMSHORT(configuration_data.lonely), MPVOID);
			WinSendMsg(hwndForm,LM_SELECTITEM,MPFROMSHORT(configuration_data.form),MPFROMSHORT(TRUE) );
			WinSendMsg(hwndColor,LM_SELECTITEM,MPFROMSHORT(configuration_data.color),MPFROMSHORT(TRUE) );
			return (MRESULT)0;


		default:
			return (MRESULT)0;
		}
	}
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/*
	SaverWindowProc
	This is the window procedure of the screen-size window that is
	created when the saver starts.
	There should be no reason to alter the code.
	Note that we do not process WM_PAINT messages. They are forwarded to
	the default window procedure, which just validates the window area
	and does no drawing. All drawing to the window should be done in
	the drawing-thread. Therefore, if you want to blank the screen before
	drawing on it for instance, issue a WinFillRect call at the beginning
	of your drawing-thread.
*/
MRESULT EXPENTRY SaverWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	/* !!!!! next line added since version 1.0 */
	static	TID	tidPriority;
	switch(msg){
	case WM_CREATE:
		/* reset the "stop" flag */
		stop_draw_thread = FALSE;
		/* store window handle */
		hwndSaver = hwnd;
		/* get presentation space */
		hps = WinGetPS(hwnd);
		/* start the drawing-thread */
/*
		$$$$$ note $$$$$
		Some compilers use another parameter ordering for
		_beginthread. The _beginthread call below works with EMX,
		ICC and BCC. Check your compiler docs for other compilers.
*/
/* !!!!! code for Borland C++ added since version 1.0 */
#if defined(__BORLANDC__)
		/* for Borland C++ */
		tidDraw = _beginthread(draw_thread, STACKSIZE, NULL);
#elif defined(__EMX__) || defined(__IBMC__)
		/* for EMX and ICC */
		tidDraw = _beginthread(draw_thread, NULL, STACKSIZE, NULL);
#endif

		/* !!!!! next 3 lines added since version 1.0, some code deleted */
		/* create thread to control priority of drawing thread */
		if(low_priority)
			DosCreateThread(&tidPriority, (PFNTHREAD)priority_thread, 0, 2L, 1000);
		return (MRESULT)FALSE;
	case WM_DESTROY:
/* !!!!! most of the code for WM_DESTROY changed since version 1.0 */
		if(low_priority)
			DosKillThread(tidPriority);
		/* tell drawing-thread to stop */
		stop_draw_thread = TRUE;
		if(DosWaitThread(&tidDraw, DCWW_NOWAIT) == ERROR_THREAD_NOT_TERMINATED){
			/* if priority of drawing-thread was set to idle time */
			/* priority, set it back to normal value */
			DosSetPriority(PRTYS_THREAD, PRTYC_REGULAR, PRTYD_MAXIMUM, tidDraw);
			/* wait until drawing-thread has ended */
			DosWaitThread(&tidDraw, DCWW_WAIT);
		}
		/* release the presentation space */
		WinReleasePS(hps);
		break;
	case WM_PAINT:
		/* just validate the update area. all drawing is done */
		/* in the drawing-thread. */
		return WinDefWindowProc(hwnd, msg, mp1, mp2);
	}
	return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

/* !!!!! the following function was added since version 1.0 */
/*
	priority_thread
	This thread controls the priority of the drawing thread.
	With these changes, if a saver module runs on low priority (this is
	the default setting), it rises to normal priority twice a second
	for 0.1 seconds. This should solve the problem that, when very
	time-consuming processes were running, the module seemed not to become
	active at all (in fact it became active, but did not get enough CPU
	time to do its saver action).
	There should be no reason to alter the code.
*/
void	priority_thread(void *args)
{
	DosSetPriority(PRTYS_THREAD, PRTYC_TIMECRITICAL, 0, 0);
	for(;;){
		DosSetPriority(PRTYS_THREAD, PRTYC_REGULAR, 0, tidDraw);
		DosSleep(100);
		DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, 0, tidDraw);
		DosSleep(400);
	}
}

/*
	load_configuration_data
	Load all module configuration data from the INI-file into the
	configuration_data structure, if not done already loaded.
*/
void	load_configuration_data(void)
{
	if(configuration_data_loaded == FALSE){
		/* data not loaded yet */
		ULONG	size;
		BOOL	fSuccess;
		/* get name of the saver module (stored as resource string) */
		if(WinLoadString(hab, hmodDLL, IDS_MODULENAME,
		  SAVER_NAME_MAXLEN, (PSZ)modulename) == 0){
			/* resource string not found. indicate error by */
			/* setting module name to empty string (the name */
			/* "" is interpreted as an error by SSDLL.DLL and */
			/* the module does not show up in the list box). */
			strcpy(modulename, "");
			return;
		}
		/* load data from INI-file. the key name is the name of the */
		/* saver module */
		size = sizeof(configuration_data);
		fSuccess = PrfQueryProfileData(HINI_USER,
		  (PSZ)application_name, (PSZ)modulename,
		  (PSZ)&configuration_data, &size);
		if(!fSuccess || size != sizeof(configuration_data) || configuration_data.version != MODULEVERSION){
			/* if entry is not found or entry has invalid size or */
			/* entry has wrong version number, create a new entry */
			/* with default values and write it to the INI-file */
			configuration_data.version = MODULEVERSION;
			configuration_data.enabled = TRUE;

			configuration_data.color = CONFIGDEFAULTCOLOR;
			configuration_data.form = CONFIGDEFAULTFORM;
			configuration_data.birth = CONFIGDEFAULTBIRTH;
			configuration_data.lonely = CONFIGDEFAULTLONELY;
			configuration_data.crowd = CONFIGDEFAULTCROWD;
			configuration_data.cell_size = CONFIGDEFAULTSIZE;
			configuration_data.init_density = CONFIGDEFAULTDENSITY;
			configuration_data.max_age = CONFIGDEFAULTAGE;

			PrfWriteProfileData(HINI_USER, (PSZ)application_name, (PSZ)modulename, (PSZ)&configuration_data, sizeof(configuration_data));
		}
		configuration_data_loaded = TRUE;
	}
}

/*
 *  All of the remainder is code specific to the game, less the drawing thread.
 */

#define TRUE         1
#define FALSE        0

typedef unsigned char   bool;
typedef int 		gen_type;  /* a generation is a number */


int GridSizeX, GridSizeY;	/* Size of grid, not screen */

typedef struct _cell {

    gen_type birthday;		/* Generation cell was born or died. A 
				   positive number in this field means the cell
				   was born in tat generation. If the number
				   is negative, the cell died in the generation
				*/
    gen_type visited;		/* Time stamp for visiting cells. Performance
				   is boosted by not visiting cells more than
				   once to determine if they should live or die
				*/
} cell;	

cell *grid;			/* The grid of cells */

typedef struct _change {	/* When the generation is processed to 
				   determine which cells should live or die,
				   we only track of the CHANGES made to the
				   grid in order to avoid checking cells and
				   their neighbors that are in a "stable" 
				   state 
				*/
				   
        short x;		/* Grid coordinates */
        short y;
} change;


				/* This is the queue of changes made to
				   the grid in the "last" generation. Each
				   generation, the queue is (1) emptied to 
				   see how changes made in the previous 
				   generation affect the cells surrounding
				   those changes and (2) filled with the 
				   changes which result from those previous 
				   changes. If you watch the saver a while
				   with a small grid size you will see how
				   this works.
				*/
change *changes; int change_head, change_tail, change_cnt; /* The queue */



/* Time stamp the cell so we can avoid visiting it twice in one generation */
inline void set_visited(int x, int y, gen_type g)
{ (grid + y * GridSizeX + x)->visited = g; }


/* Check whether cell has been visited in generation "g" */
inline bool visited(int x, int y, gen_type g)
{ return( (grid + y * GridSizeX + x)->visited == g); }


/* Enter a coordinate pair into the change queue */
inline void add_change(int x, int y)
{
    changes[change_tail].x = x;
    changes[change_tail].y = y;

    change_tail = ++change_tail % (GridSizeX * GridSizeY);
    change_cnt++;
}

/* Dequeue a change into the parameters */
inline void get_change(int *x, int *y)
{
    if (change_cnt <= 0) return;

    *x = changes[change_head].x;
    *y = changes[change_head].y;

    change_head = ++change_head % (GridSizeX * GridSizeY);
    change_cnt--;
}


/* Check how many changes are in the queue */
inline int num_change() { return(change_cnt); }


/* Determine if a cell is alive/dead in the generation g. We need the parameter
 * g to check whether the cell has been toggled in that generation. If the
 * cell's status has switched in generation g we report the opposite of the 
 * cells observed state. (see below)
*/
inline bool get_cell(int x, int y, gen_type g)
{
    gen_type tmp;

    tmp = (grid + y * GridSizeX + x)->birthday;

    if (abs(tmp) < g ) return(tmp > 0);		/* The cell's living status
						 * has been set before this
						 * generation.
						*/
    return( tmp < 0);				/* The cell has been toggled
    						 * in this generation. report
    						 * the opposite of its status: 
    						 * (if the cell has been set
    						 *  to alive this generation
    						 *  it must have been dead in
    						 *  a previous generation 
    						 *  with the algorithm we are
    						 *  using.
    						 */
}

/* Report the time since the cell was last toggled dead or alive */
inline gen_type age_cell(int x, int y, gen_type today)
{
    gen_type tmp;

    tmp = (grid + y * GridSizeX + x)->birthday;

    if (tmp > 0) return(today - tmp);

    return(0);
}

/* Set a cell to dead or alive. A negative birthday means the cell died in
 * the generation.
*/
inline void set_cell(int x, int y, gen_type birthday)
{ (grid + y * GridSizeX + x)->birthday = birthday; }

/* Count the living neighbors around the cell. */
inline int num_neighbors(int x, int y, gen_type max_age)
{
    int i,j, cnt = 0;

    for (i=x-1;i<=x+1;i++) { if ((i <0) || (i >= GridSizeX)) continue;
        for (j=y-1;j<=y+1;j++) { if ((j < 0) || (j >= GridSizeY)) continue;

            if (get_cell(i,j,max_age)) cnt++;
        }
    }

    if (cnt && get_cell(x,y,max_age)) cnt--;	/* Dont count the cell at x,y*/

    return(cnt);
}


/* Allocate memory for a grid size x*y if we havn't already and mark the cells 
 * as having died in generation zero.
*/
inline void init_grid(int x, int y)
{
    int i,j;

    if (! grid) {
        grid = (cell *) malloc( (x * y) * sizeof(cell) );
            if (! grid) { fprintf(stderr, "malloc failure\n"); exit(1); }

        changes = (change *) malloc( (x * y) * sizeof(change));
            if (! changes) { fprintf(stderr, "malloc failure\n"); exit(1); }
    }

    for (i=0; i < x; i++) for (j=0; j < y; j++) {
        (grid + (j * GridSizeX) + i)->birthday = 0;
        (grid + (j * GridSizeX) + i)->visited = 0;
    }

    change_head = change_tail = change_cnt = 0;	/* Empty the queue */
}


int draw_color;		/* Cell drawing color */
int draw_style;		/* Cell form, either outlined or filled */
int CellSize;		/* The size in pels of a cell */

/* Show a cell as either dead or alive */
inline void show_cell(int x, int y, bool cond)
{
    static RECTL r;

    r.xLeft =   (CellSize + 1) * x;
    r.yBottom = (CellSize + 1) * y;
    r.yTop = r.yBottom + CellSize - 1;
    r.xRight = r.xLeft + CellSize - 1;

    if (cond) GpiSetColor(hps, draw_color);
    else GpiSetColor(hps, CLR_BLACK);

    GpiMove(hps, (PPOINTL)&r);
    GpiBox(hps, draw_style, (PPOINTL)&r.xRight, 0,0);
}


void        draw_thread(void *args)
{
    int init_density;			/* These are documented as used */
    int i,j, x, y, cx, cy;
    bool activity;
    int cnt, changes_last_gen;
    int neighbor_cnt;
    bool ij_living;
    bool random_color;
    gen_type gen_number;
    unsigned short crowd;
    unsigned short lonely;
    unsigned short birth;
    int Iteration_Limit;
    gen_type max_age;
    RECTL    ScreenSize;



    WinQueryWindowRect( hwndSaver, &ScreenSize );

    CellSize = 		configuration_data.cell_size;
    max_age = 		configuration_data.max_age;
    init_density = 	configuration_data.init_density;
    crowd = 		configuration_data.crowd;
    birth = 		configuration_data.birth;
    lonely = 		configuration_data.lonely;
    random_color = 	configuration_data.color == 0;
    draw_color = 	configuration_data.color;

    switch (configuration_data.form) {
	case 1: draw_style = DRO_FILL; break;
	case 0: draw_style = DRO_OUTLINE;
        default:  break;
    }



    /* Set the grid size to accomidate the cells with blank lines between */
    GridSizeX = (screenSizeX -1) / (CellSize +1);
    GridSizeY = (screenSizeY -1) / (CellSize +1);

    srand(time(0) % 1000);	/* Randomize */

    Iteration_Limit = 50000;	/* Seems like enough */


    while (! stop_draw_thread) {

        WinFillRect( hps, &ScreenSize, CLR_BLACK );

        if (random_color) draw_color = rand() % 14 + 1;		/* pick color */
        if (draw_color == CLR_NEUTRAL) draw_color = CLR_WHITE;

        init_grid(GridSizeX, GridSizeY);	/* initialize grid */

        /* Set up and draw initial grid */
        for (x=0;(x<GridSizeX) && ! stop_draw_thread;x++)                        /* INITIALIZE RANDOMLY */
            for (y=0;(y < GridSizeY) && ! stop_draw_thread;y++) {

                if ( (init_density - (rand() % 100)) > 0 ) {
                    set_cell(x,y, 1);
                    add_change(x,y);
                    show_cell(x,y,TRUE);

                }
                set_visited(x, y, 0);
            }



        gen_number= 2;		/* The grid has been initialized as gen one */
        activity = TRUE;	/* Flag to make sure changes are being made
        			 * to the grid. Quit when the grid stabilizes
        			*/

        while ((gen_number<Iteration_Limit) && activity && !stop_draw_thread){


            activity = FALSE;			/* Assume no activity */
            /* see how many changes were made in last generation and process
             * only those. We need this value because we add changes to the 
             * queue for the current generation while "simultaneously"
             * processing those of the last.
            */
            changes_last_gen = num_change();


            for (cnt = 0; (cnt < changes_last_gen) && !stop_draw_thread;cnt++) {

                get_change(&cx, &cy);

                for (i=cx-1; i <= cx + 1; i++){
                for (j=cy-1; j <= cy + 1; j++){

                    /* comtinue if off grid or already visited in this generation*/
                    if ((i<0) || (i>=GridSizeX) || (j<0) || (j>=GridSizeY) || visited(i,j, gen_number)) continue;

                    set_visited(i,j, gen_number); /* Mark this cell as visited */


                    /* See how many neighbors the cell has and whether it is
                     * living or not 
                    */
                    neighbor_cnt = num_neighbors(i,j, gen_number);
                    ij_living = get_cell(i,j, gen_number);


                      /* See if this dead cell should be born */
                    if ( ! ij_living && (neighbor_cnt == birth) ) {
                        show_cell(i,j,TRUE);
                        set_cell(i,j,gen_number);
                        add_change(i,j);
                        activity = TRUE;
                    }

                      /* See if this living cell should die */
                    else if (ij_living && ((neighbor_cnt > crowd) || (neighbor_cnt < lonely) || (max_age && (age_cell(i,j, gen_number) > max_age))) ){
                        show_cell(i,j,FALSE);
                        set_cell(i,j,0 - gen_number);
                        add_change(i,j);
                        activity = TRUE;
                    }

                }} /* VISIT EVERY CELL AROUND CHANGE */

            } /* CHECK ALL CHANGES */

            ++gen_number;	/* Move on to next generation */

            /* If grid has stabilized pause for a bitter last look */
            if (! activity && ! stop_draw_thread) DosSleep(1000);

            if(! low_priority ) DosSleep(1); /* Give the other guys a break */

        } /* ITERATION LIMIT AND ACTIVITY */
    } /* WHILE DRAW THREAD */

    free(grid); free(changes);

}
