/* Entertainment Pack for OS/2 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing Entertainment Pack for OS/2...'
Say ''
Result = SysFileTree( 'BG.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BG.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BG.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BG.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'FOUR.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: FOUR.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'FOUR.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: FOUR.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'MASTER.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: MASTER.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'MASTER.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: MASTER.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'OTHELLO.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: OTHELLO.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'OTHELLO.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: OTHELLO.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'PEGGED.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PEGGED.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'PEGGED.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PEGGED.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'TIC.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: TIC.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'TIC.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: TIC.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'GALAXY.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: GALAXY.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'GALAXY.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: GALAXY.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'LICENSE.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: LICENSE.TXT not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'ENTRTAIN.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: ENTRTAIN.DOC not found! Installation cancelled.'
  Signal DONE
  End
Say 'Please enter the full name of the directory to which you want'
Say 'the Entertainment Pack for OS/2 installed (default C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory. Installation cancelled.'
    Signal DONE
    End
  End
Say ''
Say 'The program objects will be placed in the Games folder...'
Folder = '<WP_GAMES>'
Say ''
Say 'Copying BG.EXE to' Directory '...'
Copy BG.EXE Directory                  '1>NUL'
Say 'Copying BG.HLP to' Directory '...'
Copy BG.HLP Directory                  '1>NUL'
Say 'Copying FOUR.EXE to' Directory '...'
Copy FOUR.EXE Directory                  '1>NUL'
Say 'Copying FOUR.HLP to' Directory '...'
Copy FOUR.HLP Directory                  '1>NUL'
Say 'Copying MASTER.EXE to' Directory '...'
Copy MASTER.EXE Directory                  '1>NUL'
Say 'Copying MASTER.HLP to' Directory '...'
Copy MASTER.HLP Directory                  '1>NUL'
Say 'Copying OTHELLO.EXE to' Directory '...'
Copy OTHELLO.EXE Directory                  '1>NUL'
Say 'Copying OTHELLO.HLP to' Directory '...'
Copy OTHELLO.HLP Directory                  '1>NUL'
Say 'Copying PEGGED.EXE to' Directory '...'
Copy PEGGED.EXE Directory                  '1>NUL'
Say 'Copying PEGGED.HLP to' Directory '...'
Copy PEGGED.HLP Directory                  '1>NUL'
Say 'Copying TIC.EXE to' Directory '...'
Copy TIC.EXE Directory                  '1>NUL'
Say 'Copying TIC.HLP to' Directory '...'
Copy TIC.HLP Directory                  '1>NUL'
Say 'Copying GALAXY.EXE to' Directory '...'
Copy GALAXY.EXE Directory                  '1>NUL'
Say 'Copying GALAXY.HLP to' Directory '...'
Copy GALAXY.HLP Directory                  '1>NUL'
Say 'Copying LICENSE.TXT to' Directory '...'
Copy LICENSE.TXT Directory                  '1>NUL'
Say 'Copying ENTRTAIN.DOC to' Directory '...'
Copy ENTRTAIN.DOC Directory                  '1>NUL'
Say ''
Say 'Creating program objects...'
Say ''
Type = 'WPProgram'
Title = 'Backgammon'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\BG.EXE;STARTUPDIR='Directory';OBJECTID=<BG>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Title = 'Connect Four'
  Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\FOUR.EXE;STARTUPDIR='Directory';OBJECTID=<FOUR>;NOPRINT=YES;'
  Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
  If Result = 1 Then
    Title = 'Master Mind'
    Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MASTER.EXE;STARTUPDIR='Directory';OBJECTID=<MASTER>;NOPRINT=YES;'
    Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
    If Result = 1 Then
      Title = 'Othello'
      Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\OTHELLO.EXE;STARTUPDIR='Directory';OBJECTID=<OTHELLO>;NOPRINT=YES;'
      Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
      If Result = 1 Then
        Title = 'Pegged'
        Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\PEGGED.EXE;STARTUPDIR='Directory';OBJECTID=<PEGGED>;NOPRINT=YES;'
        Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
        If Result = 1 Then
          Title = 'Tic Tac Toe'
          Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\TIC.EXE;STARTUPDIR='Directory';OBJECTID=<TIC>;NOPRINT=YES;'
          Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
          If Result = 1 Then
            Title = 'Galaxy'
            Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\GALAXY.EXE;STARTUPDIR='Directory';OBJECTID=<GALAXY>;NOPRINT=YES;'
            Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
            If Result = 1 Then
              E ENTRTAIN.DOC '1>NUL'
              Say 'The Entertainment Pack for OS/2 was successfully installed.'
              Exit

Say 'ERROR: Unable to create objects. Installation cancelled.'
Exit

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Installation error.'
Signal DONE
DONE:
Exit
