;;; emx-bc.el --- byte-compile files for emx

;; Copyright (C) 1993, 1994 Eberhard Mattes

;; Author: Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
;; Keywords: emx

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Code:

(setq purify-flag nil)
(setq max-lisp-eval-depth 400)
(load "subr")
(load "version")
(load "loaddefs")
(load "files")
(load "text-mode")
(load "lisp-mode")
(load "paragraphs")
(load "isearch")			; required by emx-patch
(load "emx-patch")
(load "bytecomp")

(setq default-directory (expand-file-name "../lisp/"))

(byte-compile-file "emx-patch.el")
(byte-compile-file "emx-funcs.el")
(byte-compile-file "emx-cmd.el")
(byte-compile-file "os2help.el")
(byte-compile-file "startup.el")
(byte-compile-file "files.el")
(byte-compile-file "faces.el")
(byte-compile-file "frame.el")
(byte-compile-file "mouse.el")
(byte-compile-file "compile.el")
(byte-compile-file "gud.el")
(byte-compile-file "info.el")
(byte-compile-file "dired.el")
(byte-compile-file "server.el")
(byte-compile-file "vc.el")
(byte-compile-file "hexl.el")
(byte-compile-file "menu-bar.el")
(byte-compile-file "cp850acc.el")
(byte-compile-file "linedraw.el")
(byte-compile-file "term/pm-win.el")

(kill-emacs)

;;; emx-bc.el ends here
