/* automail in rexx version 2 by ken */

parse arg cline.1 cline.2 cline.3 cline.4 cline.5 cline.6

if cline.1 = '' then call help
if cline.2 = '' then call help

CFG = cline.1
OUTBOUND = cline.2
total_x_size = 0
'echo off'

do while lines(CFG)
   parse value linein(CFG) with netnode maxsize;
   if (left(netnode, 1) = ';' ) then nop
   else do
           flo_name = node_to_flo(netnode)
           current_flo = OUTBOUND'\'flo_name'.hlo'
           if ( stream(current_flo, 'c', 'query exists')  = "" )
             then do
                     say netnode 'has no HLO file in' OUTBOUND
                     iterate
                  end
           else do while lines(OUTBOUND'\'flo_name'.hlo')
                   x = linein(OUTBOUND'\'flo_name'.hlo')
                   y = substr(x, pos(':\',x) - 1)
                   size_y = stream(y,'c','query size')
                   total_x_size = total_x_size + size_y
                 end
           if total_x_size > maxsize
           then do
               'type' OUTBOUND'\'flo_name'.hlo' '>>' OUTBOUND'\'flo_name'.clo'
               call stream OUTBOUND'\'flo_name'.hlo','c','close'

                'del' OUTBOUND'\'flo_name'.hlo'
                  say netnode ' packet now crash '
                end
           else say netnode 'packet still on hold'
         end
end

exit

node_to_flo: arg
node = arg(1)
temp1 = substr(node,1,(pos('/',node)-1))
temp2 = substr(node,(pos('/',node)+1))
_temp1 = right( d2x(temp1) , 4, '0')
_temp2 = right( d2x(temp2) , 4, '0')
result = insert(_temp1,_temp2)
return result


help:
say
say 'CloMail.CMD'  '(c)Ken Kavanagh 1994'
say
say '  Used to change the flavour of mail put on hold so that when a FLO'
say 'file contains greater than x bytes (as configured in CloMail.CFG)'
say 'a HLO file will be renamed to CLO'
say
say 'I find it handy in reducing the number of outbound calls at least until'
say 'there is some hefty amount of mail to deliver :)'
say
say 'USAGE:'
say '           CloMail <d:\path\CloMail.cfg> [d:\<outbound>]'
say
exit (1)
