EXTPROC CEnvi
/*********************************************************
 *** WinSet.cmd - CEnvi program to position, maximize, ***
 *** ver.4        or hide a window, etc...             ***
 *********************************************************/

#include <PMdll.lib>
#include <WinTools.lib>
#include <WinMsg.lib>

#define  NO_ERROR          0     // return code from most successful DosCalls

// Initialize an array of Commands, their functions, and how many extra
// arguments they require
commands = { { "MIN",      "MyMinimizeWindow",     "0" },
             { "MAX",      "MyMaximizeWindow",     "0" },
             { "RESTORE",  "MyRestoreWindow",      "0" },
             { "HIDE",     "MyHideWindow",         "0" },
             { "SHOW",     "MyShowWindow",         "0" },
             { "ACTIVE",   "MyActivateWindow",     "0" },
             { "INACTIVE", "MyInactivateWindow",   "0" },
             { "CLOSE",    "MyClose",              "0" },
             { "SIZE",     "MySizeWindow",         "2" },
             { "MOVE",     "MyMoveWindow",         "2" },
             { "BIGGEST",  "MakeBiggestWindow",    "0" } };

main(argc,argv)
{
   if ( argc < 3  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") ) {
      Instructions();
   } else {
      if ( !strcmp(argv[1],"@") )
         lHwnd = Info().WinHandle;
      else
         lHwnd = GetHwnd(argv[1]);
      if ( lHwnd ) {
         if ( argc == 4  &&  !stricmp(argv[2],"TITLE") ) {
            SetWindowTitle(lHwnd,argv[3]);
         } else {
            // find the command in list of commands we know
            for ( i = GetArraySpan(commands); 0 <= i; i-- ) {
               command = commands[i];
               if ( !stricmp(argv[2],commands[i][0]) )
                  break;
            }
            if ( i < 0  ||  argc != 3 + (ArgCount = atoi(command[2])) ) {
               Instructions();
            } else {
               // send command to window
               function(command[1],lHwnd,
                        argv[3],argv[4],argv[5],argv[6],argv[7]);
            }
         }
      }
   }
}

Instructions()
{
   puts("\a")
   puts(`WinSet - Tell a window where to go`)
   puts(``)
   puts(`SYNTAX: WinSet Title MIN`)
   puts(`        WinSet Title MAX`)
   puts(`        WinSet Title HIDE`)
   puts(`        WinSet Title SHOW`)
   puts(`        WinSet Title RESTORE`)
   puts(`        WinSet Title BIGGEST`)
   puts(`        WinSet Title ACTIVE`)
   puts(`        WinSet Title INACTIVE`)
   puts(`        WinSet Title CLOSE`)
   puts(`        WinSet Title SIZE Width Height`)
   puts(`        WinSet Title MOVE [r]Column [t]Row`)
   puts(`        WinSet Title TITLE NewTitle`)
   puts(``)
   puts(`   Where: Title - All or partial name of a Window.`)
   puts(`          If title is @ (at) then window is this window.`)
   puts(`          r - preceding Column with r relative to right edges`)
   puts(`          t - preceding Row with t relative to top edges`)
   puts(``)
   puts(`EXAMPLE: WinSet "OS/2 Window" MOVE 300 200`)
   puts(`         WinSet "Drive C" TITLE "Boot Drive"`)
   puts(`         WinSet E.EXE move r10 t0`)
   puts(`         WinSet @ ACTIVE`)
   puts(``)
}

MyMinimizeWindow(pHwnd)
{
   ShowWindow(pHwnd,SW_MINIMIZE);
}

MyMaximizeWindow(pHwnd)
{
   ShowWindow(pHwnd,SW_SHOWMAXNOACTIVE);
}

MyHideWindow(pHwnd)
{
   ShowWindow(pHwnd,SW_HIDE);
}

MyShowWindow(pHwnd)
{
   ShowWindow(pHwnd,SW_SHOWNOACTIVATE);
}

MyRestoreWindow(pHwnd)
{
   ShowWindow(pHwnd,SW_RESTORENOACTIVE);
}

MySizeWindow(pHwnd,pWidth,pHeight)
{
   SetSize(pHwnd,atoi(pWidth),atoi(pHeight));
}

MyMoveWindow(pHwnd,pColumn,pRow)
{
   GetScreenSize(ScreenWidth,ScreenHeight);
   GetSize(pHwnd,lWidth,lHeight);
   if ( 'r' == tolower(pColumn[0]) ) {
      // move relative to right edges
      lColumn = ScreenWidth - atoi(pColumn+1) - lWidth;
   } else
      lColumn = atoi(pColumn);
   if ( 't' == tolower(pRow[0]) ) {
      // move relative to top edges
      lRow = ScreenHeight - atoi(pRow+1) - lHeight;
   } else
      lRow = atoi(pRow);
   SetPosition(pHwnd,lColumn,lRow);
}

MyActivateWindow(pHwnd)
{
   SetActiveWindow(pHwnd);
}

MyInactivateWindow(pHwnd)
{
   SetWindowPos(pHwnd,0,0,0,0,0,SWP_DEACTIVATE);
}

MyClose(pHwnd)
{
   #define WM_CLOSE  0x0029
   #define WM_QUIT   0x002a
   WinPostMsg(pHwnd,WM_CLOSE,0,0,False);
   return(TRUE);
}

MakeBiggestWindow(pHwnd)
{
   ShowWindow(pHwnd,SW_SHOWMAXNOACTIVE);
   // get maximized size, then restore but at maximum size
   GetWindowRect(pHwnd,rect);
   ShowWindow(pHwnd,SW_RESTORENOACTIVE);
   SetWindowRect(pHwnd,rect);
}

GetHwnd(pWinSpec)
{
   // Try to find window handle, look for exact match first and then
   // partial match if exact not found.  Return 0 if problem.
   if ( !(lHwnd = GetWindowHandle(pWinSpec,True)) )
      lHwnd = GetWindowHandle(pWinSpec);
   return lHwnd;
}

