EXTPROC CEnvi
//****************************************************************
//*** TempFldr.cmd - CEnvi script to open a folder and keep it ***
//*** ver.3          open only as long as it is the active     ***
//***                window.                                   ***
//****************************************************************

#include <PMdll.lib>
#include <WinTools.lib>
#include <WinMsg.lib>

// define how many milliseconds to wait between each check to see
// when the folder no longer has the focus
#define WAIT_BETWEEN_CHECKS  1000

// define how long between checks for new window when the
// folder is starting up, and how many times to look for it
#define DELAY_LOOK_FOR_FOLDER 400   // milliseconds
#define LOOK_FOR_FOLDER_COUNT 25

// #define the type of view the opened windows should have.
// note that DEFAULT won't work if you set this as the
// default action for a folder.  So remove comment from ONLY
// ONE of the following
#define OPEN_MODE "ICON"
// #define OPEN_MODE "TREE"
// #define OPEN_MODE "DETAILS"
// #define OPEN_MODE "DEFAULT"

// Check if ESCAPE key was pressed when this is invoked
#define VK_ESC 0x0F
EscapePressed = KeyPressed(VK_ESC);

main(argc,argv)
{
   if ( argc != 2 )
      Instructions();

   // Hide this TempFldr window because it's in the way.  If you
   // don't want to bother to hide it then comment-out the
   // following line
   ShowWindow(Info().WinHandle,SW_HIDE);

   // build list of existing windows, to find the new one
   WindowList = BuildWindowList();

   // Open the folder
   StartFolderObject(argv[1]);

   // Get the handle of the new folder
   FolderWindowHandle = GetNewWindowHandle(WindowList);

   // Give this new window the active focus
   if ( FolderWindowHandle != GetActiveWindow() )
      SetActiveWindow(FolderWindowHandle);

   // If escape was pressed, then just keep standard folder
   // behavior, and so exit now
   if ( EscapePressed )
      exit(EXIT_SUCCESS);

   // Wait until this folder no longer has the focus, and
   // then close it
   while ( FolderWindowHandle == GetActiveWindow() )
      suspend(WAIT_BETWEEN_CHECKS);

   #define WM_CLOSE  0x0029
   WinPostMsg(FolderWindowHandle,WM_CLOSE,0,0,False);

   return(EXIT_SUCCESS);
}

Instructions()
{
   printf("\a\n")
   printf("TempFldr - Open a temporary folder\n")
   printf("\n")
   printf("SYNTAX: TempFldr <FolderName>\n");
   printf("\n");
   printf("USAGE: Use TempFldr to open a folder that will\n")
   printf("       automatically close when it no longer\n")
   printf("       has focus. If ESCAPE is pressed while\n")
   printf("       the folder is opened then will open as\n")
   printf("       a regular folder.\n")
   printf("\n")
   printf("       Edit TempFldr.cmd to change settings to\n")
   printf("       your liking. /BIND to make it work faster.\n")
   printf("\n")
   exit(EXIT_FAILURE);
}

StartFolderObject(FolderName)
{
   lSetupString = "OPEN=" OPEN_MODE ";"
   if ( !(lObject = WinQueryObject(FolderName)) ) {
      printf("Error: can't find \"%s\"\a\a\n",FolderName);
      exit(EXIT_FAILURE);
   }
   if ( !WinSetObjectData(lObject,lSetupString) ) {
      printf("Error: can't open \"%s\"\a\a\n",FolderName);
      exit(EXIT_FAILURE);
   }
}

BuildWindowList() // return array of existing window handles
{
   lCount = 0;
   lEnum = WinBeginEnumWindows(HWND_DESKTOP);
   while ( lChild = WinGetNextWindow(lEnum) )
      lWindowArray[lCount++] = lChild;
   WinEndEnumWindows(lEnum);
   return lWindowArray;
}

GetNewWindowHandle(pOldHandles)
{
   lOldHandleCount = 1 + GetArraySpan(pOldHandles);
   for ( i = 0; i < LOOK_FOR_FOLDER_COUNT; i++ ) {
      lEnum = WinBeginEnumWindows(HWND_DESKTOP);
      while ( lChild = WinGetNextWindow(lEnum) ) {
         for ( lOldIdx = 0; lOldIdx < lOldHandleCount; lOldIdx++ ) {
            if ( lChild == pOldHandles[lOldIdx] )
               break;
         }
         if ( lOldIdx == lOldHandleCount
           && lChild != PMInfo().WinHandle ) {
            WinEndEnumWindows(lEnum);
            return(lChild);
         }
      }
      suspend(DELAY_LOOK_FOR_FOLDER);
   }

   // didn't find the folder
   printf("\aCould not find folder\a\n");
   exit(EXIT_FAILURE);
}

KeyPressed(pKey)  // return boolen TRUE if keypressed now, else FALSE
{
   #define ORD_WIN32SETKEYBOARDSTATETABLE   921
   _table[255] = '\0';   // initialize 256-byte key table
   DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
               HWND_DESKTOP,_table,FALSE);
   return( 0x80 & _table[pKey] );
}

