@echo OFF
REM *****************************************************************
REM *** OS2Wait.bat - Wait (approximately) specified milliseconds ***
REM *** ver.1         and give up processor timeslices (as much   ***
REM ***               as reasonable) during that time.            ***
REM *****************************************************************
CEnvi %0.bat %1 %2
GOTO CENVI_EXIT

Instructions()
{
   puts("\a")
   puts(`OS2Wait - Wait specified millisecond count in DOS VDM under OS/2`)
   puts(``)
   puts(`SYNTAX: OS2Wait <MilliSeconds>`)
   puts(``)
   puts(`WHERE: MilliSeconds: Time to wait, approximately in milliseconds,`)
   puts(`                     where 1000 is equal to 1 second`)
   puts(``)
   exit(EXIT_FAILURE);
}

main(argc,argv)
{
   if ( argc != 2  ||  (WaitTime = atoi(argv[1])) < 1 )
      Instructions();

   Dos_DosSuspend(WaitTime);
}


Dos_DosSuspend(pMilliSecondWait)
{
   lMicroSecond = pMilliSecondWait * 1000;
   reg.ah = 0x86;
   reg.cx = (lMicroSecond >> 16) & 0xFFFF;
   reg.dx = lMicroSecond & 0xFFFF;
   interrupt(0x15,reg);
}

:CENVI_EXIT
