@echo off
REM ********************************************************
REM *** OS2.bat - Just like OS/2's command, except       ***
REM *** ver.1     runs from a DOS VDM under OS/2.        ***
REM ***           This batch file requires CEnvi for DOS ***
REM ********************************************************

REM **************************************************************
REM *** Build an environment variable to hold all of the input ***
REM *** parameters so they can all be passed to the OS/2       ***
REM *** command in the same way they appear here               ***
REM **************************************************************
SET OS2PARM=
:PARM_LOOP
   SET OS2PARM=%OS2PARM% %1
   SHIFT
   IF NOT "%1" == "" GOTO PARM_LOOP

REM **************************************************
REM *** THE FOLLOWING IS CENVI CODE TO EXECUTE DOS ***
REM *** INTERRUPT FOR STARTING AN OS2 SESSION      ***
REM **************************************************
CENVI OS2.BAT
GOTO CENVI_EXIT

main()
{
   if !defined(OS2PARM)
      Instructions();
   else {
      if ( defined(DELDIR) ) {
         // keep temporary files from wasting time
         strcpy(RememberDelDir,DELDIR);
         undefine(DELDIR);
      }
      OS2Command(OS2PARM);
      if ( defined(RememberDelDir) )
         DELDIR = RememberDelDir;
   }
}

Instructions()
{
   puts("\a")
   puts(``)
   puts(`OS2.BAT - EXECUTE OS/2 COMMAND FROM A DOS SESSION`)
   puts(``)
   puts(`SYNTAX: OS2 [SEE] Command [parameters]`)
   puts(``)
   puts(`WHERE:`)
   puts(`  SEE - Wait for command to finish, and "SEE" OS/2 output on this screen`)
   puts(`  Command - Any OS/2 session command`)
   puts(`  parameters - Parameters to pass to the OS/2 command`)
   puts(``)
   puts(`EXAMPLES: OS2 SEE chkdsk c:`)
   puts(`          OS2 START "XCOPY A-B" /FS XCOPY A:\ B:`)
   puts(``)
   puts(`NOTE: OS2.BAT requires CEnvi for DOS`)
   puts(``)
}

OS2Command(pCommand)
{
   // determine if want to SEE output, and if so then output
   // file name
   if ( !strnicmp(pCommand,"SEE",3) && isspace(pCommand[3]) ) {
      pCommand += 4;
      // make temporary text output file in temp directory,
      // else current directory
      if ( defined(TEMP) )
         strcpy(TempDir,TEMP)
      else if ( defined(TMP) )
         strcpy(TempDir,TMP)
      else
         TempDir = ".";
      TempDir = FullPath(TempDir);
      if ( !stricmp(TempDir+1,":\\") ) TempDir[2] = 0;
      srand();
      sprintf(SeeFile,"%s\\~OS2%04X.TMP",TempDir,rand());
      if ( Directory(SeeFile) )
         system("del %s",SeeFile);
   } else {
      SeeFile = NULL;
   }

   StartData = BuildStartData(pCommand,SeeFile);
   reg.ah = 0x64;
   reg.bx = 0x25;    // API ordinal
   reg.ch = 'c', reg.cl = 'l';
   reg.ds = segment(StartData);
   reg.si = offset(StartData);
   interrupt(0x21,reg);
   GiveUpTimeSlices(1500);

   if ( SeeFile ) {
      // wait for file to exist
      while ( !Directory(SeeFile) ) {
         GiveUpTimeslices(500);
      }
      // file writing is finished when we can open it
      while ( !(fp = fopen(SeeFile,"rt")) ) {
         GiveUpTimeslices(500);
      }
      fclose(fp);
      system("type %s",SeeFile);
      system("del %s",SeeFile);
   }
}

GiveUpTimeSlices(pMilliSecondWait)
{
   lMicroSecond = pMilliSecondWait * 1000;
   reg.ah = 0x86;
   reg.cx = (lMicroSecond >> 16) & 0xFFFF;
   reg.dx = lMicroSecond & 0xFFFF;
   interrupt(0x15,reg);
}


gProgramArgs;

BuildStartData(pCommand,pSeeFile)
{
   BLObPut(sdata,0,UWORD16);  // size of structure, add later
   BLObPut(sdata,0,UWORD16);  // independent process
   BLObPut(sdata,1,UWORD16);  // background
   BLObPut(sdata,0,UWORD16);  // no trace
   BLObPut(sdata,pointer("DOS Slave"),UWORD32);
   BLObPut(sdata,NULL,UWORD32);  // NULL program to execute

   // build global program args; first change to directory then
   // run start commmand
   CurDir = FullPath(".");
   sprintf(gProgramArgs,"/C %c: & CD %s & %s",CurDir[0],CurDir+2,pCommand);
   if ( pSeeFile ) {
      strcat(gProgramArgs," > ");
      strcat(gProgramArgs,pSeeFile);
   }
   BLObPut(sdata,pointer(gProgramArgs),UWORD32);
   BLObPut(sdata,0,UWORD32);  // TERMQ

   BLObPut(sdata,0,UWORD32);  // pointer to environment
   BLObPut(sdata,0,UWORD16);  // No inheritance
   BLObPut(sdata,1,UWORD16);  // Full screen


   // go back and add size
   BLObPut(sdata,0,BLObSize(sdata),UWORD16);
   return sdata;
}

:CENVI_EXIT
SET OS2PARM=
