@echo off
// *******************************************************
// *** MiniTemp.cmd - Temporarily minimize all windows ***
// *** ver.1          until a new window is selected   ***
// *******************************************************

ECHO MiniTemp.cmd - This will minimize all windows whenever
ECHO                you hold CTRL-DOWN (control key and the
ECHO                down arrow) until a new window is selected.

start "MiniTemp" /N CEnvi.exe %0.cmd
GOTO CENVI_EXIT

#define KEY_CHECK_INTERVAL  1000  // approx. milliseconds between check for ctrl-tab
#define ACTIVE_WIN_INTERVAL 300   // wait for a new window to become active

#include <WinTools.lib>

// hide this window
ShowWindow(Info().WinHandle,SW_HIDE);

while ( True ) {
   WaitForKeys(True);
   DosBeep(880,10);
   DesktopWindow = MinimizeAllWindows(MinList,MinCount);
   if ( MinCount ) {

      // wait for new window to become active
      while ( (lActiveWindow = GetActiveWindow()) == DesktopWindow )
         suspend(ACTIVE_WIN_INTERVAL);


      // restore all of the windows
      RestoreAllWindows(MinList,MinCount,lActiveWindow);

   }
   WaitForKeys(False);
}

MinimizeAllWindows(pMinList,pMinCount)
   // minimize all windows, save whether maximized
{
   pMinCount = 0;
   lEnum = WinBeginEnumWindows(HWND_DESKTOP);
   while ( lChild = WinGetNextWindow(lEnum) ) {
      if ( IsVisible(lChild) && !IsMinimized(lChild) ) {
         pMinList[pMinCount].Handle = lChild;
         if ( pMinList[pMinCount].Maximized = IsMaximized(lChild) ) {
            GetPosition(lChild,pMinList[pMinCount].col,pMinList[pMinCount].row);
         }
         pMinCount++;
      }
   }
   WinEndEnumWindows(lEnum);
   if ( pMinCount < 2 ) {
      pMinCount = 0;
      return NULL;
   }

   // the last window is desktop, and so skip this one
   lDesktopWindow = pMinList[--pMinCount].Handle;
   SetActiveWindow(lDesktopWindow);

   // minimize all those windows in this list, in reverse order
   for ( lIdx = pMinCount; 0 < lIdx--; ) {
      ShowWindow(pMinList[lIdx].Handle,SW_SHOWMINNOACTIVE);
   }

   return lDesktopWindow;
}

RestoreAllWindows(pMinList,pMinCount,pActiveWindow)
{
   for ( lIdx = pMinCount; 0 < lIdx--; ) {
      if ( pMinList[lIdx].Maximized ) {
         ShowWindow(pMinList[lIdx].Handle,SW_SHOWMAXNOACTIVE);
         SetPosition(pMinList[lIdx].Handle,pMinList[lIdx].col,pMinList[lIdx].row);
      } else {
         ShowWindow(pMinList[lIdx].Handle,SW_RESTORENOACTIVE);
      }
   }
   SetActiveWindow(pActiveWindow);
}

WaitForKeys(pDown) // wait for keys to be held
{
   #define VK_DOWN      0x18
   #define VK_CTRL      0x0A
   // first wait for keys to not all be down before continuing
   if ( pDown ) {
      while ( !KeyPressed(VK_DOWN)  ||  !KeyPressed(VK_CTRL) )
         suspend( KEY_CHECK_INTERVAL );
   } else {
      while ( KeyPressed(VK_DOWN)  &&  KeyPressed(VK_CTRL) )
         suspend( KEY_CHECK_INTERVAL );
   }
}

KeyPressed(pKey)  // return boolen TRUE if keypressed now, else FALSE
{
   #define ORD_WIN32SETKEYBOARDSTATETABLE   921
   lTable[255] = '\0';   // initialize 256-byte key table
   DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
               HWND_DESKTOP,lTable,FALSE);
   return( 0x80 & lTable[pKey] );
}

DosBeep(Frequency,Duration)   // play specified Frequency, in Hz, for specified
{                             // duration, in milliseconds
   #define ORD_DOS32BEEP   286
   return DynamicLink("doscalls",ORD_DOS32BEEP,BIT32,CDECL,Frequency,Duration)
}

:CENVI_EXIT
