EXTPROC CEnvi
//*****************************************************************
//*** IsRun.cmd - CEnvi program to check if process is running. ***
//*** ver.2        Return errorlevel 0 if running, else 1       ***
//***              Search based on name, not directory or       ***
//***              extension.                                   ***
//*** Example: IsProc PULSE                                     ***
//*****************************************************************

main(argc,argv)
{
   if ( argc != 2 ) {
      printf("Must supply process name.\n");
      return 0;
   }

   ProcessName = argv[1];

   PList = ProcessList();
   assert( NULL != PList );
   Count = 1 + GetArraySpan(PList);
   for ( i = 0; i < Count; i++ ) {
      FileName = PList[i].name;
      Parts = SplitFileName(FileName);
      if ( !stricmp(Parts.name,ProcessName)
        || !stricmp(FileName+strlen(Parts.dir),ProcessName) ) {
         printf("%s is running.\n",ProcessName);
         return 0;
      }
   }
 
   printf("%s is not running.\n",ProcessName);
   return 1;
}

