@echo OFF
REM ****************************************************************
REM *** EnvSort.cmd - Sort environment variables alphabetically. ***
REM *** ver.1         This works by writing a temporary batch    ***
REM ***               file to set all of the environment         ***
REM ***               variables in alphabetic order, then        ***
REM ***               removing the batch file.                   ***
REM ****************************************************************
ECHO SORTING ENVIRONMENT VARIABLES...

REM *** USE TEMP OR TMP VARIABLE TO FIND DIRECTORY ***
REM *** TO STORE TEMPORARY FILE                    ***
SET __CMD=.
IF NOT "%TMP%"=="" SET __CMD=%TEMP%
IF NOT "%TEMP%"=="" SET __CMD=%TEMP%
REM REMOVE BACKSLASH IF THERE IS ONE
CEnvi i=strlen(__CMD); if(__CMD[i-1]=='\\') __CMD[i-1]=0;
SET __CMD=%__CMD%\_ENVSORT.CMD

SET | CEnvi %0.cmd
GOTO CENVI_EXIT

   // Build list of all environment variables
   Count = 0;
   while ( ELine = gets() )
      Lines[Count++] = ELine;

   // Sort variable lines
   qsort(Lines,Count,"strcmpi");

   // open temporary batch output file
   if ( !(fp = fopen(__CMD,"wt")) ) {
      printf("Error opening \"%s\" for writing.\a",__CMD);
      exit(EXIT_FAILURE);
   }

   // for each variable, write out to set to nothing
   for ( i = 0; i < Count; i++ ) {
      ELine = Lines[i];
      if ( Equal = strchr(ELine,'=') )
         fprintf(fp,"SET %.*s\n",Equal-ELine+1,ELine);
   }

   // write out all the variable lines to batch file
   for ( i = 0; i < Count; i++ )
      fprintf(fp,"SET %s\n",Lines[i]);

   // all done. close batch file
   fclose(fp);

:CENVI_EXIT

REM *** PLAY BACK THE TEMPORARY BATCH FILE; ALL DONE
CALL %__CMD%
DEL %__CMD%
SET __CMD=

REM *** ENVIRONMENT
