EXTPROC CEnvi
//***********************************************************
//*** DropMany - Drop Many elements to execute code. This ***
//*** ver.2      allows you to drag multiple filenames to ***
//***            a program, and have them all passed to a ***
//***            single instance of the program.          ***
//***********************************************************

#include <GiveMem.lib>

main(argc,argv)
{
   if ( argc < 4  ||  (MaxWait = atoi(argv[1])) < 1 ) {
      Instructions();
      exit(EXIT_FAILURE);
   }

   // name to drop in queue is the last argument
   DropName = argv[argc-1];
   QueueName = GetQueueName(argv[1]);

   // Create this queue, only first one to try will succeed
   if ( QueueHandle = CreateQueue(QueueName) ) {
      ICreatedQueue = True;
      QueueProcess = Info().Process;
   } else {
      ICreatedQueue = False;
      if ( !(QueueHandle = OpenQueue(QueueName,QueueProcess)) ) {
         printf("\nUnable to open Queue \"%s\"\n",QueueName);
         exit(EXIT_FAILURE);
      }
   }
   if ( AddNameToQueue(QueueHandle,QueueProcess,DropName) ) {
      if ( ICreatedQueue )
         QueueEntries = GetQueueEntries(QueueHandle,MaxWait);
   }
   CloseQueue(QueueHandle);
 
   if ( ICreatedQueue ) {
      if ( QueueEntries ) {
         // create full statement to execute
         strcpy(ExecuteCommand,defined(COMSPEC) ? COMSPEC : "CMD.EXE");
         strcat(ExecuteCommand," /C");
         for ( arg = 3; arg < argc; arg++ ) {
            strcat(ExecuteCommand," ");
            strcat(ExecuteCommand,argv[arg-1]);
         }
         for ( arg = GetArraySpan(QueueEntries); 0 <= arg; arg-- ) {
            strcat(ExecuteCommand," ");
            strcat(ExecuteCommand,QueueEntries[arg]);
         }
         printf("Execute: %s...",ExecuteCommand);
         spawn(P_NOWAIT,ExecuteCommand);
         printf("\n");
      }
   }
}

Instructions()
{
   printf("\a\n")
   printf("DropMany - Drop multiple files on single program instance\n")
   printf("\n")
   printf("USAGE: DROPMANY <Timeout> <Commands...> <FileSpec>\n")
   printf("\n")
   printf("WHERE: Timeout - time in milliseconds to wait for all files to tell that they\n")
   printf("                 where \"dropped\" on this object.  Recommend about 6000 if\n")
   printf("                 this is DropMany.cmd, or about 1000 if this has been turned\n")
   printf("                 into an executable\n")
   printf("       Commands - any commands to be performed on FileSpec\n")
   printf("       FileSpec - Filename to be passed to Commands\n")
   printf("\n")
   printf("EXAMPLE: EPM.EXE takes multiple file specs. To drag lots of files to a program\n")
   printf("         object and have them all started in a single instance of EPM.EXE,\n")
   printf("         create program for DROPMANY, and add \"1200 START EPM.EXE\" as\n")
   printf("         parameters.\n")
   printf("\n")
}

GetQueueName(pCommand)  // get a queue name based on given command
{
   lSplitName = SplitFileName(pCommand);
   sprintf(lQueueName,"\\QUEUES\\%s%s",lSplitName.name,lSplitName.ext);
   return lQueueName;
}

CreateQueue(pQueueName) // return handle or NULL if cannot open
{
   #define QUEUE_FIFO   0
   #define QUEUE_LIFO   1
   #define ORD_DOS32CREATEQUEUE  16
   return DynamicLink("QUECALLS",ORD_DOS32CREATEQUEUE,BIT32,CDECL,
                      lQueueHandle,QUEUE_LIFO,pQueueName) ? NULL : lQueueHandle ;
}

OpenQueue(pQueueName,pQueueProcess) // return handle or NULL if cannot open
{
   #define ORD_DOS32OPENQUEUE    15
   rc = DynamicLink("QUECALLS",ORD_DOS32OPENQUEUE,BIT32,CDECL,
                    lQueueProcess,lQueueHandle,pQueueName);
   pQueueProcess = lQueueProcess;
   return rc ? NULL : lQueueHandle ;
}

CloseQueue(pQueueHandle)
{
   #define ORD_DOS32CLOSEQUEUE  11
   return DynamicLink("QUECALLS",ORD_DOS32CLOSEQUEUE,BIT32,CDECL,pQueueHandle);
}

AddNameToQueue(pQueueHandle,pQueueProcess,pName)
{
   // give shared memory to that process
   lName = GiveMemoryToProcess(pQueueProcess);
   poke(lName,pName,1+strlen(pName));
   #define ORD_DOS32WRITEQUEUE   14
   if ( DynamicLink("QUECALLS",ORD_DOS32WRITEQUEUE,BIT32,CDECL,
                    pQueueHandle,0,1+strlen(pName),lName,0) ) {
      printf("\nError adding name to queue\n");
      return False;
   }
   return True;
}

GetQueueEntries(pQueueHandle,pMaxWait)
{
   // Wait for queue to stop getting new entries
   #define RETRIES_PER_INTERVAL  3
   lQueueCount = 0;
   for ( lKeepTrying = 0; lKeepTrying < RETRIES_PER_INTERVAL; lKeepTrying++ ) {
      #define ORD_DOS32QUERYQUEUE   12
      undefine(lNewQueueCount);
      if ( DynamicLink("QUECALLS",ORD_DOS32QUERYQUEUE,BIT32,CDECL,
                       pQueueHandle,lNewQueueCount) ) {
         printf("\nError on DosQueryQueue\n");
         return NULL;
      }
      if ( lNewQueueCount == lQueueCount ) {
         suspend( pMaxWait / RETRIES_PER_INTERVAL );
      } else {
         lKeepTrying = -1;
         lQueueCount = lNewQueueCount;
      }
   }
   if ( !lQueueCount ) {
      printf("\nNo entries found in queue\n");
      return NULL;
   }

   // read entries from queue
   BLObSize(lRequest,2*4);
   for ( lIdx = 0; lIdx < lQueueCount; lIdx++ ) {
      #define ORD_DOS32READQUEUE 9
      #define DCWW_WAIT          0
      #define DCWW_NOWAIT        1
      undefine(lDataLength); undefine(lDataPtr); undefine(lPriority);
      BLObPut(lRequest,0,Info().Process,UWORD32);
      if ( DynamicLink("QUECALLS",ORD_DOS32READQUEUE,BIT32,CDECL,
                       pQueueHandle,lRequest,lDataLength,lDataPtr,
                       0,DCWW_WAIT,lPriority,0) ) {
         printf("\nError on DosReadQueue()\n");
         return NULL;
      }
      lQueue[lIdx] = peek(lDataPtr,lDataLength);
   }
   return lQueue;
}

