/* Screen Blanker 3.3 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing Screen Blanker Version 3.3...'
Say ''
Result = SysFileTree( 'BLANKER.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.BMP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.BMP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.DOC not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'FORTUNES.DAT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: FORTUNES.DAT not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'LICENSE.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: LICENSE.TXT not found! Installation cancelled.'
  Signal DONE
  End
Say 'Please enter the full name of the directory to which'
Say 'you want Screen Blanker installed (default C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory. Installation cancelled.'
    Signal DONE
    End
  End
Say ''
Say 'Do you wish to install the program object in the startup folder? (Y/N)'
Pull YesNo
If YesNo = "Y" Then
  Do
  Folder = '<WP_START>'
  Say 'Object will be placed in the startup folder.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Object will be placed on the desktop.'
  End
Say ''
Say 'Copying BLANKER.EXE to' Directory '...'
Copy BLANKER.EXE Directory                  '1>NUL'
Say 'Copying BLANKER.HLP to' Directory '...'
Copy BLANKER.HLP Directory                  '1>NUL'
Say 'Copying BLANKER.DLL to' Directory '...'
Copy BLANKER.DLL Directory                  '1>NUL'
Say 'Copying BLANKER.BMP to' Directory '...'
Copy BLANKER.BMP Directory                  '1>NUL'
Say 'Copying BLANKER.DOC to' Directory '...'
Copy BLANKER.DOC Directory                  '1>NUL'
Say 'Copying FORTUNES.DAT to' Directory '...'
Copy FORTUNES.DAT Directory                 '1>NUL'
Say 'Copying LICENSE.TXT to' Directory '...'
Copy LICENSE.TXT Directory                  '1>NUL'
Say 'Copying Deskpic screen saver modules to' Directory '...'
Copy AQUARIUM.DSS Directory                 '1>NUL'
Copy EYES.DSS Directory                     '1>NUL'
Copy FIRE.DSS Directory                     '1>NUL'
Copy MELT.DSS Directory                     '1>NUL'
Copy OS22BOUN.DSS Directory                 '1>NUL'
Copy PUZZLE.DSS Directory                   '1>NUL'
Copy RAIN.DSS Directory                     '1>NUL'
Copy SMARTIES.DSS Directory                 '1>NUL'
Copy SPHERES.DSS Directory                  '1>NUL'
Copy STRING.DSS Directory                   '1>NUL'
Copy SWARM.DSS Directory                    '1>NUL'
Copy MELT.DSS Directory                     '1>NUL'
Copy TREK1.DSS Directory                    '1>NUL'
Copy WALL.DSS Directory                     '1>NUL'
Say ''
Say 'Creating program object...'
Say ''
Type = 'WPProgram'
Title = 'Screen Blanker'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\BLANKER.EXE;PARAMETERS=-;STARTUPDIR='Directory';OBJECTID=<BLANKER>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Say 'Screen Blanker was successfully installed.'
  Say 'Make sure that' Directory 'is included in'
  Say 'the LIBPATH statement in your CONFIG.SYS file.'
  Say 'To register Blanker, please send 15$ (cash) to'
  Say '  Peter Wansch'
  Say '  37 Hagenbachgasse'
  Say '  St. Andrae-Woerdern A 3423'
  Say '  AUSTRIA / EUROPE'
  Say '  e-mail p.wansch@ieee.org'
  Exit
Else
  Say 'ERROR: Unable to create object. Installation cancelled.'
  Exit

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Installation error.'
Signal DONE
DONE:
Exit
