/* Installation script for BaR version 2.1 */

/* Load necessary Rexx funcs. */
if RxFuncQuery( 'SysCurPos' ) then do
   call RxFuncAdd 'SysCurPos', 'RexxUtil', 'SysCurPos'
end
if RxFuncQuery( 'SysMkDir' ) then do
   call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
end
if RxFuncQuery( 'SysGetKey' ) then do
   call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
end
if RxFuncQuery( 'SysDriveMap' ) then do
   call RxFuncAdd 'SysDriveMap', 'RexxUtil', 'SysDriveMap'
end
if RxFuncQuery( 'SysCreateObject' ) then do
   call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
end
if RxFuncQuery( 'SysIni' ) then do
   call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
end

/* Begin here */
'@echo off'
   'cls'
   say "BaR Front End Installation"
   say "~~~~~~~~~~~~~~~~~~~~~~~~~~"
   say ""
   say '  Enter the directory where BaR is to be installed (e.g. d:\bin).'
   say '  Note:  BaR will create its own directory beneath the directory'
   say '         you specify.'
   say ''
   say '    Directory: '
   parse value SysCurPos() with col row
   call SysCurPos col-1, 17
   parse pull arg1
   arg1 = arg1||'\BaR'

/*Create directory*/
   say ''
   say "  Creating subdirectory "arg1
   rc = SysMkDir( arg1 )
   if rc <> 0 then do
      say ""
      say "  BARSTALL could not create the subdirectory "arg1"."
      say "  Should the BaR files be copied anyway (Y/n)?"
      parse value SysCurPos() with col row
      call SysCurPos col-1, 47
      answer = SysGetKey()
      parse upper var answer answer
      if answer = "N" then do
         say ""
         say "  Installation aborted."
         exit
      end
   end

/*Copy files to new directory*/
   say ""
   say "  Copying files:  "
   parse value SysCurPos() with row col
   call SysCurPos row-1, 18
   say "BaR.exe"
         "copy bar.exe "arg1" > nul"
   call SysCurPos row, 18
   say "BaR.ico"
         "copy bar.ico "arg1" > nul"
   call SysCurPos row+1, 18
   say "BaRHlp.txt"
         "copy barhlp.txt" arg1" > nul"

/* Create subdirs. for INI backup */
   map = SysDriveMap( 'C:', 'USED' )
   words  = Words( map )
   DriveInfo.0 = words
   count = 1
   DriveInfo.0 = 0
   do words
      newstring.count  = SubWord( map, count, "1" )
      count = count + 1
   end
   lastcol = 32 + count
   count = 1
   do words
      left = Left( newstring.count, "1" )
      newdir = arg1||"\Drive_"||left
      rc = SysMkDir( newdir )
      say ''
      if rc <> 0 then do
         say "  BARSTALL could not create the subdirectory "newdir"."
      end
      count = count + 1
   end

/* Get date format for system */
   say ""
   call lineout 'return.tmp', ''
   'date >date.tmp <return.tmp'
   call lineout 'return.tmp'
   line = linein( 'date.tmp', 1, 1 )
   line = linein( 'date.tmp' )
   call lineout 'date.tmp'
   parse var line junk '(' format ')'
   say '  BaRstall reports the following date format for your system: 'format
   say '  Is this correct (Y/n)? '
   parse value SysCurPos() with col row
   call SysCurPos col-1, 25
   answer = SysGetKey()
   parse upper var answer answer
   if answer = 'N' then do
      say ''
      say '  Enter the date format for your system (e.g. mm-dd-yy): '
      parse value SysCurPos() with col row
      call SysCurPos col-1, 59
      parse pull format .
      do forever
         length = length( format )
         if format <> '' then do
            if length = 8 then
               leave
         end
         say '                              ** ERROR!  Try again. **'
         call SysCurPos col-1, 59
         parse pull format .
      end
   end
   call CreateINI
 

/* Create a WPS object? */
   say ""
   say "  Would you like BARSTALL to create a WPS object (Y/n)?"
   Parse value SysCurPos() with row col
   call SysCurPos row-1, 56
   YesObj = SysGetKey()
   parse upper var YesObj YesObj .
   say ''
   if YesObj = "N" then signal PreExit
   If SysCreateObject("WPProgram", "BaR Front End","<WP_DESKTOP>",,
      "EXENAME="arg1"\BaR.exe" ) then
      say "  Workplace Shell object has been created."
   else do
      say ''
      say "  WPS object could not be created!"
      say "  Probable cause:  an object called 'BaR Front End'"
      say "                   already exists."
      say "  Should BARSTALL create one anyway (y/N)?"
      parse value SysCurPos() with row col
      call SysCurPos row-1, 44
      YesObj = SysGetKey()
      parse upper var YesObj YesOjb .
      if YesObj = "Y" then do
            say ''
            say "  Should the existing object be Updated or Recreated (u/R)?"
            parse value SysCurPos() with row col
            answer = SysGetKey()
            parse upper var answer answer
            call SysCurPos row-1, 61
            parse upper pull answer .
            if answer = "U" then
               call SysCreateObject "WPProgram", "BaR Front End", "<WP_DESKTOP>",,
                  "EXENAME="arg1"\BaR.exe", "U"
            else
               call SysCreateObject "WPProgram", "BaR Front End", "<WP_DESKTOP>",,
                  "EXENAME="arg1"\BaR.exe", "R"
      end
      Signal PreExit
   end
   signal DoExit

PreExit:
   say ""
   say "  You chose not to create a WPS object.  If you would like to start"
   say "  BaR from any directory, add the directory "arg1" to your path"
   say "  statement in config.sys, then add the environment variable"
   say "  SET BAR_DIR="||arg1||" to your config.sys, and, lastly, reboot."
   signal DoExit

CreateINI:
   say ''
   say '  Creating file:  '||arg1||'\BaR.ini'
   call SysIni arg1||'\BaR.ini', 'BaR', 'DateFormat', format
   call SysIni arg1||'\BaR.ini', 'BaR', 'BaR_Dir', arg1||'\BaR.ini'
   call SysIni arg1||'\BaR.ini', 'BaR', 'INIOptions', 'No 5'
   call SysIni arg1||'\BaR.ini', 'BaR', 'Invocation', '0'
   'del return.tmp >nul'
   'del date.tmp >nul'
   return

DoExit:
   say ""
   say "  Installation complete."
   say ""
   exit
