/***********************************************************************\
 *                                PC2.c                                *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 * Pc2Hook.c    Hook the input queue to filter WM_BUTTON1(DBL)CL(IC)K  *
 *              messages to allow PC2 display a Popup-Menu when mouse  *
 *              button 1 is clicked on the Desktop.                    *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Pc2Hook.c Version 1.40 04,1993 $ (LBL)";

#define         _FILE_  "PC/2 - PC2Hook.c V1.40"

#include        "PC2.h"                 /* User include files */
#include        "Error.h"

ULONG                   ulClickFlag;    /* WM_BUTTON1CLICK for a single click, and
                                           WM_BUTTON1DBLCLK for a double click */
HWND                    hwndDesktop;    /* DESKTOP window handle */
HWND                    hwndPC2;        /* PC2 client window handle */
QUERYRECFROMRECT        QueryRect;      /* Rectangle to query underlaying containers */

/*--------------------------------------------------------------------------------------*\
 * This procedure saves the window handles of PC/2 main procedure for use within the    *
 * DLL.                                                                                 *
 * Req:                                                                                 *
 *      ulC ........... Click flag (WM_BUTTON1CLICK or WM_BUTTON1DBLCLK)                *
 *      hD ............ HWND of Desktop                                                 *
 *      hP ............ HWND of PC/2 client window                                      *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
void EXPENTRY   PC2DLL_SetHwnd(ULONG ulC, HWND hD, HWND hP)
{
ulClickFlag=ulC;
hwndDesktop=hD;
hwndPC2=hP;
                                        /* Initialize to query the topmost underlaying
                                           container, that is partially hit by a rectangle
                                           around the pointer */
QueryRect.cb=sizeof(QUERYRECFROMRECT);
QueryRect.fsSearch=CMA_PARTIAL | CMA_ZORDER;
}

/*--------------------------------------------------------------------------------------*\
 * This procedure implements the hook of the input queue.        .                      *
 * Req:                                                                                 *
 *      PQMSG ......... Pointer to system QMSG structure                                *
 * Returns:                                                                             *
 *      FALSE ......... OS/2 should process QMSG in the normal way                      *
\*--------------------------------------------------------------------------------------*/
BOOL EXPENTRY   PC2DLL_Hook(HAB hab, PQMSG pqmsg, ULONG option)
{
if((pqmsg->hwnd==hwndDesktop) && (pqmsg->msg==ulClickFlag))
    {                                   /* User clicked on Desktop with mouse button 1 */
                                        /* We construct a small rectangle around the
                                           current position of the pointer */
    QueryRect.rect.xLeft=pqmsg->ptl.x;
    QueryRect.rect.xRight=pqmsg->ptl.x+1;
    QueryRect.rect.yBottom=pqmsg->ptl.y;
    QueryRect.rect.yTop=pqmsg->ptl.y+1;
    if(WinSendMsg(hwndDesktop, CM_QUERYRECORDFROMRECT, MPFROMLONG(CMA_FIRST), &QueryRect)==NULL)
                                        /* If no container is under the rectangle of the
                                           mouse pointer, we can display our Popup-Menu.
                                           The type of container is unknown, but because
                                           we test only on the Desktop, the should usually
                                           be the icons (but not the minimized programs,
                                           which are windows with a different window handle). */
        WinSendMsg(hwndPC2, WM_POPUPMENU, pqmsg->mp1, pqmsg->mp2);
    }
return(FALSE);                          /* Process the message in the normal way */
}

