.imd PC2.h
:userdoc.
:title.PC/2 Help Program
:body.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help with F1, the mouse or the keyboard.                           *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_HELP..PC/2 Help for Help
:lines align=center.
:color fc=red.
PC/2 - Program Commander/2 Version 1.40
for IBM OS/2 2.x Presentation Manager
Copyright (C) by Stangl Roman 04, 1993
:color fc=default.
:elines.
:p.Please select one of the following topics for further information:
:ul compact.
:li.:link reftype=hd res=&ID_ABOUTDIALOG..About the utility PC/2:elink.
:li.:link reftype=hd res=&ID_INSTALLATIONHELP..Installing PC/2:elink.
:li.:link reftype=hd res=&ID_GENERALHELP..Using PC/2 as a WPS addon:elink.
:li.:link reftype=hd res=&ID_CONCEPTSHELP..Concepts of the Popup-Menu:elink.
:li.:link reftype=hd res=&ID_USINGHELP..Starting a Program from PC/2:elink.
:li.:link reftype=hd res=&ID_CONFIGDIALOG..Setup the Popup-Menu:elink.
:ul compact.
:li.:link reftype=hd res=&MIID_MENUDIALOG..Adding a Submenu:elink.
:li.:link reftype=hd res=&PIID_PROGRAMDIALOG..Adding a Program:elink.
:li.:link reftype=hd res=&RDID_RESORTDIALOG..Resorting a (Sub)menu:elink.
:li.:link reftype=hd res=&SUID_STARTUPDIALOG..Run-time parameters:elink.
:eul.
:li.:link reftype=hd res=&ID_ERRORHELP..Error messages:elink.
:eul.
:p.:link reftype=hd res=&ID_HELP..<Backward>:elink.
                                  :link reftype=hd res=&ID_ABOUTDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the About PC/2 dialog box.                               *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_ABOUTDIALOG..Help for About PC/2
:lines align=center.
:color fc=red.
PC/2 - Program Commander/2 Version 1.40
for IBM OS/2 2.x Presentation Manager
Copyright (C) by Stangl Roman 04, 1993

University for Business Administration
and Management Vienna, Austria
(Wirtschaftsuniversitt Wien)
:color fc=default.
:elines.
:p.E-Mail:
:ul compact.
:li.8650533@awiwuw11.wu-wien.ac.at
:li.Roman Stangl @ IBM Austria National Support BBS ((0043) 0222 21145 6600)
:eul.
:p.This program is classified as Freeware. Under the copyright, you are allowed and
encouraged to freely use, distribute or modify this program under the following
conditions:
:ul compact.
:li.The complete source code and all executables are included. This rule also applies
for any modifications you made.
:li.You may only charge for the costs of duplicating.
:li.:hp7.Any:ehp7. commercial use is prohibited without contacting me prior, except
for incorporating the idea/code in any future release of OS/2 by IBM, however this
clause doesn't apply for any private use.
:li.You don't want to port this utility to MS Windows or Windows NT (never there).
:eul.
:p.You are encouraged to upload this utility to your favourite file-server or
BBS. Please ensure that no file is missing, if you change the archive to
a different compression scheme.
:p.If you find this program useful and want to honor the six weeks of work writing
this utility, you are welcome to send me a small fee of about 50 to 150 Austrian
Schilling (about 5 to 15 dollar) to my home address. Of course you don't need
to pay again, if a new release of PC/2 comes out.
Please send any donations in cash, because it makes some troubles to exchange
money orders or similar in Austria!
Any suggestions are of course welcome too.
:p.Thanks to all those, who sent me proposals and bug reports to improve this
utility!
:p.My home address is:
:sl compact.
:li.    Roman Stangl
:li.    Strebersdorferstrasse 46
:li.    2103  Langenzersdorf, Austria
:esl.
:p.:link reftype=hd res=&ID_HELP..<Backward>:elink.
                                  :link reftype=hd res=&ID_INSTALLATIONHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for PC/2 installation.                                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_INSTALLATIONHELP..Installing PC/2
:p.You have obviously started PC/2 once, because you are reading this help panel.
The installation is just straight forward with the REXX script that installs PC/2,
however there are some points to notice:
:ul.
:li.The installation installed an icon on the Desktop and started the help panels
of PC/2. To ensure that OS/2 starts PC/2 automatically the next time you boot your
system, you must start PC/2 again (you then can notice that the background behind
the icon changes). If you have added :hp3.SET RESTARTOBJECTS=STARTUPFOLDERSONLY:ehp3.
in your :hp2.CONFIG.SYS:ehp2. then you must also add a shadow of PC/2 to your startup
folder to ensure PC/2 is started the next time you boot OS/2.
:li.PC/2 requires the file :hp2.PC2HOOK.DLL:ehp2. to be accessible. PC/2 tries
to find this file either in the directory, where PC/2 was started from, or in a path
that is included in the environment variable :hp3.LIBPATH:ehp3.. PC/2 will
issue an error message, if it can't find it.
The file :hp2.PC2.HLP:ehp2. may be either accessible in the directory,
where PC/2 is started from, or in a path that is included in the environment
variable :hp3.HELP:ehp3.. If you have problems running PC/2, ensure,
that the working directory of PC/2 is accessible by these variables
in your :hp2.CONFIG.SYS:ehp2..
:li.The installation assumes that you are using the default profile :hp2.Pc2.cfg:ehp2.
containing a standart pre-defined Popup-Menu. If you want to use an other Popup-Menu,
you have to open the Settings of PC/2 and add your preferred profile in the
:hp3.Parameters:ehp3. entryfield. Please click for the next help panel to see the
syntax of the command-line parameters of PC/2. This command-line parameters then
must be added to the :hp3.Parameters:ehp3. entryfield.
:li.You can only run one copy of PC/2 concurrently.
:li.If you select a DOS-Program to be started via PC/2, the time-slice of their
sessions is optimized (the DOS-Settings are modified to
:hp3.IDLE_SECONDS=5 IDLE_SENSITIVITY=100:ehp3.) to get a better performance. This
is useful for most DOS games.
:li.You may use PC/2 with or without the WPS installed, you may even use PC/2 as
a replacement for the WPS. To do so you must install PC/2 first. Then you have
to ensure that :hp2.PC2HOOK.DLL:ehp2. is accessible by PC/2. PC/2 tries to find
this file in the directory where PC/2 is started from or in a path pointed to by
the :hp3.LIBPATH:ehp3. environment variable in your :hp2.CONFIG.SYS:ehp2..
You also have to ensure that :hp2.PC2.HLP:ehp2. is accessible in the PC/2 directory or
in a path pointed to by the :hp3.HELP:ehp3. environment
variable in your :hp2.CONFIG.SYS:ehp2. file. The default access ":hp2..;:ehp2." is
:hp7.not:ehp7. sufficient. Then replace the statement 
:hp2.SET RUNWORKPLACE=C&colon.\OS2\PMSHELL.EXE:ehp2. with
:hp2.SET RUNWORKPLACE=[path]PC2.EXE:ehp2. where :hp2.[path]:ehp2. is the pathname
of the directory you installed PC/2. The next time you boot, PC/2 will be
started as a replacement for the WPS.
Be carefull, OS/2 seems to dislike any parameters added to the program that
is started as the WPS!
:p.:hp7.Caution! PC/2 was not tested on all OS/2 versions or installed software
and hardware :ehp7.(simply because I don't have them):hp7., so there may be
bugs!:ehp7.. Of course you can start the WPS from a command prompt by typing
:hp2.START PMSHELL:ehp2. or add a corresponding entry to PC/2.
:eul.
:p.:link reftype=hd res=&ID_ABOUTDIALOG..<Backward>:elink.
                                  :link reftype=hd res=&ID_GENERALHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected general help from the PC/2 main help panel.                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_GENERALHELP..General Help for PC/2
:p.PC/2 - Program Commander is an addon for the WPS (Workplace Shell). The user
can configure a menu that pops up, when the left mouse button is clicked anywhere
on the Desktop. F.e. the Popup-Menu might look like:
:artwork name='Pc2ipc01.bmp' align=left.
:p.You have selected the item :hp3.Prompts:ehp3., which is a Submenu containing
four more items. F.e. the item :hp3.OS/2 Window:ehp3. starts a windowed OS/2
command prompt, when selected. This Popup-Menu is fully configurable, you may add,
change or remove items. An item can either be a Submenu containing more items, or
the name of a program.
:p.Only the first Submenu :hp3.PC/2 Setup:ehp3. cannot be modified. This Submenu
is used to setup PC/2 and to get help.
:p.Your configuration is read from the default profile :hp2.Pc2.cfg:ehp2. each time
PC/2 is started and saved every time you made changes.
You can of course overwrite the default
configuration filename to a file named :hp2.Filename.ext:ehp2. by invoking PC/2 with
the following commandline option:
:p.:hp2.PC2 [-Profile Filename.ext]:ehp2. or
:p.:hp2.PC2 [/Profile Filename.ext]:ehp2.
:p.where :hp2.Filename.ext:ehp2. conforms to a filename of a PC/2 profile. Both FAT
and HPFS filename naming convention is accepted. A few
sample configuration files are provided in this package.
:p.As the default, the Popup-Menu appears if you double-click once on the Desktop,
if no option or the following option is specified:
:p.:hp2.PC2 [-DoubleClick]:ehp2. or
:p.:hp2.PC2 [/DoubleClick]:ehp2.
:p.You may select a single-click instead, by invoking PC/2 with the following
commandline option:
:p.:hp2.PC2 [-SingleClick]:ehp2. or
:p.:hp2.PC2 [/SingleClick]:ehp2.
:p.Please be sure not to combine both click behavior options.
Of course the options changing the click behavior and the configuration
filename options may be combined.
:p.Because some people use PC/2 as a WPS replacement, PC/2 contains a Menuitem
to ShutDown OS/2. By selecting this entry, it is safe to power off your PS/2 or
PC after all disk activity has been stopped, although no windows are closed.
If you run PC/2 as a WPS replacement and may want to start the WPS either by
starting :hp2.PMSHELL.EXE:ehp2. from a command prompt or by starting a
:hp2.PMSHELL:ehp2. Menuitem with PC/2.
You then can follow the WPS initialization by heavy disk access and
buildup of your Desktop with objects.
PC/2 requires to know the Desktop (in technical terms the window handle
of the Desktop) to be able to catch mouse button 1 clicks. If you start
the WPS the Desktop changes too. Therefor PC/2 checks regularily (about every
2.5 seconds) if the Desktop has changed, so you may have to wait a little bit,
after the WPS was started, that PC/2 recognizes mouse clicks again..
:p.I would strongly recommend to start PC/2 during OS/2 boot. If you don't
want to use the default profile, don't forget to add :hp2./Profile Filename.exe:ehp2.
to the :hp3.Parameters:ehp3. entryfield in the Settings of PC/2.
:p.The reason why I wrote this utility was primarily, that many programs
installed on a system require many folders and icons on the Desktop. But to
start a program, I don't want to open and close folders, so I made shadows on
the Desktop messing it up. The solution I prefer is to click on the Desktop,
getting immediately a menu and selecting the application from this menu. So
PC/2 may help you to start your programs quickly, without needing to open
and close folders.
:p.:link reftype=hd res=&ID_INSTALLATIONHELP..<Backward>:elink.
                                  :link reftype=hd res=&ID_CONCEPTSHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected concepts from the PC/2 main help panel.                            *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_CONCEPTSHELP..Concepts of PC/2
:p.The basic idea behind PC/2 is to have an configurable Popup-Menu available,
to start programs quicky, without having to open and close folders.
:p.The Popup-Menu, popped up when you click the left mouse button anywhere on
the Desktop (just like the right one for shutdown), consists of so-called
items. An item may be a Submenu, which contains further items, or the title of
an Application. A Submenu contains a little arrow right beside the title of
the Submenu.
:p.You can imagine this Popup-Menu as a tree, with applications as leaves and
Submenus as nodes. PC/2 allows you to freely build your own tree. To do so
you have to click on the Desktop with the left mouse button and to select
:hp2.PC/2 Setup &rarrow. Configure PC/2:ehp2.. A dialog box appears, where you
can add, modify or remove Submenus and Applications. The listbox displays all
Submenus and Applications of one level (like a cut through the tree). Of
course you may change this level up and down.
:p.Once you have configured your tree of Submenus and Applications, just press
:hp2.Ok:ehp2. to take them into effect and save them to the profile or
:hp2.Cancel:ehp2. to take them into effect without saving.
:p.:link reftype=hd res=&ID_GENERALHELP..<Backward>:elink.
                                  :link reftype=hd res=&ID_USINGHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help for starting a program from PC/2.                             *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_USINGHELP..Help for starting a program via PC/2
:p.After you have configured the PC/2 Popup-Menu, you click on the Desktop
with the left mouse button, select the Application you want to start and click on it.
The Application will be started as if you were clicking on an icon.
:p.One advantage starting an Application this way is, that you can manipulate
many parameters on how the Application is started, one thing you can't do with
many icons. F.e. you can start it invisible (useful for a backup program), making
it only visible by selecting it from the tasklist. You may also specify the size
of the Application or to start it in the background.
:p.You can also start WPS objects, f.e. the Drives object or the Selective
Install.
If you have an WPS object, that represents a seamless WIN-OS2 application,
you may even launch such a session.
Be warned! - you have to create an WPS Object with :hp2.MAKEOBJ.CMD:ehp2. first
to define an Object ID (Identifier) with that Object, to enable PC/2 to get
this ID.
:p.To close an Application, select the corresponding option from the Application
or terminate it from the tasklist.
:p.:link reftype=hd res=&ID_CONCEPTSHELP..<Backward>:elink.
                                  :link reftype=hd res=&ID_CONFIGDIALOG..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Configuration/Setup PC/2 dialog box.                 *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_CONFIGDIALOG..Help for PC/2 Configuration
:p.In the listbox, all Submenus and Applications of one level (imagine as a cut
through the tree) are displayed. A Submenu has an arrow right beside it. F.e. assume
the listbox contains 3 Submenus and 2 Appliations resulting in the following Popup-Menu:
:artwork name='Pc2ipc02.bmp' align=left.
:p.You may want to get into the Submenu :hp3.Prompts:ehp3.. Just select the Submenu
:hp3.Prompts:ehp3. an click on the button :hp2.Level Down >>:ehp2.. The listbox
will now be filled with all Submenus and Applications of the Submenu :hp3.Prompts:ehp3..
To get one level up, simply press :hp2.<< Level Up:ehp2.. If nothing seems to
change, you may be either at the highest level (the root of the tree) or at 
the deapest level (a leaf of the tree) of a Submenu.
:p.To configure the Popup-Menu just select an item.
:ul compact.
:li.To change or to remove this item use the buttons :hp2.Change Entry:ehp2. 
or :hp2.Remove Entry:ehp2.. Either a new dialog appears allowing you to change
the item, or the item will be removed.
:li.To add a Submenu or an Application press the buttons :hp2.Add Submenu:ehp2.
or :hp2.Add Program:ehp2.. A new dialog is displayed allowing you to add a new
Submenu or Application, after pressing :hp2.Ok:ehp2. in this dialog, the Submenu
or Application will be inserted :hp7.after:ehp7. the selected item, or at
the end of the list if no item is selected.
:li.To resort a Submenu press the button :hp2.Resort Menu:ehp2..
A new dialog is displayed allowing you to resort the currently listed Submenu.
Press here to get more information about the
:link reftype=hd res=&RDID_RESORTDIALOG..Resort:elink. dialog.
:eul.
:p.If the listbox is empty, you can't remove or change anything. You also can't
select any item, but in this case you can add a Submenu or an Application by
just pressing the buttons, without needing to select an item.
:p.Press :hp2.Ok:ehp2. to write the configuration to the profile, or press
:hp2.Cancel:ehp2. to keep the changes only in memory. Both buttons will dismiss
the dialog.
:p.:link reftype=hd res=&CDID_HELP_1..Example 1:elink.
     :link reftype=hd res=&CDID_HELP_2..Example 2:elink.
:p.:link reftype=hd res=&ID_CONCEPTSHELP..<Backward>:elink.
                                  :link reftype=hd res=&MIID_MENUDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected example 1 from the Setup PC/2 help.                                *
.*--------------------------------------------------------------------------------------*

:h2 res=&CDID_HELP_1..Setup example 1
:p.Assume the listbox contains the following items resulting in the following Popup-Menu:
:artwork name='Pc2ipc03.bmp' align=left.
:p.You want to remove the Submenu :hp3.Editors:ehp3., rename the Submenu
:hp3.Tools:ehp3. to :hp3.Utilities:ehp3. and add a Submenu :hp3.Demos:ehp3..
:ol compact.
:li.Select the item :hp3.Editors:ehp3.. You can now press the button
:hp2.Remove Entry:ehp2. to remove the submenu, but only if this Submenu is empty.
If it isn't empty, get into this Submenu by pression :hp2.Level Down >>:ehp2.
and remove all items.
:li.To rename :hp3.Tools:ehp3. to :hp3.Utilities:ehp3. select the item
:hp3.Tools:ehp3. and press the button :hp2.Change Entry:ehp2.. A dialog box
appears allowing you to rename this item.
:li.Select the item, after which you want to insert the new Submenu. Then press
the button :hp3.Add Submenu:ehp3. to add one. A dialog box appears allowing you
to enter the title of a new Submenu.
:eol.

.*--------------------------------------------------------------------------------------*
.* The user selected example 2 from the Setup PC/2 help.                                *
.*--------------------------------------------------------------------------------------*

:h2 res=&CDID_HELP_2..Setup example 2
:p.Assume that you have remove all items, leading to an empty listbox. Now
you want to add the Applications :hp3.Backup:ehp3. and :hp3.Terminal:ehp3..
:ol compact.
:li.The listbox is empty, so you can't select any item. Just press the
button :hp2.Add Program:ehp2. and a dialog box appears, allowing you to
enter all the data required for the new Application.
:li.Now the listbox contains the item :hp3.Backup:ehp3., select it and
press the button :hp2.Add Program:ehp2. a second time. Again you get
a dialog box, where you enter the data for the Application :hp3.Terminal:ehp3..
:eol.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Menu installation PC/2 dialog box.                   *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&MIID_MENUDIALOG..Help for PC/2 Menu Installation
:p.This dialog is used to get a name for a Submenu, which is then added to the
Popup-Menu. You can enter whatever you like, f.e. to make a Submenu that contains
OS/2 utilities you might enter :hp3.Utilities:ehp3..
:p.If you have choosen in the previous dialog to change the name of a Submenu, then
overwrite the pre-entered text.
:p.Press :hp2.Ok:ehp2. to accept, or press :hp2.Cancel:ehp2. to ignore the data
you entered.
:p.:link reftype=hd res=&MIID_HELP_1..Examples:elink.
:p.:link reftype=hd res=&ID_CONFIGDIALOG..<Backward>:elink.
                                  :link reftype=hd res=&PIID_PROGRAMDIALOG..<Forward>:elink.

.*--------------------------------------------------------------------------------------*
.* The user selected examples from the Menu installation PC/2 help.                     *
.*--------------------------------------------------------------------------------------*

:h2 res=&MIID_HELP_1..Menu installation examples
:p.Assume you have entered the following Submenu Titles:
:dl tsize=22.
:dthd.:hp2.Title
:ddhd.Purpose:ehp2.
:dt.Prompts
:dd.You want to add a Submenu named :hp3.Prompts:ehp3., that contains OS/2 and DOS,
fullscreen and windowed command prompts.
:dt.Spreadsheets
:dd.You want to add a Submenu named :hp3.Spreadsheets:ehp3. for your spreadsheet
program like Lotus 123/G or Excel.
:edl.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Program installation PC/2 dialog box.                *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&PIID_PROGRAMDIALOG..Help for PC/2 Program Installation
:p.This dialog is used to get the title, the path and filename, the working
directory and parameters of a Menuitem, which is then added to the Popup-Menu.
Additionally you can fine-tune the appearance of the program you want to add
to the Popup-Menu. However the standard selections should provide a basis
that is sufficient for most applications.
:p.Sometimes you want that you can enter a commandline parameter before
an application is started, f.e. assume that you want to be prompted for
a text file just before your text-editor is invoked. PC/2 allows you to
be prompted for commandline parameters in addition to static parameters
before the application is launched. Press on
:link reftype=hd res=&SUID_STARTUPDIALOG..Commandline Parameters:elink.
to find out more about this feature.
:p.The standard file dialog is opened, if you pressed :hp2.File Find:ehp2..
Then you can easily find the program you want to add, the data of this
program are inserted automatically. If a batch file was selected, the batch
file will be inserted as a commandline parameter of a command processor.
:p.Alternatively PC/2 supports also Drag &amp. Drop.
You can f.e. use a Drives Object to select one application to add to PC/2.
Then drag it into a free area within the dialog and drop it.
PC/2 will insert the entryfields and application type correspondingly.
:p.You may also add WPS Objects, either manually or by Drag &amp. Drop.
If you insert an WPS Object correctly (I know this is a little bit
particular) you may start your objects via the PC/2 Popup Menu.
To add WPS Objects you must know the Object ID (Identifier), either
for the preinstalled Objects from :hp2.OS2_20.RC:ehp2. or the
Object ID defined with installation of one WPS Object by :hp2.MAKEOBJ.CMD:ehp2..
:p.If you have choosen in the previous dialog to change the data of a Program,
then overwrite or change the options you want.
:p.Press :hp2.Ok:ehp2. to accept, or press :hp2.Cancel:ehp2. to ignore the data
you entered.
:p.For more information click on one of the following items:
:ul compact.
:li.:link reftype=hd res=&PIID_HELP_2..Program Data:elink.
:li.:link reftype=hd res=&PIID_HELP_3..Program Type:elink.
:li.:link reftype=hd res=&PIID_HELP_4..Program Style:elink.
:li.:link reftype=hd res=&PIID_HELP_5..Program Size &amp. Position:elink.
:li.:link reftype=hd res=&PIID_HELP_6..Program Priority:elink.
:eul.
:p.:link reftype=hd res=&PIID_HELP_1..Examples:elink.
:p.:link reftype=hd res=&MIID_MENUDIALOG..<Backward>:elink.
                                  :link reftype=hd res=&RDID_RESORTDIALOG..<Forward>:elink.


.*--------------------------------------------------------------------------------------*
.* The user selected help from the Startup Parameters dialog box.                       *
.*--------------------------------------------------------------------------------------*

:h1 res=&SUID_STARTUPDIALOG..Help for PC/2 Startup Parameters
:p.PC/2 allows you to replace the commandline parameters of your application
completly or partly.
:p.F.e. assume you have a TCP/IP communications package installed on your
system. You also have added an Menuitem that start a file transfer program named
:hp3.FTP:ehp3.. :hp3.FTP:ehp3. requires as a parameter the name of the host
you want to connect to.
To prompt you for this parameter immediately before :hp3.FTP:ehp3. is started,
you would modify the parameters entryfield of the PC/2 Program Installation
dialog like :hp2.[Please enter host address]:ehp2.
:p.Further assume that you selected the Menuitem :hp3.FTP:ehp3. from the
Popup-Menu. Just before :hp3.FTP:ehp3. is started, a dialog box is displayed,
requesting the host address from you. F.e. you will type
:hp2.ftp-os2.nmsu.edu:ehp2., then the file transfer program will be invoked
as if you typed :hp2.FTP ftp-os2.nmsu.edu:ehp2. from a commandline.
:p.Generally the syntax for the commandline parameters is:
:p.:hp2.Parameter(s) 1 [Text] Parameter(s) 2:ehp2.
:p.Assume you typed :hp2.FirstFile.doc:ehp2. as the first and
:hp2.ThirdFile.doc:ehp2. as the second parameter.
You will be asked by a dialog box, what to replace :hp2.[Text]:ehp2. with.
Assume you entered :hp2.MyFile.doc:ehp2. then the program will be invoked
with the commandline parameters :hp2.FirstFile.doc MyFile.doc ThirdFile.doc:ehp2..
The string :hp2.[Text]:ehp2. would have been replaced by :hp2.MyFile.doc:ehp2..
Of course both parameters may be omited, both may contain more than one parameter
or only one of them may present. Omiting :hp2.[Text]:ehp2. would start the
application without asking you for a commandline parameter prior.
:p.PC/2 allows you to edit commandline parameters similar to the WPS (open
the Settings notebook of any application,
position the cursor into the Parameters entryfield and
press F1 or Help to get further information).
:p.Press :hp2.Ok:ehp2. to accept the parameters you entered, or press
:hp2.Cancel:ehp2. to replace the commandline parameters by an empty string.

.*--------------------------------------------------------------------------------------*
.* The user selected examples from the Program installation PC/2 help.                  *
.*--------------------------------------------------------------------------------------*

:h2 res=&PIID_HELP_1..Program installation examples
:p.Assume you want to add Lotus 123/G:
:dl tsize=22.
:dthd.:hp2.Fieldname
:ddhd.You would enter:ehp2.
:dt.Program Title:
:dd.:hp3.Lotus 123/G:ehp3.
:dt.Path and Filename:
:dd.:hp3.c&colon.\123g\123g.exe:ehp3.
:dt.Working Directory:
:dd.:hp3.c&colon.\123g:ehp3.
:dt.Parameters:
:dd.(none)
:edl.
:p.Lotus 123/G is a Presentation Manager application so you would select
:hp3.Presentation Manager:ehp3. as program type. The program style may be
:hp3.Maximized:ehp3., because more information is visible. The priority
may be left at the default selection :hp3.No Change:ehp3..
:p.Assume you want to add the WPS Object System Clock (located in the
folder :hp2.OS/2 System &rarrow. System Setup:ehp2.):
:dl tsize=22.
:dthd.:hp2.Fieldname
:ddhd.You would enter:ehp2.
:dt.Program Title:
:dd.:hp3.System Clock:ehp3.
:dt.Path and Filename:
:dd.:hp3.<WP_CLOCK>:ehp3.
:dt.Working Directory:
:dd.(n/a)
:dt.Parameters:
:dd.(n/a)
:edl.
:p.The System Clock is a WPS Object, so :hp3.WPS Object:ehp3. is
selected as the program type.
You may have to look into the file :hp2.OS2_20.RC:ehp2. to get the defined
name of preinstalled WPS Objects.
Most settings are not available for WPS Objects.
:p.Assume you want to add the WPS Object seamless WIN-OS2 Clock.
First you must create an WPS Object with a known Object ID (Identifier) with
:hp2.MAKEOBJ.CMD:ehp2., a small REXX-utility supplied with PC/2.
To do so, start :hp2.MAKEOBJ.CMD:ehp2. and supply the Object ID
:hp3.<WP_WIN_CLOCK>:ehp3. when you're asked to.
Then open the newly created Object Settings and change them as you
usually do, when you want to make an Object for a seamless WIN-OS2
session of the WIN-OS2 clock.
After you have created the WIN-OS2 clock object, you can drag it into
this dialog of PC/2:
:dl tsize=22.
:dthd.:hp2.Fieldname
:ddhd.You would enter:ehp2.
:dt.Program Title:
:dd.:hp3.Clock:ehp3.
:dt.Path and Filename:
:dd.:hp3.<WP_WIN_CLOCK>:ehp3.
:dt.Working Directory:
:dd.(n/a)
:dt.Parameters:
:dd.(n/a)
:edl.
:p.The seamless WIN-OS2 Clock is a WPS Object, so :hp3.WPS Object:ehp3.
is used as the program type.
Assuming that you created the seamless WIN-OS2 clock object as outlined
before, then the Object ID is :hp3.<WP_WIN_CLOCK>:ehp3..
If you had an WPS Object before, and you don't know the Object ID, you
have to create a new one with :hp2.MAKEOBJ.CMD:ehp2., to define a known
Object ID.
:p.Sorry, this may be a little complicated, but it is the only way I know
to get a known Object ID and the only way I know to start seamless
WIN-OS2 sessions.

:h2 res=&PIID_HELP_2..Program Data
:p.For a normal user it is the easiest way to use the following guidelines.
According to the type of application you add, some fields may not be editable
or visible:
:dl tsize=22.
:dthd.:hp2.Fieldname
:ddhd.You would enter:ehp2.
:dt.Program Title:
:dd.Here you enter the name, under which the program should appear in the tasklist.
For OS/2 and DOS windows, this will be the title of the window.
You may also name the Objects here, you want to add.
:dt.Path and Filename:
:dd.Here you enter the fully qualified path and filename. F.e. you might enter
:hp3.c&colon.\os2\cmd.exe:ehp3. to obtain an OS/2 command prompt, or
:hp3.c&colon.\os2\mdos\qbasic.exe:ehp3. to start the basic interpreter.
:p.Here you also enter the name of WPS Objects.
WPS Objects are referred either by their defined Object ID (Identity) f.e.
:hp3.<WP_DRIVES>:ehp3. or :hp3.<WP_INST>:ehp3. for preinstalled Objects,
of f.e. :hp3.<WP_USER_CALC>:ehp3. or :hp3.<WP_WIN_PBRUSH>:ehp3. for
Objects installed by the user with :hp2.MAKEOBJ.CMD:ehp2., a REXX-utility
supplied with PC/2.
Preinstalled WPS Objects have usually a defined name, you may need to take a
look into the file :hp2.OS2_20.RC:ehp2. to get further information.
:p.PC/2 can only launch WPS Objects named by their defined ID, so be carefull
to get either the correct ID from :hp2.OS2_20.RC:ehp2. or to define an Object
with a known ID with :hp2.MAKEOBJ.CMD:ehp2.
For a user installed Objects, you can freely use any name, preferably a
descriptive name in the form :hp3.<WP_xxxx>:ehp3..
:p.Sorry, this may be a little complicated, but it is the only way I know
to get a known Object ID and the only way I know to start seamless
WIN-OS2 sessions.
You can't use the Program Template to create Objects if you want them to
add to PC/2, because PC/2 can't obtain the Object ID of such Objects.
:dt.Working Directory:
:dd.Here you enter the directory where the EXE, HLP and DLL files of your
application are located. Before the application is started, a change drive
and change directory call is made, to make this directory the working directory.
:dt.Parameters:
:dd.Here you enter the parameters passed to the application. PC/2 allows you
to be asked for commandline parameters before the application is invoked.
Press on :link reftype=hd res=&SUID_STARTUPDIALOG..Commandline Parameters:elink.
to find out more about this feature. Assume that you want
to use VIEW.EXE to view the command reference, you would enter
:hp3.c&colon.\os2\book\cmdref.inf:ehp3..
:dt.DOS Settings:
:dd.If you select as program type a DOS Full-Screen or DOS Window, a multiline
entryfield is displayed where you can enter the DOS Settings you need. Default,
the DOS Settings :hp3.IDLE_SECONDS=5:ehp3. and :hp3.IDLE_SENSITIVITY:ehp3. are
added if you create a DOS application for the first time. (You have to spell
the DOS Settings exactly as they are displayed in the standard DOS Settings
dialog - even then some can't be set for whatever reasons there are.)
:dt.:hp2.File Find:ehp2.&colon.
:dd.If you click on this button, the standard file dialog of OS/2 is displayed
where you can select the application you want to install. The application
parameters (f.e. path) will then be inserted automatically in the
corresponding entryfields.
:dt.Drag &amp. Drop:
:dd.You can alternatively use the Drag &amp. Drop operation to install one
application. Select one application from f.e. a Drives object or from
a filemanager, drag it into the dialog to any area that accepts it and
drop it.
The settings will be adjusted according to the application you dragged into.
You may also drag any WPS Object into this dialog, but be carefull to
verify the name of the Object, because I don't know how to do this
automatically (you may need to look into :hp2.OS2_20.RC:ehp2.
for the exact spelling of preinstalled Objects.
:edl.
:p.For a power user, the data entered may be less. Because the OS/2 API
DosStartSession() is used to start the application, all rules for this
API apply as described in the toolkit. Hence you may leave the entryfield
Path and Filename blank and then select from the
:link reftype=hd res=&PIID_HELP_3..Program Type:elink. group an
OS/2 or DOS fullscreen or window, to get a command prompt.
:p.You may also start an appliciation indirectly through a secondary command
processor by specifying :hp3.c&colon.\os2\cmd.exe:ehp3. as the Path and Filename and
use then the :hp3./C:ehp3. or :hp3./K:ehp3. option of CMD.EXE in the
Parameters entryfield.

:h2 res=&PIID_HELP_3..Program Type
:p.Here you can select the type of application you want to add.
By default, PC/2 tries to determine the type of an application you installed
via the standard file dialog or via Drag &amp. Drop.
:p.You generally have to verify, that the Program Type setting corresponds
to the application you installed, for most programs you can use
:hp2.Determined by WPS:ehp2. if you aren't sure.
:p.According to the Program Type that is selected, some settings may not
be editable or visible.
:p.OS/2 and DOS Fullscreen or Windows are only used, if you want to start
a command prompt as the application. In this case, you usually enter in the
the entryfield Path and Filename of the group Program Data the path of
the corresponding command processor. A advanced technique to select the
type of command processor only with these radiobuttons is described under
the group :link reftype=hd res=&PIID_HELP_2..Program Data:elink..

:h2 res=&PIID_HELP_4..Program Style
:p.These selections should be self-explanatory, you can only change one of
the radiobuttons, but apply as many checkboxes as you want as the Program
Style. F.e. if you selected :hp3.Minimized:ehp3., :hp3.Invisible:ehp3. and
:hp3.Background:ehp3., the application will be started minimized, in the
background and invisible (this may make sense for a backup program).

:h2 res=&PIID_HELP_5..Program Size &amp. Position
:p.Here you can use the checkbox to start an application with a preselected
size and position. If you select the checkbox :hp3.Size, Position:ehp3. you
will be able to modify the size the started application should appear.
:p.If you deselect the checkbox, the data will be saved, but the application
is started ignoring the size and position you entered.

:h2 res=&PIID_HELP_6..Program Priority
:p.At this level of development, I don't know how to change the priority of a
program started as an independent session, so these radiobuttons are
unavailable. I know how to change the priority started as a child of PC/2, but if the
parent application PC/2 fails (by a bug or a close from the tasklist) all the
childs are also terminated, which is surely unacceptable.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected help from the Resort PC/2 dialog box.                              *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&RDID_RESORTDIALOG..Help for PC/2 Resort
:p.This dialog box contains two listboxes, the left one that displays the currently
available Menuentries and the right one that displays the currently resorted
Menuentries.
Select the first Menuentry from the left listbox and press the 
:hp2.Reorder:ehp2. button, to resort it to the right listbox.
For the next Menuentry(ies) repeat this procedure, until the left listbox is empty.
:p.You can cancel the resort before you have done any sort, but you have to resort
the complete Submenu once you made one resort operation.
:p.All sorted Menuentries in the right listbox can't be started with PC/2 until
you complete the resort by pressing :hp2.OK:ehp2..
Warning! - You have to press :hp2.OK:ehp2. in the :link reftype=hd 
res=&ID_CONFIGDIALOG..Confguration Dialog:elink. to write the resorted Menuentries
structure to the configuration file.
:p.:link reftype=hd res=&PIID_PROGRAMDIALOG..<Backward>:elink.
                                  :link reftype=hd res=&ID_ERRORHELP..<Forward>:elink.


.****************************************************************************************
.*--------------------------------------------------------------------------------------*
.* The user selected error help.                                                        *
.*--------------------------------------------------------------------------------------*
.****************************************************************************************

:h1 res=&ID_ERRORHELP..Help for PC/2 Errors
:p.PC/2 can't verify all user input for validity, so some user input may cause
some PC/2 functions to fail. In this case, a message box is displayed containing
the module and the sourcecode linenumber that failed. Also a error message is
displayed containing which error occured and what should be done to resolve the
problem.
:p.F.e. you might have configured to start the program :hp3.VIEW.EXE:ehp3. by
writing :hp3.c&colon.\os3\view.exe:ehp3. in the entryfield :hp2.Path and Filename:ehp2.
in the Program Installation dialog. This of course leads to an error, because when
OS/2 tries to start this item, it can't find the directory :hp3.\os3\:ehp3. simply
because it should read :hp3.\os2\:ehp3.. A message box is displayed saying an
error occured and that the user input should be corrected.
:p.The messagebox has three buttons that may be pressed:
:dl tsize=22.
:dthd.:hp2.Button
:ddhd.Result:ehp2.
:dt.:hp2.Abort:ehp2.
:dd.PC/2 will be terminated and all unsaved data will be lost. You have to restart
PC\2 again. This button should be the last one you select.
:dt.:hp2.Retry:ehp2.
:dd.The error is ignored, you may need to correct your data entered in the entryfields.
:dt.:hp2.Ignore:ehp2.
:dd.The error is ignored, you may need to correct your data entered in the entryfields.
:edl.
:p.:link reftype=hd res=&RDID_RESORTDIALOG..<Backward>:elink.
                                  :link reftype=hd res=&ID_HELP..<Forward>:elink.

:euserdoc.

