/***********************************************************************\
 *                                PC2.c                                *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * Dialog.c     Dialog window procedures.                              *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Dialog.c Version 1.40 04,1993 $ (LBL)";

#define         _FILE_  "PC/2 - Dialog.c V1.40"

#include        "PC2.h"                 /* User include files */
#include        "Error.h"

PFNWP           PI_ClassDialogProcedure;

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - About dialog.                               *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
        MPFROMSHORT(ID_ABOUTDIALOG),    /* Panel ID in ressource file */
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Cancel key pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Program Installation dialog.                *
 * Req:                                                                                 *
 *      StartSession .. a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session and set its priority.              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63 and load the data from the SESSIONDATA structure SessionData    *
 * into the entryfields.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        PIEF_PROGRAMTITLE,              /* Program title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(EF_SIZE60),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Load the default text of the entryfield */
        hwndDlg, PIEF_PROGRAMTITLE, SessionData.PgmTitle);
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_PATHFILENAME,              /* Path and Filename title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(hwndDlg, PIEF_PATHFILENAME, SessionData.PgmName);
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_DIRECTORY,                 /* Working directory entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(hwndDlg, PIEF_DIRECTORY, SessionData.PgmDirectory);
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_PARAMETERS,                /* Program Parameters entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(hwndDlg, PIEF_PARAMETERS, SessionData.PgmInputs);
                                        /* Insert DOS Settings. If none exist add the
                                           IDLE_* default settings */
    if(strlen(SessionData.PgmDosSettings)!=0)
        WinSendDlgItemMsg(
            hwndDlg,
            PIEF_DOSSETTINGS,           /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP(SessionData.PgmDosSettings),
            (MPARAM)NULL);
    else
        WinSendDlgItemMsg(
            hwndDlg,
            PIEF_DOSSETTINGS,           /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP("IDLE_SECONDS=5\nIDLE_SENSITIVITY=100\n"),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program type group to the state indicated by *
 * the SessionData structure.                                                           *
\*                                                                                      */
    WinSendMsg(hwndDlg, WM_SETUPPROGRAMTYPE,
        MPFROMSHORT(SessionData.SessionType), (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program style group to the state indicated   *
 * by the SessionData structure.                                                        *
\*                                                                                      */
    if(!(SessionData.PgmControl & (SSF_CONTROL_MAXIMIZE | SSF_CONTROL_MINIMIZE)))
        WinSendDlgItemMsg(              /* Send message to Default radiobutton */
            hwndDlg,                    /* Handle of dialog window */
            PIRB_DEFAULTSTYLE,          /* Program style: Default radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_MAXIMIZE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_MAXIMIZED,             /* Program style: Maximized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_MINIMIZE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_MINIMIZED,             /* Program style: Minimized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_INVISIBLE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_INVISIBLE,             /* Program style: Invisible checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_NOAUTOCLOSE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_NOAUTOCLOSE,           /* Program style: NoAutoClose checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.FgBg & SSF_FGBG_BACK)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_BACKGROUND,            /* Program style: Background checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program Priority group to the state          *
 * indicated by the SessionData structure.                                              *
\*                                                                                      */
    WinSendMsg(hwndDlg, WM_SETUPPROGRAMPRIORITY,
        MPFROMLONG(SessionData.PriorityClass), MPFROMLONG(SessionData.PriorityDelta));
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program Size & Position group to the state   *
 * indicated by the SessionData structure.                                              *
\*                                                                                      */
    if(SessionData.PgmControl & SSF_CONTROL_SETPOS)
        {                               /* If requested select it for the first time */
        WinSendDlgItemMsg(hwndDlg, PIRB_SIZEPOSITION, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
            MPFROMSHORT(TRUE), MPFROMSHORT(TRUE));
        }
    else
        WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
            MPFROMSHORT(FALSE), MPFROMSHORT(TRUE));
/*                                                                                      *\
 * Subclass dialog window procedure to catch drag & drop messages of the dialog window, *
 * which doesn't contain any child windows of it (entryfields, buttons, text fields).   *
\*                                                                                      */
                                        /* Subclass window procedure for drag & drop support
                                           save the old procedure, because the subclassing procedure
                                           must call the subclassed dialog procedure for all
                                           messages it doesn't handle itself, i.e. all but drag & drop */
    PI_ClassDialogProcedure=WinSubclassWindow(hwndDlg, PI_SubclassedDialogProcedure);
    break;
    }

/*                                                                                      *\
 * Syntax: WM_SETUPPROGRAMTYPE, (USHORT SessionType), NULL                              *                                           *
\*                                                                                      */
case WM_SETUPPROGRAMTYPE:
/*                                                                                      *\
 * Adjust the Program Type radiobuttons by selecting only the button corresponding to   *
 * the SessionType.                                                                     *
\*                                                                                      */
    {                                   /* Radiobutton IDs sorted */
    USHORT      usSessionTypeRBs[]={PIRB_SHELL, PIRB_OS2FULLSCREEN, PIRB_OS2WINDOW,
                                    PIRB_PM, PIRB_DOSFULLSCREEN, PIRB_DOSWINDOW,
                                    PIRB_WPSOBJECT};
                                        /* Corresponding session type IDs sorted */
    USHORT      usSessionTypeIDs[]={SSF_TYPE_DEFAULT, SSF_TYPE_FULLSCREEN, SSF_TYPE_WINDOWABLEVIO,
                                    SSF_TYPE_PM, SSF_TYPE_VDM, SSF_TYPE_WINDOWEDVDM,
                                    SSF_TYPE_WPSOBJECT};
    USHORT      usSessionType=SHORT1FROMMP(mp1);
    USHORT      usTemp;
                                        /* Loop for all buttons and deselect all but the
                                           one specified in usSessionType */
    for(usTemp=0; usTemp<=(sizeof(usSessionTypeRBs)/sizeof(USHORT)); usTemp++)
        if(usSessionTypeIDs[usTemp]==usSessionType)
            {
            WinSendDlgItemMsg(          /* Send message to one Program Type radiobutton,
                                           this only updates the radiobutton but doesn't
                                           create a WM_CONTROL message */
                hwndDlg,                /* Handle of dialog window */
                                        /* Program type radiobutton */
                usSessionTypeRBs[usTemp],
                BM_SETCHECK,            /* Set it to pressed */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
                                        /* Simulate the click to update the dialog's child windows */
            WinSendMsg(hwndDlg, WM_CONTROL,
                MPFROM2SHORT(usSessionTypeRBs[usTemp], BN_CLICKED), (MPARAM)NULL);
            }
                                        /* Hide DOS Settings window until the application
                                           type is DOS Window or DOS Fullscreen */
    if(usSessionType==SSF_TYPE_WPSOBJECT)
        {
                                        /* Only default priority is allowed for WPS Objects */
        WinSendMsg(hwndDlg, WM_SETUPPROGRAMPRIORITY,
            MPFROMLONG(PIRB_NOCHANGE), MPFROMLONG(SessionData.PriorityDelta));
                                        /* Only default Style is allowed */
        WinSendDlgItemMsg(hwndDlg, PIRB_DEFAULTSTYLE, BM_SETCHECK,
            MPFROMSHORT(TRUE), (MPARAM)NULL);
        }
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETPROGRAMPRIORITY, (ULONG PriorityClass), (LONG PriorityDelta)           *                                           *
\*                                                                                      */
case WM_SETUPPROGRAMPRIORITY:
/*                                                                                      *\
 * Adjust the Program Priotiry radiobuttons by selecting only the button corresponding  *
 * to the PriorityClass and select the PriorityDelta listbox.                           *
\*                                                                                      */
    {                                   /* Radiobutton IDs sorted */
    ULONG       ulPriorityClassRBs[]={PIRB_NOCHANGE, PIRB_IDLETIME, PIRB_REGULAR,
                                      PIRB_TIMECRITICAL, PIRB_FOREGROUNDSERVER};
                                        /* Corresponding priority class IDs sorted */
    ULONG       ulPriorityClassIDs[]={PRTYC_NOCHANGE, PRTYC_IDLETIME, PRTYC_REGULAR,
                                      PRTYC_TIMECRITICAL, PRTYC_FOREGROUNDSERVER};
    ULONG       ulPriorityClass=LONGFROMMP(mp1);
    LONG        lPriorityDelta=LONGFROMMP(mp2);
    USHORT      usTemp;
    UCHAR       ucBuffer[4];
    SHORT       sLoopCount;

                                        /* Loop for all buttons and deselect all but the
                                           one specified in usSessionType */
    for(usTemp=0; usTemp<=(sizeof(ulPriorityClassRBs)/sizeof(ULONG)); usTemp++)
        if(ulPriorityClassIDs[usTemp]==ulPriorityClass)
            WinSendDlgItemMsg(          /* Send message to Priority Class radiobutton */
                hwndDlg,                /* Handle of dialog window */
                                        /* Program priority radiobutton */
                ulPriorityClassRBs[usTemp],
                BM_SETCHECK,            /* Set it to pressed */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the listbox in the Program priority group to the state indicated by *
 * the SessionData structure.                                                           *
\*                                                                                      */
    for(sLoopCount=PRTYD_MAXIMUM; sLoopCount>=PRTYD_MINIMUM; sLoopCount--)
        {
        sprintf(ucBuffer, "%+2d", sLoopCount);
        WinInsertLboxItem(              /* Insert an item to listbos */
                                        /* List box handle */
            WinWindowFromID(hwndDlg, PILB_DELTAPRIORITY),
            LIT_END,                    /* Insert at end */
            ucBuffer);                  /* Text to be inserted */
        }
    WinSendDlgItemMsg(                  /* Send message to Delta Priority listbox */
        hwndDlg,                        /* Handle of dialog window */
        PILB_DELTAPRIORITY,
        LM_SELECTITEM,                  /* Set selection of an item */
                                        /* Select value for PriorityDelta */
        MPFROMSHORT(PRTYD_MAXIMUM-lPriorityDelta),
        MPFROMSHORT(TRUE));
    WinSendDlgItemMsg(                  /* Send message to Delta Priority listbox */
        hwndDlg,                        /* Handle of dialog window */
        PILB_DELTAPRIORITY,
        LM_SETTOPINDEX,                 /* Set default selection to top of the list box */
        MPFROMSHORT(PRTYD_MAXIMUM-lPriorityDelta),
        (MPARAM)NULL);
    }
    break;

/*                                                                                      *\
 * Syntax: WM_SETUPSIZEPOSITION, (BOOL bWriteable), (BOOL bInsert)                      *
\*                                                                                      */
case WM_SETUPSIZEPOSITION:
/*                                                                                      *\
 * The 4 entryfields for the Size&Position are a bit more complicated to handle.        *
 * First we set the entryfields to a size of 4 and the default values are read from the *
 * SessionData structure. Only if Size&Position is selected, this 4 entryfields are not *
 * readonly. Flag bWriteable is true if Size&Position is selected, Flag bInsert is true *
 * if we write the values the first time.                                               *
\*                                                                                      */
    {
    USHORT      usSizePositionEFs[]={PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE};
    BOOL        bWriteable=SHORT1FROMMP(mp1);
    BOOL        bInsert=SHORT1FROMMP(mp2);
    USHORT      usTemp;
    USHORT      *pusSizePosition;
    UCHAR       ucBuffer[4];

                                        /* Get first Size & Position value */
    pusSizePosition=&SessionData.InitXPos;
                                        /* Loop for all entryfields and enable and insert
                                           values into them */
    for(usTemp=0; usTemp<=(sizeof(usSizePositionEFs)/sizeof(USHORT));
        usTemp++, pusSizePosition++)
        {
        if(bWriteable==TRUE)            /* If writeable, enable them */
            WinSendDlgItemMsg(          /* Send message to entryfield */
                hwndDlg,
                                        /* Program size & position entryfield */
                usSizePositionEFs[usTemp],
                EM_SETREADONLY,         /* Set to enable read/write */
                MPFROMSHORT(FALSE),
                (MPARAM)NULL);
        else
            WinSendDlgItemMsg(          /* Send message to entryfield */
                hwndDlg,
                                        /* Program size & position entryfield */
                usSizePositionEFs[usTemp],
                EM_SETREADONLY,         /* Set to enable readonly */
                MPFROMSHORT(TRUE),
                (MPARAM)NULL);
        if(bInsert==TRUE)               /* If initializing, insert them */
            {
            WinSendDlgItemMsg(          /* Send message to dialog window */
                hwndDlg,                /* Handle of dialog window */
                                        /* Program size: X entryfield */
                usSizePositionEFs[usTemp],
                EM_SETTEXTLIMIT,        /* Set text limit to 4 */
                MPFROMSHORT(4),
                (MPARAM)NULL);
            WinSetDlgItemText(          /* Set a text string in a dialog item */
                hwndDlg,
                usSizePositionEFs[usTemp],
                (UCHAR *)_itoa(*pusSizePosition, ucBuffer, 10));
            }
        }
    }
    break;

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
                                        /* Panel ID in ressource file */
        MPFROMSHORT(PIID_PROGRAMDIALOG),
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_CONTROL:                        /* Test for autoradio buttons pressed */
/*                                                                                      *\
 * The Size & Position radiobutton must be checked every time it is selected, because   *
 * only if it is selected, the user may have write access to X, Y, Size X and Size Y    *
 * entryfields, otherwise they are read only. The DOS Setting MLE is only visible if a  *
 * DOS window or fullscreen application type is selected.                               *
\*                                                                                      */
    {                                   /* Child windows that change with the
                                           PIRB_WPSOBJECT radiobutton */
    USHORT      usChild2WPSObject[]={PIRB_MAXIMIZED, PIRB_MINIMIZED, PIRB_SIZEPOSITION,
                                     PIRB_INVISIBLE, PIRB_NOAUTOCLOSE, PIRB_BACKGROUND,
                                     PIEF_X, PIEF_Y, PIEF_XSIZE, PIEF_YSIZE,
                                     /*PIRB_IDLETIME, PIRB_REGULAR,*/ /*PIRB_NOCHANGE,*/
                                     /*PIRB_TIMECRITICAL, PIRB_FOREGROUNDSERVER,
                                     PILB_DELTAPRIORITY, PICB_CHILDPROCESS*/};
                                        /* Hide the following for WPS Objects */
    USHORT      usChild2WPSObjectHide[]={PIEF_DIRECTORY, PIEF_PARAMETERS};
                                        /* Child window that change with a DOS radiobutton */
    USHORT      usChild2DOS[]={PIEF_DOSSETTINGS};

    if(SHORT2FROMMP(mp1)==BN_CLICKED)   /* Was autoradio button clicked ? */
        switch(SHORT1FROMMP(mp1))
        {
        case PIRB_SIZEPOSITION:         /* Program type: User defined size & position */
            if((BOOL)WinSendDlgItemMsg( /* Send message to Size & Position radiobutton */
                hwndDlg,                /* Handle of dialog window */
                PIRB_SIZEPOSITION,      /* Program size: Size & Position radiobutton */
                BM_QUERYCHECK,          /* Query the state */
                (MPARAM)NULL,
                (MPARAM)NULL)==TRUE)
                WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
                    MPFROMSHORT(TRUE), MPFROMSHORT(FALSE));
            else
                WinSendMsg(hwndDlg, WM_SETUPSIZEPOSITION,
                    MPFROMSHORT(FALSE), MPFROMSHORT(FALSE));
            break;

        case PIRB_DOSFULLSCREEN:
        case PIRB_DOSWINDOW:
                                        /* Enable and show DOS child windows */
            DisableDialogItem(hwndDlg, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(hwndDlg, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(hwndDlg, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
            break;

        case PIRB_SHELL:
        case PIRB_OS2FULLSCREEN:
        case PIRB_OS2WINDOW:
        case PIRB_PM:
                                        /* Enable and hide DOS child windows */
            DisableDialogItem(hwndDlg, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), 0);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(hwndDlg, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE);
                                        /* Enable and show WPSObject child windows */
            DisableDialogItem(hwndDlg, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), WS_VISIBLE);
            break;
        
        case PIRB_WPSOBJECT:
                                        /* Disable and show WPSObject child windows */
            DisableDialogItem(hwndDlg, usChild2WPSObject,
                sizeof(usChild2WPSObject)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
                                        /* Hide but enable WPSObject child windows */
            DisableDialogItem(hwndDlg, usChild2WPSObjectHide,
                sizeof(usChild2WPSObjectHide)/sizeof(USHORT), 0);
                                        /* Enable and hide DOS child windows */
            DisableDialogItem(hwndDlg, usChild2DOS,
                sizeof(usChild2DOS)/sizeof(USHORT), 0);
                                        /* Only default priority is allowed for WPS Objects */
            WinSendMsg(hwndDlg, WM_SETUPPROGRAMPRIORITY,
                MPFROMLONG(PIRB_NOCHANGE), MPFROMLONG(SessionData.PriorityDelta));
                                        /* Only default Style is allowed */
            WinSendDlgItemMsg(hwndDlg, PIRB_DEFAULTSTYLE, BM_SETCHECK,
                MPFROMSHORT(TRUE), (MPARAM)NULL);
                                        /* Load empty text in not required fields */
            WinSetDlgItemText(hwndDlg, PIEF_DIRECTORY, "");
            WinSetDlgItemText(hwndDlg, PIEF_PARAMETERS, "");
            break;
        }
    }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case PIPB_WINFILEDLG:               /* Locate file by standard file dialog */
/*                                                                                      *\
 * The user selected the File Find pushbutton to get the standard file dialog to find   *
 * the program he wants to install.                                                     *
\*                                                                                      */
        {
        FILEDLG fdFileDlg;              /* Standard file dialog control */
        HWND    hwndFileDlg;            /* Handle of standard file dialog */

                                        /* Clear out structure */
        memset(&fdFileDlg, 0, sizeof(FILEDLG));
                                        /* Structure size */
        fdFileDlg.cbSize=sizeof(FILEDLG);
                                        /* FDS_* flags */
        fdFileDlg.fl=FDS_CENTER | FDS_OPEN_DIALOG | FDS_PRELOAD_VOLINFO;
                                        /* Dialog title string */
        fdFileDlg.pszTitle="PC/2 File Search";
                                        /* Initial path, filename or file filter */
        strcpy(fdFileDlg.szFullFile, "C:\\*");
                                        /* Open the standard file dialog ...*/
        hwndFileDlg=WinFileDlg(HWND_DESKTOP, hwndDlg, &fdFileDlg);
        if(hwndFileDlg && (fdFileDlg.lReturn==DID_OK))
                                        /* Load the values of the standard file dialog to
                                           the corresponding entryfield in the Program
                                           installation dialog. It is a file not an object. */
            InstallFilename2Dialog(hwndDlg, fdFileDlg.szFullFile, FALSE);
        }
                                        /* Prevent to dismiss program installation dialog
                                           by exiting switch via a break statement */
        return((MRESULT)FALSE);

    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Program Title, Filename, Parameters and DOS Settings and copy them to the  *
 * corresponding entries in the StartSession structure.                                 *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Program title entry */
            WinWindowFromID(hwndDlg, PIEF_PROGRAMTITLE),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmTitle),
            SessionData.PgmTitle);
        WinQueryWindowText(             /* Query data entered in Path and Filename entry */
            WinWindowFromID(hwndDlg, PIEF_PATHFILENAME),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmName),
            SessionData.PgmName);
        WinQueryWindowText(             /* Query data entered in working Directory entry */
            WinWindowFromID(hwndDlg, PIEF_DIRECTORY),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmDirectory),
            SessionData.PgmDirectory);
        WinQueryWindowText(         /* Query data entered in Parameters entry */
            WinWindowFromID(hwndDlg, PIEF_PARAMETERS),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmInputs),
            SessionData.PgmInputs);
        WinQueryWindowText(             /* Query data entered in DOS Settings MLE */
            WinWindowFromID(hwndDlg, PIEF_DOSSETTINGS),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmDosSettings),
            SessionData.PgmDosSettings);
/*                                                                                      *\
 * Query the Program Type radiobuttons and set the corresponding bit into the           *
 * StartSession structure. No change or the default selection are preselected during    *
 * WM_INITDLG. It must be one of them set, so we don't need else parts for if-else.     *
\*                                                                                      */
                                        /* Program type: WPS default */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_SHELL))
            SessionData.SessionType=SSF_TYPE_DEFAULT;
                                        /* Program type: OS/2 Fullscreen */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_OS2FULLSCREEN))
            SessionData.SessionType=SSF_TYPE_FULLSCREEN;
                                        /* Program type: OS/2 Window */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_OS2WINDOW))
            SessionData.SessionType=SSF_TYPE_WINDOWABLEVIO;
                                        /* Program type: PM */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_PM))
            SessionData.SessionType=SSF_TYPE_PM;
                                        /* Program type: DOS Fullscreen */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_DOSFULLSCREEN))
            SessionData.SessionType=SSF_TYPE_VDM;
                                        /* Program type: DOS Window */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_DOSWINDOW))
            SessionData.SessionType=SSF_TYPE_WINDOWEDVDM;
                                        /* Program type: WPS Object */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_WPSOBJECT))
            SessionData.SessionType=SSF_TYPE_WPSOBJECT;
/*                                                                                      *\
 * Query Program Style radiobuttons and set the corresponding bits in the StartSession  *
 * structure. No change or the default selection are preselected during WM_INITDLG.     *
\*                                                                                      */
                                        /* Program style: Maximized */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_MAXIMIZED))
            SessionData.PgmControl|=SSF_CONTROL_MAXIMIZE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_MAXIMIZE);
                                        /* Program style: Minimized */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_MINIMIZED))
            SessionData.PgmControl|=SSF_CONTROL_MINIMIZE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_MINIMIZE);
                                        /* Program style: Invisible */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_INVISIBLE))
            SessionData.PgmControl|=SSF_CONTROL_INVISIBLE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_INVISIBLE);
                                        /* Program style: No autoclose */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_NOAUTOCLOSE))
            SessionData.PgmControl|=SSF_CONTROL_NOAUTOCLOSE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_NOAUTOCLOSE);
                                        /* Program style: Background */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_BACKGROUND))
            SessionData.FgBg|=SSF_FGBG_BACK;
        else
            SessionData.FgBg&=(~SSF_FGBG_BACK);
/*                                                                                      *\
 * Query Size & Position radiobutton, set the corresponding bit, and load the values    *
 * from the corresponding entryfields for the StartSession structure.                   *
\*                                                                                      */
        {
        UCHAR   Buffer[4];

        if(WinQueryButtonCheckstate(hwndDlg, PIRB_SIZEPOSITION))
            SessionData.PgmControl|=SSF_CONTROL_SETPOS;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_SETPOS);
        WinQueryWindowText(             /* Query data entered in Parameters entry */
            WinWindowFromID(hwndDlg, PIEF_X),
                                        /* into temporary structure */
            sizeof(Buffer),
            Buffer);
        SessionData.InitXPos=(USHORT)atol(Buffer);
        WinQueryWindowText(
            WinWindowFromID(hwndDlg, PIEF_Y),
            sizeof(Buffer),
            Buffer);
        SessionData.InitYPos=(USHORT)atol(Buffer);
        WinQueryWindowText(
            WinWindowFromID(hwndDlg, PIEF_XSIZE),
            sizeof(Buffer),
            Buffer);
        SessionData.InitXSize=(USHORT)atol(Buffer);
        WinQueryWindowText(
            WinWindowFromID(hwndDlg, PIEF_YSIZE),
            sizeof(Buffer),
            Buffer);
        SessionData.InitYSize=(USHORT)atol(Buffer);
        }
/*                                                                                      *\
 * Query Program Priority radiobuttons and set the corresponding bits in the            *
 * StartSession structure. The default priority is No-Change. The listbox is also       *
 * queried and the Delta Priority is also set in the StartSession structure. It must be *
 * one of the radiobuttons, so else part of if-else is not required.                    *
\*                                                                                      */
                                        /* Program Priority: No-Change */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_NOCHANGE))
            SessionData.PriorityClass=PRTYC_NOCHANGE;
                                        /* Program Priority: Idle-time */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_IDLETIME))
            SessionData.PriorityClass=PRTYC_IDLETIME;
                                        /* Program Priority: Regular */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_REGULAR))
            SessionData.PriorityClass=PRTYC_REGULAR;
                                        /* Program Priority: Time-critical */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_TIMECRITICAL))
            SessionData.PriorityClass=PRTYC_TIMECRITICAL;
                                        /* Program Priority: Server */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_FOREGROUNDSERVER))
            SessionData.PriorityClass=PRTYC_FOREGROUNDSERVER;
                                        /* Query index of selected item on correct it */
        SessionData.PriorityDelta=(
            WinQueryLboxSelectedItem(
                WinWindowFromID(hwndDlg, PILB_DELTAPRIORITY))
            -PRTYD_MAXIMUM)*(-1);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the subclassed PC/2 - Program Installation dialog.     *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_SubclassedDialogProcedure(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PDRAGINFO       pDragInfo;              /* Pointer to DRAGINFO structure */
PDRAGITEM       pDragItem;              /* Pointer to DRAGITEM structure */

switch(msg)
{
/*                                                                                      *\
 * Allow objects to be dropped on dialog box to add first dragitem as an application.   *
\*                                                                                      */
case DM_DRAGOVER:
    pDragInfo = (PDRAGINFO)mp1;         /* Get the pointer to the DRAGINFO structure */
                                        /* Access the structure */
    if(DrgAccessDraginfo(pDragInfo)==FALSE) break;
                                        /* Get the first itemp of the item(s) dragged
                                           onto dialog window */
    pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);
    if(pDragInfo->cditem!=1)
                                        /* Don't allow dropping of more than one item */
        return(MPFROM2SHORT(DOR_NODROP, DO_UNKNOWN));
    else
                                        /* Allow drop of undefined operation onto dialog window */
        return(MPFROM2SHORT(DOR_DROP, DO_UNKNOWN));

case DM_DROP:
    {
    UCHAR       ucBuffer[256];
    UCHAR       ucObjectType[256];
    UCHAR       *pucBuffer;

    pDragInfo = (PDRAGINFO)mp1;         /* Get the pointer to the DRAGINFO structure */
                                        /* Access the structure */
    if(DrgAccessDraginfo(pDragInfo)==FALSE) break;
                                        /* Get the first itemp of the item(s) dragged
                                           onto dialog window */
    pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);
                                        /* Query the rendering format */
    DrgQueryStrName(pDragItem->hstrRMF, sizeof(ucObjectType), ucObjectType);
                                        /* Scan for an WPS object */
    if(strstr(ucObjectType, "<DRM_OBJECT, DRF_OBJECT>")==NULL)
        {                               /* It is an application to get path and filename */
                                        /* Query path (container) */
        DrgQueryStrName(pDragItem->hstrContainerName, sizeof(ucBuffer), ucBuffer);
                                        /* Position to \0 of path */
        pucBuffer=ucBuffer+strlen(ucBuffer);
                                        /* Query filename and append it to path */
        DrgQueryStrName(pDragItem->hstrSourceName, sizeof(ucBuffer)-strlen(pucBuffer), pucBuffer);
                                        /* Now change the entryfields to the dropped object
                                           which is not a WPS object */
        InstallFilename2Dialog(hwnd, ucBuffer, FALSE);
        }
    else
        {                               /* It is an WPS Object so only get object name */
                                        /* Query filename but don't append it to path */
        DrgQueryStrName(pDragItem->hstrSourceName, sizeof(ucBuffer), ucBuffer);
                                        /* Now change the entryfields to the dropped object
                                           which is a WPS object */
        InstallFilename2Dialog(hwnd, ucBuffer, TRUE);
        }
    }
    break;

default:                                /* Pass all other messages to default window procedure */
    return((MRESULT)PI_ClassDialogProcedure(hwnd, msg, mp1, mp2));
}
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Menu Installation dialog.                   *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session and set its priority.              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        MIEF_MENUTITLE,                 /* Program submenu title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(EF_SIZE60),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set text of title entryfield */
        hwndDlg, MIEF_MENUTITLE, SessionData.PgmTitle);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
        MPFROMSHORT(MIID_MENUDIALOG),   /* Panel ID in ressource file */
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Submenu Title and copy it to the corresponding entry in the StartSession   *
 * structure.                                                                           *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Submenu title entry */
            WinWindowFromID(hwndDlg, MIEF_MENUTITLE),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmTitle),
            SessionData.PgmTitle);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - ShutDown OS/2 dialog.                       *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
    WinPostMsg(hwndDlg, WM_SHUTDOWN, NULL, NULL);
    break;
    }

/*                                                                                      *\
 * Syntax: WM_SHUTDOWN, NULL, NULL                                                      *
\*                                                                                      */
case WM_SHUTDOWN:
/*                                                                                      *\
 * Wait for 2 seconds and then shut down OS/2.                                          *
\*                                                                                      */
    DosSleep(02000);
    DosShutdown(0);
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Startup Parameters dialog.                  *
 * Req: *PgmInputs .....A pointer to a string of commandline params of an application   *
 *                      via mp2                                                         *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static COMMANDLINEPARAMS        *pCLPParams;

switch(msg)
{
case WM_INITDLG:
    {
    UCHAR       ucBuffer[EF_SIZE255+1];

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    pCLPParams=PVOIDFROMMP(mp2);
/*                                                                                      *\
 * Load text from CLPParams into the dialog box text fields, and set the text limit of  *
 * the entryfield to 127.                                                               *
\*                                                                                      */
    sprintf(ucBuffer, "%s[...] %s", pCLPParams->ucPBefore, pCLPParams->ucPAfter);
                                        /* User information text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPINFO, pCLPParams->ucPUser);
                                        /* Current parameters text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPPARAMETERS, ucBuffer);
    WinSendDlgItemMsg(hwndDlg, SUEF_STARTUPPARAMETERS, EM_SETTEXTLIMIT,
        MPFROMSHORT(EF_SIZE60), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(hwndHelp, HM_DISPLAY_HELP,
        MPFROMSHORT(SUID_STARTUPDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        WinQueryWindowText(WinWindowFromID(hwndDlg, SUEF_STARTUPPARAMETERS),
            sizeof(pCLPParams->ucPUser), pCLPParams->ucPUser);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Resort dialog.                              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY RD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static MENUDATA *pSortedMenuData;       /* Pointer to the first element of the resorted
                                           linked list */
static MENUDATA *pParentMenuData;       /* Menuitem, which current level is a child of */
static USHORT   usChild2InitPBs[]={DID_OK};
static USHORT   usChild2MovePBs[]={DID_CANCEL};
static USHORT   usChild2OKPBs[]={RDPB_MOVE};
static BOOL     bFirstMove;
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    SHORT       sCount;
    MENUDATA    *pMDSource;             /* Pointer withing the current linked list */

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2, (swpScreen.cy-swp.cy)/2, 0, 0, SWP_MOVE);
/*                                                                                      *\
 * Disable OK pushbutton, until all items have been moved. Get the first element of the *
 * current level of the linked list which will be resorted. Add all Menuitems of the    *
 * current level of the linked list to the source listbox. Save the parent Menuitem,    *
 * from where the current level is a child of.                                          *
\*                                                                                      */
    bFirstMove=FALSE;                   /* We didn't make any sort before */
    pSortedMenuData=NULL;               /* Pointer of resorted linked list points to a non
                                           available Menuitem */
                                        /* Disable and show OK pushbutton */
    DisableDialogItem(hwndDlg, usChild2InitPBs,
        sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
    if(pMenuData==pPopupMenu)           /* Is current level is the root of all levels ? */
        pParentMenuData=NULL;           /* Yes, then parent Menuitem is NULL */
    else                                /* No, then get parent Menuitem */
        pParentMenuData=pMenuData->Back;
    pMDSource=pMenuData;                /* Get first element of linked list */
    do                                  /* Add current level of Menuitems to the source listbox */
    {
        if(pMDSource->Item==ENTRYSUBMENU) /* It is a Submenu */
            {
            UCHAR       ucBuffer[EF_SIZE60+4];
                                        /* Add >> for a Submenu */
            sprintf(ucBuffer, "%s >>", pMDSource->PgmTitle);
                                        /* Insert Menuitem at the end of the listbox */
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
            }
                                        /* It's a Menuitem */
        if(pMDSource->Item==ENTRYMENUITEM)
            WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_INSERTITEM,
                MPFROMSHORT(LIT_END), MPFROMP(pMDSource->PgmTitle));
                                        /* It may also be an empty entry, but then we
                                           ignore it, because it must be filled with
                                           Menuitem or Submenu data first */
        if(pMDSource->Next!=NULL)       /* Get through linked list without diving into
                                           Submenus */
                pMDSource=pMDSource->Next;
        else break;                     /* We're at the end of the linked list */
    }while(TRUE);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(hwndHelp, HM_DISPLAY_HELP,
        MPFROMSHORT(RDID_RESORTDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case RDPB_MOVE:                     /* Move pushbutton */
        {
        MENUDATA        *pMDSource;     /* Walk through current linked list */
                                        /* Walk through destination linked list */
        MENUDATA        *pMDDestination;
        SHORT           sCount;
 
/*                                                                                      *\
 * For the first resort operation, disable the Cancel pushbutton.                       *
\*                                                                                      */
        if(bFirstMove==FALSE)           /* After the first move operation, disable the
                                           Cancel pushbutton */
            {
            bFirstMove=TRUE;            /* We make now the first move */
            DisableDialogItem(hwndDlg, usChild2MovePBs,
                sizeof(usChild2MovePBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            }
/*                                                                                      *\
 * Now get the selected Menuitem of the source listbox, delete it from the listbox. If  *
 * the source listbox is now empty, reenable the OK pushbutton again.                   *
\*                                                                                      */
                                        /* Query the selected Menuitem from the source listbox */
        sCount=(SHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYSELECTION,
            MPFROMSHORT(LIT_FIRST), (MPARAM)NULL);
        if(sCount==LIT_NONE)            /* If no item selected ignore this button */
            return((MRESULT)FALSE);
        {
        UCHAR   ucBuffer[EF_SIZE60+4];
        SHORT   usItems;
                                        /* Query the text of the selected Menuitem from the
                                           source listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMTEXT,
            MPFROM2SHORT(sCount, sizeof(ucBuffer)), MPFROMP(ucBuffer));
                                        /* Delete the selected Menuitem from the source listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_DELETEITEM,
            MPFROMSHORT(sCount), (MPARAM)NULL);
                                        /* Insert the text of the selected Menuitem into the
                                           destination listbox */
        WinSendDlgItemMsg(hwndDlg, RDLB_DESTINATIONMENU, LM_INSERTITEM,
            MPFROMSHORT(LIT_END), MPFROMP(ucBuffer));
                                        /* Query the number of Menuitems from the source
                                           listbox */
        usItems=(USHORT)WinSendDlgItemMsg(hwndDlg, RDLB_SOURCEMENU, LM_QUERYITEMCOUNT,
            (MPARAM)NULL, (MPARAM)NULL);
        if(usItems==0)                  /* If now more items left, reenable OK pushbutton
                                           and disable Resort pushbutton */
            {
            DisableDialogItem(hwndDlg, usChild2InitPBs,
                sizeof(usChild2InitPBs)/sizeof(USHORT), WS_VISIBLE);
            DisableDialogItem(hwndDlg, usChild2OKPBs,
                sizeof(usChild2OKPBs)/sizeof(USHORT), WS_VISIBLE | WS_DISABLED);
            }
        }
/*                                                                                      *\
 * Now remove the selected Menuitem from the current linked list, by updating the       *
 * pointers according to previous or following Menuitems.                               *
\*                                                                                      */
        pMDSource=pMenuData;            /* Point to the first element of the linked list */
        for( ; sCount>0; sCount--)      /* Walk through the linked list to the selected
                                           item */
            pMDSource=pMDSource->Next;
        pMDDestination=pSortedMenuData; /* Point to the first element of the resorted linked list */
        if(pMDDestination!=NULL)        /* Walk through the resorted linked list to the
                                           last Menuitem, if there's at least one element */
            for( ; pMDDestination->Next!=NULL; pMDDestination=pMDDestination->Next);
/*                                                                                      *\
 * Now update the Popup-Menu, by moving the selected Menuitem.                          *
\*                                                                                      */
        if((pMDDestination==NULL) && (pParentMenuData==NULL))
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pPopupMenu));
        if((pMDDestination==NULL) && (pParentMenuData!=NULL))
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pParentMenuData));
        if(pMDDestination!=NULL)
            SetPopupMenu(MM_MOVEMENUITEM, MPFROMP(pMDSource), MPFROMP(pMDDestination));

        if((pMDSource->Back!=NULL) && (pMDSource->Next!=NULL))
            {                           /* Current element follows another and is followed
                                           by another element, so simple remove it by
                                           updating the pointers. Be carefull if the
                                           parent element is a Submenu where the current
                                           level is a leaf of. */
            if((pMDSource->Back)->Submenu==pMDSource)
                {
                (pMDSource->Back)->Submenu=pMDSource->Next;
                pMenuData=pMDSource->Next;
                }
            else
                (pMDSource->Back)->Next=pMDSource->Next;
            (pMDSource->Next)->Back=pMDSource->Back;
            }
        if((pMDSource->Back!=NULL) && (pMDSource->Next==NULL))
            {                           /* Current element follows another but is the last
                                           one of the current linked list.  Be carefull if
                                           the parent element is a Submenu where the current
                                           level is a leaf of. */
                                        /* Next element of course is NULL */
            if((pMDSource->Back)->Submenu==pMDSource)
                {
                (pMDSource->Back)->Submenu=pMDSource->Next;
                pMenuData=pMDSource->Next;
                }
            else
                (pMDSource->Back)->Next=pMDSource->Next;
            }
        if((pMDSource->Back==NULL) && (pMDSource->Next!=NULL))
            {                           /* Current element is the first one of the complete
                                           linked list, but is followed by another */
            (pMDSource->Next)->Back=NULL;
            pMenuData=pMDSource->Next;
            pPopupMenu=pMDSource->Next;
            }
        if((pMDSource->Back==NULL) && (pMDSource->Next==NULL))
            {                           /* Current element is the first one of the complete
                                           linked list, and isn't followed by another */
            pMenuData=NULL;
            pPopupMenu=NULL;
            }
/*                                                                                      *\
 * Now add the deleted Menuitem at the end of the resorted linked list, by updating the *
 * pointer of the last element to point to the deleted one.                             *
\*                                                                                      */
        if(pMDDestination==NULL)
            {                           /* If the resorted linked list is empty, add
                                           deleted element and update pointers */
            pSortedMenuData=pMDSource;
            pMDDestination=pMDSource;
            pMDDestination->Next=NULL;
            pMDDestination->Back=NULL;
            }
        else
            {                           /* If the resorted linked list isn't empty, add
                                           deleted element at the end and update pointers */
            pMDDestination->Next=pMDSource;
            pMDSource->Back=pMDDestination;
            pMDSource->Next=NULL;
            }
        }
        return((MRESULT)FALSE);         /* We don't want to close the dialog by breaking
                                           out of the switch statement */

    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Now replace the current linked list, which is empty as all Menuitems have been re-   *
 * moved, with the resorted linked list.                                                *
\*                                                                                      */
        if(pParentMenuData==NULL)
            {                           /* If the root of the complete linked list has been
                                           resorted, update the root pointers */
            pPopupMenu=pSortedMenuData;
            pMenuData=pPopupMenu;
            }
        else
            {                           /* If the current level has a parent Menuitem, a
                                           Submenu of course, update the current level pointers */
            pMenuData=pSortedMenuData;
            pSortedMenuData->Back=pParentMenuData;
            pParentMenuData->Submenu=pMenuData;
            }
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


