;;
;; Sample startup file for GNU Emacs under emx
;;

;;
;; Enable 8-bit input.  set-input-mode must be called when running
;; Emacs -- calling it before dumping doesn't work.
;;
(set-input-mode nil nil 1)

;;
;; Specify additional frame parameters.
;;
(setq default-frame-alist
      (append default-frame-alist
              '((altgr-modifier . meta)))) ; AltGr (and AltCar) generate M-

;;
;; Display characters 128 through 254 as-is.  Without this
;; statement, octal notation is used for these characters.
;;
(standard-display-8bit 128 254)

;; Use special symbols (which are not displayed as-is when occurring
;; in a buffer) for truncated screen lines (256), continued lines
;; (257) and for displaying control characters notation (259)
;;
(aset standard-display-table 256 16)
(aset standard-display-table 257 31)
(aset standard-display-table 259 24)

;;
;; Raise frame to the foreground if emacsclient requests a buffer.
;;
(add-hook 'server-request-hook
          '(lambda ()
             (make-frame-visible)
             (focus-frame (selected-frame))))

;;
;; Use Kai Uwe Rommel's port of GNU ls.
;;
(add-hook 'dired-load-hook 'emx-dired-kur-ls-setup)

;;
;; Enable OS/2 on-line help.
;;
(autoload 'os2help "os2help" "OS/2 on-line help" t)
(setq os2help "/emx/book/emxdoc.ndx")
(global-set-key [C-f1] 'os2help)

;;
;; Call pm-edit-menu to let the Cut, Copy and Paste choices of the
;; Edit menu use the OS/2 clipboard.
;;
;; Set the foreground and background colors of the mode line. 
;;
(if window-system                                     
    (progn
      (pm-edit-menu)
      (set-face-background 'modeline "red")
      (set-face-foreground 'modeline "yellow")))

;; End of site-start.el
