;;; cp850.el --- set up case-conversion and syntax tables for codepage 850

;; Copyright (C) 1993 [...]

;; Author: Eberhard Mattes
;; Maintainer: [...]
;; Keywords: i14n

;; This file is [...] part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; Written by Eberhard Mattes.  See case-table.el for details.

;;; Code:

(require 'case-table)

(let ((table (car (standard-case-table))))
  (set-case-syntax-pair 128 135 table) ; C with cedilla
  ;;                    129            ; See 154
  ;;                    130            ; See 144
  ;;                    131            ; See 182
  ;;                    132            ; See 142
  ;;                    133            ; See 183
  ;;                    134            ; See 143
  ;;                    135            ; See 128
  ;;                    136            ; See 210
  ;;                    137            ; See 211
  ;;                    138            ; See 212
  ;;                    139            ; See 216
  ;;                    140            ; See 215
  ;;                    141            ; See 222
  (set-case-syntax-pair 142 132 table) ; A with diaeresis or umlaut mark
  (set-case-syntax-pair 143 134 table) ; A with ring
  (set-case-syntax-pair 144 130 table) ; E with acute accent
  ;;                    145            ; See 146
  (set-case-syntax-pair 146 145 table) ; AE diphthong
  ;;                    147            ; See 226
  ;;                    148            ; See 153
  ;;                    149            ; See 227
  ;;                    150            ; See 234
  ;;                    151            ; See 235
  (set-case-syntax      152 "w" table) ; small y with diaeresis
  (set-case-syntax-pair 153 148 table) ; O with diaeresis or umlaut mark
  (set-case-syntax-pair 154 129 table) ; U with diaeresis or umlaut mark
  ;;                    155            ; See 157
  (set-case-syntax      156 "w" table) ; pound sign
  (set-case-syntax-pair 157 155 table) ; O with slash
  (set-case-syntax      158 "_" table) ; multiplication sign
  (set-case-syntax      159 "_" table) ; function f
  ;;                    160            ; See 181
  ;;                    161            ; See 214
  ;;                    162            ; See 224
  ;;                    163            ; See 233
  ;;                    164            ; See 165
  (set-case-syntax-pair 165 164 table) ; N with tilde
  (set-case-syntax      166 "_" table) ; underlined superscript a
  (set-case-syntax      167 "_" table) ; underlined superscript o
  (set-case-syntax      168 "." table) ; inverted question mark
  (set-case-syntax      169 "_" table) ; registered sign
  (set-case-syntax      170 "_" table) ; not sign
  (set-case-syntax      171 "_" table) ; fraction one-half
  (set-case-syntax      172 "_" table) ; fraction one-quarter
  (set-case-syntax      173 "." table) ; inverted exclamation mark
  (set-case-syntax-delims 174 175 table) ; angle quotation marks
  ;;                    175            ; See 174
  (set-case-syntax      176 "_" table) ; gray shade
  (set-case-syntax      177 "_" table) ; gray shade
  (set-case-syntax      178 "_" table) ; gray shade
  (set-case-syntax      179 "_" table) ; line graphics
  (set-case-syntax      180 "_" table) ; line graphics
  (set-case-syntax-pair 181 160 table) ; A with acute accent
  (set-case-syntax-pair 182 131 table) ; A with circumflex accent
  (set-case-syntax-pair 183 133 table) ; A with grave accent
  (set-case-syntax      184 "_" table) ; copyright sign
  (set-case-syntax      185 "_" table) ; line graphics
  (set-case-syntax      186 "_" table) ; line graphics
  (set-case-syntax      187 "_" table) ; line graphics
  (set-case-syntax      188 "_" table) ; line graphics
  (set-case-syntax      189 "w" table) ; cent sign
  (set-case-syntax      190 "w" table) ; yen sign
  (set-case-syntax      191 "_" table) ; line graphics
  (set-case-syntax      192 "_" table) ; line graphics
  (set-case-syntax      193 "_" table) ; line graphics
  (set-case-syntax      194 "_" table) ; line graphics
  (set-case-syntax      195 "_" table) ; line graphics
  (set-case-syntax      196 "_" table) ; line graphics
  (set-case-syntax      197 "_" table) ; line graphics
  ;;                    198            ; See 199
  (set-case-syntax-pair 199 198 table) ; A with tilde
  (set-case-syntax      200 "_" table) ; line graphics
  (set-case-syntax      201 "_" table) ; line graphics
  (set-case-syntax      202 "_" table) ; line graphics
  (set-case-syntax      203 "_" table) ; line graphics
  (set-case-syntax      204 "_" table) ; line graphics
  (set-case-syntax      205 "_" table) ; line graphics
  (set-case-syntax      206 "_" table) ; line graphics
  (set-case-syntax      207 "_" table) ; ???
  ;;                    208            ; See 209
  (set-case-syntax-pair 209 208 table) ; D with stroke, Icelandic eth
  (set-case-syntax-pair 210 136 table) ; E with circumflex accent
  (set-case-syntax-pair 211 137 table) ; E with diaeresis or umlaut mark
  (set-case-syntax-pair 212 138 table) ; E with grave accent
  (set-case-syntax      213 "_" table) ; ???
  (set-case-syntax-pair 214 161 table) ; I with acute accent
  (set-case-syntax-pair 215 140 table) ; I with circumflex accent
  (set-case-syntax-pair 216 139 table) ; I with diaeresis or umlaut mark
  (set-case-syntax      217 "_" table) ; line graphics
  (set-case-syntax      218 "_" table) ; line graphics
  (set-case-syntax      219 "_" table) ; block graphics
  (set-case-syntax      220 "_" table) ; block graphics
  (set-case-syntax      221 "_" table) ; broken vertical line
  (set-case-syntax-pair 222 141 table) ; I with grave accent
  (set-case-syntax      223 "_" table) ; block graphics
  (set-case-syntax-pair 224 162 table) ; O with acute accent
  (set-case-syntax      225 "w" table) ; small sharp s, German
  (set-case-syntax-pair 226 147 table) ; O with circumflex accent
  (set-case-syntax-pair 227 149 table) ; O with grave accent
  ;;                    228            ; See 229
  (set-case-syntax-pair 229 228 table) ; O with tilde
  (set-case-syntax      230 "_" table) ; micro sign
  ;;                    231            ; See 232
  (set-case-syntax-pair 232 231 table) ; thorn, Icelandic
  (set-case-syntax-pair 233 163 table) ; U with acute accent
  (set-case-syntax-pair 234 150 table) ; U with circumflex accent
  (set-case-syntax-pair 235 151 table) ; U with grave accent
  ;;                    236            ; See 237
  (set-case-syntax-pair 237 236 table) ; Y with acute accent
  (set-case-syntax      238 "w" table) ; macron
  (set-case-syntax      239 "w" table) ; acute accent
  (set-case-syntax      240 "_" table) ; ???
  (set-case-syntax      241 "_" table) ; plus or minus sign
  (set-case-syntax      242 "_" table) ; ???
  (set-case-syntax      243 "_" table) ; fraction three-quarters
  (set-case-syntax      244 "w" table) ; pilcrow
  (set-case-syntax      245 "w" table) ; section sign
  (set-case-syntax      246 "_" table) ; division sign
  (set-case-syntax      247 "w" table) ; cedilla
  (set-case-syntax      248 "_" table) ; degree sign
  (set-case-syntax      249 "w" table) ; diaeresis
  (set-case-syntax      250 "_" table) ; middle dot
  (set-case-syntax      251 "w" table) ; superscript one
  (set-case-syntax      252 "w" table) ; superscript three
  (set-case-syntax      253 "w" table) ; superscript two
  (set-case-syntax      254 "_" table) ; ???
  (set-case-syntax      255 " " table) ; space
  (set-standard-case-table (list table)))

(provide 'cp850)

;;; cp850.el ends here
