	name	BRK
	page	55,132
	title	'CTRL-BRK and CTRL-C disble and enable controller'

COMMENT @

  COPYRIGHT (c) John Pulliam, Walter Cox, Benjamin J. Diss 
                October 15, 1987, April 4, 1988

	This is a simple device driver that disables the Ctrl-C and
  Ctrl-Break interrupts.  It may be toggled on or off by sending the word 'on'
  or the word 'off' to the driver.  The driver is installed with the name
  'ctrl-brk'.  

  ex.

  copy con ctrl-brk
  off
  ^Z

              1 file(s) copied

  To assist in communicating with the driver a utility called nobrk is included.
  It will send the command tail to the driver called 'ctrl-brk'.

  The driver operates by intercepting all keystokes and looking for ctrl-brk
  and ctrl-c.  If active it will intercept them, it not active it passes the
  keystokes to the appropriate handler.

  This program is provided "AS IS" and the authors assume NO LIABILITY
  for damages from the use of this program.

     For DOS 2.0 +.
@


code	segment	public	'CODE'

driver	proc	far

	assume	cs:code,ds:code,es:code

	org	0

ctrl	equ	04h		; Ctrl Key is Depressed

seg40	equ	40h		; Keyboard buffer segment
kbflag	equ	17h		; Offset of KBFLAG in SEG 40H
kbinctl	equ	60h		; Keyboard IN port address
kbcmdp	equ	61h		; Keyboard COMMAND port address


init_cmd	equ	0
read_cmd	equ	4
write_cmd	equ	8

cr	equ	0dh
lf	equ	0ah
eom	equ	'$'

;
;	device driver header
;

header	dd	-1	; link to next device, -1 = end of list

	dw	8000h	; device Attribute Word
	dw	strat	; device stratagy entry point
	dw	intr	; device interrupt entry point
	db	'CTRL-BRK'	; character device name

rh_ptr	dd	?
	page

dispatch:
	dw	init
	dw	write

request struc

rlength	db	?
unit	db	?
command	db	?
status	dw	?
reserve	db	8 dup (?)
media	db	?
address	dd	?
count	dw	?
sector	dw	?

request	ends
	page

msg_len	dw	?

flag	db	1		; NOBRK turned ON or OFF (1 = ON, 0 = OFF)
kbseg	dw	SEG40		; Keyboard Segment
int09:	dw	0,0		; Store KBD BIOS interrupt 09 hex vector here

strat	proc	far

	mov	word ptr cs:[rh_ptr],bx
	mov	word ptr cs:[rh_ptr+2],es
	ret

strat	endp

	page

intr	proc	far

	push	ax	; save general registers
	push	bx
	push	cx
	push	dx
	push	ds
	push	es
	push	di
	push	si
	push	bp

	push	cs	; make local data addressable
	pop	ds

	les	di,[rh_ptr]	; let es:di = request header

	mov	bl,es:[di.command]	; get bx = command code
	xor	bh,bh

	cmp	bx,init_cmd	; check for init command
	je	intr1

	cmp	bx,read_cmd	; check for read command
	jne	test_write
	mov	ax,800bh
	jmp	intr2

test_write:	cmp	bx,write_cmd	; check for write command
	jne	cmd_error
	mov	bx,1
	jmp	intr1

cmd_error:	mov	ax,8003h	; set error bit and unknown command code
	jmp	intr2

intr1:	shl	bx,1	; form index to dispatch table
	call	word ptr [bx+dispatch]	; and branch to driver routine
			; should return ax=status
	les	di,[rh_ptr]	; restore es:di = addr of request header

intr2:	or	ax,0100h	; merge done bit into status, and
	mov	es:[di.status],ax	; store into request header

	pop	bp
	pop	si
	pop	di
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret		; back to dos

	page

write	proc	near

	mov	dx,es:[di]+14	; offset of string
	mov	ds,es:[di]+16	; segment of string
	mov	cx,es:[di]+18	; number of bytes in string

	mov	cs:msg_len,cx	; store number of bytes on stack
	cld

	push	ds
	pop	es

	mov	di,dx
	mov	al,'F'	; look in string for 'F'
repne	scasb		; set cf = 0 if found, 1 if not
	je	brk_off	; jump if cf = 0

	mov	di,dx
	mov	al,'f'	; look in string for 'f'
	mov	cx,cs:msg_len	; restore number of bytes
repne	scasb		; set cf = 0 if found, 1 if not
	je	brk_off	; jump if cf = 0

	mov	di,dx
	mov	al,'N'	; look in string for 'N'
	mov	cx,cs:msg_len	; restore number of bytes
repne	scasb		; set cf = 0 if found, 1 if not
	je	brk_on	; jump if cf = 0

	mov	di,dx
	mov	al,'n'	; look in string for 'n'
	mov	cx,cs:msg_len	; restore number of bytes
repne	scasb		; set cf = 0 if found, 1 if not
	je	brk_on	; jump if cf = 0
	jmp	done

brk_on:	mov	cs:flag,0
	jmp	done

brk_off:	mov	cs:flag,1

done:	xor	ax,ax
	ret

write	endp

chkkey:	pushf		; Save all registers
	push	ax
	push	cx
	push	di
	push	si
	push	ds
	push	es
	sti		; Allow other interrupts to occur

	mov	ax,cs
	mov	ds,ax	; Set DS to this segment
	mov	es,word ptr cs:kbseg	; Set ES to segment of keyboard buffer
	mov	si,kbflag	; 40:17H Where DOS keeps track of shift state
	mov	ah,es:[si]	; Get key input

; If OFF, then skip to exit, else see if we need to kill the Ctrl-C
;	(AH contains the latest KBFLAG value)

	test	cs:flag,1	; Ignore Ctrl-C or Ctrl-Break ?
	jz	exit	; Branch if OFF

	test	ah,ctrl	; Is Control Key pressed?
	jz	exit	; No, pass the key to BIOS routine
	test	ah,0bh	; Is ALT, LEFT or RIGHT SHIFT pressed ?
	jnz	exit	; No, pass the key to BIOS routine

	in	al,kbinctl	; Get the key code
	cmp	al,46	; ^C?
	je	kill	; Yes, kill it
	cmp	al,70	; ^BREAK?
	jne	exit	; No, exit to BIOS

;----- Kill ^C or ^BREAK

kill:	in	al,kbcmdp	; Read the KB command port
	mov	ah,al	; Copy it to AH
	or	al,80h	; Set RESET bit
	out	kbcmdp,al	; Write RESET to the command port
	mov	al,ah	; Clear the RESET bit
	out	kbcmdp,al	; and write to the command port
	mov	al,20h	; Send END OF INTERRUPT to the interrupt cont.
	out	20h,al

	pop	es	; Restore all registers
	pop	ds
	pop	si
	pop	di
	pop	cx
	pop	ax
	popf
	iret		; Return to the interrupted routine


; Restore registers and exit to the DOS keyboard interrupt handler

exit:	pop	es	; Restore all registers
	pop	ds
	pop	si
	pop	di
	pop	cx
	pop	ax
	popf
	jmp	dword ptr cs:int09	; Exit to BIOS keyboard interrupt routine


init	proc	near

	push	es	; save address of request header
	push	di

	mov	ax,3509h	; Get Interrupt Vector function
	int	21h	; Execute DOS function
	mov	word ptr int09,bx	; Store BIOS offset for INT 09
	mov	word ptr int09+2,es	; Store BIOS segment for INT 09
	mov	dx,offset chkkey	; New INT 09 vector
	mov	ax,2509h	; Set Interrupt Vector function
	int	21h	; Execute DOS function

	mov	ah,9	; print sign-on message
	mov	dx,offset message
	int	21h

	pop	di	; restore request header addr
	pop	es

	mov	word ptr es:[di.address],offset init
	mov	word ptr es:[di.address+2],cs

	xor	ax,ax
	ret

init	endp

message	db	cr,lf
	db	'CTRL-BRK - A device driver to intercept ctrl-brk and ctrl-c.'
	db	cr,lf
	db	'(C) 1987, 1988 John Pulliam, Walter Cox, and Benjamin Diss.'
	db	cr,lf,lf,eom

intr	endp

	page

driver	endp

code	ends

	end

