1           E  < U U U U U C:\WORD\STANDARD.DFV                                                HPW5A   V @ Jx!  U U   U R/*
  TBMOUS.PRG by Hannes Ziegler CIS 100142,302
  Version 0.0  Oct 03 1993

  Contains:
    Func TBMouse( oTBrowse )
    Static Func TBEvent( oTBrowse, lInit )
    Static Func TBKeyBoard( oTBrowse, nKey )

	Requirements:
    NANFOR.LIB (Availible in CI$, NanForum Toolkit)

	What is it good for:
    The code gives mouse control to any TBrowse. It is the very first
    version and it's more or less in experimental state. The reason that
    I have uploaded the code in this state is to get your opinion about
    how a general mouse control of TBrowse should look like.
    (What are your "nice to have's" ?)
    
  What can you do:
    Create a TBrowse in some code, link it with NANFOR.LIB and pass
    TBrowse to TBMouse( oTbrowse ), then watch and play with it.
  
  Current mouse control:
    If you press the left mouse button, TBrowse will follow the mouse
    as long as the mouse cursor is within oTBrowse:nTop/nLeft/nBottom/nRight
    If you press the right button, browsing terminates.
    
    At the moment there are no mouse-sensitive regions other than
    HeadSep/FootSep and oTBrowse:nTop/nLeft/nBottom/nRight. What I
    would like to know is: do you think these regions are sufficient
    or would you prefer to have mouse-sensitive regions within a
    border/frame, that is being drawn around TBrowse? How would you
    define a general mouse control for TBrowse? What are your favorites?

    I'd like to collect answers prior to uploading a mouseable TBrowse.
    So, I appreciate to get your opinion (see second line for my ID).
    
  Disclaimer:
    This code is free. Be aware that TBrowse internals are being
    accessed (it is safe!).
    If you use this code, you know what you are doing.
    
    I hope to hear from you.

*/


#include "inkey.ch"

#define  NO_EVENT                     -1
#define  KEYBOARD_EVENT                0
#define  LBUTTON_PRESSED_EVENT         1
#define  RBUTTON_PRESSED_EVENT         2

************************
Func TBMouse( oTBrowse ) // Pass a TBrowse to func TBMouse()
local nEvent:=NO_EVENT

if empty(oTBrowse:HeadSep)   // Need separators for mouse
  oTBrowse:Headsep:=chr(196)
end

if empty(oTBrowse:FootSep)
  oTBrowse:FootSep:=chr(196)
end

FT_MSHOWCRS()                // Show mouse cursor

while  nEvent != RBUTTON_PRESSED_EVENT 

  // substitute stabilize() loop with event() 
	nEvent := TBEvent( oTBrowse )

	if oTBrowse:HitTop .or. oTBrowse:HitBottom
		tone(1000,0)
		oTBrowse:HitTop := oTBrowse:HitBottom:= .F.
	end

end

FT_MHIDECRS()

return

*******************************************************
Func TBEvent( oTBrowse, lInit ) // Process mouse events
static  snMouseStatus := -1
static  snFirstRow 
static  snLastRow  
static  scTBInternal,	snRequest, snPending
static  snCellTop, snCellLef, snCellRig

local nMouseRow, nMouseCol, nOldRow:=0, nEvent:=NO_EVENT, lWait:=.F., nKey

if lInit!=nil 

	if snMouseStatus < 0
		// Reset mouse once only
	  snMouseStatus := FT_MRESET()
	end

  // Force display and init atail(oTBrowse)
  oTbrowse:configure()
  while ! oTbrowse:stabilize() ; end

	scTBInternal:= atail(oTBrowse)

  // row() of first datarow in browse area
	snFirstRow  := oTBrowse:nTop+bin2i(substr(scTBInternal,33))-1

  // row() of last  datarow in browse area
	snLastRow   := oTBrowse:nTop+bin2i(substr(scTBInternal,35))+1

	return NO_EVENT

end

// Check for keyboard input first
if (nKey := inkey()) != 0
	FT_MHIDECRS()
	nEvent := TBKeyBoard( oTBrowse, nKey )
	while ! oTBrowse:stabilize() ; end
	FT_MSHOWCRS()
end

// No significant key was pressed
if nEvent == NO_EVENT

	while (nEvent := FT_MGETCOORD( @nMouseRow, @nMouseCol )) == LBUTTON_PRESSED_EVENT ;
  .and. FT_MINREGION( oTBrowse:nTop,;
                      oTBrowse:nLeft,;
                      oTBrowse:nBottom,;
                      oTBrowse:nRight  )

		// get current coordinates for TBrowse-cursor
	  snCellTop  := oTBrowse:RowPos + snFirstrow 
	  snCellLef  := col()
	  snCellRig  := snCellLef+oTBrowse:ColWidth(oTBrowse:ColPos)-1
    lWait      := .F.

		if nOldRow != nMouseRow  // row() changed while mousing
			oTBrowse : DeHilite()
			nOldRow  := nMouseRow
		end

		// Move RowPos according to MouseRow
		do case
			case nMouseRow <= snFirstRow    // skip up
				if oTBrowse:RowPos != 1
	        oTBrowse:RowPos := 1
				else
					oTBrowse:Up()
					// if mouse is exactly at HeadSep, scroll stepwise
					lWait  := (nMouseRow == snFirstRow)
				end

			case nMouseRow >= snLastRow     // skip down
				if oTBrowse:RowPos != oTBrowse:RowCount
	        oTBrowse:RowPos := oTBrowse:RowCount
				else
					oTBrowse:Down()
					// if mouse is exactly at FootSep, scroll stepwise
					lWait  := (nMouseRow == snLastRow)
				end

      case nMouseRow  !=	snCellTop
				// This is a wee bit dirty...
        // Calculate how many records are to be skipped in either
        // direction and stuff() it into TBrowse.
        // TBrowse knows pending skips, so add Requested to Pending 
        // (it's the FASTEST way to do it using Clipper code)
			  snRequest := max(snFirstRow,min(snLastRow,nMouseRow)) - snCellTop
				snPending := bin2i(substr(scTBInternal,47))

				if snRequest != snPending
					snPending    += snRequest
					scTBInternal := stuff(scTBInternal,47,2,i2bin(snPending))
					oTBrowse[len(oTBrowse)]:=scTBInternal
				end

	    endcase

			// Move ColPos according to MouseCol
			if nMouseCol < snCellLef
				if oTBrowse:ColPos == 1
					tone(1000,0)
				else
					lWait := (oTBrowse:ColPos == oTBrowse:LeftVisible)
					oTBrowse:Left()
				end

			elseif nMouseCol > snCellRig
				if oTBrowse:ColPos == oTBrowse:ColCount
					tone(1000,0)
				else
					lWait := (oTBrowse:ColPos == oTBrowse:RightVisible)
					oTBrowse:Right()
				end

			end

			FT_MHIDECRS()                      // Hide mouse
			while ! oTBrowse:Stabilize() ; end // Update screen
			FT_MSHOWCRS()                      // Show mouse

			if oTBrowse:HitTop .or. oTBrowse:HitBottom
				exit
			elseif lWait // waitstate is required, otherwise it's too fast
				inkey(.2)
			end

   end

end

return nEvent

******************************************************************
Static Func TBKeyBoard( oTBrowse, nKey ) // process keyboard input
local block := setkey(nKey)

do case
	case valtype(block) == "B";	block   : eval( oTBrowse )
  case nKey == K_UP         ; oTbrowse:up()      
  case nKey == K_DOWN       ; oTbrowse:Down()    
  case nKey == K_LEFT       ; oTbrowse:Left()    
  case nKey == K_RIGHT      ; oTbrowse:Right()   
  case nKey == K_PGDN       ; oTbrowse:PageDown()
  case nKey == K_PGUP       ; oTbrowse:PageUp()  
  case nKey == K_HOME       ; oTbrowse:Home()    
  case nKey == K_END        ; oTbrowse:End()     
  case nKey == K_CTRL_LEFT  ; oTbrowse:PanLeft() 
  case nKey == K_CTRL_RIGHT ; oTbrowse:PanRight()
  case nKey == K_CTRL_PGDN  ; oTbrowse:goBottom()
  case nKey == K_CTRL_PGUP  ; oTbrowse:goTop()   
  case nKey == K_CTRL_HOME  ; oTbrowse:PanHome() 
  case nKey == K_CTRL_END   ; oTbrowse:PanEnd()  
  case nKey == K_ESC        ; return RBUTTON_PRESSED_EVENT
	otherwise                	
    return NO_EVENT
end

return KEYBOARD_EVENT

܀   E                       (  V  X  h                                                              
h          G                                                                        
  U          J                                                                      
  V      '  )  r                                                                      
  -  e  k                                                                            
      (  R  T  n        	                                                              
	  	  $	  &	  B	  `	  e	  g	  	  	  	                                                              
	  	  	  
  
  F
  V
  
  
  
  
                                                              

  
  
  
  
  
  
  !  >  S  h                                                              
h          
      6  R  s                                                              
s  y  {          	
  
  7
  w
                                                              
w
  y
  
  
  
  
  
       %  @                                                              
@  P  y                G                                                              
G  n            M  e                                                                  
        .  5  7  _  j                                                                  
        ,  V  _  a                                                                    
      G  p  y  {        8                                                              
8  ~      6  8  W  w                                                                    
        '  D  a  t  ~                                                                  
        &  9  C  }                                                                    
          K  M  |                                                                    
                  H                                                                
             S                                                                      
  R          Q                                                                      
  %  *  ,  C  E  F                                                                                               (       10.03.9310.03.93  