/*
 * tutor3.c - Turbo C version of Jack Crenshaw's compiler lesson 3
 */
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <string.h>
#include <stdarg.h>

#define NAMESIZE 	9
#define TAB	9
#define	CR	'\n'
#define IsAlpha(c) isalpha ((c))
#define IsDigit(c) isdigit ((c))
#define UpCase(c)  toupper ((c))
#define IsAddop(c) (c) == '+' || (c) == '-'
#define IsMulop(c) (c) == '*' || (c) == '/'
#define IsAlNum(c) isalnum ((c))
#define IsWhite(c) (c) == ' ' || (c) == TAB

char Look;	/* lookahead character */

void Expression (void);

/*
 * Read New Character From Input Stream
 */
void GetChar (void) {
    Look = getchar ();
}

/*
 * Report an Error
 */
void Error (char *fmt, ...) {
    va_list (args);

    printf ("\n\007Error: ");
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
    printf ("\n");
}

/*
 * Report Error and Halt
 */
void Abort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    Error (fmt, args);
    va_end (args);
    exit (1);
}

/*
 * Report What Was Expected
 */
void Expected (char *fmt, ...) {
    va_list args;
    char f[81];

    va_start (args, fmt);
    strcpy (f, fmt);
    Abort (strcat (f, " Expected"), args);
    va_end (args);
}

/*
 * Skip Over Leading White Space
 */
void SkipWhite (void) {
    while (IsWhite (Look))
	GetChar ();
}

/*
 * Match a Specific Input Character
 */
void Match (char x) {
    char s[4];

    if (Look != x) {
        sprintf (s, "'%c'", x);
        Expected (s);
    }
    else {
	GetChar ();
	SkipWhite ();
    }
}

/*
 * Get an Identifier
 */
char *GetName (void) {
    static char Token[NAMESIZE];
    char *c = Token;

    if (! IsAlpha (Look))
        Expected ("Name");
    while (IsAlNum (Look)) {
        *c++ = UpCase (Look);
        GetChar ();
    }
    *c = '\0';
    SkipWhite ();
    return (Token);
}

/*
 * Get a Number
 */
char *GetNum (void) {
    static char Value[NAMESIZE];
    char *c = Value;

    if (! IsDigit (Look))
        Expected ("Integer");
    while (IsDigit(Look)) {
	*c++ = UpCase (Look);
        GetChar ();
    }
    *c = '\0';
    SkipWhite ();
    return (Value);
}

/*
 * Output a String with Tab
 */
void Emit (char *fmt, ...) {
    va_list args;

    printf ("%c", TAB);
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
}

/*
 * Initialize
 */
void Init (void) {
    GetChar ();
    SkipWhite ();
}

/*
 * Parse and Translate an Identifier
 */
void Ident (void) {
    char Name[NAMESIZE];

    strcpy (Name, GetName ());
    if (Look == '(') {
	Match ('(');
	Match (')');
	Emit ("CALL %s\n", Name);
    }
    else
	Emit ("MOV AX,%s\n", Name);
}
/*
 * Parse and Translate a Math Factor
 */
void Factor (void) {

    if (Look == '(') {
	Match ('(');
	Expression ();
	Match (')');
    }
    else if (IsAlpha (Look))
	Ident ();
    else
        Emit ("MOV AX,%s\n", GetNum ());
}

/*
 * Recognize and Translate a Multiply
 */
void Multiply (void) {
    Match ('*');
    Factor ();
    Emit ("POP DX\n");
    Emit ("MUL AX,DX\n");
}

/*
 * Recognize and Translate a Divide
 */
void Divide (void) {
    Match ('/');
    Factor ();
    Emit ("POP DX\n");
    Emit ("XCHG AX,DX\n");
    Emit ("DIV AX,DX\n");
}

/*
 * Parse and Translate a Math Term
 */
void Term (void) {
    Factor ();
    while (IsMulop (Look)) {
        Emit ("PUSH AX\n");
	switch (Look) {
	    case '*' : Multiply (); break;
	    case '/' : Divide (); break;
	    default  : Expected ("Mulop"); break;
	}
    }
}

/*
 * Recognize and Translate an Add
 */
void Add (void) {
    Match ('+');
    Term ();
    Emit ("POP DX\n");
    Emit ("ADD AX,DX\n");
}

/*
 * Recognize and Translate a Subtract
 */
void Subtract (void) {
    Match ('-');
    Term ();
    Emit ("POP DX\n");
    Emit ("SUB AX,DX\n");
    Emit ("NEG AX\n");
}

/*
 * Parse and Translate an Expression
 */
void Expression (void) {
    if (IsAddop (Look))
	Emit ("XOR AX,AX\n");
    else
	Term ();
    while (IsAddop (Look)) {
        Emit ("PUSH AX\n");
        switch (Look) {
	    case '+' : Add (); break;
	    case '-' : Subtract ();  break;
	    default  : Expected ("Addop"); break;
	}
    }
}

/*
 * Parse and Translate an Assignment Statement
 */
void Assignment (void) {
    char Name[NAMESIZE];

    strcpy (Name, GetName ());
    Match ('=');
    Expression ();
    Emit ("MOV %s,AX\n", Name);
}

/*
 * Main Program
 */
void main (void) {
    Init ();
    Assignment ();
    if (Look != CR)
	Expected ("Newline");
}
