/*

    (C) Copyright 1993, Christopher A. Zielinski
    Toronto, Ontario
    CANADA

    CIS: 72723,2701

    Program:    FEval.Prg
    Release:    2.0.0
    Purpose:    To provide a standard Flat ASCII file evaluation.
                Only <nHandle> and <bRecBlock> are required parameters.
    COMPILE:    /N/W
    93-05-13

    ALL RIGHTS RESERVED.
 
                                NO WARRANTY

    PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
    FITNESS FOR A PARTICULAR PURPOSE.

*/


#include "FileIO.CH"


#ifdef TESTING

    PROCEDURE DEMO()

        LOCAL nFmHandle, nToHandle, nLineCopied

              // We'll write each record to a new file for demo!
        LOCAL bRecBlock := { | cCurrentRec | FWRITE( nToHandle, cCurrentRec ) }

              // We'll slow down coping & display the progress.
        LOCAL bDisplay  := { | nFileSz, nCurPos |                                    ;
                               DEVPOS( 12, 32 ),                                     ;
                               QQOUT( TRANSFORM( nCurPos/nFileSz*100, "999.99%" ) ), ;
                               INKEY( 0.25 )                                         ;
                               }

        CLS
        DEVPOS( 10, 10 )
        QQOUT( "Copying FEVAL.prg to DEMO.out" )
        DEVPOS( 12, 10 )
        QQOUT( "Percentage complete: " )

        DEVPOS( 18, 10 )
        QQOUT( "Coping has been slowed down by 0.25 seconds per record..." )

        IF ( nFmHandle := FOPEN( "FEval.prg" ) ) == -1
            ALERT( "FEval.prg could not be opened...  Demo aborted!!!" )
        ELSEIF ( nToHandle := FCREATE( "Demo.out" ) ) == -1
            FCLOSE( nFmHandle )
            ALERT( "Demo.out could not be created...  Demo aborted!!!" )
        ELSE
            FEval( nFmHandle, bRecBlock, bDisplay )
        END

        DEVPOS( 19, 0 )
        FCLOSE( nFmHandle )
        FCLOSE( nToHandle )

        RETURN

#endif


////////////////////////////////////////////////////////////////////////////////
Procedure FEval(            ;
                 nHandle,   ;    && DOS file handle returned by FOPEN
                            ;
                 bRecBlock, ;    && Code block to process each record with.
                            ;    && Only the current record is passed to the CB.
                            ;
                 bDisplay,  ;    && Progress display code block.  The file size,
                            ;    && current position and characters read are
                            ;    && passed in terms of bytes.
                            ;
                 bDOSError, ;    && Code block for handling DOS errors.
                            ;
                 bNoCRLF    ;    && Code block for handling no CRLF after
                            ;    && processing 30,000 bytes.
               )
////////////////////////////////////////////////////////////////////////////////

    #define CRLF    Chr(13)+Chr(10) // Carriage return, line feed.

	#define FileTop( nHandle )			( FSEEK( nHandle, 0, FS_SET 	 ) )
	#define FilePos( nHandle )			( FSEEK( nHandle, 0, FS_RELATIVE ) )
	#define FileBottom( nHandle )		( FSEEK( nHandle, 0, FS_END 	 ) )

	LOCAL nPos, nEOLPos
	LOCAL nFileSize, nCurPos, nChrsRead, nChrsToRead
	LOCAL cBuffer, cLine

	IF bDisplay == NIL	// If not define, provide a undefined code block.
		bDisplay := { || NIL }
	END

	BEGIN SEQUENCE

		nFileSize := FileBottom( nHandle )	// Get file size.
		nCurPos   := FileTop( nHandle )	// Go beginning-of-file.

		WHILE nCurPos != nFileSize	// While .not. EOF.

			nChrsToRead := 80	// Use an 80 character buffer.
			cLine := ""	// Initialize line of text.

			WHILE ( nChrsToRead != 0 )	// While CRLF not found and not end-of-file.

				nChrsToRead := MIN(80,nFileSize-nCurPos)	// Don't read past EOF.

				cBuffer   := SPACE( nChrsToRead )	// Buffer must be same size as nChrsToRead.
				nChrsRead := FREAD( nHandle, @cBuffer, nChrsToRead )

				IF FERROR() != 0	// Check for DOS error condition.
					IF bDOSError == NIL
						ALERT( "Error reading data file!" )
						BREAK
					ELSE
						EVAL( bDOSError )
					END
				END

				nPos := LEN( cLine )
				cLine += LEFT( cBuffer, nChrsRead )
				nEOLPos := AT( (CRLF), cLine )

				IF nEOLPos == 0	// Update buffer and current file position.
					IF LEN(cLine) > 30000	// Critial error, no CRLF found!
						IF bNoCRLF == NIL
							ALERT([Data error reading file!!!])
							BREAK
						ELSE
							EVAL( bNoCRLF )
						END
					End
					nCurPos += nChrsRead
					EVAL( bDisplay, nFileSize, nCurPos, nChrsRead )
				ELSE
					cLine	:= LEFT( cLine, ( nEOLPos + 1 ))
					nCurPos += ( nEOLPos + 1 - nPos )
					FSEEK( nHandle, nCurPos, FS_SET )
					nChrsToRead := 0
					EVAL( bDisplay, nFileSize, nCurPos, (nEOLPos+1-nPos) )
				END
			END

			EVAL( bRecBlock, cLine )

		END

	END SEQUENCE

	#undef CRLF	// Remove macro definition.
	#undef FileTop	// Remove macro definition.
	#undef FilePos	// Remove macro definition.
	#undef FileBottom	// Remove macro definition.

RETURN


