{************************************************}
{                                                }
{ E! for Windows                                 }
{ (c) - Patrick Philippot - 1992,1993            }
{                                                }
{ Sample Extension DLL - version 1.1             }
{                                                }
{ This DLL implements a simple word counter.     }
{ When executed it will count the number of      }
{ words and characters contained in the current  }
{ Editor and display the result in a message box.}
{                                                }
{************************************************}

(*
To use this DLL simply load it from the user menu or add its name to the
list of autoloaded Extension DLLs by using the Autoload dialog box from
the User Menu of EW. That's all.

This Extension DLL uses no hook. Since it attaches itself to the User Menu,
you don't need to run it from the User|Execute Extension Menu. A "Word
Counter" option automatically appears in the User Menu. You may also assign
this extension to a keystroke. See the documentation for a description of
how to assign DLL execution to a keystroke.
*)

{$I compdir.inc}
{$C MOVEABLE PRELOAD DISCARDABLE}

library Counter;

uses WinProcs, WinTypes, EWApiImp, Strings;

const
  Title : PChar = 'Word Counter';

var
  SaveExit : Pointer;
  EntryId  : longint;


function Words(src : PChar) : longint;

var
  Count : longint;
  i,
  len   : word;

const
  Delimiters : set of char =
    ['.', ' ', ',', ';', ':', '\', '/', '(', ')', '{', '}', '[', ']', '-'];

begin
  len := StrLen(src);
  if len = 0 then
    Count := 0
  else begin
    Count := 1;
    i := 0;
    while (i < len) and (src[i] in Delimiters) do
      Inc(i);
    repeat
      while (i < len) and not (src[i] in Delimiters) do
        Inc(i);
      while (i < len) and (src[i] in Delimiters) do
        Inc(i);
      if i < len then
        Inc(Count);
    until i >= len;
  end;
  Words := Count;
end;

function EWExecute(RoutineId : word) : integer; export;

const
  MAXLEN = 255;

var
  index        : integer;
  CharCount,
  WordCount    : longint;
  WordCountStr : array [0..7] of char;
  CharCountStr : array [0..10] of char;
  Message      : array [0..MAXLEN] of char;
  P            : PChar;

begin
  WordCount := 0;
  CharCount := 0;
  for index := 0 to Pred(EWGetLineCount) do begin
    P := EWGetLineAt(index);
    Inc(WordCount, Words(P));
    Inc(CharCount, StrLen(P));
  end;
  StrCopy(Message, EWGetFileName(EWGetCurrentEditor));
  StrCat(Message, ' contains ');
  Str(WordCount, WordCountStr);
  Str(CharCount, CharCountStr);
  StrCat(StrCat(StrCat(StrCat(Message, WordCountStr), ' words and '), CharCountStr), ' characters.');
  MessageBox(EWGetWindowHandle, Message, Title, mb_IconInformation or mb_Ok);
  EWExecute := 0;
end;

procedure LibExit; far;
begin
 {-Remove menu item from User Menu before unloading}
  EWRemoveMenuEntry(EntryId);
  ExitProc := SaveExit;
end;

exports
  EWExecute     index 1;

begin
  SaveExit := ExitProc;
  ExitProc := @LibExit;
 {-Extension attaches itself to the user Menu}
  EntryId := EWAddMenuEntry('counter', Title, 0, EWMNU_Extension, 0);
end.
