DECLARE FUNCTION PlayerDesc$ (FieldType$, PlayerValue AS LONG)
DECLARE FUNCTION PlayerInc (FieldType$, PlayerValue AS LONG)
DECLARE FUNCTION Getkey ()
  
   'DOOM 2 SaveGame Editor (1.666).
   '
   'Purpose: To modify files DOOMSAV?.DSG (the saved-games files).
   '
   'Date: November 29, 1994
   '
   'To be executed in the MSDOS QBASIC Interpreter.
   'The current working directory should contain the .DSG files

   TYPE datat
     Label AS STRING * 20
     FieldType AS STRING * 160
     Address AS INTEGER
   END TYPE

   CONST MAXPLAYERS = 2
   CONST MAXITEMS = 100

   CONST PGUP = -73
   CONST PGDOWN = -81
   CONST LEFT = -75
   CONST RIGHT = -77
   CONST UP = -72
   CONST DOWN = -80
   CONST ENTER = 13
   CONST CTRLC = 3
   CONST ESCAPE = 27
  
   DIM dirlist(40) AS STRING * 60
   DIM datatable(MAXITEMS) AS datat
   DIM PlayerValue(MAXPLAYERS, MAXITEMS) AS LONG
   DIM PlayerCol(MAXPLAYERS) AS INTEGER
   DIM byte1 AS STRING * 1
   DIM byte2 AS STRING * 2
   DIM byte50 AS STRING * 50

   title$ = "DOOM][ SaveGame Editor"
   tmpfile$ = "~DSGEDIT.!~}"
  
   FOR i = 1 TO MAXPLAYERS
     PlayerCol(i) = 3 + (i * 12)
   NEXT i

   FOR i = 1 TO 40
     dirlist(i) = SPACE$(60)
   NEXT i
  
   SCREEN 0
   WIDTH 80, 50
   COLOR 7, 1
   GOSUB loaddata
   GOSUB getdirlisting
  
   DO
     GOSUB displaydirlisting
     LOCATE 49, 49: LINE INPUT ; todo$
     IF RTRIM$(todo$) = "" THEN EXIT DO
     IF dirlength = 0 THEN EXIT DO
     filenum = INT(VAL(todo$))
     IF filenum >= 1 AND filenum <= dirlength THEN
        OPEN LEFT$(dirlist(filenum), 12) FOR BINARY AS #2
        GOSUB displayplayer
        GOSUB editplayer
        CLOSE #2
     ELSE
        LOCATE 49, 1: PRINT SPACE$(78);
        LOCATE 49, 1: PRINT "INVALID SAVEGAME NUMBER.  PRESS [ENTER]...";
        LINE INPUT ; todo$
     END IF
   LOOP
  
   SCREEN 0
   WIDTH 80, 25
   END

getdirlisting:
   SHELL "dir *.dsg > " + tmpfile$   'Generate directory listing into text file
   OPEN tmpfile$ FOR INPUT AS #1
  
   i = 0
   ERASE dirlist       'Clear out .DSG directory listing array
   DO WHILE EOF(1) = 0   'Load .DSG directory listing into array from tmp file
      LINE INPUT #1, buffer$
      IF LEN(buffer$) > 40 AND MID$(buffer$, 14, 3) <> "DIR" AND MID$(buffer$, 10, 3) = "DSG" THEN
         i = i + 1
         dirlist(i) = RTRIM$(MID$(buffer$, 1, 8)) + "." + RTRIM$(MID$(buffer$, 10, 3))
        
         OPEN dirlist(i) FOR BINARY AS #3  'Get .DSG file description
           GET #3, 1, byte50
           tmp1 = INSTR(1, byte50, CHR$(0))
           IF tmp1 > 1 THEN
             MID$(dirlist(i), 16, tmp1 - 1) = MID$(byte50, 1, tmp1 - 1)
             MID$(dirlist(i), 45, 11) = MID$(byte50, 25, 11)
           END IF
         CLOSE #3

      END IF
      IF i >= 40 THEN EXIT DO
   LOOP
   CLOSE #1
   KILL tmpfile$
   dirlength = i
RETURN

displaydirlisting:
   CLS
   LOCATE 1, 1: PRINT title$
   LOCATE 1, 32: PRINT "Saved-Game Directory Listing"
   
   COLOR 15, 1
   LOCATE 3, 15: PRINT "Filename";
   LOCATE 3, 30: PRINT "Description";
   LOCATE 3, 59: PRINT "Version";
   COLOR 7, 1

   FOR i = 1 TO dirlength
     LOCATE i + 3, 10: PRINT RTRIM$(STR$(i)); ") ", dirlist(i)
   NEXT i
   IF dirlength = 0 THEN
     LOCATE 4, 10: PRINT "<No .DSG Files found>"
     LOCATE 49, 1: PRINT "[ENTER] = Exit.";
   ELSE
     LOCATE 49, 1: PRINT "Enter SaveGame number to edit, [ENTER] to quit: ";
   END IF
   
RETURN


readdatafile:
 
  'Load Player Data

  FOR Player = 1 TO MAXPLAYERS
    FOR i = 1 TO datatablelen
      GET #2, datatable(i).Address + 1 + ((Player - 1) * 280), byte2
      a = ASC(LEFT$(byte2, 1))
      b = ASC(RIGHT$(byte2, 1))
      readtmp$ = RTRIM$(datatable(i).FieldType)
      IF readtmp$ = "Int" OR readtmp$ = "2123" THEN
        PlayerValue(Player, i) = a + (256 * b)
      ELSE
        PlayerValue(Player, i) = a
      END IF
    NEXT i
  NEXT Player
 
RETURN

writedatafile:
  'Player Write data
 
  FOR Player = 1 TO MAXPLAYERS
    FOR i = 1 TO datatablelen
      b = INT(PlayerValue(Player, i) / 256)
      a = PlayerValue(Player, i) - (b * 256)
   
      writetmp$ = RTRIM$(datatable(i).FieldType)
      IF writetmp$ = "Int" OR writetmp$ = "2123" THEN
        byte2 = CHR$(a) + CHR$(b)
        PUT #2, datatable(i).Address + 1 + ((Player - 1) * 280), byte2
      ELSE
        byte1 = CHR$(a)
        PUT #2, datatable(i).Address + 1 + ((Player - 1) * 280), byte1
      END IF
    NEXT i
  NEXT Player

RETURN

displayplayer:
  CLS
 
  GOSUB readdatafile

  LOCATE 1, 1: PRINT title$;
  LOCATE 1, 32: PRINT "Current File: "; MID$(dirlist(filenum), 1, 30);

  COLOR 15, 1
  FOR i = 1 TO MAXPLAYERS
    LOCATE 2, PlayerCol(i): PRINT "Player"; LTRIM$(STR$(i));
  NEXT i
  COLOR 7, 1

  '
  'Print Player data
  '
  FOR i = 1 TO datatablelen
    LOCATE i + 2, 1: PRINT datatable(i).Label;
    FOR j = 1 TO MAXPLAYERS
      SELECT CASE RTRIM$(datatable(i).FieldType)
         CASE IS = "Int", "2123"
           tmpdata$ = LTRIM$(STR$(PlayerValue(j, i)))
         CASE ELSE
           tmpdata$ = PlayerDesc$(datatable(i).FieldType, PlayerValue(j, i))
      END SELECT
      LOCATE i + 2, PlayerCol(j): PRINT tmpdata$;
    NEXT j
  NEXT i

  LOCATE 49, 1: PRINT "Arrows = Move   + or =: Add1    - or _: Sub1    PGUP: Add10  PGDOWN: Sub10";
  LOCATE 50, 1: PRINT "ESCAPE = Done   . or >: Add100  , or <: Sub100    SPACEBAR = Toggle";

RETURN

editplayer:
  Player = 1
  item = 1

  DO
    LOCATE item + 2, PlayerCol(Player) - 1, 1, 0, 8
    keyhit = Getkey
    
    SELECT CASE keyhit
      CASE IS = ESCAPE, CTRLC
        EXIT DO
      CASE IS = LEFT
        Player = Player - 1
        IF Player < 1 THEN
          Player = MAXPLAYERS
          item = item - 1
        END IF
        IF item < 1 THEN item = 1
      CASE IS = RIGHT
        Player = Player + 1
        IF Player > MAXPLAYERS THEN
          Player = 1
          item = item + 1
        END IF
        IF item > datatablelen THEN item = datatablelen
      CASE IS = UP
        IF item > 1 THEN item = item - 1
      CASE IS = DOWN
        IF item < datatablelen THEN item = item + 1
      CASE IS = PGUP
        changeval = 10
        GOSUB increment
      CASE IS = PGDOWN
        changeval = 10
        GOSUB decrement
      CASE IS = ASC("-"), ASC("_")
        changeval = 1
        GOSUB decrement
      CASE IS = ASC("="), ASC("+")
        changeval = 1
        GOSUB increment
      CASE IS = ASC("["), ASC(","), ASC("<")
        changeval = 100
        GOSUB decrement
      CASE IS = ASC("]"), ASC("."), ASC(">")
        changeval = 100
        GOSUB increment
      CASE IS = 32   'Spacebar
        fieldtypetmp$ = RTRIM$(datatable(item).FieldType)
          IF fieldtypetmp$ <> "Int" AND fieldtypetmp$ <> "2123" THEN
          PlayerValue(Player, item) = PlayerInc(datatable(item).FieldType, PlayerValue(Player, item))
          LOCATE item + 2, PlayerCol(Player)
          PRINT PlayerDesc$(datatable(item).FieldType, PlayerValue(Player, item))
        END IF
      CASE ELSE
    END SELECT
  LOOP
  
  
  DO
    LOCATE 48, 1: PRINT SPACE$(60);
    LOCATE 48, 1: PRINT "Save changes? (Y/N) ";
    keyhit = Getkey
    SELECT CASE keyhit
      CASE ASC("Y"), ASC("y")
        PRINT "Yes, Writing changes...";
        GOSUB writedatafile
        EXIT DO
      CASE ASC("N"), ASC("n")
        PRINT "No, exiting.";
        EXIT DO
      CASE ELSE
    END SELECT
  LOOP

RETURN

increment:
  incrtmp$ = RTRIM$(datatable(item).FieldType)
  IF incrtmp$ = "2123" THEN
    changeval = 2123
    incrtmp$ = "Int"
  END IF
  IF incrtmp$ = "Int" THEN
     PlayerValue(Player, item) = PlayerValue(Player, item) + changeval
     IF PlayerValue(Player, item) > 64000 THEN PlayerValue(Player, item) = 64000
     LOCATE item + 2, PlayerCol(Player)
     PRINT LEFT$(LTRIM$(STR$(PlayerValue(Player, item))) + SPACE$(5), 5);
  END IF
RETURN

decrement:
  incrtmp$ = RTRIM$(datatable(item).FieldType)
  IF incrtmp$ = "2123" THEN
    changeval = 2123
    incrtmp$ = "Int"
  END IF
  IF incrtmp$ = "Int" THEN
     PlayerValue(Player, item) = PlayerValue(Player, item) - changeval
     IF PlayerValue(Player, item) < 0 THEN PlayerValue(Player, item) = 0
     LOCATE item + 2, PlayerCol(Player)
     PRINT LEFT$(LTRIM$(STR$(PlayerValue(Player, item))) + SPACE$(5), 5);
  END IF
RETURN

loaddata:
  i = 1

  FOR i = 1 TO MAXITEMS
    READ tmp1$, tmp3, tmp2$
    IF tmp3 = -1 THEN EXIT FOR
    datatable(i).Label = tmp1$
    datatable(i).FieldType = tmp2$
    datatable(i).Address = tmp3
    FOR Player = 1 TO MAXPLAYERS
      PlayerValue(Player, i) = 0
    NEXT Player
  NEXT i

  datatablelen = i - 1

RETURN

'    Label        Addr Field Type
'    ==========    === =================
DATA Health       , 84,Int
DATA Armor        , 88,Int
DATA Invulnerable , 96,2123
DATA Beserk       ,100,2123
DATA Invisible    ,104,2123
DATA Radiation    ,108,2123
DATA Computer Map?,112,(0)No _(1)Yes_
DATA Light Amp    ,116,2123
DATA Blue Key?    ,120,(0)No _(1)Yes_
DATA Yellow Key?  ,124,(0)No _(1)Yes_
DATA Red Key?     ,128,(0)No _(1)Yes_
DATA Blu Skul Key?,132,(0)No _(1)Yes_
DATA Yel Skul Key?,136,(0)No _(1)Yes_
DATA Red Skul Key?,140,(0)No _(1)Yes_
DATA #Player Kills,148,Int
DATA Curr Weapon  ,164,(0)Knuckles  _(1)Pistol    _(2)Shot gun  _(3)Chain gun _(4)Rocket gun_(5)Plasma gun_(6)BFG9000   _(7)Chainsaw  _(8)Supershotg_
DATA Pistol?      ,176,(0)No _(1)Yes_
DATA Shotgun?     ,180,(0)No _(1)Yes_
DATA Chaingun?    ,184,(0)No _(1)Yes_
DATA Rocketgun?   ,188,(0)No _(1)Yes_
DATA Plasmagun?   ,192,(0)No _(1)Yes_
DATA BFG9000?     ,196,(0)No _(1)Yes_
DATA Chainsaw?    ,200,(0)No _(1)Yes_
DATA SuperShotgun?,204,(0)No _(1)Yes_
DATA #Bullets     ,208,Int
DATA #Shells      ,212,Int
DATA #Cells       ,216,Int
DATA #Rockets     ,220,Int
DATA Max Bullets  ,224,Int
DATA Max Shells   ,228,Int
DATA Max Cells    ,232,Int
DATA Max Rockets  ,236,Int
DATA Special      ,248,(0)None       _(1)Thru walls _(2)God Mode   _(3)God+ThrWall_
DATA Bonus Health ,260,Int


DATA -1,-1,-1

FUNCTION Getkey
  
  DO
    tmp$ = INKEY$
  LOOP WHILE tmp$ = ""
 
  IF LEN(tmp$) > 1 THEN
    returnval = -ASC(RIGHT$(tmp$, 1))
  ELSE
    returnval = ASC(tmp$)
  END IF

  Getkey = returnval

END FUNCTION

FUNCTION PlayerDesc$ (FieldType$, PlayerValue AS LONG)
  tmp1 = INSTR(1, FieldType$, "(" + LTRIM$(RTRIM$(STR$(PlayerValue))) + ")")
  IF tmp1 = 0 THEN
    PlayerDesc$ = "   "
    EXIT FUNCTION
  END IF
 
  tmp2 = INSTR(tmp1, FieldType$, ")")
  tmp3 = INSTR(tmp1, FieldType$, "_")

  IF tmp3 = 0 THEN tmp3 = LEN(FieldType$)
  IF tmp2 + 1 >= tmp3 - 1 THEN
    PlayerDesc$ = "   "
    EXIT FUNCTION
  END IF
  PlayerDesc$ = MID$(FieldType$, tmp2 + 1, tmp3 - tmp2 - 1)
END FUNCTION

FUNCTION PlayerInc (FieldType$, PlayerValue AS LONG)

   tmp1 = INSTR(1, FieldType$, "(" + LTRIM$(RTRIM$(STR$(PlayerValue))) + ")")
PRINT PlayerValue

   IF tmp1 = 0 THEN
     PlayerInc = PlayerValue
     EXIT FUNCTION
   END IF

   tmp2 = INSTR(tmp1 + 1, FieldType$, "(")
   IF tmp2 = 0 THEN
     GOSUB WrapAround
     EXIT FUNCTION
   END IF
    
   tmp3 = INSTR(tmp2, FieldType$, ")")
    
   IF tmp3 = 0 THEN
     GOSUB WrapAround
     EXIT FUNCTION
   END IF

   IF tmp2 >= tmp3 THEN
     PlayerInc = 0
     EXIT FUNCTION
   END IF

   PlayerInc = VAL(MID$(FieldType$, tmp2 + 1, tmp3 - tmp2 - 1))
   EXIT FUNCTION

WrapAround:
  
  tmp2 = INSTR(1, FieldType$, "(")
  IF tmp2 = 0 THEN
    PlayerInc = PlayerValue
    RETURN
  END IF

  tmp3 = INSTR(tmp2, FieldType$, ")")
  IF tmp3 = 0 THEN
    PlayerInc = PlayerValue
    RETURN
  END IF
  
  PlayerInc = VAL(MID$(FieldType$, tmp2 + 1, tmp3 - tmp2 - 1))
  RETURN

END FUNCTION

