/* wad2lmp takes a "wad" created with dmgraph (from
   a single entry wad and a gif) and makes temp.lmp */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <malloc.h>
#include <fcntl.h>

int	fhw, fhl;

void error(char *errstr)
{	printf(errstr);
	exit(1);	}

main(argc,argv)
int argc;
char *argv[];
{
	int	i;
	long	lmpsize;
	char	*lmp;
	
	if (argc != 3)
		error("Usage: wad2lmp <wadfile> <lmpfile>\n");
	
	if (!(fhw=open(argv[1], O_BINARY|O_RDONLY)))
		error("Can't open <wadfile>.\n");
	for (i=0; i<6; i++)
		read(fhw, &lmpsize, 4);
	if ((lmp=(char *)malloc(lmpsize))==NULL)
		error("Can't allocate space for lmp.\n");
	read (fhw, lmp, 8);
	read(fhw, lmp, lmpsize);
	close(fhw);

	if (!(fhl=open(argv[2],O_CREAT|O_BINARY|O_WRONLY,S_IREAD|S_IWRITE)))
		error("Can't create <lmpfile>.\n");
	write(fhl,lmp,lmpsize);
	close(fhl);

	free(lmp);	
	exit(0);
}