PROGRAM FSP;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.01  : 1993/12/26.  Now discards data from FIRST CD-ROM drive.  DDA
v1.02  : 1994/01/20.  Now only reports valid local (inc. RAM) drives,
                      C through Z.  Remote, SUBST, and CD drives ignored.  DDA
v1.10  : 1994/01/23.  Added volume label info.  Edward Dombek (73727,162)
v1.11  : 1994/01/24.  Integrated various previous suggestions above.  DDA
v1.12  : 1994/08/09.  Changed Total amounts from LongInt to Real.  Now can
                      handle multi-gig drives accurately, provided no single
                      partition exceeds 2 gig (LongInt).  Neil Edward Parks
                      Overall design improvements. DDA

------------------------------------------------------------------------------}

USES Crt, Dos;                       {Crt for colors, Dos for DiskSize/Free.}
CONST
  ProgDesc = 'FSP (Free SPace), v1.12 - DOS Multiple Hard Disk Space Utilization Utility.';
  author   = 'FREE software!  Copyright : 94/08/09 by David Daniel Anderson - Reign Ware.';
  ProgHead = 'DRIVE        ALLOCATED     FREE SPACE    TOTAL SPACE   FREE %   LABEL';
  chart_width = 75;
VAR
  TS,TF,TU : Real;     {bytes of Total space Size/Free/Used}

FUNCTION Comma (r :Real) : STRING; {Used in WriteDriveInfo & WriteTotalInfo}
VAR s : STRING[14];                {Insert commas to break up number string.}
    l : ShortInt;
BEGIN
  Str (r :0 :0, s);
  l:=(Length (s)-2);
  WHILE (l > 1) DO BEGIN 
    Insert (',', s, l);
    Dec (l, 3);
  END;
  Comma:=s;
END;

FUNCTION LeadingZero (w :Word) : STRING;  {Called by WriteDTInf to write time.}
VAR  s : STRING;
BEGIN
  Str (w :0, s);
  IF (Length (s) = 1) THEN
    s:='0'+s;
  LeadingZero:=s;
END;

PROCEDURE WriteDTInf;            {Called by WriteHeader to write Date & Time.}
CONST
  Mon : ARRAY [1..12] OF STRING[9] =
     ('January','February','March','April','May','June','July',
      'August','September','October','November','December');
  comma=#44;
  space=#32;
  colon=#58;
VAR
  Year, Month, Day, dow,
  Hour, Min,   Sec, hund : Word;
  DStr                   : STRING[8];
  YStr                   : STRING[4];
  DateStr                : STRING[chart_width-8];
  offset                 : byte;
BEGIN
  GetDate (Year, Month, Day, dow);
  GetTime (Hour, Min, Sec, hund);
  Str (Day, DStr);
  Str (Year, YStr);
  DateStr:=Mon[Month]+space+DStr+comma+space+YStr;
  offset:=length (DateStr);
  DateStr[0]:=chr (chart_width-8);
  FillChar (DateStr[offset+1], (chart_width-(offset+8)), space);
  WriteLn (DateStr, 
    LeadingZero (Hour)+colon, 
    LeadingZero (Min)+colon, 
    LeadingZero (Sec));
END;

PROCEDURE WriteHeader;                 {Called by main.}
VAR
  hyphens : STRING[chart_width];
BEGIN
  hyphens[0]:=chr (chart_width);
  FillChar (hyphens[1], chart_width, '-');
  TextBackGround (Blue);  TextColor (White);
  WriteLn (ProgDesc);                  {...a constant...}
  WriteLn (author);                    {...a constant...}
  TextBackGround (Black); TextColor (LightBlue);
  WriteDTInf;
  TextColor (LightCyan);
  WriteLn (ProgHead);                  {...a constant...}
  WriteLn (hyphens);
END;

PROCEDURE WritePercent (Free, Space :Real);       { Called by WriteDriveInfo  }
                                                 {         & WriteTotalInfo. }
VAR PF  : Real;          {integer of Percentage Free, initially 10 x %}
BEGIN
  IF (Space > 0) THEN
    PF:=100*(Free/Space)               {Using 100 to give hundredths of %}
  ELSE
    PF:=0;
  TextColor (White);
  Write (PF :8 :2, '%');
END;

PROCEDURE WriteInColor (u, f, s :Real);
BEGIN
  TextColor (LightRed);      Write (Comma (U) :15);
  TextColor (LightGreen);    Write (Comma (F) :15);
  TextColor (LightMagenta);  Write (Comma (S) :15);
END;

PROCEDURE WriteDriveInfo (DriveCounter :char);    {Called by main.}
VAR DS,DF,DU : LongInt;   {bytes of *partition* space Size/Free/Used}
    vLabel   : SearchRec;
    VolName  : STRING[12];
BEGIN
  DS:=DiskSize (ord (DriveCounter)-64);
  IF (DS < 0) THEN BEGIN
    DS:=0;
    DF:=0;
  END
  ELSE
    DF:=DiskFree (ord (DriveCounter)-64);

  DU:=DS-DF;
  TS:=TS+DS;    TF:=TF+DF;    TU:=TU+DU;

  TextColor (Yellow);        Write (DriveCounter, ' -->  ');
  WriteInColor (DU, DF, DS);
  WritePercent (DF, DS);               {...a procedure...}
  FindFirst (DriveCounter+':\*.*', $8, vLabel);
  {...Volume Label...}

  IF (DosError <> 0) THEN
    VolName:='none'
  ELSE BEGIN
    VolName:=vLabel.Name;
    IF (pos ('.', VolName) <> 0) THEN
      delete (VolName, pos ('.', VolName), 1);
    { remove period if present }
  END;
  TextColor (Yellow);        WriteLn ('   ', VolName);
END;

PROCEDURE WriteTotalInfo;                          {Called by main.}
VAR
  EQLine : STRING[chart_width];
BEGIN
  EQLine[0]:=chr (chart_width);
  FillChar (EQLine[1], chart_width, '=');
  TextColor (LightGray);
  WriteLn (EQline);

  TextColor (Yellow);        Write ('TOTALS=');
  WriteInColor (TU, TF, TS);
  WritePercent (TF, TS);               {...a procedure...}
  WriteLn;
END;

{=============================================================================}

FUNCTION IsDriveValid (cDrive :Char; VAR bLocal, bSUBST :Boolean): Boolean;
{ ** portion of a SWAG snippet

  Parameters: cDrive is the drive letter, 'A' to 'Z', that's about
  to be checked. if not in this range, the Function will return False.

  Returns: Function returns True if the given drive is valid, else
  False (!). bLocal is set if drive is local, bSUBST if drive is
  substituted. if Function returns False, the Booleans are undefined.
}
VAR
  rCPU: Dos.Registers;
BEGIN
  { --- Valid letter, set up For the Dos-call --- }
  rCPU.bx:=ord (UpCase (cDrive))-ord ('A')+1;
  rCPU.ax:=$4409;
  { --- Call the Dos IOCTL (InOutConTroL)-Functions --- }
  Intr ($21, rCPU);
  IF ((rCPU.ax AND FCarry) = FCarry) THEN
    IsDriveValid:=False
  ELSE BEGIN
    { --- drive is valid, check status --- }
    IsDriveValid:=True;
    bLocal:=((rCPU.dx AND $1000) = $0000);
    IF (bLocal) THEN
      bSUBST:=((rCPU.dx AND $8000) = $8000)
    ELSE
      bSUBST:=False;
  END;
END; { IsDriveValid }
{=============================================================================}

VAR
  cCurChar : Char ;          { loop counter, drive }
  bLocal,
  bSUBST   : Boolean ;       { drive local/remote?; SUBSTed or not? }

BEGIN
  TS:=0;  TF:=0;  TU:=0;
  IF (STRING (ptr (prefixseg, $0080)^) = '') THEN ClrScr;
  {Clear screen unless ANY parameter given.}

  WriteHeader;                         {...a procedure...}

  FOR cCurChar:=#67 TO #90 DO          { from drive 'C' to drive 'Z' }
    IF (IsDriveValid (cCurChar, bLocal, bSUBST)) THEN
      IF (blocal AND (NOT bSUBST)) THEN
        WriteDriveInfo (cCurChar);

  WriteTotalInfo;                      {...a procedure...}
  NormVideo;
END.
