
/* This program is used to test calling WIZ from another program,
 * and prints out what is returned.
 * I use Borland Turbo-C++ v 1.0.
*/

#include <stdio.h>
#include <dos.h>

/* This is the signature block of the inter-task communication area,
 * between WIZ and the calling program.
 * It must be in the 1st 64K bytes of the calling program.
 * We find it by looking for the two signature words, and the
 * psp being the same segment as the memory control block.
 * -----
 * Then we fill in the area with ASCIZ strings (ending with another
 * NULL, same as the way environment strings are.)
 * The number of strings is returned in ica_size (NOT total size).
 * WIZ will make sure to not overflow this area.  If "ica_size" does not
 * change, then WIZ didn't do anything.
 *
 * WIZ will set "ica_retf" to '.' when it starts.  If any strings would
 * not fit in the area, "ica_retf" gets set to '+'.
*/
struct itc_comm_area {
   int ica_size;	      /* Size of the itc_comm_area (bytes) */
   char ica_retf;	      /* '+' if WIZ couldn't store all the strings */
   char ica_signature_1[8];   /* Signature 1 */
   unsigned int ica_psp;      /* psp segment */
   char ica_signature_2[4];   /* Signature 2 */

   #define ICA_SIGN_1 "Wiz Area"
   #define ICA_SIGN_2 "CRVT"
};



static char the_ica[100];

main()
{
   struct itc_comm_area *p_ica;
   int i;
   char cmd_line[80];
   char *s;

   p_ica = (struct itc_comm_area *)&the_ica;
   puts("Try invoking WIZ with some parameters, & get return");
   go_set_up_ica();

   sprintf(cmd_line, "WIZ -p -z%d c:*.bat", _psp);
   system(cmd_line);
   printf("# of strings returned by WIZ: %d\n", p_ica->ica_size);
   printf("Retf is: \"%c\".\n", p_ica->ica_retf);

   for (s = p_ica->ica_signature_1; *s != 0; ) {
      printf("%s\n", s);
      s += strlen(s) +1;
   }
}




/*****************************/
/*** Set up the ica_area. ****/
go_set_up_ica() {

      struct itc_comm_area *p_ica;

      p_ica = (struct itc_comm_area *)&the_ica;
      memset(the_ica, 0x55, 100);

      p_ica->ica_size = sizeof(the_ica);
      memcpy(p_ica->ica_signature_1, ICA_SIGN_1, 8);
      memcpy(p_ica->ica_signature_2, ICA_SIGN_2, 4);
      p_ica->ica_psp = _psp;
      printf("My ica is at %08lx\n", (char far *)&the_ica);
   };



