***************************************************************************
*
* Procedure file: DRAGEVNT.PRG
*         System: DragDrop
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* DRAGEVNT- Drag event handler.
*
* Description:
* This program is used to handle drag events for DragDrop objects.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
FUNCTION dragevnt
PARAMETERS winname0,objrow0,objcol0,mclktimer,dragicon0,objclass0,objmsg0,;
           objarray,dragfnct,dragheight,dragwidth,centerrow,centercol,;
           objheight0,objwidth0,scnno,colorscheme,dblclkfnct
PRIVATE dragicon,dragicon1,dragicon2,objover,objover2,objclass
PRIVATE iconno,icondelay,icontimer,iconmode,iconstretch,iconcheck
PRIVATE dragtxt,dragtxt1,dragtxt2,objstate,objheight,objwidth
PRIVATE objheight1,objwidth1,fileext,objmsg,objmsg2,dblclick
PRIVATE objrow,objcol,objrow2,objcol2,objrow3,objcol3
PRIVATE objrow0,objcol0,foxtools,maxmove,lastmsgbar,crsrtimer
PRIVATE null,elementno,arraycnt,arrayrows,arraycols
EXTERNAL ARRAY regfn,callfn

m.dblclick=.T.
m.maxmove=SCOLS()/256
DO WHILE MDOWN()
  IF ABS(MROW()-m.objrow0)>=m.maxmove.OR.ABS(MCOL()-m.objcol0)>m.maxmove
    m.dblclick=.F.
    EXIT
  ENDIF
  IF ABS(SECONDS()-m.mclktimer)>_dblclick
    m.dblclick=.F.
  ENDIF
ENDDO
IF MDOWN().OR.EMPTY(m.dblclkfnct)
  m.dblclick=.F.
ENDIF
IF m.dblclick
  m.dblclick=.F.
  DO WHILE .T.
    IF ABS(MROW()-m.objrow0)>=m.maxmove.OR.ABS(MCOL()-m.objcol0)>m.maxmove
      EXIT
    ENDIF
    IF MDOWN()
      m.dblclick=.T.
      EXIT
    ENDIF
    IF ABS(SECONDS()-m.mclktimer)>_dblclick
      EXIT
    ENDIF
  ENDDO
ENDIF
IF m.dblclick
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
  m.objmsg=evlmsg(m.objmsg0)
  IF '('$m.dblclkfnct
    =&dblclkfnct
  ELSE
    DO (m.dblclkfnct)
  ENDIF
  RETURN .F.
ENDIF
IF .NOT.MDOWN()
  RETURN .F.
ENDIF
_FOX25=('2.5'$VERSION())
_FOX25REV=IIF(_FOX25,SUBSTR(VERSION(),AT('2.5',VERSION())+3,1),'')
IF .NOT._FOX25
  _DOS=.T.
  _WINDOWS=.F.
  _MAC=.F.
  _UNIX=.F.
ENDIF
m.null=CHR(0)
IF _WINDOWS.OR._MAC
  m.lastmsgbar=SET('MESSAGE',1)
  SET MESSAGE TO
ELSE
  WAIT CLEAR
ENDIF
IF m.colorscheme<1
  m.colorscheme=1
ENDIF
IF EMPTY(m.dragicon0)
  m.dragicon0=m.null
ENDIF
m.dragicon=m.dragicon0
m.dragicon1=''
m.dragicon2=''
m.objclass=UPPER(ALLTRIM(m.objclass0))
m.objmsg=m.objmsg0
m.objmsg2=''
m.objover=m.null
m.objover2=m.objover
m.objstate=-2
m.dragtxt=''
m.dragtxt1=''
m.dragtxt2=''
m.objheight=m.objheight0
m.objheight1=0
m.objwidth=m.objwidth0
m.objwidth1=0
m.iconmode=.F.
m.iconstretch=.F.
m.iconcheck=.F.
m.objrow2=-999
m.objcol2=-999
m.iconno=-1
m.icondelay=0
m.icontimer=-999
m.crsrtimer=-999
m.foxtools=.F.
IF _WINDOWS
  IF .NOT.'\FOXTOOLS.FLL'$SET('LIBRARY').AND.FILE(SYS(2004)+'FOXTOOLS.FLL')
    SET LIBRARY TO SYS(2004)+'FOXTOOLS' ADDITIVE
  ENDIF
  m.foxtools=('\FOXTOOLS.FLL'$SET('LIBRARY'))
ENDIF
DO WHILE MDOWN()
  m.objrow=MROW(m.winname0)
  m.objcol=MCOL(m.winname0)
  IF m.objrow<0.OR.m.objcol<0
    m.objrow=999
    m.objcol=999
    IF WEXIST('w_dragobj')
      =updwinpos()
    ENDIF
  ENDIF
  IF m.foxtools.AND.(m.objrow2<0.OR.m.objcol2<0.OR.m.objrow=999.OR.;
     m.dragicon1==m.null.OR.ABS(SECONDS()-m.crsrtimer)>=.1)
    m.loadcsr=regfn("LoadCursor","IL","I")
    m.setcsr=regfn("SetCursor","I","I")
    =callfn(m.setcsr,callfn(m.loadcsr,0,IIF(m.objrow=999.OR.;
            m.dragicon1==m.null,32512,0)))
    m.crsrtimer=SECONDS()
  ENDIF
  IF m.objrow=999.AND.m.objrow=m.objrow2.AND.m.objcol=m.objcol2
    LOOP
  ENDIF
  IF m.dragheight>=0.AND.ABS(m.objrow-m.centerrow)>(m.dragheight/2)
    m.objrow=IIF(m.objrow>m.centerrow,m.centerrow+m.dragheight/2,;
                 m.centerrow-m.dragheight/2)
  ENDIF
  IF m.dragwidth>=0.AND.ABS(m.objcol-m.centercol)>(m.dragwidth/2)
    m.objcol=IIF(m.objcol>m.centercol,m.centercol+m.dragwidth/2,;
                 m.centercol-m.dragwidth/2)
  ENDIF
  IF .NOT.WEXIST('w_dragobj')
    =updwinsize(m.dragicon)
    IF _WINDOWS.OR._MAC
      DEFINE WINDOW w_dragobj;
                    FROM 999,999 TO m.objheight1+999,m.objwidth1+999;
                    IN WINDOW (m.winname0) NONE;
                    FONT 'MS Sans Serif',8;
                    COLOR RGB(,,,192,192,192)
    ELSE
      DEFINE WINDOW w_dragobj;
                    FROM 999,999 TO m.objheight1+999,m.objwidth1+999;
                    IN WINDOW (m.winname0) NONE COLOR SCHEME (m.colorscheme)
    ENDIF
    ACTIVATE WINDOW w_dragobj NOSHOW
  ENDIF
  IF EMPTY(m.dragicon)
    m.dragicon=m.dragicon0
    m.objheight=m.objheight0
    m.objwidth=m.objwidth0
    m.iconno=-1
    m.icondelay=0
    m.icontimer=-999
  ENDIF
  IF LEFT(m.dragicon,1)=='@'
    IF ABS(SECONDS()-m.icontimer)>=m.icondelay
      m.dragicon1=evlmsg(m.dragicon)
      IF m.icontimer<0
        m.icontimer=SECONDS()
      ELSE
        m.icontimer=m.icontimer+m.icondelay
      ENDIF
    ELSE
      m.dragicon1=ALLTRIM(m.dragicon2)
    ENDIF
    IF EMPTY(m.dragicon1)
      m.dragicon1=ALLTRIM(m.dragicon2)
      IF LEFT(m.dragicon1,1)=='@'
        m.dragicon1=m.null
      ENDIF
    ENDIF
    IF m.dragicon1==m.null
      m.dragicon1=''
    ENDIF
  ELSE
    m.dragicon1=m.dragicon
    m.iconno=-1
    m.icondelay=0
    m.icontimer=-999
  ENDIF
  IF EMPTY(m.dragicon1)
    m.dragicon1=m.dragicon0
    m.objheight=m.objheight0
    m.objwidth=m.objwidth0
    m.iconno=-1
    m.icondelay=0
    m.icontimer=-999
  ELSE
    m.dragicon1=MLINE(m.dragicon1,1)
  ENDIF
  IF .NOT.m.dragicon1==m.dragicon2
    m.dragicon2=m.dragicon1
    IF m.iconno=-1.AND..NOT.m.dragicon1==m.dragicon0
      IF m.objheight<=0
        m.objheight=-1
      ENDIF
      IF m.objwidth<=0
        m.objwidth=-1
      ENDIF
    ENDIF
    m.fileext=UPPER(RIGHT(m.dragicon1,4))
    IF m.fileext=='.BMP'.OR.m.fileext=='.ICO'
      DO CASE
        CASE .NOT._WINDOWS.AND..NOT._MAC
          m.dragicon1=trimpath(m.dragicon1,.T.)
        CASE m.iconno=-1.AND..NOT.m.iconcheck.AND..NOT.FILE(m.dragicon1)
          m.dragicon1=trimpath(m.dragicon1)+'*'
          m.dragicon0=m.dragicon1
          m.fileext=''
      ENDCASE
    ENDIF
    m.iconcheck=.T.
    DO CASE
      CASE m.dragicon1==m.null
        MOVE WINDOW w_dragobj TO 999,999
        m.objrow2=-999
        m.objcol2=-999
        IF m.foxtools
          m.loadcsr=regfn("LoadCursor","IL","I")
          m.setcsr=regfn("SetCursor","I","I")
          =callfn(m.setcsr,callfn(m.loadcsr,0,32512))
        ENDIF
      CASE (_WINDOWS.OR._MAC).AND.(m.fileext=='.BMP'.OR.m.fileext=='.ICO')
        IF .NOT.m.iconmode.OR.m.objheight>-2.OR.m.objwidth>-2
          m.iconstretch=.F.
          IF m.objheight=0
            m.objheight=m.objheight0
          ENDIF
          DO CASE
            CASE m.objheight=-1.OR.m.objheight=0
              m.objheight1=2.462
            CASE m.objheight>0
              m.objheight1=m.objheight
              m.iconstretch=.T.
          ENDCASE
          IF m.objwidth=0
            m.objwidth=m.objwidth0
          ENDIF
          DO CASE
            CASE m.objwidth=-1.OR.m.objwidth=0
              m.objwidth1=6.4
            CASE m.objwidth>0
              m.objwidth1=m.objwidth
              m.iconstretch=.T.
          ENDCASE
          MODIFY WINDOW w_dragobj;
                        FROM m.objrow-(m.objheight1/2),m.objcol-(m.objwidth1/2);
                        SIZE m.objheight1,m.objwidth1
          m.iconmode=.T.
          m.objheight=-2
          m.objwidth=-2
        ENDIF
        IF .NOT.WOUTPUT('w_dragobj')
          ACTIVATE WINDOW w_dragobj SAME
        ENDIF
        CLEAR
        IF m.iconstretch
          @ 0,0 SAY (m.dragicon1) BITMAP;
                    SIZE WROWS(),WCOLS();
                    STRETCH STYLE 'T'
        ELSE
          @ 0,0 SAY (m.dragicon1) BITMAP;
                    SIZE WROWS(),WCOLS();
                    ISOMETRIC STYLE 'T'
        ENDIF
        IF m.foxtools
          m.loadcsr=regfn("LoadCursor","IL","I")
          m.setcsr=regfn("SetCursor","I","I")
          =callfn(m.setcsr,callfn(m.loadcsr,0,0))
        ENDIF
      OTHERWISE
        =updwinsize(m.dragicon1)
        IF _WINDOWS.OR._MAC
          MODIFY WINDOW w_dragobj;
                        FROM m.objrow-(m.objheight1/2),m.objcol-(m.objwidth1/2);
                        SIZE m.objheight1,m.objwidth1
        ELSE
          ZOOM WINDOW w_dragobj NORM;
                      FROM m.objrow,m.objcol-(m.objwidth1/2);
                      SIZE m.objheight1,m.objwidth1
        ENDIF
        m.iconmode=.F.
        m.objheight=-1
        m.objwidth=-1
        m.iconstretch=.F.
        IF .NOT.WOUTPUT('w_dragobj')
          ACTIVATE WINDOW w_dragobj SAME
        ENDIF
        CLEAR
        IF .NOT.m.dragicon1==m.null
          @ 0,0 SAY m.dragicon1
          IF m.foxtools
            m.loadcsr=regfn("LoadCursor","IL","I")
            m.setcsr=regfn("SetCursor","I","I")
            =callfn(m.setcsr,callfn(m.loadcsr,0,0))
          ENDIF
        ENDIF
    ENDCASE
  ENDIF
  m.dragtxt1=LEFT(evlmsg(m.dragtxt),79)
  IF .NOT.m.dragtxt1==m.dragtxt2
    m.dragtxt2=m.dragtxt1
    IF EMPTY(m.dragtxt1)
      IF _WINDOWS.OR._MAC
        SET MESSAGE TO
      ELSE
        WAIT CLEAR
      ENDIF
    ELSE
      IF _WINDOWS.OR._MAC
        SET MESSAGE TO m.dragtxt1
      ELSE
        WAIT CLEAR
        WAIT m.dragtxt1 WINDOW NOWAIT
      ENDIF
    ENDIF
  ENDIF
  IF m.objstate=1
    m.objstate=0
  ENDIF
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
  m.objmsg=evlmsg(m.objmsg0)
  IF m.objrow#m.objrow2.OR.m.objcol#m.objcol2
    m.objover=dragover()
    IF m.objover==m.null.OR.(.NOT.EMPTY(m.objover2).AND.;
       .NOT.m.objover==m.objover2))
      m.objstate=1
      IF .NOT.m.objover2==m.null
        m.objrow3=m.objrow
        m.objcol3=m.objcol
        m.objrow=m.objrow2
        m.objcol=m.objcol2
        =dragover()
        m.objrow=m.objrow3
        m.objcol=m.objcol3
        m.objstate=1
      ENDIF
    ENDIF
    IF .NOT.EMPTY(m.dragfnct)
      IF '('$m.dragfnct
        =&dragfnct
      ELSE
        DO (m.dragfnct)
      ENDIF
    ENDIF
  ENDIF
  =updwinpos()
  IF .NOT.m.dragicon1==m.null.AND.(.NOT.WVISIBLE('w_dragobj').OR.;
     .NOT.WONTOP('w_dragobj'))
    =updwinpos()
    ACTIVATE WINDOW w_dragobj
  ENDIF
  IF m.objstate#1.OR..NOT.m.objover==m.null
    m.objstate=2
  ENDIF
  m.objmsg2=m.objmsg
  m.objover2=m.objover
  IF m.objrow>=0
    m.objrow2=m.objrow
  ENDIF
  IF m.objcol>=0
    m.objcol2=m.objcol
  ENDIF
ENDDO
RELEASE WINDOW w_dragobj
IF _WINDOWS.OR._MAC
  IF m.lastmsgbar==''
    SET MESSAGE TO
  ELSE
    SET MESSAGE TO m.lastmsgbar
  ENDIF
ELSE
  WAIT CLEAR
ENDIF
IF m.foxtools
  m.loadcsr=regfn("LoadCursor","IL","I")
  m.setcsr=regfn("SetCursor","I","I")
  =callfn(m.setcsr,callfn(m.loadcsr,0,32512))
ENDIF
m.objstate=-1
IF EMPTY(m.objarray)
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
  m.objmsg=evlmsg(m.objmsg0)
  =dragover()
  RETURN .T.
ENDIF
m.arrayrows=IIF(TYPE(m.objarray)=='C',ALEN((m.objarray),1),0)
IF m.arrayrows=0
  RETURN .T.
ENDIF
m.arraycols=ALEN((m.objarray),2)
IF m.arraycols=0
  m.objclass=UPPER(ALLTRIM(evlmsg(m.objclass0)))
ENDIF
FOR m.arraycnt = 1 TO m.arrayrows
  IF m.arraycols=0
    m.objmsg=evlmsg(EVALUATE(m.objarray+'(m.arraycnt)'))
  ELSE
    m.objclass=UPPER(ALLTRIM(evlmsg(EVALUATE(m.objarray+'(m.arraycnt,1)'))))
    m.objmsg=evlmsg(EVALUATE(m.objarray+'(m.arraycnt,2)'))
  ENDIF
  IF .NOT.EMPTY(m.objmsg)
    =dragover()
  ENDIF
ENDFOR
RETURN .T.

* END dragevnt



FUNCTION updwinpos
PRIVATE moverow,movecol

IF (m.objrow=m.objrow2.AND.m.objcol=m.objcol2).OR.m.dragicon1==m.null
  RETURN .F.
ENDIF
IF _WINDOWS.OR._MAC
  m.moverow=m.objrow-(m.objheight1/2)
  m.movecol=m.objcol-(m.objwidth1/2)
ELSE
  m.moverow=m.objrow
  m.movecol=m.objcol-(m.objwidth1/2)
ENDIF
IF MROW('w_dragobj')#m.moverow.OR.MCOL('w_dragobj')#m.movecol
  MOVE WINDOW w_dragobj TO m.moverow,m.movecol
ENDIF
m.crsrtimer=SECONDS()
RETURN .T.

* END updwinpos



FUNCTION updwinsize
PARAMETER m.str_data
PRIVATE m.str_data

IF _WINDOWS.OR._MAC
  m.objheight1=SROWS()/SYSMETRIC(1)*FONTMETRIC(1,WFONT(1,''),WFONT(2,''),;
              WFONT(3,''))+8*SROWS()/SYSMETRIC(1)
  m.objwidth1=TXTWIDTH(m.str_data)+2*SCOLS()/SYSMETRIC(2)
ELSE
  m.objheight1=1
  m.objwidth1=LEN(m.str_data)
ENDIF
RETURN .T.

* END updwinsize



FUNCTION trimext
PARAMETERS m.filename
PRIVATE m.filename,m.at_pos

m.at_pos=AT('.',m.filename)
IF m.at_pos>0
  m.filename=LEFT(m.filename,m.at_pos-1)
ENDIF
RETURN ALLTRIM(m.filename)

* END trimext



FUNCTION trimpath
PARAMETERS m.filename,m.trim_ext
PRIVATE m.filename,m.trim_ext,m.at_pos

IF EMPTY(m.filename)
  RETURN ''
ENDIF
m.at_pos=AT(':',m.filename)
IF m.at_pos>0
  m.filename=SUBSTR(m.filename,m.at_pos+1)
ENDIF
IF m.trim_ext
  m.filename=trimext(m.filename)
ENDIF
RETURN ALLTRIM(SUBSTR(m.filename,AT('\',m.filename,;
       MAX(OCCURS('\',m.filename),1))+1))

* END trimpath



FUNCTION evlmsg
PARAMETERS m.old_str
PRIVATE m.old_text,m.new_text,m.eval_str,m.var_type

IF TYPE('m.old_str')#'C'
  RETURN ''
ENDIF
IF .NOT.LEFT(m.old_str,1)=='@'
  RETURN m.old_str
ENDIF
m.eval_str=EVALUATE(SUBSTR(m.old_str,2))
m.var_type=TYPE('m.eval_str')
DO CASE
  CASE m.var_type=='C'
    m.new_str=m.eval_str
  CASE m.var_type=='N'
    m.new_str=ALLTRIM(STR(m.eval_str,24,12))
    DO WHILE RIGHT(m.new_str,1)=='0'
      m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
      IF RIGHT(m.new_str,1)=='.'
        m.new_str=LEFT(m.new_str,LEN(m.new_str)-1)
        EXIT
      ENDIF
    ENDDO
  CASE m.var_type=='D'
    m.new_str=DTOC(m.eval_str)
  CASE m.var_type=='L'
    m.new_str=IIF(m.eval_str,'.T.','.F.')
  OTHERWISE
    m.new_str=m.old_str
ENDCASE
RETURN m.new_str

* END evlmsg



FUNCTION animate
PARAMETERS m.iconmask,m.iconspeed,m.value1,m.value2,m.valuecount
PRIVATE m.iconmask,m.iconspeed,m.value1,m.value2,m.valuecount
PRIVATE m.ascflag,m.wildcard,m.iconfile

DO CASE
  CASE TYPE('m.value1')=='C'
    m.ascflag=.T.
    m.value1=ASC(m.value1)
    m.value2=ASC(m.value2)
  CASE TYPE('m.value1')#'N'
    RETURN m.iconmask
  OTHERWISE
    m.ascflag=.F.
ENDCASE
DO CASE
  CASE '??'$m.iconmask
    m.wildcard='??'
  CASE '?'$m.iconmask
    m.wildcard='?'
  OTHERWISE
    RETURN m.iconmask
ENDCASE
IF TYPE('m.iconspeed')#'N'
  m.iconspeed=0
ENDIF
m.icondelay=IIF(m.iconspeed<=0,0,1/m.iconspeed)
IF m.value2>=m.value1
  IF TYPE('m.valuecount')#'N'
    m.valuecount=1
  ENDIF
  IF .NOT.BETWEEN(m.iconno,m.value1,m.value2)
    m.iconno=m.value1
  ENDIF
ELSE
  IF TYPE('m.valuecount')#'N'
    m.valuecount=-1
  ENDIF
  IF .NOT.BETWEEN(m.iconno,m.value2,m.value1)
    m.iconno=m.value1
  ENDIF
ENDIF
IF m.ascflag
  m.iconfile=CHR(m.iconno)
ELSE
  m.iconfile=ALLTRIM(STR(m.iconno,2))
  IF LEN(m.wildcard)>LEN(m.iconfile)
    m.iconfile=REPLICATE('0',LEN(m.wildcard)-LEN(m.iconfile))+m.iconfile
  ENDIF
ENDIF
m.iconfile=STRTRAN(m.iconmask,m.wildcard,m.iconfile,1,1)
m.iconno=m.iconno+m.valuecount
IF m.foxtools
  m.loadcsr=regfn("LoadCursor","IL","I")
  m.setcsr=regfn("SetCursor","I","I")
  =callfn(m.setcsr,callfn(m.loadcsr,0,0))
ENDIF
RETURN m.iconfile

* END animate
