/*
 * This is a sample input mask, which verifies the data entered in the
 * "LastVersion" and "ReleaseDate" fields.
 *
 * Below are the input mask specification lines:
 * - the first column is the field's name
 * - the second column tells if we must call the AREXX script to check
 *   a new value entered (enter "-" if no, anything else if yes)
 * - the third column is the message to display at the bottom of the screen
 *
 * There is no obligation to provide a specification for each field, although
 * you should.
 *
 * $MSG
 *	Name		-	Program name
 *	LastVersion	y	Last version's number
 *	Size		-	Last version's size
 *	ReleaseDate	y	Last version's release date
 *	Shareware	-	Shareware flag
 *	Description	-	Short description of the program
 * $END
 *			^
 *			|
 *			+-- as you can see, this script will be called only
 *			    for "LastVersion" and "ReleaseDate" fields.
 */

/*
 * Get arguments
 * The script is called with the field's name as first argument, and
 * the new value to check as second argument
 */

PARSE ARG Field NewValue

/*
 * Check the LastVersion field
 * We must have something like "x.yz" (e.g. "1.03")
 */

IF Field = "LastVersion" THEN DO
	IF LENGTH( NewValue )                   ~= 4            THEN EXIT 5
	IF SUBSTR( NewValue , 2 , 1 )           ~= '.'          THEN EXIT 5
	IF DATATYPE( LEFT( NewValue , 1 ) )     ~= "NUM"        THEN EXIT 5
	IF DATATYPE( RIGHT( NewValue , 2 ) )    ~= "NUM"        THEN EXIT 5
	EXIT 0
END

/*
 * Check the ReleaseDate field
 * If must not be after today's date
 */

IF Field = "ReleaseDate" THEN DO
	IF NewValue > DATE( 'SORTED' ) THEN EXIT 5
	EXIT 0
END

/* We should never come here... */

EXIT 0

