;==============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;==============================================================================

; WalkingMan Version 1.03 October 31, 1992.

;==============================================================================
;                        WALKINGMAN INTERFACE
;==============================================================================

; WalkingMan.Constructor()
; WalkingMan.Destructor()
; WalkingMan.Move()
; WalkingMan.Resize()
; WalkingMan.HandleMouse()
;
; WalkingMan.StartRow
; WalkingMan.StartCol
; WalkingMan.EndCol
; WalkingMan.StepColumns
; WalkingMan.TimeInterval
; WalkingMan.WindowHandle
; WalkingMan.Row
; WalkingMan.Col
; WalkingMan.IsActive

;==============================================================================
;                      WALKINGMAN IMPLEMENTATION
;==============================================================================

Proc WalkingMan.Frame1()
Text

         -----
        -|'  |
         |-__|
          -|-
         / | \
        /  |  \
       /   |   |
      /    |   |
     A    / |  A
         /  |
        /   |
       \    |
        \   |
         \  |
        / __|

EndText
EndProc

Proc WalkingMan.Frame2()
Text

         -----
        -|'  |
         |-__|
          -|-
         | | \
         | |  \
        /  |  /
       /   | /
      A   /| A
         / |
        /  |
       /    \
      /      \
   \ /        \
              /

EndText
EndProc

Proc WalkingMan.Frame3()
Text

         -----
        -|'  |
         |-__|
          -|-
         | | |
         | | |
         | | |
         | |/
         | /
         AA \
         /   \
        /     \
       |       \
       |        \
     __|        /

EndText
EndProc

Proc WalkingMan.Frame4()
Text

         -----
        -|'  |
         |-__|
          -|-
          |||
          |||
          |||
          |/
          /\
         A  \
        /    \_____
       |           |
       |
       |
     __|

EndText
EndProc

Proc WalkingMan.Frame5()
Text

         -----
        -|'  |
         |-__|
          -|-
          ||\
          || \
          ||  \
         / |  |
        /  || |
       A   || A
           ||_____
           |      |
           |
           |
         __|

EndText
EndProc

Proc WalkingMan.Frame6()
Text

         -----
        -|'  |
         |-__|
          -|-
         / | \
        /  |  \
       /   |   |
      /    |   |
     A     ||  A
           ||
           ||
            \
            |\
            | \
          __| /

EndText
EndProc

Proc WalkingMan.Constructor()
   Private
      WindowBag,
      CurrentWindow
   CurrentWindow = GetWindow()
   WalkingMan.Ticks = 0
   WalkingMan.StartRow = 2
   WalkingMan.StartCol = 90
   WalkingMan.EndCol = -40
   WalkingMan.StepColumns = 2
   WalkingMan.TimeInterval = 100
   Dynarray WindowBag[]
   WindowBag["HasShadow"] = False
   WindowBag["Floating"] = True
   WindowBag["CanvasHeight"] = 17
   WindowBag["CanvasWidth"] = 22
   WindowBag["Height"] = WindowBag["CanvasHeight"] + 2
   WindowBag["Width"] = WindowBag["CanvasWidth"] + 2
   WindowBag["CanMaximize"] = False
   WindowBag["CanResize"] = False
   WindowBag["OriginRow"] = WalkingMan.StartRow
   WindowBag["OriginCol"] = WalkingMan.StartCol
   Window Create Attributes WindowBag To WalkingMan.WindowHandle
   If IsWindow(CurrentWindow) Then
      Window Select CurrentWindow
   Endif
   WalkingMan.Row = WalkingMan.StartRow
   WalkingMan.Col = WalkingMan.StartCol
   Dynarray WalkingMan.Frames[]
   WalkingMan.Frames[1] = "WalkingMan.Frame1"
   WalkingMan.Frames[2] = "WalkingMan.Frame2"
   WalkingMan.Frames[3] = "WalkingMan.Frame3"
   WalkingMan.Frames[4] = "WalkingMan.Frame4"
   WalkingMan.Frames[5] = "WalkingMan.Frame5"
   WalkingMan.Frames[6] = "WalkingMan.Frame6"
   WalkingMan.FramePtr = 1
   WalkingMan.IsActive = True
EndProc

Proc WalkingMan.Destructor()
   Private
      CurrentWindow
   CurrentWindow = GetWindow()
   Window Select WalkingMan.WindowHandle
   Window Close
   If IsWindow(CurrentWindow) Then
      Window Select CurrentWindow
   Endif
   Release Vars
      WalkingMan.Ticks,
      WalkingMan.StartRow,
      WalkingMan.StartCol,
      WalkingMan.EndCol,
      WalkingMan.StepColumns,
      WalkingMan.TimeInterval,
      WalkingMan.WindowHandle,
      WalkingMan.Row,
      WalkingMan.Col,
      WalkingMan.Frames,
      WalkingMan.FramePtr,
      WalkingMan.IsActive
EndProc ; WalkingMan.Destructor

Proc WalkingMan.Move()
   If WalkingMan.Ticks + WalkingMan.TimeInterval < Ticks() Then
      WalkingMan.Ticks = Ticks()
   Else
      Return
   Endif
   SetCanvas WalkingMan.WindowHandle
   WalkingMan.Col = WalkingMan.Col - WalkingMan.StepColumns
   If WalkingMan.Col < WalkingMan.EndCol Then
      WalkingMan.Col = WalkingMan.StartCol
   Endif
   Window Move WalkingMan.WindowHandle To WalkingMan.Row, WalkingMan.Col
   Canvas off
   Clear
   @0,0
   ExecProc WalkingMan.Frames[WalkingMan.FramePtr]
   Canvas On
   If WalkingMan.FramePtr = 6 Then
      WalkingMan.FramePtr = 1
   Else
      WalkingMan.FramePtr = WalkingMan.FramePtr + 1
   Endif
EndProc ; WalkingMan.Move

Proc WalkingMan.Resize()
   Private
      WindowBag
   WinResize
   Window GetAttributes WalkingMan.WindowHandle To WindowBag
   WalkingMan.Row = WindowBag["OriginRow"]
   WalkingMan.Col = WindowBag["OriginCol"]
   Return 1
EndProc ; WalkingMan.Resize

Proc WalkingMan.HandleMouse()
   ExecEvent EventMan.EventBag
   Window GetAttributes WalkingMan.WindowHandle To WindowBag
   WalkingMan.Row = WindowBag["OriginRow"]
   WalkingMan.Col = WindowBag["OriginCol"]
   Return 1
EndProc ; WalkingMan.HandleMouse

If Not IsAssigned(Librarian.HasControl) Then

Proc Closed WalkingMan.Demo()
   WalkingMan.Constructor()
   Cursor off
   While True
      GetEvent All To EventMan.EventBag
      EventType = EventMan.EventBag["Type"]
      Switch
         Case EventType = "KEY":
            Switch
               Case EventMan.EventBag["Keycode"] = Asc("Esc"):
                  WalkingMan.Destructor()
                  QuitLoop
               Case EventMan.EventBag["Keycode"] = Asc("WinResize"):
                  WalkingMan.Resize()
                Otherwise:
                   ExecEvent EventMan.EventBag
             EndSwitch
          Case EventType = "MOUSE":
             WalkingMan.HandleMouse()
          Case EventType = "MESSAGE":
             If EventMan.EventBag["Message"] = "CLOSE" Then
                WalkingMan.Destructor()
                QuitLoop
             Else
                ExecEvent EventMan.EventBag
             Endif
          Case EventType = "IDLE":
             WalkingMan.Move()
      EndSwitch
   EndWhile
EndProc ; WalkingMan.Demo

WalkingMan.Demo()

Endif