;==============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;==============================================================================

;==============================================================================
;                             Hypertext INTERFACE
;==============================================================================

; Methods:
; HyperMemo.Constructor()
; HyperMemo.LoadTables()
; HyperMemo.HideWindow()
; HyperMemo.ShowPanel(PanelName)
; HyperMemo.UnloadTables()
; HyperMemo.Destructor()
;
; Properties:
; HyperMemo.HelpListTabName
; HyperMemo.HelpSpecTabName
; HyperMemo.Directory
; HyperMemo.ColorBag[]
; HyperMemo.WindowBag[]
; HyperMemo.HypertextKey
; HyperMemo.Prompt

;==============================================================================
;                         Hypertext IMPLEMENTATION
;==============================================================================

Proc HyperMemo.Constructor()
   HyperMemo.HelpListTabName = "helplist"
   HyperMemo.HelpSpecTabName = "helpspec"
   HyperMemo.Directory = "Generic\\helpman\\data\\"
   Dynarray HyperMemo.ColorBag[]
   HyperMemo.ColorBag[0] = 8 + 32
   HyperMemo.ColorBag[1] = 8 + 32
   HyperMemo.ColorBag[2] = 8 + 32
   HyperMemo.ColorBag[3] = 8 + 32
   HyperMemo.ColorBag[4] = 8 + 32
   Dynarray HyperMemo.WindowBag[]
   HyperMemo.HypertextKey = Asc("Enter")
   HyperMemo.SetFocusProc = "HyperMemo!SetFocus"
   HyperMemo.Prompt =
      "[Tab/ShiftTab] for next/prev hotspot; [Enter] to select hypertext"
   HyperMemo.LoadTables()
EndProc ; HyperMemo.Constructor

Proc HyperMemo.Destructor()
   HyperMemo.UnloadTables()
   Release Vars
      HyperMemo.HelpText,
      HyperMemo.nHotSpots,
      HyperMemo.HelpDepth,
      HyperMemo.HotSpotLeft,
      HyperMemo.HotSpotRight,
      HyperMemo.HotSpotString,
      HyperMemo.HotSpotStackLeft,
      HyperMemo.HotSpotStackRight,
      HyperMemo.HotSpotStackName,
      HyperMemo.HelpListTabName,
      HyperMemo.HelpListWindowHandle,
      HyperMemo.HelpSpecTabName,
      HyperMemo.HelpSpecWindowHandle,
      HyperMemo.Directory,
      HyperMemo.ColorBag,
      HyperMemo.WindowBag,
      HyperMemo.HypertextKey,
      HyperMemo.SetFocusProc,
      HyperMemo.Prompt,
      HyperMemo_PanelName
EndProc ; HyperMemo.Destructor

;--------------------------- SHOW HELP Panel -------------------------------

Proc HyperMemo.LoadTables()
   View HyperMemo.Directory + HyperMemo.HelpSpecTabName
   HyperMemo.HelpSpecWindowHandle = GetWindow()
   HyperMemo.HideWindow()
   View HyperMemo.Directory + HyperMemo.HelpListTabName
   HyperMemo.HelpListWindowHandle = GetWindow()
   HyperMemo.HideWindow()
EndProc ; HyperMemo.LoadTables

Proc HyperMemo.HideWindow()
   Window Move GetWindow() To 500,500
EndProc ; HyperMemo.HideWindow

Proc HyperMemo.UnloadTables()
   Moveto HyperMemo.Directory + HyperMemo.HelpListTabName
   ClearImage
   Moveto HyperMemo.Directory + HyperMemo.HelpSpecTabName
   ClearImage
EndProc ; HyperMemo.UnloadTables

Proc HyperMemo.ShowPanel(PanelName)

   Echo off
   ShowPullDown
      "NextHotSpot":"Moveto next HotSpot":"NextHotSpot",
      "PrevHotSpot":"Moveto previous HotSpot":"PrevHotSpot",
      "SelectHotSpot":"Select current HotSpot":"SelectHotSpot",
      "P~r~evPanel":"Move back to parent panel, or quit":"ParentPanel",
      "Quit":"Leave help panel":"QuitPanel"
   EndMenu
   Prompt HyperMemo.Prompt
   HyperMemo_PanelName = Upper(PanelName)
   HyperMemo.SetStack()
   Moveto HyperMemo.Directory + HyperMemo.HelpListTabName
   Moveto [Help Panel name]
   Locate Indexorder HyperMemo_PanelName
   If Not Retval Then
      Return False
   Endif
   HyperMemo!SetFocus()
   HyperMemo!BrowseText()
   Return True
EndProc ; HyperMemo.ShowPanel

Proc HyperMemo.SetStack()
   HyperMemo.HelpDepth = 0
   Dynarray HyperMemo.HotSpotStackLeft[]
   Dynarray HyperMemo.HotSpotStackRight[]
   Dynarray HyperMemo.HotSpotStackName[]
EndProc ; HyperMemo.SetStack

Proc HyperMemo!SetFocus()
   Private
      WindowHandle
   Echo off
   HyperMemo.CollectHotSpots()
   Moveto [Help text]
   HyperMemo!ShowWindow()
   Echo Normal
EndProc ; HyperMemo!SetFocus

Proc HyperMemo!ShowWindow()
   FieldView
   If [Wordwrap] = "Y" Then
      Menu {Options}{WordWrap}{Set}
   Else
      Menu {Options}{WordWrap}{Clear}
   Endif
   WindowHandle = GetWindow()
   HyperMemo.WindowBag["Title"] = StrVal(HyperMemo.HelpDepth + 1) +
      ":" + [Help title]
   If Not IsBlank([Origin row]) Then
      HyperMemo.WindowBag["OriginRow"] = [Origin row]
   Else
      Release Vars HyperMemo.WindowBag["OriginRow"]
   Endif
   If Not IsBlank([Origin col]) Then
      HyperMemo.WindowBag["OriginCol"] = [Origin col]
   Else
      Release Vars HyperMemo.WindowBag["OriginCol"]
   Endif
   If Not IsBlank([Height]) Then
      HyperMemo.WindowBag["Height"] = [Height]
   Else
      Release Vars HyperMemo.WindowBag["Height"]
   Endif
   If Not IsBlank([Width]) Then
      HyperMemo.WindowBag["Width"] = [Width]
   Else
      Release Vars HyperMemo.WindowBag["Width"]
   Endif
   Window SetAttributes WindowHandle From HyperMemo.WindowBag
   Window SetColors WindowHandle From HyperMemo.ColorBag
EndProc ; HyperMemo!ShowWindow

Proc HyperMemo.CollectHotSpots()
   Private
      ScanPos,
      Scanning,
      LeftMarkPos,
      RightMarkPos,
      Found,
      WorkString,
      Length,
      OK

   HyperMemo.HelpText = [Help text]
   HyperMemo.nHotSpots = 0

   DynArray HyperMemo.HotSpotLeft[]
   DynArray HyperMemo.HotSpotRight[]
   DynArray HyperMemo.HotSpotString[]

   ScanPos = 1
   Scanning = True
   While Scanning
      LeftMarkPos = SearchFrom("",HyperMemo.HelpText,ScanPos)
      Found = (LeftMarkPos <> 0)
      Scanning = Found
      If Found Then
         ScanPos = LeftMarkPos
         RightMarkPos = SearchFrom("",HyperMemo.HelpText,ScanPos)
         Found = (RightMarkPos <> 0)
         If Found Then
            Length = RightMarkPos - LeftMarkPos + 1 - 2
            OK = (Length <= 32 And Length > 0)
            If OK Then
               WorkString = Substr(HyperMemo.HelpText,LeftMarkPos + 1,Length)
               OK = (Substr(WorkString,1,1) <> " ")
               If OK Then
                  OK = (Substr(WorkString,Length,1) <> " ")
                  If OK Then
                     OK = (Search("\010",WorkString) = 0)
                  Endif
               Endif
            Endif
            If OK Then
               HyperMemo.nHotSpots = HyperMemo.nHotSpots + 1
               HyperMemo.HotSpotLeft[HyperMemo.nHotSpots] = LeftMarkPos
               HyperMemo.HotSpotRight[HyperMemo.nHotSpots] = RightMarkPos
               HyperMemo.HotSpotString[HyperMemo.nHotSpots] = WorkString
               ScanPos = RightMarkPos + 1
            Else
               ScanPos = LeftMarkPos + 1
            Endif
         Endif ; Found
      Else
         Scanning = False
      Endif
   EndWhile
EndProc ; HyperMemo.CollectHotSpots

Proc HyperMemo!BrowseText()
   Private
      Browsing,
      LeftMarkPos,
      RightMarkPos,
      EventBag,
      Keycode,
      MessageTag,
      MenuTag
   Browsing = True
   While Browsing
      GetEvent To EventBag
      Switch
         Case EventBag["Type"] = "KEY":
            Keycode = EventBag["Keycode"]
            Switch
               Case KeyCode = Asc("F2"):
                  Do_It!
                  Browsing = False
               Case KeyCode = Asc("Esc"):
                  If Not HyperMemo.PrevPanel() Then
                     Do_It!
                     Browsing = False
                     Echo normal
                  Endif
               Case KeyCode = Asc("Tab"):
                  HyperMemo.GotoNextHotSpot()
               Case KeyCode = Asc("ReverseTab"):
                  HyperMemo.GotoPrevHotSpot()
               Case KeyCode = HyperMemo.HypertextKey:
                  HyperMemo.SelectHotSpot()
               Case KeyCode = Asc("WinMax"):
                  WinMax
               Case KeyCode = Asc("WinResize"):
                  WinResize
               Case Keycode = Asc("Home") or
                  Keycode = Asc("End") or
                  Keycode = Asc("PgUp") or
                  Keycode = Asc("PgDn") or
                  Keycode = Asc("Left") or
                  Keycode = Asc("Right") or
                  Keycode = Asc("Up") or
                  Keycode = Asc("Down") or
                  Keycode = Asc("CtrlPgUp") or
                  Keycode = Asc("CtrlPgDn") or
                  Keycode = Asc("CtrlLeft") or
                  Keycode = Asc("CtrlRight"):
                  ExecEvent EventBag
               OtherWise:
                  ; do nothing... suppress the keystroke.
            EndSwitch
         Case EventBag["Type"] = "MESSAGE":
            MessageTag = EventBag["Message"]
            Switch
               Case MessageTag = "CLOSE":
                  Do_It!
                  Browsing = False
               Case MessageTag = "MENUSELECT":
                  MenuTag = EventBag["MenuTag"]
                  Switch
                     Case MenuTag = "NextHotSpot":
                        HyperMemo.GotoNextHotSpot()
                     Case MenuTag = "PrevHotSpot":
                        HyperMemo.GotoPrevHotSpot()
                     Case MenuTag = "SelectHotSpot":
                        HyperMemo.SelectHotSpot()
                     Case MenuTag = "ParentPanel":
                        If Not HyperMemo.PrevPanel() Then
                           Do_It!
                           Browsing = False
                           Echo normal
                        Endif
                     Case MenuTag = "QuitPanel":
                        Do_It!
                        Browsing = False
                  EndSwitch
               OtherWise:
                  ExecEvent EventBag
            EndSwitch
         Case EventBag["Type"] = "MOUSE":
            EventTag = EventBag["Buttons"] +
                 IIf(EventBag["Doubleclick"],"DOUBLE","") +
                 EventBag["Action"]
            Switch
               Case WindowAt(EventBag["Row"],EventBag["Col"]) <>
                  GetWindow(): ; do nothing
               Case EventTag = "LEFTDOUBLEDOWN":
                  HyperMemo.SelectHotSpot()
               Case EventTag = "RIGHTDOWN":
                  If Not HyperMemo.PrevPanel() Then
                     Do_It!
                     Browsing = False
                     Echo normal
                  Endif
               Case EventBag["DoubleClick"]:
                  ; suppress this
            OtherWise:
               ExecEvent EventBag
            EndSwitch
         OtherWise:
            ExecEvent EventBag
      EndSwitch
   EndWhile ; Browsing
EndProc ; HyperMemo!BrowseText

Proc HyperMemo.SelectHotSpot()
   Private
      LeftMarkPos,
      RightMarkPos,
      EditorBag,
      ReferenceText,
      PanelName

   HyperMemo!MarkCurrentHotSpot()
   Editor Info To EditorBag
   If EditorBag["SelStart"] = 0 Then
      Message "No hotspot selected"
   Else
      Echo off
      Message "Working..."
      Editor Extract to ReferenceText
      ReferenceText = Substr(ReferenceText,2,len(ReferenceText) - 2)
      HyperMemo.HelpDepth = HyperMemo.HelpDepth + 1
      HyperMemo.HotSpotStackLeft[HyperMemo.HelpDepth] = EditorBag["SelStart"]
      HyperMemo.HotSpotStackRight[HyperMemo.HelpDepth] = EditorBag["SelEnd"]
      FieldView ; Do_It!
      PanelName = [Help panel name]
      HyperMemo.HotSpotStackName[HyperMemo.HelpDepth] = PanelName
      Moveto HyperMemo.Directory + HyperMemo.HelpSpecTabName
      Locate IndexOrder PanelName,ReferenceText
      If Not RetVal Then
         Moveto HyperMemo.Directory + HyperMemo.HelpListTabName
         PanelName = HyperMemo.HotSpotStackName[HyperMemo.HelpDepth]
         LeftMarkPos = HyperMemo.HotSpotStackLeft[HyperMemo.HelpDepth]
         RightMarkPos = HyperMemo.HotSpotStackRight[HyperMemo.HelpDepth]
         Release Vars
            HyperMemo.HotSpotStackName[HyperMemo.HelpDepth],
            HyperMemo.HotSpotStackLeft[HyperMemo.HelpDepth],
            HyperMemo.HotSpotStackRight[HyperMemo.HelpDepth]
         HyperMemo.HelpDepth = HyperMemo.HelpDepth - 1
         FieldView
         ; HyperMemo!SetFocus()
         Editor Select LeftMarkPos RightMarkPos
         Message "No reference for hotspot"
      Else
         PanelName = [Referenced help Panel]
         Moveto HyperMemo.Directory + HyperMemo.HelpListTabName
         Moveto [Help Panel name]
         Locate IndexOrder PanelName
         Moveto [Help text]
         ExecProc HyperMemo.SetFocusProc
      Endif
      Message ""
   Endif
   Return 1
EndProc ; HyperMemo.SelectHotSpot

Proc HyperMemo!MarkCurrentHotSpot()
   Private
      EditorBag,
      ScanPos,
      LeftMarkPos,
      RightMarkPos,
      Found,
      i

   If HyperMemo.nHotSpots = 0 Then
      Return
   Endif
   Editor Info To EditorBag
   If EditorBag["SelStart"] = 0 Then
      ScanPos = EditorBag["CharPos"]
   Else
      Return
   Endif
   Found = False
   For i From 1 to HyperMemo.nHotSpots
      Found = HyperMemo.HotSpotLeft[i] <= ScanPos And HyperMemo.HotSpotRight[i] >= ScanPos
      If Found Then
         LeftMarkPos = HyperMemo.HotSpotLeft[i]
         RightMarkPos = HyperMemo.HotSpotRight[i]
         QuitLoop
      Endif
   EndFor
   If Found Then
      Editor Select LeftmarkPos RightMarkPos
   Endif
EndProc ; HyperMemo!MarkCurrentHotSpot

Proc HyperMemo.PrevPanel()
   Private
      LeftMarkPos,
      RightMarkPos
   Echo off
   If HyperMemo.HelpDepth = 0 Then
      Return False
   Else
      FieldView
      Message "Working..."
      HyperMemo_PanelName = HyperMemo.HotSpotStackName[HyperMemo.HelpDepth]
      LeftMarkPos = HyperMemo.HotSpotStackLeft[HyperMemo.HelpDepth]
      RightMarkPos = HyperMemo.HotSpotStackRight[HyperMemo.HelpDepth]
      Release Vars
         HyperMemo.HotSpotStackName[HyperMemo.HelpDepth],
         HyperMemo.HotSpotStackLeft[HyperMemo.HelpDepth],
         HyperMemo.HotSpotStackRight[HyperMemo.HelpDepth]
      HyperMemo.HelpDepth = HyperMemo.HelpDepth - 1
      Moveto [Help Panel name]
      Locate IndexOrder HyperMemo_PanelName
      Moveto [Help text]
      Execproc HyperMemo.SetFocusProc
      Editor Select LeftMarkPos RightMarkPos
      Message ""
      Echo normal
      Return True
   Endif
EndProc ; HyperMemo.PrevPanel

Proc HyperMemo.GotoNextHotSpot()
   Private
      EditorBag,
      ScanPos,
      LeftMarkPos,
      RightMarkPos,
      Found,
      i

   If HyperMemo.nHotSpots = 0 Then
      Return 1
   Endif
   Editor Info To EditorBag
   ScanPos = EditorBag["CharPos"]
   Found = False
   For i From 1 to HyperMemo.nHotSpots
      HyperMemo!FindNextHotSpot()
      If Found Then
         QuitLoop
      Endif
   EndFor
   If Not Found Then
      ScanPos = 1
      For i From 1 To HyperMemo.nHotSpots
         HyperMemo!FindNextHotSpot()
         If Found Then
            QuitLoop
         Endif
      EndFor
   Endif
   Editor Select LeftmarkPos RightMarkPos
   Return 1
EndProc ; HyperMemo.GotoNextHotSpot

Proc HyperMemo!FindNextHotSpot()
   If ScanPos <= HyperMemo.HotSpotRight[i] Then
      Found = True
      LeftmarkPos = HyperMemo.HotSpotLeft[i]
      RightMarkPos = HyperMemo.HotSpotRight[i]
   Endif
EndProc ; HyperMemo!FindNextHotSpot

Proc HyperMemo.GotoPrevHotSpot()
   Private
      EditorBag,
      ScanPos,
      LeftMarkPos,
      RightMarkPos,
      Found,
      i

   If HyperMemo.nHotSpots = 0 Then
      Return 1
   Endif
   Editor Info To EditorBag
   If EditorBag["SelStart"] = 0 Then
      ScanPos = EditorBag["CharPos"]
   Else
      ScanPos = EditorBag["Selstart"] - 1
   Endif
   Found = False
   For i From HyperMemo.nHotSpots to 1 Step -1
      HyperMemo!FindPrevHotSpot()
      If Found Then
         QuitLoop
      Endif
   EndFor
   If Not Found Then
      ScanPos = Len(HyperMemo.HelpText)
      For i From HyperMemo.nHotSpots To 1 Step -1
         HyperMemo!FindPrevHotSpot()
         If Found Then
            QuitLoop
         Endif
      EndFor
   Endif
   Editor Select LeftmarkPos RightMarkPos
   Return 1
EndProc ; HyperMemo.GotoPrevHotSpot

Proc HyperMemo!FindPrevHotSpot()
   If ScanPos >= HyperMemo.HotSpotLeft[i] Then
      Found = True
      LeftmarkPos = HyperMemo.HotSpotLeft[i]
      RightMarkPos = HyperMemo.HotSpotRight[i]
   Endif
EndProc ; HyperMemo!FindPrevHotSpot