;============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;============================================================================

; KeyBar version 1.1

Proc KeyBar.Constructor()
   If Not IsAssigned(ButtonMan.IsActive) Then
      ButtonMan.Constructor()
   Endif
   Dynarray KeyBar.ButtonBag[]
   KeyBar.ButtonBag["HELP"]   = Asc("F1")
   KeyBar.ButtonBag["ESC"]    = Asc("Esc")
   KeyBar.ButtonBag["CLOSE"]  = Asc("WinClose")
   KeyBar.ButtonBag["NEXT"]   = Asc("WinNext")
   KeyBar.ButtonBag["EDIT"]   = Asc("CoEditKey")
   KeyBar.ButtonBag["FIELD"]  = Asc("Fieldview")
   KeyBar.ButtonBag["INS"]    = Asc("Ins")
   KeyBar.ButtonBag["DEL"]    = Asc("Del")
   KeyBar.ButtonBag["UNDO"]   = Asc("Undo")
   KeyBar.ButtonBag["DO IT"]  = Asc("Do_It!")
   KeyBar.ButtonBag[" ???"]   = Asc("Zoom")
   KeyBar.ButtonBag[" ?.."]   = Asc("ZoomNext")
   KeyBar.ButtonBag[" "]    = Asc("Home")
   KeyBar.ButtonBag[" "]    = Asc("PgUp")
   KeyBar.ButtonBag["  "]    = Asc("CtrlPgUp")
   KeyBar.ButtonBag["  "]    = Asc("CtrlPgDn")
   KeyBar.ButtonBag[" "]    = Asc("PgDn")
   KeyBar.ButtonBag[" "]    = Asc("End")
   KeyBar.ButtonBag[" "]   = Asc("Enter")
   KeyBar.Row = BlankNum()
   KeyBar.Col = BlankNum()
   KeyBar.IsHidden = False
   KeyBar.IsActive = True
EndProc ; KeyBar.Constructor

Proc KeyBar.Destructor()
   Release Vars
      KeyBar.ButtonBag,
      KeyBar.IsActive,
      KeyBar.Row,
      KeyBar.Col,
      KeyBar.IsHidden
EndProc ; KeyBar.Destructor

Proc KeyBar.PushButton()
   Private
      SelectedButton,
      ReturnCode,
      ObjectTag,
      WorkspaceTag
   ; ************* Moveto alternate window?
   SelectedButton = ButtonMan.Property[EventMan.ObjectTag + "ButtonTag"]
   ForEach Element in EventMan.EventBag
      Release Vars EventMan.EventBag[Element]
   EndForEach
   EventMan.EventBag["Type"] = "KEY"
   EventMan.EventBag["Buttons"] = "NONE" ; required to get out of
                                         ; completeMouseSequence
   EventMan.EventBag["Keycode"] = KeyBar.ButtonBag[SelectedButton]
   EventMan.TargetWindow =
      EventMan.GetTargetWindow("EVENT",EventMan.EventBag)
   ; EventMan.ObjectTag = WorkspaceTag *************
   ; If EventMan.ObjectTag = "" Then
      ExecProc EventMan.SetObjectTagProc
   ; Endif
   If IsAssigned(EventMan.ObjectTypeBag[EventMan.ObjectTag]) And
      EventMan.ObjectType = "TABLE" Then
      Switch
         Case EventMan.EventBag["Keycode"] = Asc("CtrlPgUp"):
            EventMan.EventBag["Keycode"] = Asc("Up")
         Case EventMan.EventBag["Keycode"] = Asc("CtrlPgDn"):
            EventMan.EventBag["Keycode"] = Asc("Down")
      EndSwitch
   Endif
   EventMan.DispatchEventBag()
   ReturnCode = EventMan.ReturnCode
   Return ReturnCode
EndProc ; KeyBar.PushButton

Proc KeyBar.MakeButtonBar()
   Private
      PropertyBag,
      ButtonBag,
      WindowBag,
      ColorBag,
      SysinfoBag,
      Bkg

   Dynarray PropertyBag[]
   Dynarray ButtonBag[]
   Dynarray WindowBag[]
   Dynarray ColorBag[]

   If True Then ; SysMode() = "Main" Then
      ButtonBag[" "]     = Chr(1)  + "KeyBar.PushButton"
      ButtonBag[" "]     = Chr(2)  + "KeyBar.PushButton"
      ButtonBag["  "]     = Chr(3)  + "KeyBar.PushButton"
      ButtonBag["  "]     = Chr(4)  + "KeyBar.PushButton"
      ButtonBag[" "]     = Chr(5)  + "KeyBar.PushButton"
      ButtonBag[" "]     = Chr(6)  + "KeyBar.PushButton"
      ButtonBag[" "]    = Chr(7)  + "KeyBar.PushButton"
      ButtonBag["Help"]   = Chr(8)  + "KeyBar.PushButton"
      ButtonBag["Esc"]    = Chr(9)  + "KeyBar.PushButton"
      ButtonBag["Close"]   = Chr(10) + "KeyBar.PushButton"
      ButtonBag["Next"]    = Chr(11) + "KeyBar.PushButton"
      ButtonBag["Field"]   = Chr(12) + "KeyBar.PushButton"
      ButtonBag[" ???"]    = Chr(13) + "KeyBar.PushButton"
      ButtonBag[" ?.."]    = Chr(14) + "KeyBar.PushButton"
   Else
      ButtonBag[" "]     = Chr(1)  + "KeyBar.PushButton"
      ButtonBag[" "]     = Chr(2)  + "KeyBar.PushButton"
      ButtonBag["  "]     = Chr(3)  + "KeyBar.PushButton"
      ButtonBag["  "]     = Chr(4)  + "KeyBar.PushButton"
      ButtonBag[" "]     = Chr(5)  + "KeyBar.PushButton"
      ButtonBag[" "]     = Chr(6)  + "KeyBar.PushButton"
      ButtonBag[" "]    = Chr(7)  + "KeyBar.PushButton"
      ButtonBag["DO IT"]   = Chr(8)  + "KeyBar.PushButton"
      ButtonBag["Esc"]     = Chr(9)  + "KeyBar.PushButton"
      ButtonBag["HELP"]    = Chr(10) + "KeyBar.PushButton"
      ButtonBag["INS"]     = Chr(11) + "KeyBar.PushButton"
      ButtonBag["DEL"]     = Chr(12) + "KeyBar.PushButton"
      ButtonBag["UNDO"]    = Chr(13) + "KeyBar.PushButton"
      ButtonBag["Field"]   = Chr(14) + "KeyBar.PushButton"
   Endif

   PropertyBag["ObjectTag"] = "KeyBar"
   PropertyBag["Action"] = "Toggle"
   PropertyBag["WrapCount"] = 7
   Bkg = 48 ; cyan
   PropertyBag["CanvasColor"] = Bkg + 0
   PropertyBag["HighlightColor"] = Bkg + 11
   PropertyBag["ShadowColor"] = Bkg + 8
   PropertyBag["ButtonColor"] = Bkg + 0
   PropertyBag["SelectedColor"] = Bkg + 4
   PropertyBag["UserScript"] = "!Keybar"

   WindowBag["Title"] = "Key Bar"
   WindowBag["HasFrame"] = False

   If Not IsAssigned(ButtonMan.Property["KeyBarObjectTag"]) Then
      Sysinfo To SysinfoBag
      WindowBag["OriginRow"] = SysinfoBag["ScreenHeight"] - 7
      WindowBag["OriginCol"] = 0
   Endif
   ButtonMan.MakeButtonBar(PropertyBag,ButtonBag,WindowBag,ColorBag)

EndProc ; KeyBar.MakeButtonBar

Proc KeyBar.DestroyButtonBar()
   Private
      CurrentWindow,
      IsButtonBarWindow,
      ResponseCode,
      WindowBag,
      WindowHandle

   ResponseCode = 0
   If IsAssigned(ButtonMan.Property["KeyBarObjectTag"]) Then
      WindowHandle = EventMan.ObjectTagWindow["KeyBar"]
      IsButtonBarWindow = (WindowHandle = GetWindow())
      CurrentWindow = GetWindow()
      Window Select WindowHandle
      Window GetAttributes WindowHandle To WindowBag
      ButtonMan.DestroyButtonBar("KeyBar")
      If IsWindow(CurrentWindow) Then
         Window Select CurrentWindow
      Endif
   Endif
   Return ResponseCode
EndProc ; KeyBar.DestroyButtonBar

Proc KeyBar.Hide()
   Private
      WindowBag
   If IsAssigned(KeyBar.IsActive) Then
      Window GetAttributes EventMan.ObjectTagWindow["Keybar"] To WindowBag
      KeyBar.Row = WindowBag["OriginRow"]
      KeyBar.Col = WindowBag["OriginCol"]
      Window Move EventMan.ObjectTagWindow["KeyBar"] To 500,500
      KeyBar.IsHidden = True
   Endif
EndProc ; KeyBar.Hide

Proc KeyBar.UnHide()
   If IsAssigned(KeyBar.IsActive) Then
      Window Move EventMan.ObjectTagWindow["KeyBar"] To KeyBar.Row, KeyBar.Col
   Endif
EndProc ; KeyBar.Unhide