;==============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;==============================================================================

; The HelpPanel.<PanelName> procs set the following dynarrays:
;   Hypertext.HotSpotString[]
;   Hypertext.HotSpotStartLine[]
;   Hypertext.HotSpotStartCol[]
;   Hypertext.HotSpotEndLine[]
;   Hypertext.HotSpotEndCol[]
;   Hypertext.HotSpotReference[]
;
; ... as well as the properties:
;   Hypertext.Width
;   Hypertext.Height
;
;==============================================================================
;                             Hypertext INTERFACE
;==============================================================================

; Methods:
; Hypertext.Constructor()
; Hypertext.ShowPanel(PanelName)
; Hypertext.Destructor()
; Hypertext.StartWithPanel(PanelName)
;
; Properties:
; (public...)
; Hypertext.ColorBag[]
; Hypertext.WindowBag[]
; Hypertext.HypertextKey
; Hypertext.Prompt
; Hypertext.HighLightColor
; Hypertext.HotSpotColor
; (protected...)
; Hypertext.WindowHandle
; Hypertext.Width
; Hypertext.Height

;==============================================================================
;                         Hypertext IMPLEMENTATION
;==============================================================================

Proc Hypertext.Constructor()
   Dynarray Hypertext.ColorBag[]
   Hypertext.ColorBag[0] = 8 + 32
   Hypertext.ColorBag[1] = 8 + 32
   Hypertext.ColorBag[2] = 8 + 32
   Hypertext.ColorBag[3] = 8 + 32
   Hypertext.ColorBag[4] = 8 + 32
   Dynarray Hypertext.WindowBag[]
   Hypertext.HypertextKey = Asc("Enter")
   Hypertext.Prompt =
      "[Tab/ShiftTab] for next/prev hotspot; [Enter] to select hypertext"
   Hypertext.HighLightColor = 112 + 4
   Hypertext.HotSpotColor = 64 + 15
   Hypertext.TextColor = 112 + 0
EndProc ; Hypertext.Constructor

Proc Hypertext.Destructor()
   Release Vars
      Hypertext_HelpText,
      Hypertext_nHotSpots,
      Hypertext_CurrentHotSpot,
      Hypertext_StackDepth,
      Hypertext_StackCurrent,
      Hypertext_StackHeight,
      Hypertext_StackWidth,
      Hypertext_StackRow,
      Hypertext_StackCol,
      Hypertext_StackName,
      Hypertext_ErrorCode,
      Hypertext_PanelName,
      Hypertext.ColorBag,
      Hypertext.WindowBag,
      Hypertext.HypertextKey,
      Hypertext.Prompt,
      Hypertext.HotSpotColor,
      Hypertext.HighLightColor,
      Hypertext.WindowHandle,
      Hypertext.HotSpotStartCol,
      Hypertext.HotSpotEndCol,
      Hypertext.HotSpotStartLine,
      Hypertext.HotSpotEndLint,
      Hypertext.HotSpotString,
      Hypertext.HotSpotReference,
      Hypertext.Hieght,
      Hypertext.Width,
      Hypertext.HotSpot
EndProc ; Hypertext.Destructor

;--------------------------- SHOW HELP Panel -------------------------------

Proc Hypertext.ShowPanel(PanelName)
   Private
      WindowBag,
      StartWindowHandle,
      CRow,
      CCol,
      ErrorProc,
      Found
   StartWindowHandle = GetWindow()
   ShowPullDown
      "NextHotSpot":"Moveto next HotSpot":"NextHotSpot",
      "PrevHotSpot":"Moveto previous HotSpot":"PrevHotSpot",
      "SelectHotSpot":"Select current HotSpot":"SelectHotSpot",
      "P~r~evPanel":"Move back to parent panel, or quit":"ParentPanel",
      "Quit":"Leave help panel":"QuitPanel"
   EndMenu
   Prompt Hypertext.Prompt
   PanelName = Upper(PanelName)
   Hypertext!SetStack()
   Dynarray WindowBag[]
   WindowBag["CanvasHeight"] = 200
   WindowBag["CanvasWidth"] = 132
   Window Create Floating @500,500 Attributes WindowBag
      To Hypertext.WindowHandle
   Cursor Normal
   Window SetColors Hypertext.WindowHandle From Hypertext.ColorBag
   PaintCanvas Attribute Hypertext.TextColor All
   Hypertext_PanelName = PanelName
   Canvas off
   Hypertext_ErrorCode = 0
   ErrorProc = "Hypertext.ErrorProc"
   ExecProc "HyperPanel." + PanelName
   ErrorProc = ""
   If Hypertext_ErrorCode <> 34 Then
      CRow = 0
      CCol = 0
      @CRow,CCol
      Hypertext_nHotSpots = Dynarraysize(HyperText.HotSpotString)
      Found = False
      If IsAssigned(Hypertext.HotSpot) Then
         Hypertext.HotSpot = Upper(Hypertext.HotSpot)
         ForEach Element In Hypertext.HotSpotReference
            Found = (Upper(Hypertext.HotSpotString[Element]) = Hypertext.HotSpot)
            If Found Then
               Hypertext_CurrentHotSpot = NumVal(Element)
               QuitLoop
            Endif
         EndForEach
      Endif
      If Not Found Then
         Hypertext_CurrentHotSpot = Min(Hypertext_nHotSpots,1)
      Endif
      Hypertext!HighlightHotSpots()
      Hypertext!SetHotSpot(Hypertext_CurrentHotSpot)
      Canvas on
      if Hypertext_currentHotSpot > 0 then
         CRow = HyperText.HotSpotStartLine[Hypertext_CurrentHotSpot] - 1
         CCol = Hypertext.HotSpotStartCol[Hypertext_CurrentHotSpot] - 1
      endif
      @CRow,CCol
      Hypertext!BrowseText()
   Else
      Message PanelName, " panel not found."
      Hypertext_ErrorCode = 0
   Endif
   Window Select Hypertext.WindowHandle
   Window Close
   If IsWindow(StartWindowHandle) Then
      Window Select StartWindowHandle
   Endif
   Return True
EndProc ; Hypertext.ShowPanel

Proc Hypertext.ErrorProc()
   Hypertext_ErrorCode = ErrorCode()
   Return 1
EndProc ; Hypertext.ErrorProc

Proc Hypertext!HighlightHotSpots()
   Private
      HotSpotNum,
      Length,
      FirstHalfLength,
      LastHalfLength
   SetCanvas Hypertext.WindowHandle
   For HotSpotNum From 1 to Hypertext_nHotSpots
      Hypertext!SetHotSpotColor(HotSpotNum,Hypertext.HighLightColor)
   EndFor
EndProc ; Hypertext!HighlightHotSpots

Proc Hypertext!SetHotSpotColor(HotSpotNum,HighLightColor)
   Private
      FirstHalfLength
   If Hypertext.HotSpotStartLine[HotSpotNum] =
      Hypertext.HotSpotEndLine[HotSpotNum] Then
      PaintCanvas Attribute HighlightColor
         Hypertext.HotSpotStartLine[HotSpotNum] -1,
         Hypertext.HotSpotStartCol[HotSpotNum] -1,
         Hypertext.HotSpotEndLine[HotSpotNum] -1,
         Hypertext.HotSpotEndCol[HotSpotNum] -1
   Else
      FirstHalfLength = Len(Hypertext.HotSpotString[HotSpotNum]) + 2 -
                            (Hypertext.HotSpotEndCol[HotSpotNum] + 1)
      PaintCanvas Attribute HighlightColor
         Hypertext.HotSpotStartLine[HotSpotNum] -1,
         Hypertext.HotSpotStartCol[HotSpotNum] -1,
         Hypertext.HotSpotStartLine[HotSpotNum] -1,
         Hypertext.HotSpotStartCol[HotSpotNum] + FirstHalfLength  -2
      PaintCanvas Attribute HighlightColor
         Hypertext.HotSpotEndLine[HotSpotNum] -1, 0,
         Hypertext.HotSpotEndLine[HotSpotNum] -1,
         Hypertext.HotSpotEndCol[HotSpotNum] -1
   Endif
EndProc ; Hypertext!SetHotSpotColor

Proc Hypertext!SetHotSpot(HotSpotNum)
   If HotSpotNum = 0 Then
      Return
   Endif
   If HotSpotNum <> Hypertext_CurrentHotSpot Then
      Hypertext!SetHotSpotColor(
         Hypertext_CurrentHotSpot,Hypertext.HighLightColor)
      Hypertext_CurrentHotSpot = HotSpotNum
   Endif
   Hypertext!SetHotSpotColor(
      Hypertext_CurrentHotSpot,Hypertext.HotSpotColor)
EndProc ; Hypertext!SetHotSpot

Proc Hypertext!SetStack()
   Hypertext_StackDepth = 0
   Dynarray Hypertext_StackCurrent[]
   Dynarray Hypertext_StackName[]
   Dynarray Hypertext_StackHeight[]
   Dynarray Hypertext_StackWidth[]
   Dynarray Hypertext_StackRow[]
   Dynarray Hypertext_StackCol[]
EndProc ; Hypertext!SetStack

Proc Hypertext!BrowseText()
   Private
      Browsing,
      EventBag,
      Keycode,
      MessageTag,
      MenuTag,
      WindowBag,
      MRow,
      MCol
   Browsing = True
   While Browsing
      GetEvent All To EventBag
      Switch
         Case EventBag["Type"] = "KEY":
            Keycode = EventBag["Keycode"]
            Switch
               Case KeyCode = Asc("F2"):
                  Browsing = False
               Case KeyCode = Asc("Esc"):
                  If Not Hypertext!PrevPanel() Then
                     Browsing = False
                  Endif
               Case KeyCode = Asc("Tab"):
                  Hypertext!GotoNextHotSpot()
               Case KeyCode = Asc("ReverseTab"):
                  Hypertext!GotoPrevHotSpot()
               Case KeyCode = Hypertext.HypertextKey:
                  Hypertext!SelectHotSpot()
               Case KeyCode = Asc("WinMax"):
                  WinMax
               Case KeyCode = Asc("WinResize"):
                  WinResize
               Case Keycode = Asc("Home"):
                  CCol = 0
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("End"):
                  CCol = Hypertext.Width
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("PgUp"):
                  Window GetAttributes Hypertext.WindowHandle To WindowBag
                  CRow = Max(CRow - (WindowBag["Height"] - 3),0)
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("PgDn"):
                  Window GetAttributes Hypertext.WindowHandle To WindowBag
                  CRow = Min(CRow + (WindowBag["Height"] - 3),Hypertext.Height - 1)
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("Left"):
                  CCol = CCol - 1
                  If CCol < 0 Then
                     If CRow > 0 Then
                        CCol = Hypertext.Width
                        CRow = CRow - 1
                     Else
                        CCol = 0
                     Endif
                  Endif
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("Right"):
                  CCol = CCol + 1
                  If CCol > Hypertext.Width Then
                     If CRow < Hypertext.Height - 1 Then
                        CCol = 0
                        CRow = CRow + 1
                     Else
                        CCol = Hypertext.Width
                     Endif
                  Endif
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("Up"):
                  If CRow > 0 Then
                     CRow = Crow - 1
                  Endif
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("Down"):
                  If CRow < Hypertext.Height - 1 Then
                     CRow = Crow + 1
                  Endif
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("CtrlPgUp"):
                  Crow = 0
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("CtrlPgDn"):
                  CRow = Hypertext.Height - 1
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("CtrlLeft"):
                  If CCol > 20 Then
                     CCol = CCol - 20
                  Else
                     CCol = 0
                  Endif
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               Case Keycode = Asc("CtrlRight"):
                  If CCol < Hypertext.Width - 21 Then
                     CCol = CCol + 20
                  Else
                     CCol = Hypertext.Width
                  Endif
                  @CRow,CCol
                  Hypertext!ResetHotSpot()
               OtherWise:
                  ; do nothing... suppress the keystroke.
            EndSwitch
         Case EventBag["Type"] = "MESSAGE":
            MessageTag = EventBag["Message"]
            Switch
               Case MessageTag = "CLOSE":
                  Browsing = False
               Case MessageTag = "MENUSELECT":
                  MenuTag = EventBag["MenuTag"]
                  Switch
                     Case MenuTag = "NextHotSpot":
                        Hypertext!GotoNextHotSpot()
                     Case MenuTag = "PrevHotSpot":
                        Hypertext!GotoPrevHotSpot()
                     Case MenuTag = "SelectHotSpot":
                        Hypertext!SelectHotSpot()
                     Case MenuTag = "ParentPanel":
                        If Not Hypertext!PrevPanel() Then
                           Browsing = False
                        Endif
                     Case MenuTag = "QuitPanel":
                        Browsing = False
                  EndSwitch
               OtherWise:
                  ExecEvent EventBag
            EndSwitch
         Case EventBag["Type"] = "MOUSE":
            EventTag = EventBag["Buttons"] +
                 IIf(EventBag["Doubleclick"],"DOUBLE","") +
                 EventBag["Action"]
            Switch
               Case WindowAt(EventBag["Row"],EventBag["Col"]) <>
                  GetWindow(): ; do nothing
               Case EventTag = "LEFTDOUBLEDOWN":
                  MRow = EventBag["Row"]
                  MCol = EventBag["Col"]
                  LocalizeEvent EventBag
                  Window GetAttributes Hypertext.WindowHandle To WindowBag
                  If EventBag["Row"] = 0 or EventBag["Col"] = 0 or
                     EventBag["Row"] = WindowBag["Height"] - 1 or
                     EventBag["Col"] = WindowBag["Width"] - 1 Then
                     EventBag["Row"] = MRow
                     EventBag["Col"] = MCol
                     ExecEvent EventBag
                  Else
                     If WindowBag["ScrollRow"] + EventBag["Row"] - 1 = CRow And
                        WindowBag["ScrollCol"] + EventBag["Col"] - 1 = CCol And
                        Hypertext!GetHotSpotNumber() <> 0 Then
                        Hypertext!SelectHotSpot()
                     Endif
                  Endif
               Case EventTag = "RIGHTDOWN":
                  If Not Hypertext!PrevPanel() Then
                     Browsing = False
                  Endif
               Case EventTag = "LEFTDOWN":
                  MRow = EventBag["Row"]
                  MCol = EventBag["Col"]
                  LocalizeEvent EventBag
                  Window GetAttributes Hypertext.WindowHandle To WindowBag
                  If EventBag["Row"] = 0 or EventBag["Col"] = 0 or
                     EventBag["Row"] = WindowBag["Height"] - 1 or
                     EventBag["Col"] = WindowBag["Width"] - 1 Then
                     EventBag["Row"] = MRow
                     EventBag["Col"] = MCol
                     ExecEvent EventBag
                  Else
                     CRow = WindowBag["ScrollRow"] + EventBag["Row"] - 1
                     CCol = WindowBag["ScrollCol"] + EventBag["Col"] - 1
                     @CRow,CCol
                     Hypertext!ResetHotSpot()
                  Endif
               Case EventBag["DoubleClick"]:
                  ; suppress this
            OtherWise:
               ExecEvent EventBag
            EndSwitch
         Case EventBag["Type"] = "IDLE":
            If IsAssigned(EventMan.IsActive) Then
               EventMan.DoIdleEvent()
               SetCanvas Hypertext.WindowHandle
            Endif
         OtherWise:
            ExecEvent EventBag
      EndSwitch
   EndWhile ; Browsing
EndProc ; Hypertext!BrowseText

Proc Hypertext!SelectHotSpot()
   Private
      EditorBag,
      ReferenceText,
      PanelName,
      WindowBag
   If Hypertext_nHotSpots = 0 Then
      Message "No hotspot to select"
      Return
   Endif
   If Not Hypertext!IsVisible() Then
      Message "No hotspots visible"
      Return
   Endif
   If IsBlank(Hypertext.HotSpotReference[Hypertext_CurrentHotSpot]) Then
      Message "No more information on this subject."
      Return
   Endif
   Message "Working..."
   Hypertext_StackDepth = Hypertext_StackDepth + 1
   Hypertext_StackCurrent[Hypertext_StackDepth] = Hypertext_CurrentHotSpot
   Hypertext_StackName[Hypertext_StackDepth] = Hypertext_PanelName
   Window GetAttributes Hypertext.WindowHandle to WindowBag
   Hypertext_StackHeight[Hypertext_StackDepth] = WindowBag["Height"]
   Hypertext_StackWidth[Hypertext_StackDepth] = WindowBag["Width"]
   Hypertext_StackRow[Hypertext_StackDepth] = WindowBag["OriginRow"]
   Hypertext_StackCol[Hypertext_StackDepth] = WindowBag["OriginCol"]
   Hypertext_PanelName = Hypertext.HotSpotReference[Hypertext_CurrentHotSpot]
   SetCanvas Hypertext.WindowHandle
   Canvas off
   Clear
   PaintCanvas Attribute Hypertext.TextColor All
   @0,0
   ExecProc "HyperPanel." + Hypertext_PanelName
   CRow = 0
   CCol = 0
   @CRow,CCol
   Hypertext_nHotSpots = Dynarraysize(HyperText.HotSpotString)
   Hypertext_CurrentHotSpot = Min(Hypertext_nHotSpots,1)
   Hypertext!HighlightHotSpots()
   Hypertext!SetHotSpot(Hypertext_CurrentHotSpot)
   Canvas on
   Message ""
EndProc ; Hypertext!SelectHotSpot

Proc Hypertext!IsVisible()
   Private
      WindowBag,
      RowOffset,
      ColOffset,
      WinHeight,
      WinWidth,
      LeftMarker,
      RightMarker,
      TopLine,
      BottomLine,
      FirstHalfLength
   If Hypertext_CurrentHotSpot = 0 Then
      Return False
   Endif
   Window GetAttributes Hypertext.WindowHandle To WindowBag
   RowOffset = WindowBag["ScrollRow"]
   ColOffset = WindowBag["ScrollCol"]
   WinHeight = WindowBag["Height"]
   WinWidth = WindowBag["Width"]
   LeftMarker = Hypertext.HotSpotStartCol[Hypertext_CurrentHotSpot] - 1
   RightMarker = Hypertext.HotSpotEndCol[Hypertext_CurrentHotSpot] - 1
   TopLine = Hypertext.HotSpotStartLine[Hypertext_CurrentHotSpot] - 1
   BottomLine = Hypertext.HotSpotEndLine[Hypertext_CurrentHotSpot] - 1
   If TopLine = BottomLine Then
      If (TopLine >= RowOffset And
         BottomLine < RowOffset + WinHeight - 2) And
         ((LeftMarker >= ColOffset And
         LeftMarker < ColOffset + WinWidth - 2) Or
         (RightMarker >= ColOffset And
          RightMarker < ColOffset + WinWidth - 2)) Then
         Return True
      Else
         Return False
      Endif
   Else
      FirstHalfLength = Len(Hypertext.HotSpotString[Hypertext_CurrentHotSpot]) + 2 -
                            (Hypertext.HotSpotEndCol[Hypertext_CurrentHotSpot] + 1)
      If ((TopLine >= RowOffset And
         TopLine < RowOffset + WinHeight - 2) And
         ((LeftMarker >= ColOffset And
         LeftMarker < ColOffset + WinWidth - 2) Or
         (LeftMarker + FirstHalfLength - 1 >= ColOffset And
          LeftMarker + FirstHalfLength - 1 < ColOffset + WinWidth - 2)))
         ;---
          Or
         ;---
         ((BottomLine >= RowOffset And
         BottomLine < WinHeight - 2) And
         ((0 >= ColOffset And
         0 < WinWidth - 2) Or
         (RightMarker >= ColOffset And
          RightMarker < WinWidth - 2)))
         ;---
         Then
         ;---
         Return True
      Else
         Return False
      Endif
   Endif
EndProc ; Hypertext!IsVisible

Proc Hypertext!PrevPanel()
   Private
      WindowBag
   If Hypertext_StackDepth = 0 Then
      Return False
   Else
      Message "Working..."
      Hypertext_PanelName = Hypertext_StackName[Hypertext_StackDepth]
      Hypertext_CurrentHotSpot = Hypertext_StackCurrent[Hypertext_StackDepth]
      Release Vars
         Hypertext_StackName[Hypertext_StackDepth],
         Hypertext_StackCurrent[Hypertext_StackDepth]
      SetCanvas Hypertext.WindowHandle
      Canvas off
      Clear
      PaintCanvas Attribute Hypertext.TextColor All
      @0,0
      Hypertext_StackDepth = Hypertext_StackDepth - 1
                ; to accomodate depth marker in title
      ExecProc "HyperPanel." + Hypertext_PanelName
      Hypertext_StackDepth = Hypertext_StackDepth + 1
      Dynarray WindowBag[]
      WindowBag["Height"] = Hypertext_StackHeight[Hypertext_StackDepth]
      WindowBag["Width"] = Hypertext_StackWidth[Hypertext_StackDepth]
      WindowBag["OriginRow"] = Hypertext_StackRow[Hypertext_StackDepth]
      WindowBag["OriginCol"] = Hypertext_StackCol[Hypertext_StackDepth]
      Window SetAttributes Hypertext.WindowHandle From WindowBag
      Hypertext_StackDepth = Hypertext_StackDepth - 1
      @0,0
      Hypertext_nHotSpots = Dynarraysize(HyperText.HotSpotString)
      Hypertext!HighlightHotSpots()
      Hypertext!SetHotSpot(Hypertext_CurrentHotSpot)
      CRow = HyperText.HotSpotStartLine[Hypertext_CurrentHotSpot] - 1
      CCol = HyperText.HotSpotStartCol[Hypertext_CurrentHotSpot] - 1
      @CRow,CCol
      Canvas on
      Message ""
      Return True
   Endif
EndProc ; Hypertext!PrevPanel

Proc Hypertext!GotoNextHotSpot()
   Private
      NextHotSpot
   If Hypertext_nHotSpots = 0 Then
      Return
   Endif
   NextHotSpot = Hypertext!GetNextHotSpot()
   Hypertext!SetHotSpot(NextHotSpot)
   CRow = HyperText.HotSpotStartLine[Hypertext_CurrentHotSpot] - 1
   CCol = Hypertext.HotSpotStartCol[Hypertext_CurrentHotSpot] - 1
   @CRow,CCol
EndProc ; Hypertext!GotoNextHotSpot

Proc Hypertext!GetNextHotSpot()
   Private
      HotSpotNum
   HotSpotNum = 1
   ;-------------------------------------------------------------------------
   ; Find the next row for a hotspot
   ;-------------------------------------------------------------------------
   While HotSpotNum <= Hypertext_nHotSpots And
      CRow > Hypertext.HotSpotStartLine[HotSpotNum] - 1
      HotSpotNum = HotSpotNum + 1
   EndWhile
   ;-------------------------------------------------------------------------
   ; If the next row is the current row then try to find the next hotspot on
   ; the line
   ;-------------------------------------------------------------------------
   If HotSpotNum <= Hypertext_nHotSpots And
      CRow = Hypertext.HotSpotStartLine[HotSpotNum] - 1 Then
      While HotSpotNum <= Hypertext_nHotSpots And
         CRow = Hypertext.HotSpotStartLine[HotSpotNum] - 1 And
         CCol >= Hypertext.HotSpotStartCol[HotSpotNum] - 1
         HotSpotNum = HotSpotNum + 1
      EndWhile
      If HotSpotNum <= Hypertext_nHotSpots And
         CRow = Hypertext.HotSpotStartLine[HotSpotNum] - 1 And
         CCol < Hypertext.HotSpotStartCol[HotSpotNum] - 1 Then
         Return HotSpotNum
      Endif
   Endif
   ;-------------------------------------------------------------------------
   ; Resolve the situation by getting the next available hotspot...
   ;-------------------------------------------------------------------------
   If HotSpotNum > Hypertext_nHotSpots Then
      HotSpotNum = 1
   Endif
   Return HotSpotNum
EndProc ; Hypertext!GetNextHotSpot

Proc Hypertext!GotoPrevHotSpot()
   Private
      NextHotSpot
   If Hypertext_nHotSpots = 0 Then
      Return
   Endif
   NextHotSpot = Hypertext!GetPrevHotSpot()
   Hypertext!SetHotSpot(NextHotSpot)
   CRow = HyperText.HotSpotStartLine[Hypertext_CurrentHotSpot] - 1
   CCol = Hypertext.HotSpotStartCol[Hypertext_CurrentHotSpot] - 1
   @CRow,CCol
EndProc ; Hypertext!GotoPrevHotSpot

Proc Hypertext!GetPrevHotSpot()
   Private
      HotSpotNum
   HotSpotNum = Hypertext_nHotSpots
   ;-------------------------------------------------------------------------
   ; Find the previous row for a hotspot
   ;-------------------------------------------------------------------------
   While HotSpotNum >= 1 And
      CRow < Hypertext.HotSpotStartLine[HotSpotNum] - 1
      HotSpotNum = HotSpotNum - 1
   EndWhile
   ;-------------------------------------------------------------------------
   ; If the next row is the current row then try to find the previous hotspot
   ; on the line
   ;-------------------------------------------------------------------------
   If HotSpotNum >= 1 And
      CRow = Hypertext.HotSpotStartLine[HotSpotNum] - 1 Then
      While HotSpotNum >= 1 And
         CRow = Hypertext.HotSpotStartLine[HotSpotNum] - 1 And
         CCol <= Hypertext.HotSpotStartCol[HotSpotNum] - 1
         HotSpotNum = HotSpotNum - 1
      EndWhile
      If HotSpotNum >= 1 And
         CRow = Hypertext.HotSpotStartLine[HotSpotNum] - 1 And
         CCol > Hypertext.HotSpotStartCol[HotSpotNum] - 1 Then
         Return HotSpotNum
      Endif
   Endif
   ;-------------------------------------------------------------------------
   ; Resolve the situation by getting the previous available hotspot...
   ;-------------------------------------------------------------------------
   If HotSpotNum < 1 Then
      HotSpotNum = Hypertext_nHotSpots
   Endif
   Return HotSpotNum
EndProc ; Hypertext!GetPrevHotSpot

Proc Hypertext!GetHotSpotNumber()
   Private
      HotSpotNum
   HotSpotNum = 1
   While HotSpotNum <= Hypertext_nHotSpots And
      (Hypertext.HotSpotStartLine[HotSpotNum] - 1 < CRow And
      Hypertext.HotSpotEndLine[HotSpotNum] - 1 < CRow)
      HotSpotNum = HotSpotNum + 1
   EndWhile
   If HotSpotNum <= Hypertext_nHotSpots And
      (Hypertext.HotSpotStartLine[HotSpotNum] -1 = CRow or
      Hypertext.HotSpotEndLine[HotSpotNum] - 1 = CRow) Then
      While HotSpotNum <= Hypertext_nHotSpots And
         (Hypertext.HotSpotStartLine[HotSpotNum] -1 = CRow or
         Hypertext.HotSpotEndLine[HotSpotNum] - 1 = CRow)
         If (Hypertext.HotSpotStartCol[HotSpotNum] - 1 <= CCol And
             Hypertext.HotSpotEndCol[HotSpotNum] - 1 >= CCol) or
            (Hypertext.HotSpotEndCol[HotSpotNum] - 1 >= CCol and
             Hypertext.HotSpotEndLine[HotSpotNum] -1 = CRow And
             Hypertext.HotSpotStartLine[HotSpotNum] -1 < CRow) Or
            (Hypertext.HotSpotStartCol[HotSpotNum] - 1 <= CCol and
             Hypertext.HotSpotEndLine[HotSpotNum] -1 > CRow And
             Hypertext.HotSpotStartLine[HotSpotNum] -1 = CRow) Then
             Return HotSpotNum
         Endif
         HotSpotNum = HotSpotNum + 1
      EndWhile
   Endif
   Return 0
EndProc ; Hypertext!GetHotSpotNumber

Proc Hypertext!ResetHotSpot()
   Private
      HotSpotNum
   If Hypertext_nHotSpots > 0 Then
      HotSpotNum = Hypertext!GetHotSpotNumber()
      If  (HotSpotNum <> 0) And (HotSpotNum <> Hypertext_CurrentHotSpot) Then
         Hypertext!SetHotSpot(HotSpotNum)
      Endif
   Endif
EndProc ; Hypertext!ResetHotSpot

Proc Hypertext.StartWithPanel(PanelName)
   Hypertext.Constructor()
   Hypertext.ShowPanel(PanelName)
   Hypertext.Destructor()
EndProc ; Hypertext.StartWithPanel

If IsAssigned(Librarian.HasControl) And
   IsAssigned(Librarian.WriteToHelpLib) Then
   WriteLib Librarian.LibSpec
      Hypertext.Constructor,
      Hypertext.Destructor,
      Hypertext.ShowPanel,
      Hypertext.ErrorProc,
      Hypertext!HighlightHotSpots,
      Hypertext!SetHotSpotColor,
      Hypertext!SetHotSpot,
      Hypertext!SetStack,
      Hypertext!BrowseText,
      Hypertext!SelectHotSpot,
      Hypertext!IsVisible,
      Hypertext!PrevPanel,
      Hypertext!GotoNextHotSpot,
      Hypertext!GetNextHotSpot,
      Hypertext!GotoPrevHotSpot,
      Hypertext!GetPrevHotSpot,
      Hypertext!GetHotSpotNumber,
      Hypertext!ResetHotSpot,
      Hypertext.StartWithPanel

   Release Procs
      Hypertext.Constructor,
      Hypertext.Destructor,
      Hypertext.ShowPanel,
      Hypertext.ErrorProc,
      Hypertext!HighlightHotSpots,
      Hypertext!SetHotSpotColor,
      Hypertext!SetHotSpot,
      Hypertext!SetStack,
      Hypertext!BrowseText,
      Hypertext!SelectHotSpot,
      Hypertext!IsVisible,
      Hypertext!PrevPanel,
      Hypertext!GotoNextHotSpot,
      Hypertext!GetNextHotSpot,
      Hypertext!GotoPrevHotSpot,
      Hypertext!GetPrevHotSpot,
      Hypertext!GetHotSpotNumber,
      Hypertext!ResetHotSpot,
      Hypertext.StartWithPanel
Endif