;============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;============================================================================

Proc HelpGen.Constructor()
EndProc ; HelpGen.Constructor

Proc HelpGen.Destructor()
   Release Vars
      HelpGen.Directory,
      HelpGen.FileName,
      HelpGen.ScriptName,
      HelpGen.LibName,
      HelpGen.WindowBag,
      HelpGen.HotSpotStartLine,
      HelpGen.HotSpotStartCol,
      HelpGen.HotSpotEndLine,
      HelpGen.HotSpotEndCol,
      HelpGen.HotSpotString,
      HelpGen.HotSpotReference,
      HelpGen.ProcNames,
      HelpGen.Width,
      HelpGen.Height

EndProc ; HelpGen.Destructor

Proc HelpGen.GetDirName()
   Private
      HelpGen.DirControlVar
   ShowDialog ""
      Proc "HelpGen.GetDirProc" Trigger "Accept"
      @5,20 Height 8 Width 41
      @1,3 ?? "Enter directory path for library:"
      Accept @2,3 Width 33 "A33" Picture "*{?,#,-,_,%,&,;?,\\,.,:}" Required
         Tag "Directory"
         To HelpGen.Directory
      PushButton @4,5 Width 12 "~O~K"
         OK Default
         Value "OK"
         Tag "OK" To
         HelpGen.DirControlVar
      PushButton @4,22 Width 12 "~C~ancel"
         Cancel
         Value "Cancel"
         Tag "Cancel" To
         HelpGen.DirControlVar
   EndDialog
   Return Retval
EndProc ; HelpGen.GetDirName

Proc HelpGen.GetDirProc(TriggerType,TagValue,EventValue,ElementValue)
   If Substr(HelpGen.Directory,Len(HelpGen.Directory),1) <> "\\" Then
      HelpGen.Directory = HelpGen.Directory + "\\"
      RefreshControl "Directory"
   Endif
   Switch
      Case DirExists(HelpGen.Directory) = -1:
         Message "Error in directory name"
         SelectControl "Directory"
         Return False
      Case DirExists(HelpGen.Directory) = 0:
         Message "Directory does not exist"
         SelectControl "Directory"
         Return False
      Otherwise:
         If Not HelpGen.GetFileName() Then
            SelectControl "Directory"
            Return False
         Else
            Return True
         Endif
    EndSwitch
EndProc ; HelpGen.GetDirProc

Proc HelpGen.GetFileName()
   Private
      HelpGen.FileControlVar
   ShowDialog ""
      Proc "HelpGen.GetFileProc" Trigger "Accept"
      @9,24 Height 8 Width 41
      @1,3 ?? "Enter file name for library:"
      Accept @2,3 Width 33 "A8" Picture "*{?,#,-,_,%,&,;?}" Required
         Tag "File"
         To HelpGen.FileName
      PushButton @4,5 Width 12 "~O~K"
         OK Default
         Value "OK"
         Tag "OK" To
         HelpGen.FileControlVar
      PushButton @4,22 Width 12 "~C~ancel"
         Cancel
         Value "Cancel"
         Tag "Cancel" To
         HelpGen.FileControlVar
   EndDialog
   Return Retval
EndProc ; HelpGen.GetFileName

Proc HelpGen.GetFileProc(TriggerType,TagValue,EventValue,ElementValue)
   HelpGen.ScriptName = HelpGen.FileName + ".SC"
   HelpGen.LibName = HelpGen.FileName + ".LIB"
   Switch
      Case DirExists(HelpGen.ScriptName) = -1:
         Message "Error in file name"
         SelectControl "File"
         Return False
      Case DirExists(HelpGen.LibName) = -1:
         Message "Error in file name"
         SelectControl "File"
         Return False
      Case DirExists(HelpGen.Directory + HelpGen.ScriptName) = 1:
         Message "Directory exists for file"
         SelectControl "File"
         Return False
      Case DirExists(HelpGen.Directory + HelpGen.LibName) = 1:
         Message "Directory exists for file"
         SelectControl "File"
         Return False
      Case IsFile(HelpGen.Directory + HelpGen.ScriptName):
         Message HelpGen.Directory + HelpGen.ScriptName," exists"
         If HelpGen.MenuConfirm("Overwrite file?") Then
            Return True
         Else
            SelectControl "File"
            Return False
         Endif
      Case IsFile(HelpGen.Directory + HelpGen.LibName):
         Message HelpGen.Directory + HelpGen.LibName, " exists"
         If HelpGen.MenuConfirm("Overwrite library?") Then
            Return True
         Else
            SelectControl "File"
            Return False
         Endif
      Otherwise:
         Return True
    EndSwitch
EndProc ; HelpGen.GetFileProc

Proc HelpGen.MenuConfirm(Question)
   Private
      Command
   ShowPopup Question @13,33
      "No":"Do NOT proceed":"No",
      "Yes":"Proceed":"Yes"
   EndMenu
   To Command
   If Command = "Yes" Then
      Return True
   Else
      Return False
   Endif
EndProc ; HelpGen.MenuConfirm

; ---------------------------- GENERATE SCRIPT ------------------------------

Proc HelpGen.GenerateScript()
   Private
      ScriptFileSpec,
      nLines,
      LineNum,
      HelpText,
      Element,
      Value,
      PanelName,
      HotSpotNum,
      nProcs

   ScriptFileSpec = HelpGen.Directory + HelpGen.ScriptName
   Dynarray HelpGen.ProcNames[]
   nProcs = 0
   Echo Off
   If IsFile(ScriptFileSpec) Then
      {Tools}{Delete}{Script}
      Select Substr(ScriptFileSpec,1,Len(ScriptFileSpec) -3)
      {OK}
   Endif
   Moveto HelpMan.Directory + HelpMan.HelpListTabName
   Home
   Scan
      PanelName = [Help panel name]
      HelpGen!ShowPanel()
      Message "Collecting data for panel ", PanelName
      HelpGen!CollectPanel()
      HyperMemo.CollectHotSpots()
      HelpGen!GetHotSpotData()
      Do_It!
      HelpGen!GetHotSpotReferences()
      Message "Generating procedure HyperPanel.",PanelName,"()"
      nProcs = nProcs + 1
      HelpGen.ProcNames[nProcs] = "HyperPanel." + PanelName
      HelpGen!GenerateProc()
   EndScan
   Librarian.HasControl = True
   Librarian.LibrarySpec = Substr(HelpGen.Directory + HelpGen.LibName,1,
      Len(HelpGen.Directory + HelpGen.LibName) - 4)
   Librarian.LibSpec = Librarian.LibrarySpec
   ListForm.LibrarySpec = HelpGen.Directory + HelpGen.LibName
   Message "Generating library ",HelpGen.Directory + HelpGen.LibName
   Librarian.LibrarySpec = HelpGen!FixSpecString(Librarian.LibrarySpec)
   HelpGen!GenerateScriptFooter()
   Play Substr(ScriptFileSpec,1,Len(ScriptFileSpec) - 3)
   Librarian.WriteToHelpLib = True
   Message "Adding Hypertext: driver procedures"
   Play HelpMan.CodeDirectory + "Hypertxt"
   Release Vars
      Librarian.HasControl,
      Librarian.LibrarySpec,
      Librarian.WriteToHelpLib,
      Librarian.LibSpec
   Message "Finished generating ",HelpGen.Directory + HelpGen.LibName
   Echo Normal
EndProc ; HelpGen.GenerateScript

Proc HelpGen!GenerateProc()
   Print File ScriptFileSpec
      "Proc HyperPanel." + PanelName + "()\n",
      "   Private\n",
      "      WindowBag\n\n",
      "   Dynarray WindowBag[]\n"
   ForEach Element in HelpGen.WindowBag
      Value = HelpGen.WindowBag[Element]
      If Substr(Type(Value),1,1) = "A" Then
         Value = "\"" + Value + "\""
      Else
         Value = StrVal(Value)
      Endif
      Print File ScriptFileSpec
         "   WindowBag[\"" + Element + "\"] = " + Value + "\n"
   EndForEach
   Print File ScriptFileSpec
         "   WindowBag[\"Title\"] = ",
         "StrVal(Hypertext_StackDepth + 1) + ",
         "\">\" + WindowBag[\"Title\"]\n"
   Print File ScriptFileSpec
      "   Window SetAttributes HyperText.WindowHandle From WindowBag\n",
      "\n"
   Print File ScriptFileSpec
      "   Hypertext.Width = " + StrVal(HelpGen.Width) + "\n",
      "   Hypertext.Height = " + StrVal(HelpGen.Height) + "\n\n",
      "   Dynarray Hypertext.HotSpotString[]\n",
      "   Dynarray Hypertext.HotSpotStartLine[]\n",
      "   Dynarray Hypertext.HotSpotStartCol[]\n",
      "   Dynarray Hypertext.HotSpotEndLine[]\n",
      "   Dynarray Hypertext.HotSpotEndCol[]\n",
      "   Dynarray Hypertext.HotSpotReference[]\n"
   For HotSpotNum From 1 to HyperMemo.nHotSpots
      Print File ScriptFileSpec
         "\n",
         "   Hypertext.HotSpotString[" + StrVal(HotSpotNum) + "] = \"" +
            HelpGen.HotSpotString[HotSpotNum] + "\"\n",
         "   Hypertext.HotSpotStartLine[" + StrVal(HotSpotNum) + "] = " +
               StrVal(HelpGen.HotSpotStartLine[HotSpotNum]) + "\n",
         "   Hypertext.HotSpotStartCol[" + StrVal(HotSpotNum) + "] = " +
            StrVal(HelpGen.HotSpotStartCol[HotSpotNum]) + "\n",
         "   Hypertext.HotSpotEndLine[" + StrVal(HotSpotNum) + "] = " +
            StrVal(HelpGen.HotSpotEndLine[HotSpotNum]) + "\n",
         "   Hypertext.HotSpotEndCol[" + StrVal(HotSpotNum) + "] = " +
            StrVal(HelpGen.HotSpotEndCol[HotSpotNum]) + "\n",
         "   Hypertext.HotSpotReference[" + StrVal(HotSpotNum) + "] = \"" +
            HelpGen.HotSpotReference[HotSpotNum] + "\"\n"
   EndFor
   Print File ScriptFileSpec
      "Style Attribute Hypertext.TextColor\n",
      "TEXT\n"
   For LineNum From 1 to nLines
      Print File ScriptFileSpec HelpText[LineNum],"\n"
   EndFor
   Print File ScriptFileSpec
      "ENDTEXT\nStyle\n",
      "EndProc ; HelpPanel." + [Help panel name],"\n\n"
EndProc ; HelpGen!GenerateProc

Proc HelpGen!ShowPanel()
   Private
      WindowBag
   Echo off

   Moveto [Help text]
   FieldView
   HelpPanel.SetAttributes()
   Window SetColors GetWindow() From HelpPanel.ColorBag
   Window GetAttributes GetWindow() To WindowBag
   Dynarray HelpGen.WindowBag[]
   HelpGen.WindowBag["Title"] = WindowBag["Title"]
   HelpGen.WindowBag["OriginRow"] = WindowBag["OriginRow"]
   HelpGen.WindowBag["OriginCol"] = WindowBag["OriginCol"]
   HelpGen.WindowBag["Height"] = WindowBag["Height"]
   HelpGen.WindowBag["Width"] = WindowBag["Width"]

   Echo normal
EndProc ; HelpGen!ShowPanel

Proc HelpGen!CollectPanel()
   Private
      EditorBag,
      TextLine
   Dynarray HelpText[]
   CtrlPgDn
   Editor Info Complete To EditorBag
   nLines = EditorBag["CurLine"]
   HelpGen.Height = nLines
   CtrlPgUp
   Home
   HelpGen.Width = 1
   For LineNum from 1 to nLines
      ShiftPress "End"
      Editor Extract To TextLine
      HelpText[LineNum] = TextLine
      HelpGen.Width = Max(HelpGen.Width,Len(TextLine))
      Home
      Down
   EndFor
EndProc ; HelpGen!CollectPanel

Proc HelpGen!GetHotSpotData()
   Private
      HotSpotNum,
      EditorBag
   Dynarray HelpGen.HotSpotStartLine[]
   Dynarray HelpGen.HotSpotStartCol[]
   Dynarray HelpGen.HotSpotEndLine[]
   Dynarray HelpGen.HotSpotEndCol[]
   Dynarray HelpGen.HotSpotString[]
   Dynarray HelpGen.HotSpotReference[]
   For HotSpotNum From 1 To HyperMemo.nHotSpots
      Editor Select HyperMemo.HotSpotLeft[HotSpotNum]
         HyperMemo.HotSpotRight[HotSpotNum]
      Editor Goto Position HyperMemo.HotSpotLeft[HotSpotNum]
      Editor Info Complete To EditorBag
      HelpGen.HotSpotStartLine[HotSpotNum] = EditorBag["CurLine"]
      HelpGen.HotSpotStartCol[HotSpotNum] = EditorBag["Col"]
      Editor Goto Position HyperMemo.HotSpotRight[HotSpotNum]
      Editor Info Complete To EditorBag
      HelpGen.HotSpotEndLine[HotSpotNum] = EditorBag["CurLine"]
      HelpGen.HotSpotEndCol[HotSpotNum] = EditorBag["Col"]
      HelpGen.HotSpotString[HotSpotNum] = HyperMemo.HotSpotString[HotSpotNum]
   EndFor
EndProc ; HelpGen!GetHotSpotData

Proc HelpGen!GetHotSpotReferences()
   Private
      HotSpotNum
   Moveto HelpMan.Directory + HelpMan.HelpSpecTabName
   For HotSpotNum From 1 To HyperMemo.nHotSpots
      Locate PanelName,HelpGen.HotSpotString[HotSpotNum]
      If RetVal Then
         HelpGen.HotSpotReference[HotSpotNum] = [Referenced help panel]
      Else
         HelpGen.HotSpotReference[HotSpotNum] = ""
      Endif
   EndFor
   Moveto HelpMan.Directory + HelpMan.HelpListTabName
EndProc ; HelpGen!GetHotSpotReferences

Proc HelpGen!GenerateScriptFooter()
   Private
      ProcNum
   Print File ScriptFileSpec
      "If IsAssigned(Librarian.HasControl) Then\n",
      "   CreateLib \"" + Librarian.LibrarySpec + "\" Size 640\n",
      "   WriteLib \"" + Librarian.LibrarySpec + "\"\n"
   For ProcNum From 1 to nProcs - 1
      Print File ScriptFileSpec
         "      " + HelpGen.ProcNames[ProcNum] + ",\n"
   EndFor
   Print File ScriptFileSpec
      "      " + HelpGen.ProcNames[nProcs] + "\n\n"
   Print File ScriptFileSpec
      "   Release Procs\n"
   For ProcNum From 1 to nProcs - 1
      Print File ScriptFileSpec
         "      " + HelpGen.ProcNames[ProcNum] + ",\n"
   EndFor
   Print File ScriptFileSpec
      "      " + HelpGen.ProcNames[nProcs] + "\n"
   Print File ScriptFileSpec
      "Endif\n"
EndProc ; HelpGen!GenerateScriptFooter

Proc HelpGen!FixSpecString(SpecString)
   Private
      String,
      Head,
      Tail
   String = ""
   Tail = SpecString
   While Match(Tail,"..\\..",Head,Tail)
      String = String + Head + "\\\\"
   EndWhile
   String = String + Tail
   Return String
EndProc ; HelpGen!FixSpecString