;============================================================================
; (c) Copyright Elect Software International Inc., 1992, Toronto. Anyone can
; use this code for anything as long as it is not resold as a software
; development resource, as long as the copyright notice isn't removed, as
; long as changes are clearly marked as to authorship, and as long as users
; indemnify Elect from any liability.
; Comments welcome. Henrik Bechmann, CIS:72701,3717; Tel:416-534-8176.
;============================================================================

; ColorPal Version 1.00 January, 1993.

;==============================================================================
;                       COLORPAL DESCRIPION
;==============================================================================
; Puts up a color palette and provides facilities for changing the selected
; color by arrow key or mouse. Can be dragged by mouse.
;==============================================================================
;                       COLORPAL INTERFACE
;==============================================================================
; METHODS:
; ColorPal.Constructor()
; ColorPal.Destructor()
; ColorPal.MakePalette()
; ColorPal.DestoryPalette()
; ColorPal.ShowAttribute(ColorAttribute)
; ColorPal.SelectAttribute(EventBag) ; Arrow key or mouse down on the palette
;                                    ; window
; PROPERTIES:
; ColorPal.WindowHandle ; the window handle of the palette after MakePalette()
; ColorPal.ColorAttribute ; The attribute resulting from showAttribute() or
;                         ; selectAttribute()
; ColorPal.IsActive       ; if the color palette constructor has been run.
;                         ; Check isWindow(ColorPal.WindowHandle) to make sure
;                         ; that MakePalette has been run.
;==============================================================================
;                       COLORPAL IMPLEMENTATION
;==============================================================================

Proc ColorPal.Constructor()
   ColorPal.WindowHandle = 0
   ColorPal.BackGround = 4 * 16
   ColorPal.ForeGround = 7
   ColorPal.ColorAttribute = ColorPal.ForeGround +
                             ColorPal.BackGround
   ColorPal.IsActive = True
EndProc ; ColorPal.Constructor

Proc ColorPal.Destructor()
   Release Vars
      ColorPal.WindowHandle,
      ColorPal.ColorAttribute,
      ColorPal.Background,
      ColorPal.Foreground,
      ColorPal.IsActive
EndProc ; ColorPal.Destructor

Proc ColorPal.MakePalette()
   Private
      WindowBag,
      i,j
   Dynarray WindowBag[]
   WindowBag["Style"] = 112 + 8
   WindowBag["HasFrame"] = False
   WindowBag["CanvasHeight"] = 11
   WindowBag["CanvasWidth"] = 18
   Window Create Floating Attributes WindowBag To ColorPal.WindowHandle
   SetCanvas ColorPal.WindowHandle
   @0,0 PaintCanvas Fill " " Background 0,0,0,17
   Frame Single From 1,0 To 10,17
   For i From 0 to 7
      For j From 0 to 15
         PaintCanvas Fill "" Attribute (i * 16) + j
            i + 2,j + 1,i + 2 ,j + 1
      EndFor
   EndFor
   ColorPal.SetColorBlinking(ColorPal.BackGround,ColorPal.ForeGround)
EndProc ; ColorPal.MakePalette

Proc ColorPal.DestroyPalette()
   Window Select ColorPal.WindowHandle
   Window Close
EndProc

Proc ColorPal.ShowAttribute(ColorAttribute)
   While ColorAttribute > 127
      ColorAttribute = ColorAttribute - 128
   EndWhile
   ColorPal.SetColorNormal(ColorPal.Background,ColorPal.ForeGround)
   ColorPal.BackGround = Int(ColorAttribute/16) * 16
   ColorPal.ForeGround = Mod(ColorAttribute,16)
   ColorPal.SetColorBlinking(ColorPal.Background,ColorPal.ForeGround)
EndProc ; ColorPal.SetAttribute

Proc ColorPal.SelectAttribute(EventBag)
   Private
      CRow,
      CCol,
      MRow,
      MCol,
      Keycode,
      ReturnVal
   ReturnVal = True
   ColorPal.SetColorNormal(ColorPal.Background,ColorPal.Foreground)
   ColorPal.BackGround = ColorPal.BackGround / 16
   Switch
      Case EventBag["Type"] = "KEY":
         KeyCode = EventBag["KeyCode"]
         Switch
            Case Keycode = Asc("Up"):
               ColorPal.Background = ColorPal.Background - 1
               If ColorPal.Background < 0 Then
                  ColorPal.Background = 7
               Endif
            Case Keycode = Asc("Down"):
               ColorPal.Background = ColorPal.Background + 1
               If ColorPal.Background > 7 Then
                  ColorPal.Background = 0
               Endif
            Case Keycode = Asc("Left"):
               ColorPal.Foreground = ColorPal.Foreground - 1
               If ColorPal.Foreground < 0 Then
                  ColorPal.Foreground = 15
               Endif
            Case Keycode = Asc("Right"):
               ColorPal.Foreground = ColorPal.Foreground + 1
               If ColorPal.Foreground > 15 Then
                  ColorPal.Foreground = 0
               Endif
            OtherWise:
               ReturnVal = False
         EndSwitch
      Case EventBag["Type"] = "MOUSE":
         Crow = EventBag["Row"]
         Ccol = EventBag["Col"]
         LocalizeEvent EventBag
         MRow = EventBag["Row"]
         MCol = EventBag["Col"]
         EventBag["Row"] = CRow
         EventBag["Col"] = Ccol
         If MRow > 1 And MRow < 10
            And MCol > 0 And MCol < 17 Then
            ColorPal.BackGround = MRow - 2
            ColorPal.ForeGround = MCol - 1
            ReturnVal = True
         Else
            If MRow = 0 Then
               ColorPal!MouseMovePalette(EventBag)
            Endif
            ReturnVal = False
         Endif
   EndSwitch
   ColorPal.BackGround = ColorPal.Background * 16
   ColorPal.SetColorBlinking(ColorPal.Background,ColorPal.Foreground)
   ColorPal.ColorAttribute = ColorPal.BackGround + ColorPal.ForeGround
   Return ReturnVal
EndProc ; ColorPal.SelectAttribute

Proc ColorPal!MouseMovePalette(MouseEventBag)
   Private
      EventBar,
      WindowBag,
      OriginRow,
      OriginCol,
      MosueRow,
      MouseCol

   Window GetAttributes ColorPal.WindowHandle To WindowBag
   OriginRow = WindowBag["OriginRow"]
   OriginCol = WindowBag["OriginCol"]
   MouseRow = MouseEventBag["Row"]
   MouseCol = MouseEventBag["Col"]
   While True
      GetEvent To EventBag
      If EventBag["Type"] = "MOUSE" Then
         If EventBag["Action"] = "MOVE" Then
            Window Move ColorPal.WindowHandle To
               OriginRow + (EventBag["Row"] - MouseRow),
               OriginCol + (EventBag["Col"] - MouseCol)
         Endif
         If EventBag["Action"] = "UP" Then
            Quitloop
         Endif
      Endif
   EndWhile
   Window GetAttributes ColorPal.WindowHandle To WindowBag
   If WindowBag["OriginRow"] < 1 Then
      WindowBag["OriginRow"] = 1
      Window SetAttributes ColorPal.WindowHandle From WindowBag
   Endif
EndProc ; ColorPal!MouseMovePalette

Proc ColorPal.SetColorBlinking(BackGround,ForeGround)
   Private
      CRow,
      CCol
   CRow = (BackGround / 16) + 2
   CCol = ForeGround + 1
   SetCanvas ColorPal.WindowHandle
   PaintCanvas Attribute BackGround + ForeGround + 128
      Crow,CCol,Crow,Ccol
EndProc ; ColorPal.SetColorBlinking

Proc ColorPal.SetColorNormal(BackGround,ForeGround)
   Private
      CRow,
      CCol
   CRow = (BackGround / 16) + 2
   CCol = ForeGround + 1
   SetCanvas ColorPal.WindowHandle
   PaintCanvas Attribute BackGround + ForeGround
      Crow,CCol,Crow,Ccol
EndProc